/***************************************************************************
                          noad.h  -  description
                             -------------------
    begin                : Sun Mar 10 2002
    copyright            : (C) 2002/2004 by theNoad #709GRW
    email                : theNoad@ulmail.net
 ***************************************************************************/
 /*
   this is tha main part of noad
   most of the work is done here
*/
#ifndef __NOAD_H__
#define __NOAD_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <getopt.h>
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#include <signal.h>
#endif
#include <inttypes.h>

#define FFMPEG_DECODER 1
#define LIBMPEG2_DECODER 2
extern int default_Decoder; 

//#include "mpeg2wrap.h"
//#include "mpeg2wrap_ffmpeg.h"
#include "mpeg_decoder.h"
extern noadYUVBuf lastYUVBuf;  // last yuvbuf from StdCallBack
#include "vdr_cl.h"
#include "noaddata.h"
#include "ccontrol.h"
#include "ffmpeg_decoder.h"
#include "libmpeg2_decoder.h"

// in vdr_cl.h double framespersec=25.0
// in vdr_cl.h #define FRAMESPERMIN (framespersec*60)
#define BIGSTEP (15 * framespersec)
#define SMALLSTEP 1
#define LOGOSTABLETIME 40*framespersec

#define FRAMES_FOR_AC51DETECT (framespersec*2000)
#define AC3_51DETECT_SKIP 250
#define AC3ACTIVECUTOFF 60

#define FRAMES_TO_CHECK 3000
#define CHECKLOGO_FRAMES 250
#define CHECKLOGO_BLOCKS 10
#define CHECKLOGO_BLOCKFRAMES 50
#define CHECKLOGO_DIST  (5*FRAMESPERMIN)
#define CHECKLOGO_SHORTDIST  (1*FRAMESPERMIN)
#define MINBLACKLINES 15
#define MAXBLACKLINEDIFF 10
#define BACKFRAMES (framespersec*90)
#define OFFBACKFRAMES (framespersec*30)

// some defines for overlap-detection
#define PICS_READ_BEFORE (22*framespersec)
#define PICS_READ_AFTER (250*framespersec)
#define PICS_BEFORE_ONMARK (60*framespersec)
#define MIN_PICS_SIMILAR (2*framespersec)
#define OVERLAP_OK_FRAMES 75

// some defines for AUDIO-SCAN
#define AUDIO_CHECK_RANGE (FRAMESPERMIN * 2 + framespersec * 30)
//#define AUDIO_CHECK_RANGE (FRAMESPERMIN * 3)

extern noadData *ndata;
extern CControl* cctrl;
extern MPEGDecoder *decoder;

//statistic data
extern int totalFrames;
extern int totalDecodedFrames;
extern int decodedFramesForLogoDetection;
extern int decodedFramesForLogoCheck;
extern int decodedFramesForAC3Detection;
extern int decodedFramesForAC3Check;
extern int secsForLogoDetection;
extern int secsForLogoCheck;
extern int secsForAC3Detection;
extern int secsForAC3Scan;
extern int secsForScan;
extern bool hasBlackLines;
extern bool hasAC3;
extern bool hasOverlaps;
extern int picWidth;
extern int picHeight;
extern int osdMsg;
extern bool markComments;
// control-data
extern bool saveLogo;
extern bool backupMarks;
extern bool doPass2;
extern bool doPass3;
extern bool pass3only;
extern bool useSceneChangeDetection;
extern bool detectOverlaps;
extern bool useAudioDetection;
extern bool logoJumpDetection;
extern bool isNelonen;


typedef void(*fcbSizeChanged)(int width, int height);
bool StdCallBack( noadYUVBuf* yuvbuf );
int simpleCallback( noadYUVBuf* yuvbuf );
int LogoDetectCallback( noadYUVBuf* yuvbuf );
int BlacklineCallback( noadYUVBuf* yuvbuf );
int BlackframeCallback( noadYUVBuf* yuvbuf );
int checkCallback( noadYUVBuf* yuvbuf );
int nBlacklineCallback( noadYUVBuf* yuvbuf );

bool checkLogo(int startpos);
bool checkLogoShort(int startpos);
bool doLogoDetection(int curIndex);

void reInitNoad(int top, int bottom );
bool detectLogo(const char* logoname, int iStartFrame = 0 );
int checkLogoState(int iState, int iCurrentFrame, int FramesToSkip, int FramesToCheck);
int findLogoChange(int iState, int& iCurrentFrame,
                   int FramesToSkip, int repeatCheckframes=0);
void MarkToggle(cMarks *marks, int index, const char *Comment=NULL);
void moveMark( cMarks *marks, cMark *m, int iNewPos, const char *Comment=NULL);
void listMarks(cMarks *marks);
void checkOnMarkBlacklines( cMarks *marks, cMark *m, cFileName *cfn);
void checkOffMarkBlacklines( cMarks *marks, cMark *m, cFileName *cfn);
bool checkOnMark( cMarks *marks, cMark *m, bool bForward, int iCheckTime);
int displayIFrame(int iFrameIndex);
bool checkBlacklineOnMark( cMarks *marks, cMark *m, bool bForward, int iCheckTime, int iTopLines, int iBottomLines);
bool checkBlackFrameOnMark( cMarks *marks, cMark *m, bool bForward, int iCheckTime );
void checkOnMarks(cMarks *marks);
bool checkBlackFramesOnMarks(cMarks *marks);
bool detectBlacklines(int _index, int iFramesToCheck, int& iTopLines, int& iBottomLines);
bool detectBlacklines(cMarks *marks, int& iTopLines, int& iBottomLines);
bool checkBlacklineOnMarks(cMarks *marks);
void cleanInactiveMarks(cMarks *marks);
void cleanActiveMarks(cMarks *marks);
void MarkCleanup(cMarks *marks);
void pass2a(cMarks *marks);
const char *getVersion();

int audiocallback(int mode);
#ifdef HAVE_LIBAVCODEC
void pass3(cMarks *marks);
#endif

int doX11Scan(noadData *thedata, const char *fName, int iNumFrames );
const char *myTime(time_t tim);
void clearStats();

int checkScenecheckOnMark( cMarks *marks, cMark *m );
void checkMarksOnIFrames(noadData *thedata, const char *fName);
void checkMarkPair(cMark **m_org, cMarks *marks);
int getIFrameFor(cIndexFile* cIF, int iFrame);
#ifdef VNOAD
int scanRecord( int iNumFrames, cMarks *marks = NULL );
typedef void (* infocbfunc)(const char*info1, const char *info2);
extern infocbfunc info_callback;
void setInfoCallback(infocbfunc infocb);
void info(const char*info1, const char *info2);
#define INFO(a,b) info(a,b)
#else
#define INFO(a,b)
#endif

#endif

