/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec.validator;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SpecsValidator;

public class SearchBasedSpecValidator
extends SpecsValidator {
    @Override
    public void validate(Spec spec) throws IOException {
        if (spec.getFiles() == null || spec.getFiles().length == 0) {
            throw new IllegalArgumentException("Spec must contain at least one fileSpec.");
        }
        for (FileSpec fileSpec : spec.getFiles()) {
            boolean isAql = StringUtils.isNotBlank(fileSpec.getAql());
            boolean isPattern = StringUtils.isNotBlank(fileSpec.getPattern());
            boolean isBuild = StringUtils.isNotBlank(fileSpec.getBuild());
            if (!(isAql || isPattern || isBuild)) {
                throw new IllegalArgumentException("A search based Spec must contain AQL or Pattern, and/or Build keys.");
            }
            SearchBasedSpecValidator.validateQueryInputs(fileSpec);
        }
    }
}

