#ifndef FILEDB_H
#define FILEDB_H

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "chain.h"

typedef struct fileent
		{
		 char *name;
		 time_t mtime;
		 off_t size;
		 int lastrun;
		 int wasmod;
		} fileent;


int strcomp(char *s1, char *s2);
void addfile(char *s, element *filechain);
void killfilechain(element *c);
element *scanchain(element *filechain);
element *findfile(char *s, element *filechain);

/***************************************
 checkfile()

 will return one of 
  0 : File has not changed since last check
  1 : File has been changed
  2 : File has been changed, not changed any more since last call
 -1 : File did not exist
 -2 : File does not exist anymore
 ***************************************/
int checkfile(char *s, int run, element *filechain);


#endif
