#include <stdio.h>
#include <stdlib.h>
#include "inifile.h"

/*
Library: inifile
Created: 12.8.2001
Author : Peter Turczak <p_turczak@wiwa.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

void ini_init()
{
}

int ini_goto_grp(inifile *i, char *name)
{
 int r;

if (strcasecmp(i->sts.cur_grp, name)!=0)  
{ 
 ini_rewind(i);
 while ((strcasecmp(i->sts.cur_grp, name)!=0) && (!feof(i->f)))
  {
   r=ini_nextgrp(i);
  }
 
 if ((strcasecmp(i->sts.cur_grp, name)!=0))
  r=-1;
 else
  r=0;
}  else 
{
 r=0;
} 
 return(r);
}

inifile *ini_open(char *name)
{
inifile *r=(inifile *)malloc(sizeof(inifile));
ini_line curbuf;
char readbuf[1023];

 curbuf.line_nr=0;
 r->f=fopen(name, "r");
 if (r->f==NULL) 
  {
   free(r);
   r=NULL;
  } else
  {
 r->name=(char *)strdup(name);
   r->data=newchain();

   strcpy(r->sts.cur_grp,"");
   r->sts.transition=0;

   if (r->f==NULL)
    {
     free(r->name);
     free(r);
    }
  }
   
return(r);
}

int ini_nextgrp(inifile *i)
{
int r=-1; // Fail by default!
char *tmp=(char *)malloc(1024);
char *tmp2;

if (i->sts.transition==0)
{
 strcpy(tmp, "#");
 while ((ini_classify(tmp)!=INI_CLS_GRP) && (!feof(i->f)))
  {
    fgets(tmp, 1023, i->f);
  }
 
 if (ini_classify(tmp)==INI_CLS_GRP)
  {
   tmp2=ini_grp2s(tmp);
   if (tmp2!=NULL)
   {
    strncpy(i->sts.cur_grp, tmp2, 511); 
  //  free(tmp2);
    r=0;
   }
  }
} else
{ 
i->sts.transition=0;
r=0;
}
  
if (feof(i->f)) r=-1; 
free(tmp);
return(r);
}

void ini_rewind(inifile *i)
{
 
 strcpy(i->sts.cur_grp, "");
 i->sts.transition=0;
 rewind(i->f);

}

void ini_close(inifile *i)
{
 fclose(i->f);
 free(i->name);
 free(i);
}

char *ini_nextline(inifile *i)
{
char buffer[1024];
char *r=buffer;
char *tmp2;

 strcpy(buffer, "#");
 
 while ((ini_classify(buffer)!=INI_CLS_DATA) && (!feof(i->f)) && (ini_classify(buffer)!=INI_CLS_GRP))
  {
    fgets(buffer, 1023, i->f);
  } 

 if (ini_classify(buffer)==INI_CLS_DATA)
  {
   return((char *)strdup(buffer));
  }
  else
  {
  if (ini_classify(buffer)==INI_CLS_GRP)
    {
    tmp2=ini_grp2s(buffer);
    if (tmp2!=NULL)
     {
      strncpy(i->sts.cur_grp, tmp2, 511);
      i->sts.transition=1;
    //  free(tmp2);
      r=0;
     }
    } 
   return(NULL);
  }

}

char *ini_grp2s(char *s)
{
 char *r=(char *)strdup(s);
 char *tmp;
 
 if (strlen(r)>0)
  {
   if (r[0]=='[')
    {
     r++;
     if (strrchr(r,']')!=NULL)
      {
       tmp=(char *)strrchr(r,']');
       tmp[0]=0x00;
      } else
      {
       free(r);
       return(NULL);
      }
    }
  }
 return(r); 
}

char *ini_trim(char *s)
{
 if (strlen(s)>0)
  {
   while ((s[0]==' ')&&(strlen(s)>0))
    {
     s++;
    }
  }
 return(s); 
}

int ini_classify(char *s)
{
char *w=ini_trim(s); //working string
int r=INI_CLS_DATA;

 if (strlen(s)>0)
  {
   switch (w[0])
    {
     case '[':
      r=INI_CLS_GRP;
      break;

     case '#':
      r=INI_CLS_CMNT;
      break;

     case ';':
      r=INI_CLS_CMNT;
      break;
    }
  } else
  {
   r=INI_CLS_NULL;
  }
  
return(r);
}
