#ifndef CHAIN_H
#define CHAIN_H

/*
Library: chain
Created: 22.10.2001
Author : Peter Turczak <p_turczak@wiwa.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

typedef struct element {
			struct element *prev,*cur,*next, *head;
			} element;

struct element* newchain();

struct element* head(struct element *chain);
struct element* tail(struct element *chain);

struct element* e_next(struct element *chain);  // Return next element
struct element* e_prev(struct element *chain);  // Return previous element
struct element* r_next(struct element *chain);  // Return next element, wrap around
struct element* r_prev(struct element *chain);  // Return previous element, wrap around


struct element* addelement(void *newp, int size, struct element* chain);
struct element* movelement(struct element *from, struct element *to);
struct element* unchain(struct element *chain);

int chainlen(struct element *chain);

void clearlst(struct element *chain);

#endif
