#ifndef INIFILE_H
#define INIFILE_H

/*
Library: inifile
Created: 12.8.2001
Author : Peter Turczak <p_turczak@wiwa.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "chain.h"

#define INI_CLS_DATA	0
#define INI_CLS_GRP	1
#define INI_CLS_CMNT	2
#define INI_CLS_NULL	3


#define E2I(i) ((ini_line *)i->cur)

typedef struct ini_statusblk
		{
		 char cur_grp[512];
		 int transition;
		} ini_statusblk;

typedef struct ini_line
		{
		 int class;	  // Classification
		 int line_nr;	  // Line number in original file
		 char *buf;       // Buffer, free it!
		} ini_line;

typedef struct inifile
                {
                 char *name;
                 FILE *f;
		 ini_statusblk sts;
		 element *data;		// The whole file as a double chained
		 			// List
                } inifile;


int ini_classify(char *s);
char *ini_trim(char *s);
inifile *ini_open(char *name);
int ini_nextgrp(inifile *i);
char *ini_grp2s(char *s);
void ini_rewind(inifile *i);
char *ini_nextline(inifile *i);
int ini_goto_grp(inifile *i, char *name);
void ini_dump(inifile *i);

#endif
