//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// FirewallPolicyIdpsSignaturesServer is a fake server for instances of the armnetwork.FirewallPolicyIdpsSignaturesClient type.
type FirewallPolicyIdpsSignaturesServer struct {
	// List is the fake for method FirewallPolicyIdpsSignaturesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, firewallPolicyName string, parameters armnetwork.IDPSQueryObject, options *armnetwork.FirewallPolicyIdpsSignaturesClientListOptions) (resp azfake.Responder[armnetwork.FirewallPolicyIdpsSignaturesClientListResponse], errResp azfake.ErrorResponder)
}

// NewFirewallPolicyIdpsSignaturesServerTransport creates a new instance of FirewallPolicyIdpsSignaturesServerTransport with the provided implementation.
// The returned FirewallPolicyIdpsSignaturesServerTransport instance is connected to an instance of armnetwork.FirewallPolicyIdpsSignaturesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFirewallPolicyIdpsSignaturesServerTransport(srv *FirewallPolicyIdpsSignaturesServer) *FirewallPolicyIdpsSignaturesServerTransport {
	return &FirewallPolicyIdpsSignaturesServerTransport{srv: srv}
}

// FirewallPolicyIdpsSignaturesServerTransport connects instances of armnetwork.FirewallPolicyIdpsSignaturesClient to instances of FirewallPolicyIdpsSignaturesServer.
// Don't use this type directly, use NewFirewallPolicyIdpsSignaturesServerTransport instead.
type FirewallPolicyIdpsSignaturesServerTransport struct {
	srv *FirewallPolicyIdpsSignaturesServer
}

// Do implements the policy.Transporter interface for FirewallPolicyIdpsSignaturesServerTransport.
func (f *FirewallPolicyIdpsSignaturesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FirewallPolicyIdpsSignaturesClient.List":
		resp, err = f.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FirewallPolicyIdpsSignaturesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if f.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/firewallPolicies/(?P<firewallPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listIdpsSignatures`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.IDPSQueryObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	firewallPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("firewallPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.List(req.Context(), resourceGroupNameParam, firewallPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueryResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
