# asdf-vm [![Build Status](https://travis-ci.org/asdf-vm/asdf.svg?branch=master)](https://travis-ci.org/asdf-vm/asdf)

**Manage multiple runtime versions with a single CLI tool, extendable via plugins** - [docs at asdf-vm.com](https://asdf-vm.github.io/asdf/)

asdf-vm is a CLI tool that can manage multiple language runtime versions on a per-project basis. It is like `gvm`, `nvm`, `rbenv` & `pyenv` (and more) all in one! Simply install your language's plugin!

## Why use asdf-vm?

- single CLI for multiple languages
- consistent commands to manage all your languages
- single global config keeping defaults in one place
- single `.tool-versions` config file per project
- support for existing config files `.node-version`, `.nvmrc`, `.ruby-version` for easy migration
- automatically switches runtime versions as you traverse your directories
- simple plugin system to add support for your language of choice
- completion scripts managed by the plugin, not you!

## Documentation

[Please head over the documentation site for more information](https://asdf-vm.github.io/asdf/)!

- [Getting Started](https://asdf-vm.github.io/asdf/#/core-manage-asdf-vm)
- [All Commands](https://asdf-vm.github.io/asdf/#/core-commands)
- [All Plugins](https://asdf-vm.github.io/asdf/#/plugins-all)
- [Create a Plugin](https://asdf-vm.github.io/asdf/#/plugins-create)

## Contributing

See [CONTRIBUTING.md in the repo](https://github.com/asdf-vm/asdf/blob/master/CONTRIBUTING.md) or the [Contributing section on the docs site](http://asdf-vm.github.io/asdf/#/contributing-core-asdf-vm).
