// Copyright 2019 Drone IO, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package secret

import (
	"context"
	"strings"

	"github.com/drone/drone/core"
)

// Static returns a new static Secret controller.
func Static(secrets []*core.Secret) core.SecretService {
	return &staticController{secrets: secrets}
}

type staticController struct {
	secrets []*core.Secret
}

func (c *staticController) Find(ctx context.Context, in *core.SecretArgs) (*core.Secret, error) {
	for _, secret := range c.secrets {
		if !strings.EqualFold(secret.Name, in.Name) {
			continue
		}
		// The secret can be restricted to non-pull request
		// events. If the secret is restricted, return
		// empty results.
		if secret.PullRequest == false &&
			in.Build.Event == core.EventPullRequest {
			continue
		}
		return secret, nil
	}
	return nil, nil
}
