// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediatailor

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opConfigureLogsForChannel = "ConfigureLogsForChannel"

// ConfigureLogsForChannelRequest generates a "aws/request.Request" representing the
// client's request for the ConfigureLogsForChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfigureLogsForChannel for more information on using the ConfigureLogsForChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConfigureLogsForChannelRequest method.
//	req, resp := client.ConfigureLogsForChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForChannel
func (c *MediaTailor) ConfigureLogsForChannelRequest(input *ConfigureLogsForChannelInput) (req *request.Request, output *ConfigureLogsForChannelOutput) {
	op := &request.Operation{
		Name:       opConfigureLogsForChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/configureLogs/channel",
	}

	if input == nil {
		input = &ConfigureLogsForChannelInput{}
	}

	output = &ConfigureLogsForChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfigureLogsForChannel API operation for AWS MediaTailor.
//
// Configures Amazon CloudWatch log settings for a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ConfigureLogsForChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForChannel
func (c *MediaTailor) ConfigureLogsForChannel(input *ConfigureLogsForChannelInput) (*ConfigureLogsForChannelOutput, error) {
	req, out := c.ConfigureLogsForChannelRequest(input)
	return out, req.Send()
}

// ConfigureLogsForChannelWithContext is the same as ConfigureLogsForChannel with the addition of
// the ability to pass a context and additional request options.
//
// See ConfigureLogsForChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ConfigureLogsForChannelWithContext(ctx aws.Context, input *ConfigureLogsForChannelInput, opts ...request.Option) (*ConfigureLogsForChannelOutput, error) {
	req, out := c.ConfigureLogsForChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfigureLogsForPlaybackConfiguration = "ConfigureLogsForPlaybackConfiguration"

// ConfigureLogsForPlaybackConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ConfigureLogsForPlaybackConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfigureLogsForPlaybackConfiguration for more information on using the ConfigureLogsForPlaybackConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConfigureLogsForPlaybackConfigurationRequest method.
//	req, resp := client.ConfigureLogsForPlaybackConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForPlaybackConfiguration
func (c *MediaTailor) ConfigureLogsForPlaybackConfigurationRequest(input *ConfigureLogsForPlaybackConfigurationInput) (req *request.Request, output *ConfigureLogsForPlaybackConfigurationOutput) {
	op := &request.Operation{
		Name:       opConfigureLogsForPlaybackConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/configureLogs/playbackConfiguration",
	}

	if input == nil {
		input = &ConfigureLogsForPlaybackConfigurationInput{}
	}

	output = &ConfigureLogsForPlaybackConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfigureLogsForPlaybackConfiguration API operation for AWS MediaTailor.
//
// Amazon CloudWatch log settings for a playback configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ConfigureLogsForPlaybackConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForPlaybackConfiguration
func (c *MediaTailor) ConfigureLogsForPlaybackConfiguration(input *ConfigureLogsForPlaybackConfigurationInput) (*ConfigureLogsForPlaybackConfigurationOutput, error) {
	req, out := c.ConfigureLogsForPlaybackConfigurationRequest(input)
	return out, req.Send()
}

// ConfigureLogsForPlaybackConfigurationWithContext is the same as ConfigureLogsForPlaybackConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ConfigureLogsForPlaybackConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ConfigureLogsForPlaybackConfigurationWithContext(ctx aws.Context, input *ConfigureLogsForPlaybackConfigurationInput, opts ...request.Option) (*ConfigureLogsForPlaybackConfigurationOutput, error) {
	req, out := c.ConfigureLogsForPlaybackConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelRequest method.
//	req, resp := client.CreateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateChannel
func (c *MediaTailor) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channel/{ChannelName}",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS MediaTailor.
//
// Creates a channel. For information about MediaTailor channels, see Working
// with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation CreateChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateChannel
func (c *MediaTailor) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLiveSource = "CreateLiveSource"

// CreateLiveSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateLiveSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLiveSource for more information on using the CreateLiveSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLiveSourceRequest method.
//	req, resp := client.CreateLiveSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateLiveSource
func (c *MediaTailor) CreateLiveSourceRequest(input *CreateLiveSourceInput) (req *request.Request, output *CreateLiveSourceOutput) {
	op := &request.Operation{
		Name:       opCreateLiveSource,
		HTTPMethod: "POST",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}",
	}

	if input == nil {
		input = &CreateLiveSourceInput{}
	}

	output = &CreateLiveSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLiveSource API operation for AWS MediaTailor.
//
// The live source configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation CreateLiveSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateLiveSource
func (c *MediaTailor) CreateLiveSource(input *CreateLiveSourceInput) (*CreateLiveSourceOutput, error) {
	req, out := c.CreateLiveSourceRequest(input)
	return out, req.Send()
}

// CreateLiveSourceWithContext is the same as CreateLiveSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLiveSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) CreateLiveSourceWithContext(ctx aws.Context, input *CreateLiveSourceInput, opts ...request.Option) (*CreateLiveSourceOutput, error) {
	req, out := c.CreateLiveSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrefetchSchedule = "CreatePrefetchSchedule"

// CreatePrefetchScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrefetchSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrefetchSchedule for more information on using the CreatePrefetchSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePrefetchScheduleRequest method.
//	req, resp := client.CreatePrefetchScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreatePrefetchSchedule
func (c *MediaTailor) CreatePrefetchScheduleRequest(input *CreatePrefetchScheduleInput) (req *request.Request, output *CreatePrefetchScheduleOutput) {
	op := &request.Operation{
		Name:       opCreatePrefetchSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/prefetchSchedule/{PlaybackConfigurationName}/{Name}",
	}

	if input == nil {
		input = &CreatePrefetchScheduleInput{}
	}

	output = &CreatePrefetchScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrefetchSchedule API operation for AWS MediaTailor.
//
// Creates a prefetch schedule for a playback configuration. A prefetch schedule
// allows you to tell MediaTailor to fetch and prepare certain ads before an
// ad break happens. For more information about ad prefetching, see Using ad
// prefetching (https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation CreatePrefetchSchedule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreatePrefetchSchedule
func (c *MediaTailor) CreatePrefetchSchedule(input *CreatePrefetchScheduleInput) (*CreatePrefetchScheduleOutput, error) {
	req, out := c.CreatePrefetchScheduleRequest(input)
	return out, req.Send()
}

// CreatePrefetchScheduleWithContext is the same as CreatePrefetchSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrefetchSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) CreatePrefetchScheduleWithContext(ctx aws.Context, input *CreatePrefetchScheduleInput, opts ...request.Option) (*CreatePrefetchScheduleOutput, error) {
	req, out := c.CreatePrefetchScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProgram = "CreateProgram"

// CreateProgramRequest generates a "aws/request.Request" representing the
// client's request for the CreateProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProgram for more information on using the CreateProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProgramRequest method.
//	req, resp := client.CreateProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateProgram
func (c *MediaTailor) CreateProgramRequest(input *CreateProgramInput) (req *request.Request, output *CreateProgramOutput) {
	op := &request.Operation{
		Name:       opCreateProgram,
		HTTPMethod: "POST",
		HTTPPath:   "/channel/{ChannelName}/program/{ProgramName}",
	}

	if input == nil {
		input = &CreateProgramInput{}
	}

	output = &CreateProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProgram API operation for AWS MediaTailor.
//
// Creates a program within a channel. For information about programs, see Working
// with programs (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation CreateProgram for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateProgram
func (c *MediaTailor) CreateProgram(input *CreateProgramInput) (*CreateProgramOutput, error) {
	req, out := c.CreateProgramRequest(input)
	return out, req.Send()
}

// CreateProgramWithContext is the same as CreateProgram with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) CreateProgramWithContext(ctx aws.Context, input *CreateProgramInput, opts ...request.Option) (*CreateProgramOutput, error) {
	req, out := c.CreateProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSourceLocation = "CreateSourceLocation"

// CreateSourceLocationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSourceLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSourceLocation for more information on using the CreateSourceLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSourceLocationRequest method.
//	req, resp := client.CreateSourceLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateSourceLocation
func (c *MediaTailor) CreateSourceLocationRequest(input *CreateSourceLocationInput) (req *request.Request, output *CreateSourceLocationOutput) {
	op := &request.Operation{
		Name:       opCreateSourceLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/sourceLocation/{SourceLocationName}",
	}

	if input == nil {
		input = &CreateSourceLocationInput{}
	}

	output = &CreateSourceLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSourceLocation API operation for AWS MediaTailor.
//
// Creates a source location. A source location is a container for sources.
// For more information about source locations, see Working with source locations
// (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation CreateSourceLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateSourceLocation
func (c *MediaTailor) CreateSourceLocation(input *CreateSourceLocationInput) (*CreateSourceLocationOutput, error) {
	req, out := c.CreateSourceLocationRequest(input)
	return out, req.Send()
}

// CreateSourceLocationWithContext is the same as CreateSourceLocation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSourceLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) CreateSourceLocationWithContext(ctx aws.Context, input *CreateSourceLocationInput, opts ...request.Option) (*CreateSourceLocationOutput, error) {
	req, out := c.CreateSourceLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVodSource = "CreateVodSource"

// CreateVodSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateVodSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVodSource for more information on using the CreateVodSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVodSourceRequest method.
//	req, resp := client.CreateVodSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource
func (c *MediaTailor) CreateVodSourceRequest(input *CreateVodSourceInput) (req *request.Request, output *CreateVodSourceOutput) {
	op := &request.Operation{
		Name:       opCreateVodSource,
		HTTPMethod: "POST",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}",
	}

	if input == nil {
		input = &CreateVodSourceInput{}
	}

	output = &CreateVodSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVodSource API operation for AWS MediaTailor.
//
// The VOD source configuration parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation CreateVodSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource
func (c *MediaTailor) CreateVodSource(input *CreateVodSourceInput) (*CreateVodSourceOutput, error) {
	req, out := c.CreateVodSourceRequest(input)
	return out, req.Send()
}

// CreateVodSourceWithContext is the same as CreateVodSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVodSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) CreateVodSourceWithContext(ctx aws.Context, input *CreateVodSourceInput, opts ...request.Option) (*CreateVodSourceOutput, error) {
	req, out := c.CreateVodSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelRequest method.
//	req, resp := client.DeleteChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannel
func (c *MediaTailor) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channel/{ChannelName}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for AWS MediaTailor.
//
// Deletes a channel. For information about MediaTailor channels, see Working
// with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeleteChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannel
func (c *MediaTailor) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelPolicy = "DeleteChannelPolicy"

// DeleteChannelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelPolicy for more information on using the DeleteChannelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelPolicyRequest method.
//	req, resp := client.DeleteChannelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannelPolicy
func (c *MediaTailor) DeleteChannelPolicyRequest(input *DeleteChannelPolicyInput) (req *request.Request, output *DeleteChannelPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channel/{ChannelName}/policy",
	}

	if input == nil {
		input = &DeleteChannelPolicyInput{}
	}

	output = &DeleteChannelPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelPolicy API operation for AWS MediaTailor.
//
// The channel policy to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeleteChannelPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannelPolicy
func (c *MediaTailor) DeleteChannelPolicy(input *DeleteChannelPolicyInput) (*DeleteChannelPolicyOutput, error) {
	req, out := c.DeleteChannelPolicyRequest(input)
	return out, req.Send()
}

// DeleteChannelPolicyWithContext is the same as DeleteChannelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeleteChannelPolicyWithContext(ctx aws.Context, input *DeleteChannelPolicyInput, opts ...request.Option) (*DeleteChannelPolicyOutput, error) {
	req, out := c.DeleteChannelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLiveSource = "DeleteLiveSource"

// DeleteLiveSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLiveSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLiveSource for more information on using the DeleteLiveSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLiveSourceRequest method.
//	req, resp := client.DeleteLiveSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteLiveSource
func (c *MediaTailor) DeleteLiveSourceRequest(input *DeleteLiveSourceInput) (req *request.Request, output *DeleteLiveSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteLiveSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}",
	}

	if input == nil {
		input = &DeleteLiveSourceInput{}
	}

	output = &DeleteLiveSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLiveSource API operation for AWS MediaTailor.
//
// The live source to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeleteLiveSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteLiveSource
func (c *MediaTailor) DeleteLiveSource(input *DeleteLiveSourceInput) (*DeleteLiveSourceOutput, error) {
	req, out := c.DeleteLiveSourceRequest(input)
	return out, req.Send()
}

// DeleteLiveSourceWithContext is the same as DeleteLiveSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLiveSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeleteLiveSourceWithContext(ctx aws.Context, input *DeleteLiveSourceInput, opts ...request.Option) (*DeleteLiveSourceOutput, error) {
	req, out := c.DeleteLiveSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlaybackConfiguration = "DeletePlaybackConfiguration"

// DeletePlaybackConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlaybackConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlaybackConfiguration for more information on using the DeletePlaybackConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePlaybackConfigurationRequest method.
//	req, resp := client.DeletePlaybackConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration
func (c *MediaTailor) DeletePlaybackConfigurationRequest(input *DeletePlaybackConfigurationInput) (req *request.Request, output *DeletePlaybackConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeletePlaybackConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/playbackConfiguration/{Name}",
	}

	if input == nil {
		input = &DeletePlaybackConfigurationInput{}
	}

	output = &DeletePlaybackConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlaybackConfiguration API operation for AWS MediaTailor.
//
// Deletes a playback configuration. For information about MediaTailor configurations,
// see Working with configurations in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeletePlaybackConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration
func (c *MediaTailor) DeletePlaybackConfiguration(input *DeletePlaybackConfigurationInput) (*DeletePlaybackConfigurationOutput, error) {
	req, out := c.DeletePlaybackConfigurationRequest(input)
	return out, req.Send()
}

// DeletePlaybackConfigurationWithContext is the same as DeletePlaybackConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlaybackConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeletePlaybackConfigurationWithContext(ctx aws.Context, input *DeletePlaybackConfigurationInput, opts ...request.Option) (*DeletePlaybackConfigurationOutput, error) {
	req, out := c.DeletePlaybackConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePrefetchSchedule = "DeletePrefetchSchedule"

// DeletePrefetchScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeletePrefetchSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePrefetchSchedule for more information on using the DeletePrefetchSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePrefetchScheduleRequest method.
//	req, resp := client.DeletePrefetchScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePrefetchSchedule
func (c *MediaTailor) DeletePrefetchScheduleRequest(input *DeletePrefetchScheduleInput) (req *request.Request, output *DeletePrefetchScheduleOutput) {
	op := &request.Operation{
		Name:       opDeletePrefetchSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prefetchSchedule/{PlaybackConfigurationName}/{Name}",
	}

	if input == nil {
		input = &DeletePrefetchScheduleInput{}
	}

	output = &DeletePrefetchScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePrefetchSchedule API operation for AWS MediaTailor.
//
// Deletes a prefetch schedule for a specific playback configuration. If you
// call DeletePrefetchSchedule on an expired prefetch schedule, MediaTailor
// returns an HTTP 404 status code. For more information about ad prefetching,
// see Using ad prefetching (https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeletePrefetchSchedule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePrefetchSchedule
func (c *MediaTailor) DeletePrefetchSchedule(input *DeletePrefetchScheduleInput) (*DeletePrefetchScheduleOutput, error) {
	req, out := c.DeletePrefetchScheduleRequest(input)
	return out, req.Send()
}

// DeletePrefetchScheduleWithContext is the same as DeletePrefetchSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePrefetchSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeletePrefetchScheduleWithContext(ctx aws.Context, input *DeletePrefetchScheduleInput, opts ...request.Option) (*DeletePrefetchScheduleOutput, error) {
	req, out := c.DeletePrefetchScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProgram = "DeleteProgram"

// DeleteProgramRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProgram for more information on using the DeleteProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProgramRequest method.
//	req, resp := client.DeleteProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteProgram
func (c *MediaTailor) DeleteProgramRequest(input *DeleteProgramInput) (req *request.Request, output *DeleteProgramOutput) {
	op := &request.Operation{
		Name:       opDeleteProgram,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channel/{ChannelName}/program/{ProgramName}",
	}

	if input == nil {
		input = &DeleteProgramInput{}
	}

	output = &DeleteProgramOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProgram API operation for AWS MediaTailor.
//
// Deletes a program within a channel. For information about programs, see Working
// with programs (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeleteProgram for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteProgram
func (c *MediaTailor) DeleteProgram(input *DeleteProgramInput) (*DeleteProgramOutput, error) {
	req, out := c.DeleteProgramRequest(input)
	return out, req.Send()
}

// DeleteProgramWithContext is the same as DeleteProgram with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeleteProgramWithContext(ctx aws.Context, input *DeleteProgramInput, opts ...request.Option) (*DeleteProgramOutput, error) {
	req, out := c.DeleteProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSourceLocation = "DeleteSourceLocation"

// DeleteSourceLocationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSourceLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSourceLocation for more information on using the DeleteSourceLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSourceLocationRequest method.
//	req, resp := client.DeleteSourceLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteSourceLocation
func (c *MediaTailor) DeleteSourceLocationRequest(input *DeleteSourceLocationInput) (req *request.Request, output *DeleteSourceLocationOutput) {
	op := &request.Operation{
		Name:       opDeleteSourceLocation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sourceLocation/{SourceLocationName}",
	}

	if input == nil {
		input = &DeleteSourceLocationInput{}
	}

	output = &DeleteSourceLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSourceLocation API operation for AWS MediaTailor.
//
// Deletes a source location. A source location is a container for sources.
// For more information about source locations, see Working with source locations
// (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeleteSourceLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteSourceLocation
func (c *MediaTailor) DeleteSourceLocation(input *DeleteSourceLocationInput) (*DeleteSourceLocationOutput, error) {
	req, out := c.DeleteSourceLocationRequest(input)
	return out, req.Send()
}

// DeleteSourceLocationWithContext is the same as DeleteSourceLocation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSourceLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeleteSourceLocationWithContext(ctx aws.Context, input *DeleteSourceLocationInput, opts ...request.Option) (*DeleteSourceLocationOutput, error) {
	req, out := c.DeleteSourceLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVodSource = "DeleteVodSource"

// DeleteVodSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVodSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVodSource for more information on using the DeleteVodSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVodSourceRequest method.
//	req, resp := client.DeleteVodSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteVodSource
func (c *MediaTailor) DeleteVodSourceRequest(input *DeleteVodSourceInput) (req *request.Request, output *DeleteVodSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteVodSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}",
	}

	if input == nil {
		input = &DeleteVodSourceInput{}
	}

	output = &DeleteVodSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVodSource API operation for AWS MediaTailor.
//
// The video on demand (VOD) source to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DeleteVodSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteVodSource
func (c *MediaTailor) DeleteVodSource(input *DeleteVodSourceInput) (*DeleteVodSourceOutput, error) {
	req, out := c.DeleteVodSourceRequest(input)
	return out, req.Send()
}

// DeleteVodSourceWithContext is the same as DeleteVodSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVodSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DeleteVodSourceWithContext(ctx aws.Context, input *DeleteVodSourceInput, opts ...request.Option) (*DeleteVodSourceOutput, error) {
	req, out := c.DeleteVodSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelRequest method.
//	req, resp := client.DescribeChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeChannel
func (c *MediaTailor) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channel/{ChannelName}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for AWS MediaTailor.
//
// Describes a channel. For information about MediaTailor channels, see Working
// with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DescribeChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeChannel
func (c *MediaTailor) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLiveSource = "DescribeLiveSource"

// DescribeLiveSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLiveSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLiveSource for more information on using the DescribeLiveSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLiveSourceRequest method.
//	req, resp := client.DescribeLiveSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeLiveSource
func (c *MediaTailor) DescribeLiveSourceRequest(input *DescribeLiveSourceInput) (req *request.Request, output *DescribeLiveSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeLiveSource,
		HTTPMethod: "GET",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}",
	}

	if input == nil {
		input = &DescribeLiveSourceInput{}
	}

	output = &DescribeLiveSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLiveSource API operation for AWS MediaTailor.
//
// The live source to describe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DescribeLiveSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeLiveSource
func (c *MediaTailor) DescribeLiveSource(input *DescribeLiveSourceInput) (*DescribeLiveSourceOutput, error) {
	req, out := c.DescribeLiveSourceRequest(input)
	return out, req.Send()
}

// DescribeLiveSourceWithContext is the same as DescribeLiveSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLiveSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DescribeLiveSourceWithContext(ctx aws.Context, input *DescribeLiveSourceInput, opts ...request.Option) (*DescribeLiveSourceOutput, error) {
	req, out := c.DescribeLiveSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProgram = "DescribeProgram"

// DescribeProgramRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProgram for more information on using the DescribeProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeProgramRequest method.
//	req, resp := client.DescribeProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeProgram
func (c *MediaTailor) DescribeProgramRequest(input *DescribeProgramInput) (req *request.Request, output *DescribeProgramOutput) {
	op := &request.Operation{
		Name:       opDescribeProgram,
		HTTPMethod: "GET",
		HTTPPath:   "/channel/{ChannelName}/program/{ProgramName}",
	}

	if input == nil {
		input = &DescribeProgramInput{}
	}

	output = &DescribeProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProgram API operation for AWS MediaTailor.
//
// Describes a program within a channel. For information about programs, see
// Working with programs (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DescribeProgram for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeProgram
func (c *MediaTailor) DescribeProgram(input *DescribeProgramInput) (*DescribeProgramOutput, error) {
	req, out := c.DescribeProgramRequest(input)
	return out, req.Send()
}

// DescribeProgramWithContext is the same as DescribeProgram with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DescribeProgramWithContext(ctx aws.Context, input *DescribeProgramInput, opts ...request.Option) (*DescribeProgramOutput, error) {
	req, out := c.DescribeProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSourceLocation = "DescribeSourceLocation"

// DescribeSourceLocationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSourceLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSourceLocation for more information on using the DescribeSourceLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSourceLocationRequest method.
//	req, resp := client.DescribeSourceLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeSourceLocation
func (c *MediaTailor) DescribeSourceLocationRequest(input *DescribeSourceLocationInput) (req *request.Request, output *DescribeSourceLocationOutput) {
	op := &request.Operation{
		Name:       opDescribeSourceLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/sourceLocation/{SourceLocationName}",
	}

	if input == nil {
		input = &DescribeSourceLocationInput{}
	}

	output = &DescribeSourceLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSourceLocation API operation for AWS MediaTailor.
//
// Describes a source location. A source location is a container for sources.
// For more information about source locations, see Working with source locations
// (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DescribeSourceLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeSourceLocation
func (c *MediaTailor) DescribeSourceLocation(input *DescribeSourceLocationInput) (*DescribeSourceLocationOutput, error) {
	req, out := c.DescribeSourceLocationRequest(input)
	return out, req.Send()
}

// DescribeSourceLocationWithContext is the same as DescribeSourceLocation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSourceLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DescribeSourceLocationWithContext(ctx aws.Context, input *DescribeSourceLocationInput, opts ...request.Option) (*DescribeSourceLocationOutput, error) {
	req, out := c.DescribeSourceLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVodSource = "DescribeVodSource"

// DescribeVodSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVodSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVodSource for more information on using the DescribeVodSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVodSourceRequest method.
//	req, resp := client.DescribeVodSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeVodSource
func (c *MediaTailor) DescribeVodSourceRequest(input *DescribeVodSourceInput) (req *request.Request, output *DescribeVodSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeVodSource,
		HTTPMethod: "GET",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}",
	}

	if input == nil {
		input = &DescribeVodSourceInput{}
	}

	output = &DescribeVodSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVodSource API operation for AWS MediaTailor.
//
// Provides details about a specific video on demand (VOD) source in a specific
// source location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation DescribeVodSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeVodSource
func (c *MediaTailor) DescribeVodSource(input *DescribeVodSourceInput) (*DescribeVodSourceOutput, error) {
	req, out := c.DescribeVodSourceRequest(input)
	return out, req.Send()
}

// DescribeVodSourceWithContext is the same as DescribeVodSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVodSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) DescribeVodSourceWithContext(ctx aws.Context, input *DescribeVodSourceInput, opts ...request.Option) (*DescribeVodSourceOutput, error) {
	req, out := c.DescribeVodSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelPolicy = "GetChannelPolicy"

// GetChannelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelPolicy for more information on using the GetChannelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelPolicyRequest method.
//	req, resp := client.GetChannelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelPolicy
func (c *MediaTailor) GetChannelPolicyRequest(input *GetChannelPolicyInput) (req *request.Request, output *GetChannelPolicyOutput) {
	op := &request.Operation{
		Name:       opGetChannelPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/channel/{ChannelName}/policy",
	}

	if input == nil {
		input = &GetChannelPolicyInput{}
	}

	output = &GetChannelPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelPolicy API operation for AWS MediaTailor.
//
// Returns the channel's IAM policy. IAM policies are used to control access
// to your channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation GetChannelPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelPolicy
func (c *MediaTailor) GetChannelPolicy(input *GetChannelPolicyInput) (*GetChannelPolicyOutput, error) {
	req, out := c.GetChannelPolicyRequest(input)
	return out, req.Send()
}

// GetChannelPolicyWithContext is the same as GetChannelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) GetChannelPolicyWithContext(ctx aws.Context, input *GetChannelPolicyInput, opts ...request.Option) (*GetChannelPolicyOutput, error) {
	req, out := c.GetChannelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelSchedule = "GetChannelSchedule"

// GetChannelScheduleRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelSchedule for more information on using the GetChannelSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelScheduleRequest method.
//	req, resp := client.GetChannelScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule
func (c *MediaTailor) GetChannelScheduleRequest(input *GetChannelScheduleInput) (req *request.Request, output *GetChannelScheduleOutput) {
	op := &request.Operation{
		Name:       opGetChannelSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/channel/{ChannelName}/schedule",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetChannelScheduleInput{}
	}

	output = &GetChannelScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelSchedule API operation for AWS MediaTailor.
//
// Retrieves information about your channel's schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation GetChannelSchedule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule
func (c *MediaTailor) GetChannelSchedule(input *GetChannelScheduleInput) (*GetChannelScheduleOutput, error) {
	req, out := c.GetChannelScheduleRequest(input)
	return out, req.Send()
}

// GetChannelScheduleWithContext is the same as GetChannelSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) GetChannelScheduleWithContext(ctx aws.Context, input *GetChannelScheduleInput, opts ...request.Option) (*GetChannelScheduleOutput, error) {
	req, out := c.GetChannelScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetChannelSchedulePages iterates over the pages of a GetChannelSchedule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetChannelSchedule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetChannelSchedule operation.
//	pageNum := 0
//	err := client.GetChannelSchedulePages(params,
//	    func(page *mediatailor.GetChannelScheduleOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) GetChannelSchedulePages(input *GetChannelScheduleInput, fn func(*GetChannelScheduleOutput, bool) bool) error {
	return c.GetChannelSchedulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetChannelSchedulePagesWithContext same as GetChannelSchedulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) GetChannelSchedulePagesWithContext(ctx aws.Context, input *GetChannelScheduleInput, fn func(*GetChannelScheduleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetChannelScheduleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetChannelScheduleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetChannelScheduleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPlaybackConfiguration = "GetPlaybackConfiguration"

// GetPlaybackConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetPlaybackConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlaybackConfiguration for more information on using the GetPlaybackConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPlaybackConfigurationRequest method.
//	req, resp := client.GetPlaybackConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPlaybackConfiguration
func (c *MediaTailor) GetPlaybackConfigurationRequest(input *GetPlaybackConfigurationInput) (req *request.Request, output *GetPlaybackConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetPlaybackConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/playbackConfiguration/{Name}",
	}

	if input == nil {
		input = &GetPlaybackConfigurationInput{}
	}

	output = &GetPlaybackConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlaybackConfiguration API operation for AWS MediaTailor.
//
// Retrieves a playback configuration. For information about MediaTailor configurations,
// see Working with configurations in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation GetPlaybackConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPlaybackConfiguration
func (c *MediaTailor) GetPlaybackConfiguration(input *GetPlaybackConfigurationInput) (*GetPlaybackConfigurationOutput, error) {
	req, out := c.GetPlaybackConfigurationRequest(input)
	return out, req.Send()
}

// GetPlaybackConfigurationWithContext is the same as GetPlaybackConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlaybackConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) GetPlaybackConfigurationWithContext(ctx aws.Context, input *GetPlaybackConfigurationInput, opts ...request.Option) (*GetPlaybackConfigurationOutput, error) {
	req, out := c.GetPlaybackConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPrefetchSchedule = "GetPrefetchSchedule"

// GetPrefetchScheduleRequest generates a "aws/request.Request" representing the
// client's request for the GetPrefetchSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPrefetchSchedule for more information on using the GetPrefetchSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPrefetchScheduleRequest method.
//	req, resp := client.GetPrefetchScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPrefetchSchedule
func (c *MediaTailor) GetPrefetchScheduleRequest(input *GetPrefetchScheduleInput) (req *request.Request, output *GetPrefetchScheduleOutput) {
	op := &request.Operation{
		Name:       opGetPrefetchSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/prefetchSchedule/{PlaybackConfigurationName}/{Name}",
	}

	if input == nil {
		input = &GetPrefetchScheduleInput{}
	}

	output = &GetPrefetchScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPrefetchSchedule API operation for AWS MediaTailor.
//
// Retrieves a prefetch schedule for a playback configuration. A prefetch schedule
// allows you to tell MediaTailor to fetch and prepare certain ads before an
// ad break happens. For more information about ad prefetching, see Using ad
// prefetching (https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation GetPrefetchSchedule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPrefetchSchedule
func (c *MediaTailor) GetPrefetchSchedule(input *GetPrefetchScheduleInput) (*GetPrefetchScheduleOutput, error) {
	req, out := c.GetPrefetchScheduleRequest(input)
	return out, req.Send()
}

// GetPrefetchScheduleWithContext is the same as GetPrefetchSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See GetPrefetchSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) GetPrefetchScheduleWithContext(ctx aws.Context, input *GetPrefetchScheduleInput, opts ...request.Option) (*GetPrefetchScheduleOutput, error) {
	req, out := c.GetPrefetchScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAlerts = "ListAlerts"

// ListAlertsRequest generates a "aws/request.Request" representing the
// client's request for the ListAlerts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAlerts for more information on using the ListAlerts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAlertsRequest method.
//	req, resp := client.ListAlertsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts
func (c *MediaTailor) ListAlertsRequest(input *ListAlertsInput) (req *request.Request, output *ListAlertsOutput) {
	op := &request.Operation{
		Name:       opListAlerts,
		HTTPMethod: "GET",
		HTTPPath:   "/alerts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAlertsInput{}
	}

	output = &ListAlertsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAlerts API operation for AWS MediaTailor.
//
// Lists the alerts that are associated with a MediaTailor channel assembly
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListAlerts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts
func (c *MediaTailor) ListAlerts(input *ListAlertsInput) (*ListAlertsOutput, error) {
	req, out := c.ListAlertsRequest(input)
	return out, req.Send()
}

// ListAlertsWithContext is the same as ListAlerts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAlerts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListAlertsWithContext(ctx aws.Context, input *ListAlertsInput, opts ...request.Option) (*ListAlertsOutput, error) {
	req, out := c.ListAlertsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAlertsPages iterates over the pages of a ListAlerts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAlerts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAlerts operation.
//	pageNum := 0
//	err := client.ListAlertsPages(params,
//	    func(page *mediatailor.ListAlertsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListAlertsPages(input *ListAlertsInput, fn func(*ListAlertsOutput, bool) bool) error {
	return c.ListAlertsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAlertsPagesWithContext same as ListAlertsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListAlertsPagesWithContext(ctx aws.Context, input *ListAlertsInput, fn func(*ListAlertsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAlertsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAlertsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAlertsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsRequest method.
//	req, resp := client.ListChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels
func (c *MediaTailor) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS MediaTailor.
//
// Retrieves information about the channels that are associated with the current
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListChannels for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels
func (c *MediaTailor) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannels operation.
//	pageNum := 0
//	err := client.ListChannelsPages(params,
//	    func(page *mediatailor.ListChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLiveSources = "ListLiveSources"

// ListLiveSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListLiveSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLiveSources for more information on using the ListLiveSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLiveSourcesRequest method.
//	req, resp := client.ListLiveSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListLiveSources
func (c *MediaTailor) ListLiveSourcesRequest(input *ListLiveSourcesInput) (req *request.Request, output *ListLiveSourcesOutput) {
	op := &request.Operation{
		Name:       opListLiveSources,
		HTTPMethod: "GET",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/liveSources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLiveSourcesInput{}
	}

	output = &ListLiveSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLiveSources API operation for AWS MediaTailor.
//
// Lists the live sources contained in a source location. A source represents
// a piece of content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListLiveSources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListLiveSources
func (c *MediaTailor) ListLiveSources(input *ListLiveSourcesInput) (*ListLiveSourcesOutput, error) {
	req, out := c.ListLiveSourcesRequest(input)
	return out, req.Send()
}

// ListLiveSourcesWithContext is the same as ListLiveSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListLiveSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListLiveSourcesWithContext(ctx aws.Context, input *ListLiveSourcesInput, opts ...request.Option) (*ListLiveSourcesOutput, error) {
	req, out := c.ListLiveSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLiveSourcesPages iterates over the pages of a ListLiveSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLiveSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLiveSources operation.
//	pageNum := 0
//	err := client.ListLiveSourcesPages(params,
//	    func(page *mediatailor.ListLiveSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListLiveSourcesPages(input *ListLiveSourcesInput, fn func(*ListLiveSourcesOutput, bool) bool) error {
	return c.ListLiveSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLiveSourcesPagesWithContext same as ListLiveSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListLiveSourcesPagesWithContext(ctx aws.Context, input *ListLiveSourcesInput, fn func(*ListLiveSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLiveSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLiveSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLiveSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlaybackConfigurations = "ListPlaybackConfigurations"

// ListPlaybackConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlaybackConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlaybackConfigurations for more information on using the ListPlaybackConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPlaybackConfigurationsRequest method.
//	req, resp := client.ListPlaybackConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations
func (c *MediaTailor) ListPlaybackConfigurationsRequest(input *ListPlaybackConfigurationsInput) (req *request.Request, output *ListPlaybackConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListPlaybackConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/playbackConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlaybackConfigurationsInput{}
	}

	output = &ListPlaybackConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlaybackConfigurations API operation for AWS MediaTailor.
//
// Retrieves existing playback configurations. For information about MediaTailor
// configurations, see Working with Configurations in AWS Elemental MediaTailor
// (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListPlaybackConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations
func (c *MediaTailor) ListPlaybackConfigurations(input *ListPlaybackConfigurationsInput) (*ListPlaybackConfigurationsOutput, error) {
	req, out := c.ListPlaybackConfigurationsRequest(input)
	return out, req.Send()
}

// ListPlaybackConfigurationsWithContext is the same as ListPlaybackConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlaybackConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListPlaybackConfigurationsWithContext(ctx aws.Context, input *ListPlaybackConfigurationsInput, opts ...request.Option) (*ListPlaybackConfigurationsOutput, error) {
	req, out := c.ListPlaybackConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlaybackConfigurationsPages iterates over the pages of a ListPlaybackConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlaybackConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPlaybackConfigurations operation.
//	pageNum := 0
//	err := client.ListPlaybackConfigurationsPages(params,
//	    func(page *mediatailor.ListPlaybackConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListPlaybackConfigurationsPages(input *ListPlaybackConfigurationsInput, fn func(*ListPlaybackConfigurationsOutput, bool) bool) error {
	return c.ListPlaybackConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlaybackConfigurationsPagesWithContext same as ListPlaybackConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListPlaybackConfigurationsPagesWithContext(ctx aws.Context, input *ListPlaybackConfigurationsInput, fn func(*ListPlaybackConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlaybackConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlaybackConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlaybackConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPrefetchSchedules = "ListPrefetchSchedules"

// ListPrefetchSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListPrefetchSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrefetchSchedules for more information on using the ListPrefetchSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPrefetchSchedulesRequest method.
//	req, resp := client.ListPrefetchSchedulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules
func (c *MediaTailor) ListPrefetchSchedulesRequest(input *ListPrefetchSchedulesInput) (req *request.Request, output *ListPrefetchSchedulesOutput) {
	op := &request.Operation{
		Name:       opListPrefetchSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/prefetchSchedule/{PlaybackConfigurationName}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPrefetchSchedulesInput{}
	}

	output = &ListPrefetchSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrefetchSchedules API operation for AWS MediaTailor.
//
// Lists the prefetch schedules for a playback configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListPrefetchSchedules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules
func (c *MediaTailor) ListPrefetchSchedules(input *ListPrefetchSchedulesInput) (*ListPrefetchSchedulesOutput, error) {
	req, out := c.ListPrefetchSchedulesRequest(input)
	return out, req.Send()
}

// ListPrefetchSchedulesWithContext is the same as ListPrefetchSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrefetchSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListPrefetchSchedulesWithContext(ctx aws.Context, input *ListPrefetchSchedulesInput, opts ...request.Option) (*ListPrefetchSchedulesOutput, error) {
	req, out := c.ListPrefetchSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPrefetchSchedulesPages iterates over the pages of a ListPrefetchSchedules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrefetchSchedules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPrefetchSchedules operation.
//	pageNum := 0
//	err := client.ListPrefetchSchedulesPages(params,
//	    func(page *mediatailor.ListPrefetchSchedulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListPrefetchSchedulesPages(input *ListPrefetchSchedulesInput, fn func(*ListPrefetchSchedulesOutput, bool) bool) error {
	return c.ListPrefetchSchedulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPrefetchSchedulesPagesWithContext same as ListPrefetchSchedulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListPrefetchSchedulesPagesWithContext(ctx aws.Context, input *ListPrefetchSchedulesInput, fn func(*ListPrefetchSchedulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPrefetchSchedulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPrefetchSchedulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPrefetchSchedulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSourceLocations = "ListSourceLocations"

// ListSourceLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSourceLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSourceLocations for more information on using the ListSourceLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSourceLocationsRequest method.
//	req, resp := client.ListSourceLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations
func (c *MediaTailor) ListSourceLocationsRequest(input *ListSourceLocationsInput) (req *request.Request, output *ListSourceLocationsOutput) {
	op := &request.Operation{
		Name:       opListSourceLocations,
		HTTPMethod: "GET",
		HTTPPath:   "/sourceLocations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSourceLocationsInput{}
	}

	output = &ListSourceLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSourceLocations API operation for AWS MediaTailor.
//
// Lists the source locations for a channel. A source location defines the host
// server URL, and contains a list of sources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListSourceLocations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations
func (c *MediaTailor) ListSourceLocations(input *ListSourceLocationsInput) (*ListSourceLocationsOutput, error) {
	req, out := c.ListSourceLocationsRequest(input)
	return out, req.Send()
}

// ListSourceLocationsWithContext is the same as ListSourceLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSourceLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListSourceLocationsWithContext(ctx aws.Context, input *ListSourceLocationsInput, opts ...request.Option) (*ListSourceLocationsOutput, error) {
	req, out := c.ListSourceLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSourceLocationsPages iterates over the pages of a ListSourceLocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSourceLocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSourceLocations operation.
//	pageNum := 0
//	err := client.ListSourceLocationsPages(params,
//	    func(page *mediatailor.ListSourceLocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListSourceLocationsPages(input *ListSourceLocationsInput, fn func(*ListSourceLocationsOutput, bool) bool) error {
	return c.ListSourceLocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSourceLocationsPagesWithContext same as ListSourceLocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListSourceLocationsPagesWithContext(ctx aws.Context, input *ListSourceLocationsInput, fn func(*ListSourceLocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSourceLocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSourceLocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSourceLocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListTagsForResource
func (c *MediaTailor) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS MediaTailor.
//
// A list of tags that are associated with this resource. Tags are key-value
// pairs that you can associate with Amazon resources to help with organization,
// access control, and cost tracking. For more information, see Tagging AWS
// Elemental MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   - BadRequestException
//     A request contains unexpected data.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListTagsForResource
func (c *MediaTailor) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVodSources = "ListVodSources"

// ListVodSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListVodSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVodSources for more information on using the ListVodSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVodSourcesRequest method.
//	req, resp := client.ListVodSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources
func (c *MediaTailor) ListVodSourcesRequest(input *ListVodSourcesInput) (req *request.Request, output *ListVodSourcesOutput) {
	op := &request.Operation{
		Name:       opListVodSources,
		HTTPMethod: "GET",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/vodSources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVodSourcesInput{}
	}

	output = &ListVodSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVodSources API operation for AWS MediaTailor.
//
// Lists the VOD sources contained in a source location. A source represents
// a piece of content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation ListVodSources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources
func (c *MediaTailor) ListVodSources(input *ListVodSourcesInput) (*ListVodSourcesOutput, error) {
	req, out := c.ListVodSourcesRequest(input)
	return out, req.Send()
}

// ListVodSourcesWithContext is the same as ListVodSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListVodSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListVodSourcesWithContext(ctx aws.Context, input *ListVodSourcesInput, opts ...request.Option) (*ListVodSourcesOutput, error) {
	req, out := c.ListVodSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVodSourcesPages iterates over the pages of a ListVodSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVodSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVodSources operation.
//	pageNum := 0
//	err := client.ListVodSourcesPages(params,
//	    func(page *mediatailor.ListVodSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaTailor) ListVodSourcesPages(input *ListVodSourcesInput, fn func(*ListVodSourcesOutput, bool) bool) error {
	return c.ListVodSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVodSourcesPagesWithContext same as ListVodSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) ListVodSourcesPagesWithContext(ctx aws.Context, input *ListVodSourcesInput, fn func(*ListVodSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVodSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVodSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVodSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutChannelPolicy = "PutChannelPolicy"

// PutChannelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutChannelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutChannelPolicy for more information on using the PutChannelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutChannelPolicyRequest method.
//	req, resp := client.PutChannelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutChannelPolicy
func (c *MediaTailor) PutChannelPolicyRequest(input *PutChannelPolicyInput) (req *request.Request, output *PutChannelPolicyOutput) {
	op := &request.Operation{
		Name:       opPutChannelPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/channel/{ChannelName}/policy",
	}

	if input == nil {
		input = &PutChannelPolicyInput{}
	}

	output = &PutChannelPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutChannelPolicy API operation for AWS MediaTailor.
//
// Creates an IAM policy for the channel. IAM policies are used to control access
// to your channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation PutChannelPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutChannelPolicy
func (c *MediaTailor) PutChannelPolicy(input *PutChannelPolicyInput) (*PutChannelPolicyOutput, error) {
	req, out := c.PutChannelPolicyRequest(input)
	return out, req.Send()
}

// PutChannelPolicyWithContext is the same as PutChannelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutChannelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) PutChannelPolicyWithContext(ctx aws.Context, input *PutChannelPolicyInput, opts ...request.Option) (*PutChannelPolicyOutput, error) {
	req, out := c.PutChannelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPlaybackConfiguration = "PutPlaybackConfiguration"

// PutPlaybackConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutPlaybackConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPlaybackConfiguration for more information on using the PutPlaybackConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPlaybackConfigurationRequest method.
//	req, resp := client.PutPlaybackConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutPlaybackConfiguration
func (c *MediaTailor) PutPlaybackConfigurationRequest(input *PutPlaybackConfigurationInput) (req *request.Request, output *PutPlaybackConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutPlaybackConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/playbackConfiguration",
	}

	if input == nil {
		input = &PutPlaybackConfigurationInput{}
	}

	output = &PutPlaybackConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutPlaybackConfiguration API operation for AWS MediaTailor.
//
// Creates a playback configuration. For information about MediaTailor configurations,
// see Working with configurations in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation PutPlaybackConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutPlaybackConfiguration
func (c *MediaTailor) PutPlaybackConfiguration(input *PutPlaybackConfigurationInput) (*PutPlaybackConfigurationOutput, error) {
	req, out := c.PutPlaybackConfigurationRequest(input)
	return out, req.Send()
}

// PutPlaybackConfigurationWithContext is the same as PutPlaybackConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutPlaybackConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) PutPlaybackConfigurationWithContext(ctx aws.Context, input *PutPlaybackConfigurationInput, opts ...request.Option) (*PutPlaybackConfigurationOutput, error) {
	req, out := c.PutPlaybackConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartChannel = "StartChannel"

// StartChannelRequest generates a "aws/request.Request" representing the
// client's request for the StartChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChannel for more information on using the StartChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartChannelRequest method.
//	req, resp := client.StartChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StartChannel
func (c *MediaTailor) StartChannelRequest(input *StartChannelInput) (req *request.Request, output *StartChannelOutput) {
	op := &request.Operation{
		Name:       opStartChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channel/{ChannelName}/start",
	}

	if input == nil {
		input = &StartChannelInput{}
	}

	output = &StartChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartChannel API operation for AWS MediaTailor.
//
// Starts a channel. For information about MediaTailor channels, see Working
// with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation StartChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StartChannel
func (c *MediaTailor) StartChannel(input *StartChannelInput) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	return out, req.Send()
}

// StartChannelWithContext is the same as StartChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StartChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) StartChannelWithContext(ctx aws.Context, input *StartChannelInput, opts ...request.Option) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopChannel = "StopChannel"

// StopChannelRequest generates a "aws/request.Request" representing the
// client's request for the StopChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopChannel for more information on using the StopChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopChannelRequest method.
//	req, resp := client.StopChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StopChannel
func (c *MediaTailor) StopChannelRequest(input *StopChannelInput) (req *request.Request, output *StopChannelOutput) {
	op := &request.Operation{
		Name:       opStopChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channel/{ChannelName}/stop",
	}

	if input == nil {
		input = &StopChannelInput{}
	}

	output = &StopChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopChannel API operation for AWS MediaTailor.
//
// Stops a channel. For information about MediaTailor channels, see Working
// with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation StopChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StopChannel
func (c *MediaTailor) StopChannel(input *StopChannelInput) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	return out, req.Send()
}

// StopChannelWithContext is the same as StopChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StopChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) StopChannelWithContext(ctx aws.Context, input *StopChannelInput, opts ...request.Option) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/TagResource
func (c *MediaTailor) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS MediaTailor.
//
// The resource to tag. Tags are key-value pairs that you can associate with
// Amazon resources to help with organization, access control, and cost tracking.
// For more information, see Tagging AWS Elemental MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   - BadRequestException
//     A request contains unexpected data.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/TagResource
func (c *MediaTailor) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UntagResource
func (c *MediaTailor) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS MediaTailor.
//
// The resource to untag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   - BadRequestException
//     A request contains unexpected data.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UntagResource
func (c *MediaTailor) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelRequest method.
//	req, resp := client.UpdateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateChannel
func (c *MediaTailor) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channel/{ChannelName}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for AWS MediaTailor.
//
// Updates a channel. For information about MediaTailor channels, see Working
// with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation UpdateChannel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateChannel
func (c *MediaTailor) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLiveSource = "UpdateLiveSource"

// UpdateLiveSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLiveSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLiveSource for more information on using the UpdateLiveSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLiveSourceRequest method.
//	req, resp := client.UpdateLiveSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateLiveSource
func (c *MediaTailor) UpdateLiveSourceRequest(input *UpdateLiveSourceInput) (req *request.Request, output *UpdateLiveSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateLiveSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}",
	}

	if input == nil {
		input = &UpdateLiveSourceInput{}
	}

	output = &UpdateLiveSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLiveSource API operation for AWS MediaTailor.
//
// Updates a live source's configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation UpdateLiveSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateLiveSource
func (c *MediaTailor) UpdateLiveSource(input *UpdateLiveSourceInput) (*UpdateLiveSourceOutput, error) {
	req, out := c.UpdateLiveSourceRequest(input)
	return out, req.Send()
}

// UpdateLiveSourceWithContext is the same as UpdateLiveSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLiveSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) UpdateLiveSourceWithContext(ctx aws.Context, input *UpdateLiveSourceInput, opts ...request.Option) (*UpdateLiveSourceOutput, error) {
	req, out := c.UpdateLiveSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProgram = "UpdateProgram"

// UpdateProgramRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProgram for more information on using the UpdateProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProgramRequest method.
//	req, resp := client.UpdateProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateProgram
func (c *MediaTailor) UpdateProgramRequest(input *UpdateProgramInput) (req *request.Request, output *UpdateProgramOutput) {
	op := &request.Operation{
		Name:       opUpdateProgram,
		HTTPMethod: "PUT",
		HTTPPath:   "/channel/{ChannelName}/program/{ProgramName}",
	}

	if input == nil {
		input = &UpdateProgramInput{}
	}

	output = &UpdateProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProgram API operation for AWS MediaTailor.
//
// Updates a program within a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation UpdateProgram for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateProgram
func (c *MediaTailor) UpdateProgram(input *UpdateProgramInput) (*UpdateProgramOutput, error) {
	req, out := c.UpdateProgramRequest(input)
	return out, req.Send()
}

// UpdateProgramWithContext is the same as UpdateProgram with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) UpdateProgramWithContext(ctx aws.Context, input *UpdateProgramInput, opts ...request.Option) (*UpdateProgramOutput, error) {
	req, out := c.UpdateProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSourceLocation = "UpdateSourceLocation"

// UpdateSourceLocationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSourceLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSourceLocation for more information on using the UpdateSourceLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSourceLocationRequest method.
//	req, resp := client.UpdateSourceLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateSourceLocation
func (c *MediaTailor) UpdateSourceLocationRequest(input *UpdateSourceLocationInput) (req *request.Request, output *UpdateSourceLocationOutput) {
	op := &request.Operation{
		Name:       opUpdateSourceLocation,
		HTTPMethod: "PUT",
		HTTPPath:   "/sourceLocation/{SourceLocationName}",
	}

	if input == nil {
		input = &UpdateSourceLocationInput{}
	}

	output = &UpdateSourceLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSourceLocation API operation for AWS MediaTailor.
//
// Updates a source location. A source location is a container for sources.
// For more information about source locations, see Working with source locations
// (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html)
// in the MediaTailor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation UpdateSourceLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateSourceLocation
func (c *MediaTailor) UpdateSourceLocation(input *UpdateSourceLocationInput) (*UpdateSourceLocationOutput, error) {
	req, out := c.UpdateSourceLocationRequest(input)
	return out, req.Send()
}

// UpdateSourceLocationWithContext is the same as UpdateSourceLocation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSourceLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) UpdateSourceLocationWithContext(ctx aws.Context, input *UpdateSourceLocationInput, opts ...request.Option) (*UpdateSourceLocationOutput, error) {
	req, out := c.UpdateSourceLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVodSource = "UpdateVodSource"

// UpdateVodSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVodSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVodSource for more information on using the UpdateVodSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVodSourceRequest method.
//	req, resp := client.UpdateVodSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateVodSource
func (c *MediaTailor) UpdateVodSourceRequest(input *UpdateVodSourceInput) (req *request.Request, output *UpdateVodSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateVodSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}",
	}

	if input == nil {
		input = &UpdateVodSourceInput{}
	}

	output = &UpdateVodSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVodSource API operation for AWS MediaTailor.
//
// Updates a VOD source's configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaTailor's
// API operation UpdateVodSource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateVodSource
func (c *MediaTailor) UpdateVodSource(input *UpdateVodSourceInput) (*UpdateVodSourceOutput, error) {
	req, out := c.UpdateVodSourceRequest(input)
	return out, req.Send()
}

// UpdateVodSourceWithContext is the same as UpdateVodSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVodSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaTailor) UpdateVodSourceWithContext(ctx aws.Context, input *UpdateVodSourceInput, opts ...request.Option) (*UpdateVodSourceOutput, error) {
	req, out := c.UpdateVodSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access configuration parameters.
type AccessConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of authentication used to access content from HttpConfiguration::BaseUrl
	// on your source location.
	//
	// S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style
	// access. If your source location base URL is an Amazon S3 bucket, MediaTailor
	// can use AWS Signature Version 4 (SigV4) authentication to access the bucket
	// where your source content is stored. Your MediaTailor source location baseURL
	// must follow the S3 virtual hosted-style request URL format. For example,
	// https://bucket-name.s3.Region.amazonaws.com/key-name.
	//
	// Before you can use S3_SIGV4, you must meet these requirements:
	//
	// • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com
	// principal access in IAM. For information about configuring access in IAM,
	// see Access management in the IAM User Guide.
	//
	// • The mediatailor.amazonaws.com service principal must have permissions
	// to read all top level manifests referenced by the VodSource packaging configurations.
	//
	// • The caller of the API must have s3:GetObject IAM permissions to read
	// all top level manifests referenced by your MediaTailor VodSource packaging
	// configurations.
	//
	// AUTODETECT_SIGV4 - AWS Signature Version 4 authentication for a set of supported
	// services: MediaPackage Version 2 and Amazon S3 hosted virtual-style access.
	// If your source location base URL is a MediaPackage Version 2 endpoint or
	// an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
	// authentication to access the resource where your source content is stored.
	//
	// Before you can use AUTODETECT_SIGV4 with a MediaPackage Version 2 endpoint,
	// you must meet these requirements:
	//
	// • You must grant MediaTailor access to your MediaPackage endpoint by granting
	// mediatailor.amazonaws.com principal access in an Origin Access policy on
	// the endpoint.
	//
	// • Your MediaTailor source location base URL must be a MediaPackage V2 endpoint.
	//
	// • The caller of the API must have mediapackagev2:GetObject IAM permissions
	// to read all top level manifests referenced by the MediaTailor source packaging
	// configurations.
	//
	// Before you can use AUTODETECT_SIGV4 with an Amazon S3 bucket, you must meet
	// these requirements:
	//
	// • You must grant MediaTailor access to your S3 bucket by granting mediatailor.amazonaws.com
	// principal access in IAM. For more information about configuring access in
	// IAM, see Access management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
	// in the IAM User Guide..
	//
	// • The mediatailor.amazonaws.com service principal must have permissions
	// to read all top-level manifests referenced by the VodSource packaging configurations.
	//
	// • The caller of the API must have s3:GetObject IAM permissions to read
	// all top level manifests referenced by your MediaTailor VodSource packaging
	// configurations.
	AccessType *string `type:"string" enum:"AccessType"`

	// AWS Secrets Manager access token configuration parameters.
	SecretsManagerAccessTokenConfiguration *SecretsManagerAccessTokenConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessConfiguration) GoString() string {
	return s.String()
}

// SetAccessType sets the AccessType field's value.
func (s *AccessConfiguration) SetAccessType(v string) *AccessConfiguration {
	s.AccessType = &v
	return s
}

// SetSecretsManagerAccessTokenConfiguration sets the SecretsManagerAccessTokenConfiguration field's value.
func (s *AccessConfiguration) SetSecretsManagerAccessTokenConfiguration(v *SecretsManagerAccessTokenConfiguration) *AccessConfiguration {
	s.SecretsManagerAccessTokenConfiguration = v
	return s
}

// Ad break configuration parameters.
type AdBreak struct {
	_ struct{} `type:"structure"`

	// Defines a list of key/value pairs that MediaTailor generates within the EXT-X-ASSETtag
	// for SCTE35_ENHANCED output.
	AdBreakMetadata []*KeyValuePair `type:"list"`

	// The SCTE-35 ad insertion type. Accepted value: SPLICE_INSERT, TIME_SIGNAL.
	MessageType *string `type:"string" enum:"MessageType"`

	// How long (in milliseconds) after the beginning of the program that an ad
	// starts. This value must fall within 100ms of a segment boundary, otherwise
	// the ad break will be skipped.
	//
	// OffsetMillis is a required field
	OffsetMillis *int64 `type:"long" required:"true"`

	// Ad break slate configuration.
	Slate *SlateSource `type:"structure"`

	// This defines the SCTE-35 splice_insert() message inserted around the ad.
	// For information about using splice_insert(), see the SCTE-35 specficiaiton,
	// section 9.7.3.1.
	SpliceInsertMessage *SpliceInsertMessage `type:"structure"`

	// Defines the SCTE-35 time_signal message inserted around the ad.
	//
	// Programs on a channel's schedule can be configured with one or more ad breaks.
	// You can attach a splice_insert SCTE-35 message to the ad break. This message
	// provides basic metadata about the ad break.
	//
	// See section 9.7.4 of the 2022 SCTE-35 specification for more information.
	TimeSignalMessage *TimeSignalMessage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdBreak) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdBreak) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdBreak) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdBreak"}
	if s.OffsetMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("OffsetMillis"))
	}
	if s.AdBreakMetadata != nil {
		for i, v := range s.AdBreakMetadata {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdBreakMetadata", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdBreakMetadata sets the AdBreakMetadata field's value.
func (s *AdBreak) SetAdBreakMetadata(v []*KeyValuePair) *AdBreak {
	s.AdBreakMetadata = v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *AdBreak) SetMessageType(v string) *AdBreak {
	s.MessageType = &v
	return s
}

// SetOffsetMillis sets the OffsetMillis field's value.
func (s *AdBreak) SetOffsetMillis(v int64) *AdBreak {
	s.OffsetMillis = &v
	return s
}

// SetSlate sets the Slate field's value.
func (s *AdBreak) SetSlate(v *SlateSource) *AdBreak {
	s.Slate = v
	return s
}

// SetSpliceInsertMessage sets the SpliceInsertMessage field's value.
func (s *AdBreak) SetSpliceInsertMessage(v *SpliceInsertMessage) *AdBreak {
	s.SpliceInsertMessage = v
	return s
}

// SetTimeSignalMessage sets the TimeSignalMessage field's value.
func (s *AdBreak) SetTimeSignalMessage(v *TimeSignalMessage) *AdBreak {
	s.TimeSignalMessage = v
	return s
}

// A location at which a zero-duration ad marker was detected in a VOD source
// manifest.
type AdBreakOpportunity struct {
	_ struct{} `type:"structure"`

	// The offset in milliseconds from the start of the VOD source at which an ad
	// marker was detected.
	//
	// OffsetMillis is a required field
	OffsetMillis *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdBreakOpportunity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdBreakOpportunity) GoString() string {
	return s.String()
}

// SetOffsetMillis sets the OffsetMillis field's value.
func (s *AdBreakOpportunity) SetOffsetMillis(v int64) *AdBreakOpportunity {
	s.OffsetMillis = &v
	return s
}

// For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT,
// and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor
// personalized manifest.
//
// No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has
// a value of 60, but no ads are filled for that ad break, MediaTailor will
// not set the value to 0.
type AdMarkerPassthrough struct {
	_ struct{} `type:"structure"`

	// Enables ad marker passthrough for your configuration.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdMarkerPassthrough) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdMarkerPassthrough) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AdMarkerPassthrough) SetEnabled(v bool) *AdMarkerPassthrough {
	s.Enabled = &v
	return s
}

// Alert configuration parameters.
type Alert struct {
	_ struct{} `type:"structure"`

	// The code for the alert. For example, NOT_PROCESSED.
	//
	// AlertCode is a required field
	AlertCode *string `type:"string" required:"true"`

	// If an alert is generated for a resource, an explanation of the reason for
	// the alert.
	//
	// AlertMessage is a required field
	AlertMessage *string `type:"string" required:"true"`

	// The category that MediaTailor assigns to the alert.
	Category *string `type:"string" enum:"AlertCategory"`

	// The timestamp when the alert was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`

	// The Amazon Resource Names (ARNs) related to this alert.
	//
	// RelatedResourceArns is a required field
	RelatedResourceArns []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alert) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alert) GoString() string {
	return s.String()
}

// SetAlertCode sets the AlertCode field's value.
func (s *Alert) SetAlertCode(v string) *Alert {
	s.AlertCode = &v
	return s
}

// SetAlertMessage sets the AlertMessage field's value.
func (s *Alert) SetAlertMessage(v string) *Alert {
	s.AlertMessage = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *Alert) SetCategory(v string) *Alert {
	s.Category = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Alert) SetLastModifiedTime(v time.Time) *Alert {
	s.LastModifiedTime = &v
	return s
}

// SetRelatedResourceArns sets the RelatedResourceArns field's value.
func (s *Alert) SetRelatedResourceArns(v []*string) *Alert {
	s.RelatedResourceArns = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Alert) SetResourceArn(v string) *Alert {
	s.ResourceArn = &v
	return s
}

// MediaTailor only places (consumes) prefetched ads if the ad break meets the
// criteria defined by the dynamic variables. This gives you granular control
// over which ad break to place the prefetched ads into.
//
// As an example, let's say that you set DynamicVariable to scte.event_id and
// Operator to EQUALS, and your playback configuration has an ADS URL of https://my.ads.server.com/path?&podId=[scte.avail_num]&event=[scte.event_id]&duration=[session.avail_duration_secs].
// And the prefetch request to the ADS contains these values https://my.ads.server.com/path?&podId=3&event=my-awesome-event&duration=30.
// MediaTailor will only insert the prefetched ads into the ad break if has
// a SCTE marker with an event id of my-awesome-event, since it must match the
// event id that MediaTailor uses to query the ADS.
//
// You can specify up to five AvailMatchingCriteria. If you specify multiple
// AvailMatchingCriteria, MediaTailor combines them to match using a logical
// AND. You can model logical OR combinations by creating multiple prefetch
// schedules.
type AvailMatchingCriteria struct {
	_ struct{} `type:"structure"`

	// The dynamic variable(s) that MediaTailor should use as avail matching criteria.
	// MediaTailor only places the prefetched ads into the avail if the avail matches
	// the criteria defined by the dynamic variable. For information about dynamic
	// variables, see Using dynamic ad variables (https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html)
	// in the MediaTailor User Guide.
	//
	// You can include up to 100 dynamic variables.
	//
	// DynamicVariable is a required field
	DynamicVariable *string `type:"string" required:"true"`

	// For the DynamicVariable specified in AvailMatchingCriteria, the Operator
	// that is used for the comparison.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"Operator"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailMatchingCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailMatchingCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailMatchingCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailMatchingCriteria"}
	if s.DynamicVariable == nil {
		invalidParams.Add(request.NewErrParamRequired("DynamicVariable"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDynamicVariable sets the DynamicVariable field's value.
func (s *AvailMatchingCriteria) SetDynamicVariable(v string) *AvailMatchingCriteria {
	s.DynamicVariable = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AvailMatchingCriteria) SetOperator(v string) *AvailMatchingCriteria {
	s.Operator = &v
	return s
}

// The configuration for avail suppression, also known as ad suppression. For
// more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
type AvailSuppression struct {
	_ struct{} `type:"structure"`

	// Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE
	// will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can
	// be used to invoke partial ad break fills when a session starts mid-break.
	FillPolicy *string `type:"string" enum:"FillPolicy"`

	// Sets the ad suppression mode. By default, ad suppression is off and all ad
	// breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE,
	// ad suppression is active and MediaTailor won't fill ad breaks on or behind
	// the ad suppression Value time in the manifest lookback window. When Mode
	// is set to AFTER_LIVE_EDGE, ad suppression is active and MediaTailor won't
	// fill ad breaks that are within the live edge plus the avail suppression value.
	Mode *string `type:"string" enum:"Mode"`

	// A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on
	// or behind this time in the manifest lookback window. If Value is set to 00:00:00,
	// it is in sync with the live edge, and MediaTailor won't fill any ad breaks
	// on or behind the live edge. If you set a Value time, MediaTailor won't fill
	// any ad breaks on or behind this time in the manifest lookback window. For
	// example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur
	// within 45 minutes behind the live edge, but won't fill ad breaks on or behind
	// 45 minutes behind the live edge.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailSuppression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailSuppression) GoString() string {
	return s.String()
}

// SetFillPolicy sets the FillPolicy field's value.
func (s *AvailSuppression) SetFillPolicy(v string) *AvailSuppression {
	s.FillPolicy = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AvailSuppression) SetMode(v string) *AvailSuppression {
	s.Mode = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AvailSuppression) SetValue(v string) *AvailSuppression {
	s.Value = &v
	return s
}

// A request contains unexpected data.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for bumpers. Bumpers are short audio or video clips that
// play at the start or before the end of an ad break. To learn more about bumpers,
// see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
type Bumper struct {
	_ struct{} `type:"structure"`

	// The URL for the end bumper asset.
	EndUrl *string `type:"string"`

	// The URL for the start bumper asset.
	StartUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Bumper) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Bumper) GoString() string {
	return s.String()
}

// SetEndUrl sets the EndUrl field's value.
func (s *Bumper) SetEndUrl(v string) *Bumper {
	s.EndUrl = &v
	return s
}

// SetStartUrl sets the StartUrl field's value.
func (s *Bumper) SetStartUrl(v string) *Bumper {
	s.StartUrl = &v
	return s
}

// The configuration for using a content delivery network (CDN), like Amazon
// CloudFront, for content and ad segment management.
type CdnConfiguration struct {
	_ struct{} `type:"structure"`

	// A non-default content delivery network (CDN) to serve ad segments. By default,
	// AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings
	// as its CDN for ad segments. To set up an alternate CDN, create a rule in
	// your CDN for the origin ads.mediatailor.<region>.amazonaws.com. Then specify
	// the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor
	// serves a manifest, it reports your CDN as the source for ad segments.
	AdSegmentUrlPrefix *string `type:"string"`

	// A content delivery network (CDN) to cache content segments, so that content
	// requests don’t always have to go to the origin server. First, create a
	// rule in your CDN for the content segment origin server. Then specify the
	// rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor
	// serves a manifest, it reports your CDN as the source for content segments.
	ContentSegmentUrlPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CdnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CdnConfiguration) GoString() string {
	return s.String()
}

// SetAdSegmentUrlPrefix sets the AdSegmentUrlPrefix field's value.
func (s *CdnConfiguration) SetAdSegmentUrlPrefix(v string) *CdnConfiguration {
	s.AdSegmentUrlPrefix = &v
	return s
}

// SetContentSegmentUrlPrefix sets the ContentSegmentUrlPrefix field's value.
func (s *CdnConfiguration) SetContentSegmentUrlPrefix(v string) *CdnConfiguration {
	s.ContentSegmentUrlPrefix = &v
	return s
}

// The configuration parameters for a channel. For information about MediaTailor
// channels, see Working with channels (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
type Channel struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// Returns the state whether the channel is running or not.
	//
	// ChannelState is a required field
	ChannelState *string `type:"string" required:"true"`

	// The timestamp of when the channel was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The slate used to fill gaps between programs in the schedule. You must configure
	// filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't
	// support filler slate for channels using the LOOP PlaybackMode.
	FillerSlate *SlateSource `type:"structure"`

	// The timestamp of when the channel was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The log configuration.
	//
	// LogConfiguration is a required field
	LogConfiguration *LogConfigurationForChannel `type:"structure" required:"true"`

	// The channel's output properties.
	//
	// Outputs is a required field
	Outputs []*ResponseOutputItem `type:"list" required:"true"`

	// The type of playback mode for this channel.
	//
	// LINEAR - Programs play back-to-back only once.
	//
	// LOOP - Programs play back-to-back in an endless loop. When the last program
	// in the schedule plays, playback loops back to the first program in the schedule.
	//
	// PlaybackMode is a required field
	PlaybackMode *string `type:"string" required:"true"`

	// The tags to assign to the channel. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The tier for this channel. STANDARD tier channels can contain live programs.
	//
	// Tier is a required field
	Tier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *Channel) SetChannelName(v string) *Channel {
	s.ChannelName = &v
	return s
}

// SetChannelState sets the ChannelState field's value.
func (s *Channel) SetChannelState(v string) *Channel {
	s.ChannelState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Channel) SetCreationTime(v time.Time) *Channel {
	s.CreationTime = &v
	return s
}

// SetFillerSlate sets the FillerSlate field's value.
func (s *Channel) SetFillerSlate(v *SlateSource) *Channel {
	s.FillerSlate = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Channel) SetLastModifiedTime(v time.Time) *Channel {
	s.LastModifiedTime = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *Channel) SetLogConfiguration(v *LogConfigurationForChannel) *Channel {
	s.LogConfiguration = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Channel) SetOutputs(v []*ResponseOutputItem) *Channel {
	s.Outputs = v
	return s
}

// SetPlaybackMode sets the PlaybackMode field's value.
func (s *Channel) SetPlaybackMode(v string) *Channel {
	s.PlaybackMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Channel) SetTags(v map[string]*string) *Channel {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *Channel) SetTier(v string) *Channel {
	s.Tier = &v
	return s
}

// Clip range configuration for the VOD source associated with the program.
type ClipRange struct {
	_ struct{} `type:"structure"`

	// The end offset of the clip range, in milliseconds, starting from the beginning
	// of the VOD source associated with the program.
	//
	// EndOffsetMillis is a required field
	EndOffsetMillis *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClipRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClipRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClipRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClipRange"}
	if s.EndOffsetMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("EndOffsetMillis"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndOffsetMillis sets the EndOffsetMillis field's value.
func (s *ClipRange) SetEndOffsetMillis(v int64) *ClipRange {
	s.EndOffsetMillis = &v
	return s
}

type ConfigureLogsForChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The types of logs to collect.
	//
	// LogTypes is a required field
	LogTypes []*string `type:"list" required:"true" enum:"LogType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureLogsForChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigureLogsForChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.LogTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("LogTypes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *ConfigureLogsForChannelInput) SetChannelName(v string) *ConfigureLogsForChannelInput {
	s.ChannelName = &v
	return s
}

// SetLogTypes sets the LogTypes field's value.
func (s *ConfigureLogsForChannelInput) SetLogTypes(v []*string) *ConfigureLogsForChannelInput {
	s.LogTypes = v
	return s
}

type ConfigureLogsForChannelOutput struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	ChannelName *string `type:"string"`

	// The types of logs collected.
	LogTypes []*string `type:"list" enum:"LogType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForChannelOutput) GoString() string {
	return s.String()
}

// SetChannelName sets the ChannelName field's value.
func (s *ConfigureLogsForChannelOutput) SetChannelName(v string) *ConfigureLogsForChannelOutput {
	s.ChannelName = &v
	return s
}

// SetLogTypes sets the LogTypes field's value.
func (s *ConfigureLogsForChannelOutput) SetLogTypes(v []*string) *ConfigureLogsForChannelOutput {
	s.LogTypes = v
	return s
}

// Configures Amazon CloudWatch log settings for a playback configuration.
type ConfigureLogsForPlaybackConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The percentage of session logs that MediaTailor sends to your Cloudwatch
	// Logs account. For example, if your playback configuration has 1000 sessions
	// and percentEnabled is set to 60, MediaTailor sends logs for 600 of the sessions
	// to CloudWatch Logs. MediaTailor decides at random which of the playback configuration
	// sessions to send logs for. If you want to view logs for a specific session,
	// you can use the debug log mode (https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
	//
	// Valid values: 0 - 100
	//
	// PercentEnabled is a required field
	PercentEnabled *int64 `type:"integer" required:"true"`

	// The name of the playback configuration.
	//
	// PlaybackConfigurationName is a required field
	PlaybackConfigurationName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForPlaybackConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForPlaybackConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureLogsForPlaybackConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigureLogsForPlaybackConfigurationInput"}
	if s.PercentEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("PercentEnabled"))
	}
	if s.PlaybackConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaybackConfigurationName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPercentEnabled sets the PercentEnabled field's value.
func (s *ConfigureLogsForPlaybackConfigurationInput) SetPercentEnabled(v int64) *ConfigureLogsForPlaybackConfigurationInput {
	s.PercentEnabled = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *ConfigureLogsForPlaybackConfigurationInput) SetPlaybackConfigurationName(v string) *ConfigureLogsForPlaybackConfigurationInput {
	s.PlaybackConfigurationName = &v
	return s
}

type ConfigureLogsForPlaybackConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The percentage of session logs that MediaTailor sends to your Cloudwatch
	// Logs account.
	//
	// PercentEnabled is a required field
	PercentEnabled *int64 `type:"integer" required:"true"`

	// The name of the playback configuration.
	PlaybackConfigurationName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForPlaybackConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsForPlaybackConfigurationOutput) GoString() string {
	return s.String()
}

// SetPercentEnabled sets the PercentEnabled field's value.
func (s *ConfigureLogsForPlaybackConfigurationOutput) SetPercentEnabled(v int64) *ConfigureLogsForPlaybackConfigurationOutput {
	s.PercentEnabled = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *ConfigureLogsForPlaybackConfigurationOutput) SetPlaybackConfigurationName(v string) *ConfigureLogsForPlaybackConfigurationOutput {
	s.PlaybackConfigurationName = &v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The slate used to fill gaps between programs in the schedule. You must configure
	// filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't
	// support filler slate for channels using the LOOP PlaybackMode.
	FillerSlate *SlateSource `type:"structure"`

	// The channel's output properties.
	//
	// Outputs is a required field
	Outputs []*RequestOutputItem `type:"list" required:"true"`

	// The type of playback mode to use for this channel.
	//
	// LINEAR - The programs in the schedule play once back-to-back in the schedule.
	//
	// LOOP - The programs in the schedule play back-to-back in an endless loop.
	// When the last program in the schedule stops playing, playback loops back
	// to the first program in the schedule.
	//
	// PlaybackMode is a required field
	PlaybackMode *string `type:"string" required:"true" enum:"PlaybackMode"`

	// The tags to assign to the channel. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The tier of the channel.
	Tier *string `type:"string" enum:"Tier"`

	// The time-shifted viewing configuration you want to associate to the channel.
	TimeShiftConfiguration *TimeShiftConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.PlaybackMode == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaybackMode"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimeShiftConfiguration != nil {
		if err := s.TimeShiftConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TimeShiftConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateChannelInput) SetChannelName(v string) *CreateChannelInput {
	s.ChannelName = &v
	return s
}

// SetFillerSlate sets the FillerSlate field's value.
func (s *CreateChannelInput) SetFillerSlate(v *SlateSource) *CreateChannelInput {
	s.FillerSlate = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateChannelInput) SetOutputs(v []*RequestOutputItem) *CreateChannelInput {
	s.Outputs = v
	return s
}

// SetPlaybackMode sets the PlaybackMode field's value.
func (s *CreateChannelInput) SetPlaybackMode(v string) *CreateChannelInput {
	s.PlaybackMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *CreateChannelInput) SetTier(v string) *CreateChannelInput {
	s.Tier = &v
	return s
}

// SetTimeShiftConfiguration sets the TimeShiftConfiguration field's value.
func (s *CreateChannelInput) SetTimeShiftConfiguration(v *TimeShiftConfiguration) *CreateChannelInput {
	s.TimeShiftConfiguration = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) to assign to the channel.
	Arn *string `type:"string"`

	// The name to assign to the channel.
	ChannelName *string `type:"string"`

	// Indicates whether the channel is in a running state or not.
	ChannelState *string `type:"string" enum:"ChannelState"`

	// The timestamp of when the channel was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// Contains information about the slate used to fill gaps between programs in
	// the schedule.
	FillerSlate *SlateSource `type:"structure"`

	// The timestamp of when the channel was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The output properties to assign to the channel.
	Outputs []*ResponseOutputItem `type:"list"`

	// The playback mode to assign to the channel.
	PlaybackMode *string `type:"string"`

	// The tags to assign to the channel. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The tier of the channel.
	Tier *string `type:"string"`

	// The time-shifted viewing configuration assigned to the channel.
	TimeShiftConfiguration *TimeShiftConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateChannelOutput) SetArn(v string) *CreateChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateChannelOutput) SetChannelName(v string) *CreateChannelOutput {
	s.ChannelName = &v
	return s
}

// SetChannelState sets the ChannelState field's value.
func (s *CreateChannelOutput) SetChannelState(v string) *CreateChannelOutput {
	s.ChannelState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateChannelOutput) SetCreationTime(v time.Time) *CreateChannelOutput {
	s.CreationTime = &v
	return s
}

// SetFillerSlate sets the FillerSlate field's value.
func (s *CreateChannelOutput) SetFillerSlate(v *SlateSource) *CreateChannelOutput {
	s.FillerSlate = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateChannelOutput) SetLastModifiedTime(v time.Time) *CreateChannelOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateChannelOutput) SetOutputs(v []*ResponseOutputItem) *CreateChannelOutput {
	s.Outputs = v
	return s
}

// SetPlaybackMode sets the PlaybackMode field's value.
func (s *CreateChannelOutput) SetPlaybackMode(v string) *CreateChannelOutput {
	s.PlaybackMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelOutput) SetTags(v map[string]*string) *CreateChannelOutput {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *CreateChannelOutput) SetTier(v string) *CreateChannelOutput {
	s.Tier = &v
	return s
}

// SetTimeShiftConfiguration sets the TimeShiftConfiguration field's value.
func (s *CreateChannelOutput) SetTimeShiftConfiguration(v *TimeShiftConfiguration) *CreateChannelOutput {
	s.TimeShiftConfiguration = v
	return s
}

type CreateLiveSourceInput struct {
	_ struct{} `type:"structure"`

	// A list of HTTP package configuration parameters for this live source.
	//
	// HttpPackageConfigurations is a required field
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list" required:"true"`

	// The name of the live source.
	//
	// LiveSourceName is a required field
	LiveSourceName *string `location:"uri" locationName:"LiveSourceName" type:"string" required:"true"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`

	// The tags to assign to the live source. Tags are key-value pairs that you
	// can associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLiveSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLiveSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLiveSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLiveSourceInput"}
	if s.HttpPackageConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpPackageConfigurations"))
	}
	if s.LiveSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("LiveSourceName"))
	}
	if s.LiveSourceName != nil && len(*s.LiveSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LiveSourceName", 1))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.HttpPackageConfigurations != nil {
		for i, v := range s.HttpPackageConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HttpPackageConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *CreateLiveSourceInput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *CreateLiveSourceInput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *CreateLiveSourceInput) SetLiveSourceName(v string) *CreateLiveSourceInput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateLiveSourceInput) SetSourceLocationName(v string) *CreateLiveSourceInput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLiveSourceInput) SetTags(v map[string]*string) *CreateLiveSourceInput {
	s.Tags = v
	return s
}

type CreateLiveSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN to assign to the live source.
	Arn *string `type:"string"`

	// The time the live source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// A list of HTTP package configuration parameters for this live source.
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list"`

	// The time the live source was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name to assign to the live source.
	LiveSourceName *string `type:"string"`

	// The name to assign to the source location of the live source.
	SourceLocationName *string `type:"string"`

	// The tags to assign to the live source. Tags are key-value pairs that you
	// can associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLiveSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLiveSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLiveSourceOutput) SetArn(v string) *CreateLiveSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateLiveSourceOutput) SetCreationTime(v time.Time) *CreateLiveSourceOutput {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *CreateLiveSourceOutput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *CreateLiveSourceOutput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateLiveSourceOutput) SetLastModifiedTime(v time.Time) *CreateLiveSourceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *CreateLiveSourceOutput) SetLiveSourceName(v string) *CreateLiveSourceOutput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateLiveSourceOutput) SetSourceLocationName(v string) *CreateLiveSourceOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLiveSourceOutput) SetTags(v map[string]*string) *CreateLiveSourceOutput {
	s.Tags = v
	return s
}

type CreatePrefetchScheduleInput struct {
	_ struct{} `type:"structure"`

	// The configuration settings for MediaTailor's consumption of the prefetched
	// ads from the ad decision server. Each consumption configuration contains
	// an end time and an optional start time that define the consumption window.
	// Prefetch schedules automatically expire no earlier than seven days after
	// the end time.
	//
	// Consumption is a required field
	Consumption *PrefetchConsumption `type:"structure" required:"true"`

	// The name to assign to the schedule request.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`

	// The name to assign to the playback configuration.
	//
	// PlaybackConfigurationName is a required field
	PlaybackConfigurationName *string `location:"uri" locationName:"PlaybackConfigurationName" type:"string" required:"true"`

	// The configuration settings for retrieval of prefetched ads from the ad decision
	// server. Only one set of prefetched ads will be retrieved and subsequently
	// consumed for each ad break.
	//
	// Retrieval is a required field
	Retrieval *PrefetchRetrieval `type:"structure" required:"true"`

	// An optional stream identifier that MediaTailor uses to prefetch ads for multiple
	// streams that use the same playback configuration. If StreamId is specified,
	// MediaTailor returns all of the prefetch schedules with an exact match on
	// StreamId. If not specified, MediaTailor returns all of the prefetch schedules
	// for the playback configuration, regardless of StreamId.
	StreamId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrefetchScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrefetchScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrefetchScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrefetchScheduleInput"}
	if s.Consumption == nil {
		invalidParams.Add(request.NewErrParamRequired("Consumption"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PlaybackConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaybackConfigurationName"))
	}
	if s.PlaybackConfigurationName != nil && len(*s.PlaybackConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlaybackConfigurationName", 1))
	}
	if s.Retrieval == nil {
		invalidParams.Add(request.NewErrParamRequired("Retrieval"))
	}
	if s.Consumption != nil {
		if err := s.Consumption.Validate(); err != nil {
			invalidParams.AddNested("Consumption", err.(request.ErrInvalidParams))
		}
	}
	if s.Retrieval != nil {
		if err := s.Retrieval.Validate(); err != nil {
			invalidParams.AddNested("Retrieval", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumption sets the Consumption field's value.
func (s *CreatePrefetchScheduleInput) SetConsumption(v *PrefetchConsumption) *CreatePrefetchScheduleInput {
	s.Consumption = v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePrefetchScheduleInput) SetName(v string) *CreatePrefetchScheduleInput {
	s.Name = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *CreatePrefetchScheduleInput) SetPlaybackConfigurationName(v string) *CreatePrefetchScheduleInput {
	s.PlaybackConfigurationName = &v
	return s
}

// SetRetrieval sets the Retrieval field's value.
func (s *CreatePrefetchScheduleInput) SetRetrieval(v *PrefetchRetrieval) *CreatePrefetchScheduleInput {
	s.Retrieval = v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CreatePrefetchScheduleInput) SetStreamId(v string) *CreatePrefetchScheduleInput {
	s.StreamId = &v
	return s
}

type CreatePrefetchScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The ARN to assign to the prefetch schedule.
	Arn *string `type:"string"`

	// The configuration settings for MediaTailor's consumption of the prefetched
	// ads from the ad decision server. Each consumption configuration contains
	// an end time and an optional start time that define the consumption window.
	// Prefetch schedules automatically expire no earlier than seven days after
	// the end time.
	Consumption *PrefetchConsumption `type:"structure"`

	// The name to assign to the prefetch schedule.
	Name *string `type:"string"`

	// The name to assign to the playback configuration.
	PlaybackConfigurationName *string `type:"string"`

	// The configuration settings for retrieval of prefetched ads from the ad decision
	// server. Only one set of prefetched ads will be retrieved and subsequently
	// consumed for each ad break.
	Retrieval *PrefetchRetrieval `type:"structure"`

	// An optional stream identifier that MediaTailor uses to prefetch ads for multiple
	// streams that use the same playback configuration. If StreamId is specified,
	// MediaTailor returns all of the prefetch schedules with an exact match on
	// StreamId. If not specified, MediaTailor returns all of the prefetch schedules
	// for the playback configuration, regardless of StreamId.
	StreamId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrefetchScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePrefetchScheduleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePrefetchScheduleOutput) SetArn(v string) *CreatePrefetchScheduleOutput {
	s.Arn = &v
	return s
}

// SetConsumption sets the Consumption field's value.
func (s *CreatePrefetchScheduleOutput) SetConsumption(v *PrefetchConsumption) *CreatePrefetchScheduleOutput {
	s.Consumption = v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePrefetchScheduleOutput) SetName(v string) *CreatePrefetchScheduleOutput {
	s.Name = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *CreatePrefetchScheduleOutput) SetPlaybackConfigurationName(v string) *CreatePrefetchScheduleOutput {
	s.PlaybackConfigurationName = &v
	return s
}

// SetRetrieval sets the Retrieval field's value.
func (s *CreatePrefetchScheduleOutput) SetRetrieval(v *PrefetchRetrieval) *CreatePrefetchScheduleOutput {
	s.Retrieval = v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CreatePrefetchScheduleOutput) SetStreamId(v string) *CreatePrefetchScheduleOutput {
	s.StreamId = &v
	return s
}

type CreateProgramInput struct {
	_ struct{} `type:"structure"`

	// The ad break configuration settings.
	AdBreaks []*AdBreak `type:"list"`

	// The name of the channel for this Program.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The name of the LiveSource for this Program.
	LiveSourceName *string `type:"string"`

	// The name of the Program.
	//
	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"ProgramName" type:"string" required:"true"`

	// The schedule configuration settings.
	//
	// ScheduleConfiguration is a required field
	ScheduleConfiguration *ScheduleConfiguration `type:"structure" required:"true"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `type:"string" required:"true"`

	// The name that's used to refer to a VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProgramInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}
	if s.ScheduleConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleConfiguration"))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.AdBreaks != nil {
		for i, v := range s.AdBreaks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdBreaks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScheduleConfiguration != nil {
		if err := s.ScheduleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ScheduleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdBreaks sets the AdBreaks field's value.
func (s *CreateProgramInput) SetAdBreaks(v []*AdBreak) *CreateProgramInput {
	s.AdBreaks = v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateProgramInput) SetChannelName(v string) *CreateProgramInput {
	s.ChannelName = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *CreateProgramInput) SetLiveSourceName(v string) *CreateProgramInput {
	s.LiveSourceName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *CreateProgramInput) SetProgramName(v string) *CreateProgramInput {
	s.ProgramName = &v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *CreateProgramInput) SetScheduleConfiguration(v *ScheduleConfiguration) *CreateProgramInput {
	s.ScheduleConfiguration = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateProgramInput) SetSourceLocationName(v string) *CreateProgramInput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *CreateProgramInput) SetVodSourceName(v string) *CreateProgramInput {
	s.VodSourceName = &v
	return s
}

type CreateProgramOutput struct {
	_ struct{} `type:"structure"`

	// The ad break configuration settings.
	AdBreaks []*AdBreak `type:"list"`

	// The ARN to assign to the program.
	Arn *string `type:"string"`

	// The name to assign to the channel for this program.
	ChannelName *string `type:"string"`

	// The clip range configuration settings.
	ClipRange *ClipRange `type:"structure"`

	// The time the program was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The duration of the live program in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The name of the LiveSource for this Program.
	LiveSourceName *string `type:"string"`

	// The name to assign to this program.
	ProgramName *string `type:"string"`

	// The scheduled start time for this Program.
	ScheduledStartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name to assign to the source location for this program.
	SourceLocationName *string `type:"string"`

	// The name that's used to refer to a VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProgramOutput) GoString() string {
	return s.String()
}

// SetAdBreaks sets the AdBreaks field's value.
func (s *CreateProgramOutput) SetAdBreaks(v []*AdBreak) *CreateProgramOutput {
	s.AdBreaks = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateProgramOutput) SetArn(v string) *CreateProgramOutput {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateProgramOutput) SetChannelName(v string) *CreateProgramOutput {
	s.ChannelName = &v
	return s
}

// SetClipRange sets the ClipRange field's value.
func (s *CreateProgramOutput) SetClipRange(v *ClipRange) *CreateProgramOutput {
	s.ClipRange = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateProgramOutput) SetCreationTime(v time.Time) *CreateProgramOutput {
	s.CreationTime = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *CreateProgramOutput) SetDurationMillis(v int64) *CreateProgramOutput {
	s.DurationMillis = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *CreateProgramOutput) SetLiveSourceName(v string) *CreateProgramOutput {
	s.LiveSourceName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *CreateProgramOutput) SetProgramName(v string) *CreateProgramOutput {
	s.ProgramName = &v
	return s
}

// SetScheduledStartTime sets the ScheduledStartTime field's value.
func (s *CreateProgramOutput) SetScheduledStartTime(v time.Time) *CreateProgramOutput {
	s.ScheduledStartTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateProgramOutput) SetSourceLocationName(v string) *CreateProgramOutput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *CreateProgramOutput) SetVodSourceName(v string) *CreateProgramOutput {
	s.VodSourceName = &v
	return s
}

type CreateSourceLocationInput struct {
	_ struct{} `type:"structure"`

	// Access configuration parameters. Configures the type of authentication used
	// to access content from your source location.
	AccessConfiguration *AccessConfiguration `type:"structure"`

	// The optional configuration for the server that serves segments.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration `type:"structure"`

	// The source's HTTP package configurations.
	//
	// HttpConfiguration is a required field
	HttpConfiguration *HttpConfiguration `type:"structure" required:"true"`

	// A list of the segment delivery configurations associated with this resource.
	SegmentDeliveryConfigurations []*SegmentDeliveryConfiguration `type:"list"`

	// The name associated with the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`

	// The tags to assign to the source location. Tags are key-value pairs that
	// you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSourceLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSourceLocationInput"}
	if s.HttpConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpConfiguration"))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.HttpConfiguration != nil {
		if err := s.HttpConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HttpConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *CreateSourceLocationInput) SetAccessConfiguration(v *AccessConfiguration) *CreateSourceLocationInput {
	s.AccessConfiguration = v
	return s
}

// SetDefaultSegmentDeliveryConfiguration sets the DefaultSegmentDeliveryConfiguration field's value.
func (s *CreateSourceLocationInput) SetDefaultSegmentDeliveryConfiguration(v *DefaultSegmentDeliveryConfiguration) *CreateSourceLocationInput {
	s.DefaultSegmentDeliveryConfiguration = v
	return s
}

// SetHttpConfiguration sets the HttpConfiguration field's value.
func (s *CreateSourceLocationInput) SetHttpConfiguration(v *HttpConfiguration) *CreateSourceLocationInput {
	s.HttpConfiguration = v
	return s
}

// SetSegmentDeliveryConfigurations sets the SegmentDeliveryConfigurations field's value.
func (s *CreateSourceLocationInput) SetSegmentDeliveryConfigurations(v []*SegmentDeliveryConfiguration) *CreateSourceLocationInput {
	s.SegmentDeliveryConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateSourceLocationInput) SetSourceLocationName(v string) *CreateSourceLocationInput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSourceLocationInput) SetTags(v map[string]*string) *CreateSourceLocationInput {
	s.Tags = v
	return s
}

type CreateSourceLocationOutput struct {
	_ struct{} `type:"structure"`

	// Access configuration parameters. Configures the type of authentication used
	// to access content from your source location.
	AccessConfiguration *AccessConfiguration `type:"structure"`

	// The ARN to assign to the source location.
	Arn *string `type:"string"`

	// The time the source location was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The optional configuration for the server that serves segments.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration `type:"structure"`

	// The source's HTTP package configurations.
	HttpConfiguration *HttpConfiguration `type:"structure"`

	// The time the source location was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The segment delivery configurations for the source location. For information
	// about MediaTailor configurations, see Working with configurations in AWS
	// Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
	SegmentDeliveryConfigurations []*SegmentDeliveryConfiguration `type:"list"`

	// The name to assign to the source location.
	SourceLocationName *string `type:"string"`

	// The tags to assign to the source location. Tags are key-value pairs that
	// you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSourceLocationOutput) GoString() string {
	return s.String()
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *CreateSourceLocationOutput) SetAccessConfiguration(v *AccessConfiguration) *CreateSourceLocationOutput {
	s.AccessConfiguration = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateSourceLocationOutput) SetArn(v string) *CreateSourceLocationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateSourceLocationOutput) SetCreationTime(v time.Time) *CreateSourceLocationOutput {
	s.CreationTime = &v
	return s
}

// SetDefaultSegmentDeliveryConfiguration sets the DefaultSegmentDeliveryConfiguration field's value.
func (s *CreateSourceLocationOutput) SetDefaultSegmentDeliveryConfiguration(v *DefaultSegmentDeliveryConfiguration) *CreateSourceLocationOutput {
	s.DefaultSegmentDeliveryConfiguration = v
	return s
}

// SetHttpConfiguration sets the HttpConfiguration field's value.
func (s *CreateSourceLocationOutput) SetHttpConfiguration(v *HttpConfiguration) *CreateSourceLocationOutput {
	s.HttpConfiguration = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateSourceLocationOutput) SetLastModifiedTime(v time.Time) *CreateSourceLocationOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSegmentDeliveryConfigurations sets the SegmentDeliveryConfigurations field's value.
func (s *CreateSourceLocationOutput) SetSegmentDeliveryConfigurations(v []*SegmentDeliveryConfiguration) *CreateSourceLocationOutput {
	s.SegmentDeliveryConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateSourceLocationOutput) SetSourceLocationName(v string) *CreateSourceLocationOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSourceLocationOutput) SetTags(v map[string]*string) *CreateSourceLocationOutput {
	s.Tags = v
	return s
}

type CreateVodSourceInput struct {
	_ struct{} `type:"structure"`

	// A list of HTTP package configuration parameters for this VOD source.
	//
	// HttpPackageConfigurations is a required field
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list" required:"true"`

	// The name of the source location for this VOD source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`

	// The tags to assign to the VOD source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name associated with the VOD source.>
	//
	// VodSourceName is a required field
	VodSourceName *string `location:"uri" locationName:"VodSourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVodSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVodSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVodSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVodSourceInput"}
	if s.HttpPackageConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpPackageConfigurations"))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.VodSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VodSourceName"))
	}
	if s.VodSourceName != nil && len(*s.VodSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VodSourceName", 1))
	}
	if s.HttpPackageConfigurations != nil {
		for i, v := range s.HttpPackageConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HttpPackageConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *CreateVodSourceInput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *CreateVodSourceInput {
	s.HttpPackageConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateVodSourceInput) SetSourceLocationName(v string) *CreateVodSourceInput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVodSourceInput) SetTags(v map[string]*string) *CreateVodSourceInput {
	s.Tags = v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *CreateVodSourceInput) SetVodSourceName(v string) *CreateVodSourceInput {
	s.VodSourceName = &v
	return s
}

type CreateVodSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN to assign to this VOD source.
	Arn *string `type:"string"`

	// The time the VOD source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// A list of HTTP package configuration parameters for this VOD source.
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list"`

	// The time the VOD source was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name to assign to the source location for this VOD source.
	SourceLocationName *string `type:"string"`

	// The tags to assign to the VOD source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name to assign to the VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVodSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVodSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateVodSourceOutput) SetArn(v string) *CreateVodSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateVodSourceOutput) SetCreationTime(v time.Time) *CreateVodSourceOutput {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *CreateVodSourceOutput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *CreateVodSourceOutput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVodSourceOutput) SetLastModifiedTime(v time.Time) *CreateVodSourceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *CreateVodSourceOutput) SetSourceLocationName(v string) *CreateVodSourceOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVodSourceOutput) SetTags(v map[string]*string) *CreateVodSourceOutput {
	s.Tags = v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *CreateVodSourceOutput) SetVodSourceName(v string) *CreateVodSourceOutput {
	s.VodSourceName = &v
	return s
}

// The configuration for DASH content.
type DashConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL generated by MediaTailor to initiate a playback session. The session
	// uses server-side reporting. This setting is ignored in PUT operations.
	ManifestEndpointPrefix *string `type:"string"`

	// The setting that controls whether MediaTailor includes the Location tag in
	// DASH manifests. MediaTailor populates the Location tag with the URL for manifest
	// update requests, to be used by players that don't support sticky redirects.
	// Disable this if you have CDN routing rules set up for accessing MediaTailor
	// manifests, and you are either using client-side reporting or your players
	// support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT.
	// The EMT_DEFAULT setting enables the inclusion of the tag and is the default
	// value.
	MpdLocation *string `type:"string"`

	// The setting that controls whether MediaTailor handles manifests from the
	// origin server as multi-period manifests or single-period manifests. If your
	// origin server produces single-period manifests, set this to SINGLE_PERIOD.
	// The default setting is MULTI_PERIOD. For multi-period manifests, omit this
	// setting or set it to MULTI_PERIOD.
	OriginManifestType *string `type:"string" enum:"OriginManifestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashConfiguration) GoString() string {
	return s.String()
}

// SetManifestEndpointPrefix sets the ManifestEndpointPrefix field's value.
func (s *DashConfiguration) SetManifestEndpointPrefix(v string) *DashConfiguration {
	s.ManifestEndpointPrefix = &v
	return s
}

// SetMpdLocation sets the MpdLocation field's value.
func (s *DashConfiguration) SetMpdLocation(v string) *DashConfiguration {
	s.MpdLocation = &v
	return s
}

// SetOriginManifestType sets the OriginManifestType field's value.
func (s *DashConfiguration) SetOriginManifestType(v string) *DashConfiguration {
	s.OriginManifestType = &v
	return s
}

// The configuration for DASH PUT operations.
type DashConfigurationForPut struct {
	_ struct{} `type:"structure"`

	// The setting that controls whether MediaTailor includes the Location tag in
	// DASH manifests. MediaTailor populates the Location tag with the URL for manifest
	// update requests, to be used by players that don't support sticky redirects.
	// Disable this if you have CDN routing rules set up for accessing MediaTailor
	// manifests, and you are either using client-side reporting or your players
	// support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT.
	// The EMT_DEFAULT setting enables the inclusion of the tag and is the default
	// value.
	MpdLocation *string `type:"string"`

	// The setting that controls whether MediaTailor handles manifests from the
	// origin server as multi-period manifests or single-period manifests. If your
	// origin server produces single-period manifests, set this to SINGLE_PERIOD.
	// The default setting is MULTI_PERIOD. For multi-period manifests, omit this
	// setting or set it to MULTI_PERIOD.
	OriginManifestType *string `type:"string" enum:"OriginManifestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashConfigurationForPut) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashConfigurationForPut) GoString() string {
	return s.String()
}

// SetMpdLocation sets the MpdLocation field's value.
func (s *DashConfigurationForPut) SetMpdLocation(v string) *DashConfigurationForPut {
	s.MpdLocation = &v
	return s
}

// SetOriginManifestType sets the OriginManifestType field's value.
func (s *DashConfigurationForPut) SetOriginManifestType(v string) *DashConfigurationForPut {
	s.OriginManifestType = &v
	return s
}

// Dash manifest configuration parameters.
type DashPlaylistSettings struct {
	_ struct{} `type:"structure"`

	// The total duration (in seconds) of each manifest. Minimum value: 30 seconds.
	// Maximum value: 3600 seconds.
	ManifestWindowSeconds *int64 `type:"integer"`

	// Minimum amount of content (measured in seconds) that a player must keep available
	// in the buffer. Minimum value: 2 seconds. Maximum value: 60 seconds.
	MinBufferTimeSeconds *int64 `type:"integer"`

	// Minimum amount of time (in seconds) that the player should wait before requesting
	// updates to the manifest. Minimum value: 2 seconds. Maximum value: 60 seconds.
	MinUpdatePeriodSeconds *int64 `type:"integer"`

	// Amount of time (in seconds) that the player should be from the live point
	// at the end of the manifest. Minimum value: 2 seconds. Maximum value: 60 seconds.
	SuggestedPresentationDelaySeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashPlaylistSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashPlaylistSettings) GoString() string {
	return s.String()
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *DashPlaylistSettings) SetManifestWindowSeconds(v int64) *DashPlaylistSettings {
	s.ManifestWindowSeconds = &v
	return s
}

// SetMinBufferTimeSeconds sets the MinBufferTimeSeconds field's value.
func (s *DashPlaylistSettings) SetMinBufferTimeSeconds(v int64) *DashPlaylistSettings {
	s.MinBufferTimeSeconds = &v
	return s
}

// SetMinUpdatePeriodSeconds sets the MinUpdatePeriodSeconds field's value.
func (s *DashPlaylistSettings) SetMinUpdatePeriodSeconds(v int64) *DashPlaylistSettings {
	s.MinUpdatePeriodSeconds = &v
	return s
}

// SetSuggestedPresentationDelaySeconds sets the SuggestedPresentationDelaySeconds field's value.
func (s *DashPlaylistSettings) SetSuggestedPresentationDelaySeconds(v int64) *DashPlaylistSettings {
	s.SuggestedPresentationDelaySeconds = &v
	return s
}

// The optional configuration for a server that serves segments. Use this if
// you want the segment delivery server to be different from the source location
// server. For example, you can configure your source location server to be
// an origination server, such as MediaPackage, and the segment delivery server
// to be a content delivery network (CDN), such as CloudFront. If you don't
// specify a segment delivery server, then the source location server is used.
type DefaultSegmentDeliveryConfiguration struct {
	_ struct{} `type:"structure"`

	// The hostname of the server that will be used to serve segments. This string
	// must include the protocol, such as https://.
	BaseUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultSegmentDeliveryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultSegmentDeliveryConfiguration) GoString() string {
	return s.String()
}

// SetBaseUrl sets the BaseUrl field's value.
func (s *DefaultSegmentDeliveryConfiguration) SetBaseUrl(v string) *DefaultSegmentDeliveryConfiguration {
	s.BaseUrl = &v
	return s
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteChannelInput) SetChannelName(v string) *DeleteChannelInput {
	s.ChannelName = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeleteChannelPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel associated with this channel policy.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelPolicyInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteChannelPolicyInput) SetChannelName(v string) *DeleteChannelPolicyInput {
	s.ChannelName = &v
	return s
}

type DeleteChannelPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyOutput) GoString() string {
	return s.String()
}

type DeleteLiveSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the live source.
	//
	// LiveSourceName is a required field
	LiveSourceName *string `location:"uri" locationName:"LiveSourceName" type:"string" required:"true"`

	// The name of the source location associated with this Live Source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLiveSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLiveSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLiveSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLiveSourceInput"}
	if s.LiveSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("LiveSourceName"))
	}
	if s.LiveSourceName != nil && len(*s.LiveSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LiveSourceName", 1))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *DeleteLiveSourceInput) SetLiveSourceName(v string) *DeleteLiveSourceInput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DeleteLiveSourceInput) SetSourceLocationName(v string) *DeleteLiveSourceInput {
	s.SourceLocationName = &v
	return s
}

type DeleteLiveSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLiveSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLiveSourceOutput) GoString() string {
	return s.String()
}

type DeletePlaybackConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the playback configuration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlaybackConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlaybackConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeletePlaybackConfigurationInput) SetName(v string) *DeletePlaybackConfigurationInput {
	s.Name = &v
	return s
}

type DeletePlaybackConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaybackConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePrefetchScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the prefetch schedule. If the action is successful, the service
	// sends back an HTTP 204 response with an empty HTTP body.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`

	// The name of the playback configuration for this prefetch schedule.
	//
	// PlaybackConfigurationName is a required field
	PlaybackConfigurationName *string `location:"uri" locationName:"PlaybackConfigurationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrefetchScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrefetchScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePrefetchScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePrefetchScheduleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PlaybackConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaybackConfigurationName"))
	}
	if s.PlaybackConfigurationName != nil && len(*s.PlaybackConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlaybackConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeletePrefetchScheduleInput) SetName(v string) *DeletePrefetchScheduleInput {
	s.Name = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *DeletePrefetchScheduleInput) SetPlaybackConfigurationName(v string) *DeletePrefetchScheduleInput {
	s.PlaybackConfigurationName = &v
	return s
}

type DeletePrefetchScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrefetchScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrefetchScheduleOutput) GoString() string {
	return s.String()
}

type DeleteProgramInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The name of the program.
	//
	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"ProgramName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProgramInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteProgramInput) SetChannelName(v string) *DeleteProgramInput {
	s.ChannelName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DeleteProgramInput) SetProgramName(v string) *DeleteProgramInput {
	s.ProgramName = &v
	return s
}

type DeleteProgramOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProgramOutput) GoString() string {
	return s.String()
}

type DeleteSourceLocationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSourceLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSourceLocationInput"}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DeleteSourceLocationInput) SetSourceLocationName(v string) *DeleteSourceLocationInput {
	s.SourceLocationName = &v
	return s
}

type DeleteSourceLocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceLocationOutput) GoString() string {
	return s.String()
}

type DeleteVodSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the source location associated with this VOD Source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`

	// The name of the VOD source.
	//
	// VodSourceName is a required field
	VodSourceName *string `location:"uri" locationName:"VodSourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVodSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVodSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVodSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVodSourceInput"}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.VodSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VodSourceName"))
	}
	if s.VodSourceName != nil && len(*s.VodSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VodSourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DeleteVodSourceInput) SetSourceLocationName(v string) *DeleteVodSourceInput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *DeleteVodSourceInput) SetVodSourceName(v string) *DeleteVodSourceInput {
	s.VodSourceName = &v
	return s
}

type DeleteVodSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVodSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVodSourceOutput) GoString() string {
	return s.String()
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DescribeChannelInput) SetChannelName(v string) *DescribeChannelInput {
	s.ChannelName = &v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	Arn *string `type:"string"`

	// The name of the channel.
	ChannelName *string `type:"string"`

	// Indicates whether the channel is in a running state or not.
	ChannelState *string `type:"string" enum:"ChannelState"`

	// The timestamp of when the channel was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// Contains information about the slate used to fill gaps between programs in
	// the schedule.
	FillerSlate *SlateSource `type:"structure"`

	// The timestamp of when the channel was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The log configuration for the channel.
	//
	// LogConfiguration is a required field
	LogConfiguration *LogConfigurationForChannel `type:"structure" required:"true"`

	// The channel's output properties.
	Outputs []*ResponseOutputItem `type:"list"`

	// The channel's playback mode.
	PlaybackMode *string `type:"string"`

	// The tags assigned to the channel. Tags are key-value pairs that you can associate
	// with Amazon resources to help with organization, access control, and cost
	// tracking. For more information, see Tagging AWS Elemental MediaTailor Resources
	// (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The channel's tier.
	Tier *string `type:"string"`

	// The time-shifted viewing configuration for the channel.
	TimeShiftConfiguration *TimeShiftConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeChannelOutput) SetArn(v string) *DescribeChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *DescribeChannelOutput) SetChannelName(v string) *DescribeChannelOutput {
	s.ChannelName = &v
	return s
}

// SetChannelState sets the ChannelState field's value.
func (s *DescribeChannelOutput) SetChannelState(v string) *DescribeChannelOutput {
	s.ChannelState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeChannelOutput) SetCreationTime(v time.Time) *DescribeChannelOutput {
	s.CreationTime = &v
	return s
}

// SetFillerSlate sets the FillerSlate field's value.
func (s *DescribeChannelOutput) SetFillerSlate(v *SlateSource) *DescribeChannelOutput {
	s.FillerSlate = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeChannelOutput) SetLastModifiedTime(v time.Time) *DescribeChannelOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *DescribeChannelOutput) SetLogConfiguration(v *LogConfigurationForChannel) *DescribeChannelOutput {
	s.LogConfiguration = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *DescribeChannelOutput) SetOutputs(v []*ResponseOutputItem) *DescribeChannelOutput {
	s.Outputs = v
	return s
}

// SetPlaybackMode sets the PlaybackMode field's value.
func (s *DescribeChannelOutput) SetPlaybackMode(v string) *DescribeChannelOutput {
	s.PlaybackMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChannelOutput) SetTags(v map[string]*string) *DescribeChannelOutput {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *DescribeChannelOutput) SetTier(v string) *DescribeChannelOutput {
	s.Tier = &v
	return s
}

// SetTimeShiftConfiguration sets the TimeShiftConfiguration field's value.
func (s *DescribeChannelOutput) SetTimeShiftConfiguration(v *TimeShiftConfiguration) *DescribeChannelOutput {
	s.TimeShiftConfiguration = v
	return s
}

type DescribeLiveSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the live source.
	//
	// LiveSourceName is a required field
	LiveSourceName *string `location:"uri" locationName:"LiveSourceName" type:"string" required:"true"`

	// The name of the source location associated with this Live Source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLiveSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLiveSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLiveSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLiveSourceInput"}
	if s.LiveSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("LiveSourceName"))
	}
	if s.LiveSourceName != nil && len(*s.LiveSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LiveSourceName", 1))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *DescribeLiveSourceInput) SetLiveSourceName(v string) *DescribeLiveSourceInput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeLiveSourceInput) SetSourceLocationName(v string) *DescribeLiveSourceInput {
	s.SourceLocationName = &v
	return s
}

type DescribeLiveSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the live source.
	Arn *string `type:"string"`

	// The timestamp that indicates when the live source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The HTTP package configurations.
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list"`

	// The timestamp that indicates when the live source was modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the live source.
	LiveSourceName *string `type:"string"`

	// The name of the source location associated with the live source.
	SourceLocationName *string `type:"string"`

	// The tags assigned to the live source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLiveSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLiveSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeLiveSourceOutput) SetArn(v string) *DescribeLiveSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLiveSourceOutput) SetCreationTime(v time.Time) *DescribeLiveSourceOutput {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *DescribeLiveSourceOutput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *DescribeLiveSourceOutput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeLiveSourceOutput) SetLastModifiedTime(v time.Time) *DescribeLiveSourceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *DescribeLiveSourceOutput) SetLiveSourceName(v string) *DescribeLiveSourceOutput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeLiveSourceOutput) SetSourceLocationName(v string) *DescribeLiveSourceOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeLiveSourceOutput) SetTags(v map[string]*string) *DescribeLiveSourceOutput {
	s.Tags = v
	return s
}

type DescribeProgramInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel associated with this Program.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The name of the program.
	//
	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"ProgramName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProgramInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DescribeProgramInput) SetChannelName(v string) *DescribeProgramInput {
	s.ChannelName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DescribeProgramInput) SetProgramName(v string) *DescribeProgramInput {
	s.ProgramName = &v
	return s
}

type DescribeProgramOutput struct {
	_ struct{} `type:"structure"`

	// The ad break configuration settings.
	AdBreaks []*AdBreak `type:"list"`

	// The ARN of the program.
	Arn *string `type:"string"`

	// The name of the channel that the program belongs to.
	ChannelName *string `type:"string"`

	// The clip range configuration settings.
	ClipRange *ClipRange `type:"structure"`

	// The timestamp of when the program was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The duration of the live program in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The name of the LiveSource for this Program.
	LiveSourceName *string `type:"string"`

	// The name of the program.
	ProgramName *string `type:"string"`

	// The date and time that the program is scheduled to start in ISO 8601 format
	// and Coordinated Universal Time (UTC). For example, the value 2021-03-27T17:48:16.751Z
	// represents March 27, 2021 at 17:48:16.751 UTC.
	ScheduledStartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The source location name.
	SourceLocationName *string `type:"string"`

	// The name that's used to refer to a VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProgramOutput) GoString() string {
	return s.String()
}

// SetAdBreaks sets the AdBreaks field's value.
func (s *DescribeProgramOutput) SetAdBreaks(v []*AdBreak) *DescribeProgramOutput {
	s.AdBreaks = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeProgramOutput) SetArn(v string) *DescribeProgramOutput {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *DescribeProgramOutput) SetChannelName(v string) *DescribeProgramOutput {
	s.ChannelName = &v
	return s
}

// SetClipRange sets the ClipRange field's value.
func (s *DescribeProgramOutput) SetClipRange(v *ClipRange) *DescribeProgramOutput {
	s.ClipRange = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeProgramOutput) SetCreationTime(v time.Time) *DescribeProgramOutput {
	s.CreationTime = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *DescribeProgramOutput) SetDurationMillis(v int64) *DescribeProgramOutput {
	s.DurationMillis = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *DescribeProgramOutput) SetLiveSourceName(v string) *DescribeProgramOutput {
	s.LiveSourceName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DescribeProgramOutput) SetProgramName(v string) *DescribeProgramOutput {
	s.ProgramName = &v
	return s
}

// SetScheduledStartTime sets the ScheduledStartTime field's value.
func (s *DescribeProgramOutput) SetScheduledStartTime(v time.Time) *DescribeProgramOutput {
	s.ScheduledStartTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeProgramOutput) SetSourceLocationName(v string) *DescribeProgramOutput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *DescribeProgramOutput) SetVodSourceName(v string) *DescribeProgramOutput {
	s.VodSourceName = &v
	return s
}

type DescribeSourceLocationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSourceLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSourceLocationInput"}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeSourceLocationInput) SetSourceLocationName(v string) *DescribeSourceLocationInput {
	s.SourceLocationName = &v
	return s
}

type DescribeSourceLocationOutput struct {
	_ struct{} `type:"structure"`

	// The access configuration for the source location.
	AccessConfiguration *AccessConfiguration `type:"structure"`

	// The ARN of the source location.
	Arn *string `type:"string"`

	// The timestamp that indicates when the source location was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The default segment delivery configuration settings.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration `type:"structure"`

	// The HTTP package configuration settings for the source location.
	HttpConfiguration *HttpConfiguration `type:"structure"`

	// The timestamp that indicates when the source location was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// A list of the segment delivery configurations associated with this resource.
	SegmentDeliveryConfigurations []*SegmentDeliveryConfiguration `type:"list"`

	// The name of the source location.
	SourceLocationName *string `type:"string"`

	// The tags assigned to the source location. Tags are key-value pairs that you
	// can associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceLocationOutput) GoString() string {
	return s.String()
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *DescribeSourceLocationOutput) SetAccessConfiguration(v *AccessConfiguration) *DescribeSourceLocationOutput {
	s.AccessConfiguration = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeSourceLocationOutput) SetArn(v string) *DescribeSourceLocationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeSourceLocationOutput) SetCreationTime(v time.Time) *DescribeSourceLocationOutput {
	s.CreationTime = &v
	return s
}

// SetDefaultSegmentDeliveryConfiguration sets the DefaultSegmentDeliveryConfiguration field's value.
func (s *DescribeSourceLocationOutput) SetDefaultSegmentDeliveryConfiguration(v *DefaultSegmentDeliveryConfiguration) *DescribeSourceLocationOutput {
	s.DefaultSegmentDeliveryConfiguration = v
	return s
}

// SetHttpConfiguration sets the HttpConfiguration field's value.
func (s *DescribeSourceLocationOutput) SetHttpConfiguration(v *HttpConfiguration) *DescribeSourceLocationOutput {
	s.HttpConfiguration = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeSourceLocationOutput) SetLastModifiedTime(v time.Time) *DescribeSourceLocationOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSegmentDeliveryConfigurations sets the SegmentDeliveryConfigurations field's value.
func (s *DescribeSourceLocationOutput) SetSegmentDeliveryConfigurations(v []*SegmentDeliveryConfiguration) *DescribeSourceLocationOutput {
	s.SegmentDeliveryConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeSourceLocationOutput) SetSourceLocationName(v string) *DescribeSourceLocationOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSourceLocationOutput) SetTags(v map[string]*string) *DescribeSourceLocationOutput {
	s.Tags = v
	return s
}

type DescribeVodSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the source location associated with this VOD Source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`

	// The name of the VOD Source.
	//
	// VodSourceName is a required field
	VodSourceName *string `location:"uri" locationName:"VodSourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVodSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVodSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVodSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVodSourceInput"}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.VodSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VodSourceName"))
	}
	if s.VodSourceName != nil && len(*s.VodSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VodSourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeVodSourceInput) SetSourceLocationName(v string) *DescribeVodSourceInput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *DescribeVodSourceInput) SetVodSourceName(v string) *DescribeVodSourceInput {
	s.VodSourceName = &v
	return s
}

type DescribeVodSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ad break opportunities within the VOD source.
	AdBreakOpportunities []*AdBreakOpportunity `type:"list"`

	// The ARN of the VOD source.
	Arn *string `type:"string"`

	// The timestamp that indicates when the VOD source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The HTTP package configurations.
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list"`

	// The last modified time of the VOD source.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the source location associated with the VOD source.
	SourceLocationName *string `type:"string"`

	// The tags assigned to the VOD source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVodSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVodSourceOutput) GoString() string {
	return s.String()
}

// SetAdBreakOpportunities sets the AdBreakOpportunities field's value.
func (s *DescribeVodSourceOutput) SetAdBreakOpportunities(v []*AdBreakOpportunity) *DescribeVodSourceOutput {
	s.AdBreakOpportunities = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeVodSourceOutput) SetArn(v string) *DescribeVodSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeVodSourceOutput) SetCreationTime(v time.Time) *DescribeVodSourceOutput {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *DescribeVodSourceOutput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *DescribeVodSourceOutput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeVodSourceOutput) SetLastModifiedTime(v time.Time) *DescribeVodSourceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *DescribeVodSourceOutput) SetSourceLocationName(v string) *DescribeVodSourceOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeVodSourceOutput) SetTags(v map[string]*string) *DescribeVodSourceOutput {
	s.Tags = v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *DescribeVodSourceOutput) SetVodSourceName(v string) *DescribeVodSourceOutput {
	s.VodSourceName = &v
	return s
}

type GetChannelPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel associated with this Channel Policy.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelPolicyInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *GetChannelPolicyInput) SetChannelName(v string) *GetChannelPolicyInput {
	s.ChannelName = &v
	return s
}

type GetChannelPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The IAM policy for the channel. IAM policies are used to control access to
	// your channel.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetChannelPolicyOutput) SetPolicy(v string) *GetChannelPolicyOutput {
	s.Policy = &v
	return s
}

type GetChannelScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel associated with this Channel Schedule.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The duration in minutes of the channel schedule.
	DurationMinutes *string `location:"querystring" locationName:"durationMinutes" type:"string"`

	// The maximum number of channel schedules that you want MediaTailor to return
	// in response to the current request. If there are more than MaxResults channel
	// schedules, use the value of NextToken in the response to get the next page
	// of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// (Optional) If the playback configuration has more than MaxResults channel
	// schedules, use NextToken to get the second and subsequent pages of results.
	//
	// For the first GetChannelScheduleRequest request, omit this value.
	//
	// For the second and subsequent requests, get the value of NextToken from the
	// previous response and specify that value for NextToken in the request.
	//
	// If the previous response didn't include a NextToken element, there are no
	// more channel schedules to get.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelScheduleInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *GetChannelScheduleInput) SetChannelName(v string) *GetChannelScheduleInput {
	s.ChannelName = &v
	return s
}

// SetDurationMinutes sets the DurationMinutes field's value.
func (s *GetChannelScheduleInput) SetDurationMinutes(v string) *GetChannelScheduleInput {
	s.DurationMinutes = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetChannelScheduleInput) SetMaxResults(v int64) *GetChannelScheduleInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetChannelScheduleInput) SetNextToken(v string) *GetChannelScheduleInput {
	s.NextToken = &v
	return s
}

type GetChannelScheduleOutput struct {
	_ struct{} `type:"structure"`

	// A list of schedule entries for the channel.
	Items []*ScheduleEntry `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelScheduleOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetChannelScheduleOutput) SetItems(v []*ScheduleEntry) *GetChannelScheduleOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetChannelScheduleOutput) SetNextToken(v string) *GetChannelScheduleOutput {
	s.NextToken = &v
	return s
}

type GetPlaybackConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the playback configuration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlaybackConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlaybackConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetPlaybackConfigurationInput) SetName(v string) *GetPlaybackConfigurationInput {
	s.Name = &v
	return s
}

type GetPlaybackConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The URL for the ad decision server (ADS). This includes the specification
	// of static parameters and placeholders for dynamic parameters. AWS Elemental
	// MediaTailor substitutes player-specific and session-specific parameters as
	// needed when calling the ADS. Alternately, for testing, you can provide a
	// static VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string `type:"string"`

	// The configuration for avail suppression, also known as ad suppression. For
	// more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	AvailSuppression *AvailSuppression `type:"structure"`

	// The configuration for bumpers. Bumpers are short audio or video clips that
	// play at the start or before the end of an ad break. To learn more about bumpers,
	// see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
	Bumper *Bumper `type:"structure"`

	// The configuration for using a content delivery network (CDN), like Amazon
	// CloudFront, for content and ad segment management.
	CdnConfiguration *CdnConfiguration `type:"structure"`

	// The player parameters and aliases used as dynamic variables during session
	// initialization. For more information, see Domain Variables (https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html).
	ConfigurationAliases map[string]map[string]*string `type:"map"`

	// The configuration for DASH content.
	DashConfiguration *DashConfiguration `type:"structure"`

	// The configuration for HLS content.
	HlsConfiguration *HlsConfiguration `type:"structure"`

	// The configuration for pre-roll ad insertion.
	LivePreRollConfiguration *LivePreRollConfiguration `type:"structure"`

	// The Amazon CloudWatch log settings for a playback configuration.
	LogConfiguration *LogConfiguration `type:"structure"`

	// The configuration for manifest processing rules. Manifest processing rules
	// enable customization of the personalized manifests created by MediaTailor.
	ManifestProcessingRules *ManifestProcessingRules `type:"structure"`

	// The identifier for the playback configuration.
	Name *string `type:"string"`

	// Defines the maximum duration of underfilled ad time (in seconds) allowed
	// in an ad break. If the duration of underfilled ad time exceeds the personalization
	// threshold, then the personalization of the ad break is abandoned and the
	// underlying content is shown. This feature applies to ad replacement in live
	// and VOD streams, rather than ad insertion, because it relies on an underlying
	// content stream. For more information about ad break behavior, including ad
	// replacement and insertion, see Ad Behavior in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	PersonalizationThresholdSeconds *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) for the playback configuration.
	PlaybackConfigurationArn *string `type:"string"`

	// The URL that the player accesses to get a manifest from AWS Elemental MediaTailor.
	// This session will use server-side reporting.
	PlaybackEndpointPrefix *string `type:"string"`

	// The URL that the player uses to initialize a session that uses client-side
	// reporting.
	SessionInitializationEndpointPrefix *string `type:"string"`

	// The URL for a high-quality video asset to transcode and use to fill in time
	// that's not used by ads. AWS Elemental MediaTailor shows the slate to fill
	// in gaps in media content. Configuring the slate is optional for non-VPAID
	// playback configurations. For VPAID, the slate is required because MediaTailor
	// provides it in the slots designated for dynamic ad content. The slate must
	// be a high-quality asset that contains both audio and video.
	SlateAdUrl *string `type:"string"`

	// The tags assigned to the playback configuration. Tags are key-value pairs
	// that you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name that is used to associate this playback configuration with a custom
	// transcode profile. This overrides the dynamic transcoding defaults of MediaTailor.
	// Use this only if you have already set up custom profiles with the help of
	// AWS Support.
	TranscodeProfileName *string `type:"string"`

	// The URL prefix for the parent manifest for the stream, minus the asset ID.
	// The maximum length is 512 characters.
	VideoContentSourceUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaybackConfigurationOutput) GoString() string {
	return s.String()
}

// SetAdDecisionServerUrl sets the AdDecisionServerUrl field's value.
func (s *GetPlaybackConfigurationOutput) SetAdDecisionServerUrl(v string) *GetPlaybackConfigurationOutput {
	s.AdDecisionServerUrl = &v
	return s
}

// SetAvailSuppression sets the AvailSuppression field's value.
func (s *GetPlaybackConfigurationOutput) SetAvailSuppression(v *AvailSuppression) *GetPlaybackConfigurationOutput {
	s.AvailSuppression = v
	return s
}

// SetBumper sets the Bumper field's value.
func (s *GetPlaybackConfigurationOutput) SetBumper(v *Bumper) *GetPlaybackConfigurationOutput {
	s.Bumper = v
	return s
}

// SetCdnConfiguration sets the CdnConfiguration field's value.
func (s *GetPlaybackConfigurationOutput) SetCdnConfiguration(v *CdnConfiguration) *GetPlaybackConfigurationOutput {
	s.CdnConfiguration = v
	return s
}

// SetConfigurationAliases sets the ConfigurationAliases field's value.
func (s *GetPlaybackConfigurationOutput) SetConfigurationAliases(v map[string]map[string]*string) *GetPlaybackConfigurationOutput {
	s.ConfigurationAliases = v
	return s
}

// SetDashConfiguration sets the DashConfiguration field's value.
func (s *GetPlaybackConfigurationOutput) SetDashConfiguration(v *DashConfiguration) *GetPlaybackConfigurationOutput {
	s.DashConfiguration = v
	return s
}

// SetHlsConfiguration sets the HlsConfiguration field's value.
func (s *GetPlaybackConfigurationOutput) SetHlsConfiguration(v *HlsConfiguration) *GetPlaybackConfigurationOutput {
	s.HlsConfiguration = v
	return s
}

// SetLivePreRollConfiguration sets the LivePreRollConfiguration field's value.
func (s *GetPlaybackConfigurationOutput) SetLivePreRollConfiguration(v *LivePreRollConfiguration) *GetPlaybackConfigurationOutput {
	s.LivePreRollConfiguration = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *GetPlaybackConfigurationOutput) SetLogConfiguration(v *LogConfiguration) *GetPlaybackConfigurationOutput {
	s.LogConfiguration = v
	return s
}

// SetManifestProcessingRules sets the ManifestProcessingRules field's value.
func (s *GetPlaybackConfigurationOutput) SetManifestProcessingRules(v *ManifestProcessingRules) *GetPlaybackConfigurationOutput {
	s.ManifestProcessingRules = v
	return s
}

// SetName sets the Name field's value.
func (s *GetPlaybackConfigurationOutput) SetName(v string) *GetPlaybackConfigurationOutput {
	s.Name = &v
	return s
}

// SetPersonalizationThresholdSeconds sets the PersonalizationThresholdSeconds field's value.
func (s *GetPlaybackConfigurationOutput) SetPersonalizationThresholdSeconds(v int64) *GetPlaybackConfigurationOutput {
	s.PersonalizationThresholdSeconds = &v
	return s
}

// SetPlaybackConfigurationArn sets the PlaybackConfigurationArn field's value.
func (s *GetPlaybackConfigurationOutput) SetPlaybackConfigurationArn(v string) *GetPlaybackConfigurationOutput {
	s.PlaybackConfigurationArn = &v
	return s
}

// SetPlaybackEndpointPrefix sets the PlaybackEndpointPrefix field's value.
func (s *GetPlaybackConfigurationOutput) SetPlaybackEndpointPrefix(v string) *GetPlaybackConfigurationOutput {
	s.PlaybackEndpointPrefix = &v
	return s
}

// SetSessionInitializationEndpointPrefix sets the SessionInitializationEndpointPrefix field's value.
func (s *GetPlaybackConfigurationOutput) SetSessionInitializationEndpointPrefix(v string) *GetPlaybackConfigurationOutput {
	s.SessionInitializationEndpointPrefix = &v
	return s
}

// SetSlateAdUrl sets the SlateAdUrl field's value.
func (s *GetPlaybackConfigurationOutput) SetSlateAdUrl(v string) *GetPlaybackConfigurationOutput {
	s.SlateAdUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetPlaybackConfigurationOutput) SetTags(v map[string]*string) *GetPlaybackConfigurationOutput {
	s.Tags = v
	return s
}

// SetTranscodeProfileName sets the TranscodeProfileName field's value.
func (s *GetPlaybackConfigurationOutput) SetTranscodeProfileName(v string) *GetPlaybackConfigurationOutput {
	s.TranscodeProfileName = &v
	return s
}

// SetVideoContentSourceUrl sets the VideoContentSourceUrl field's value.
func (s *GetPlaybackConfigurationOutput) SetVideoContentSourceUrl(v string) *GetPlaybackConfigurationOutput {
	s.VideoContentSourceUrl = &v
	return s
}

type GetPrefetchScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the prefetch schedule. The name must be unique among all prefetch
	// schedules that are associated with the specified playback configuration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`

	// Returns information about the prefetch schedule for a specific playback configuration.
	// If you call GetPrefetchSchedule on an expired prefetch schedule, MediaTailor
	// returns an HTTP 404 status code.
	//
	// PlaybackConfigurationName is a required field
	PlaybackConfigurationName *string `location:"uri" locationName:"PlaybackConfigurationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrefetchScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrefetchScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPrefetchScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPrefetchScheduleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PlaybackConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaybackConfigurationName"))
	}
	if s.PlaybackConfigurationName != nil && len(*s.PlaybackConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlaybackConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetPrefetchScheduleInput) SetName(v string) *GetPrefetchScheduleInput {
	s.Name = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *GetPrefetchScheduleInput) SetPlaybackConfigurationName(v string) *GetPrefetchScheduleInput {
	s.PlaybackConfigurationName = &v
	return s
}

type GetPrefetchScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prefetch schedule.
	Arn *string `type:"string"`

	// Consumption settings determine how, and when, MediaTailor places the prefetched
	// ads into ad breaks. Ad consumption occurs within a span of time that you
	// define, called a consumption window. You can designate which ad breaks that
	// MediaTailor fills with prefetch ads by setting avail matching criteria.
	Consumption *PrefetchConsumption `type:"structure"`

	// The name of the prefetch schedule. The name must be unique among all prefetch
	// schedules that are associated with the specified playback configuration.
	Name *string `type:"string"`

	// The name of the playback configuration to create the prefetch schedule for.
	PlaybackConfigurationName *string `type:"string"`

	// A complex type that contains settings for prefetch retrieval from the ad
	// decision server (ADS).
	Retrieval *PrefetchRetrieval `type:"structure"`

	// An optional stream identifier that you can specify in order to prefetch for
	// multiple streams that use the same playback configuration.
	StreamId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrefetchScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPrefetchScheduleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetPrefetchScheduleOutput) SetArn(v string) *GetPrefetchScheduleOutput {
	s.Arn = &v
	return s
}

// SetConsumption sets the Consumption field's value.
func (s *GetPrefetchScheduleOutput) SetConsumption(v *PrefetchConsumption) *GetPrefetchScheduleOutput {
	s.Consumption = v
	return s
}

// SetName sets the Name field's value.
func (s *GetPrefetchScheduleOutput) SetName(v string) *GetPrefetchScheduleOutput {
	s.Name = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *GetPrefetchScheduleOutput) SetPlaybackConfigurationName(v string) *GetPrefetchScheduleOutput {
	s.PlaybackConfigurationName = &v
	return s
}

// SetRetrieval sets the Retrieval field's value.
func (s *GetPrefetchScheduleOutput) SetRetrieval(v *PrefetchRetrieval) *GetPrefetchScheduleOutput {
	s.Retrieval = v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *GetPrefetchScheduleOutput) SetStreamId(v string) *GetPrefetchScheduleOutput {
	s.StreamId = &v
	return s
}

// The configuration for HLS content.
type HlsConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL that is used to initiate a playback session for devices that support
	// Apple HLS. The session uses server-side reporting.
	ManifestEndpointPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsConfiguration) GoString() string {
	return s.String()
}

// SetManifestEndpointPrefix sets the ManifestEndpointPrefix field's value.
func (s *HlsConfiguration) SetManifestEndpointPrefix(v string) *HlsConfiguration {
	s.ManifestEndpointPrefix = &v
	return s
}

// HLS playlist configuration parameters.
type HlsPlaylistSettings struct {
	_ struct{} `type:"structure"`

	// Determines the type of SCTE 35 tags to use in ad markup. Specify DATERANGE
	// to use DATERANGE tags (for live or VOD content). Specify SCTE35_ENHANCED
	// to use EXT-X-CUE-OUT and EXT-X-CUE-IN tags (for VOD content only).
	AdMarkupType []*string `type:"list" enum:"AdMarkupType"`

	// The total duration (in seconds) of each manifest. Minimum value: 30 seconds.
	// Maximum value: 3600 seconds.
	ManifestWindowSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsPlaylistSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsPlaylistSettings) GoString() string {
	return s.String()
}

// SetAdMarkupType sets the AdMarkupType field's value.
func (s *HlsPlaylistSettings) SetAdMarkupType(v []*string) *HlsPlaylistSettings {
	s.AdMarkupType = v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *HlsPlaylistSettings) SetManifestWindowSeconds(v int64) *HlsPlaylistSettings {
	s.ManifestWindowSeconds = &v
	return s
}

// The HTTP configuration for the source location.
type HttpConfiguration struct {
	_ struct{} `type:"structure"`

	// The base URL for the source location host server. This string must include
	// the protocol, such as https://.
	//
	// BaseUrl is a required field
	BaseUrl *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpConfiguration"}
	if s.BaseUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseUrl sets the BaseUrl field's value.
func (s *HttpConfiguration) SetBaseUrl(v string) *HttpConfiguration {
	s.BaseUrl = &v
	return s
}

// The HTTP package configuration properties for the requested VOD source.
type HttpPackageConfiguration struct {
	_ struct{} `type:"structure"`

	// The relative path to the URL for this VOD source. This is combined with SourceLocation::HttpConfiguration::BaseUrl
	// to form a valid URL.
	//
	// Path is a required field
	Path *string `type:"string" required:"true"`

	// The name of the source group. This has to match one of the Channel::Outputs::SourceGroup.
	//
	// SourceGroup is a required field
	SourceGroup *string `type:"string" required:"true"`

	// The streaming protocol for this package configuration. Supported values are
	// HLS and DASH.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpPackageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpPackageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpPackageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpPackageConfiguration"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.SourceGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceGroup"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPath sets the Path field's value.
func (s *HttpPackageConfiguration) SetPath(v string) *HttpPackageConfiguration {
	s.Path = &v
	return s
}

// SetSourceGroup sets the SourceGroup field's value.
func (s *HttpPackageConfiguration) SetSourceGroup(v string) *HttpPackageConfiguration {
	s.SourceGroup = &v
	return s
}

// SetType sets the Type field's value.
func (s *HttpPackageConfiguration) SetType(v string) *HttpPackageConfiguration {
	s.Type = &v
	return s
}

// For SCTE35_ENHANCED output, defines a key and corresponding value. MediaTailor
// generates these pairs within the EXT-X-ASSETtag.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// For SCTE35_ENHANCED output, defines a key. MediaTailor takes this key, and
	// its associated value, and generates the key/value pair within the EXT-X-ASSETtag.
	// If you specify a key, you must also specify a corresponding value.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// For SCTE35_ENHANCED output, defines a value. MediaTailor; takes this value,
	// and its associated key, and generates the key/value pair within the EXT-X-ASSETtag.
	// If you specify a value, you must also specify a corresponding key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuePair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyValuePair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyValuePair"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *KeyValuePair) SetKey(v string) *KeyValuePair {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValuePair) SetValue(v string) *KeyValuePair {
	s.Value = &v
	return s
}

type ListAlertsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of alerts that you want MediaTailor to return in response
	// to the current request. If there are more than MaxResults alerts, use the
	// value of NextToken in the response to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAlertsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAlertsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAlertsInput) SetMaxResults(v int64) *ListAlertsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlertsInput) SetNextToken(v string) *ListAlertsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListAlertsInput) SetResourceArn(v string) *ListAlertsInput {
	s.ResourceArn = &v
	return s
}

type ListAlertsOutput struct {
	_ struct{} `type:"structure"`

	// A list of alerts that are associated with this resource.
	Items []*Alert `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAlertsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListAlertsOutput) SetItems(v []*Alert) *ListAlertsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlertsOutput) SetNextToken(v string) *ListAlertsOutput {
	s.NextToken = &v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of channels that you want MediaTailor to return in response
	// to the current request. If there are more than MaxResults channels, use the
	// value of NextToken in the response to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of channels that are associated with this account.
	Items []*Channel `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListChannelsOutput) SetItems(v []*Channel) *ListChannelsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListLiveSourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of live sources that you want MediaTailor to return in
	// response to the current request. If there are more than MaxResults live sources,
	// use the value of NextToken in the response to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the source location associated with this Live Sources list.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLiveSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLiveSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLiveSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLiveSourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLiveSourcesInput) SetMaxResults(v int64) *ListLiveSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLiveSourcesInput) SetNextToken(v string) *ListLiveSourcesInput {
	s.NextToken = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *ListLiveSourcesInput) SetSourceLocationName(v string) *ListLiveSourcesInput {
	s.SourceLocationName = &v
	return s
}

type ListLiveSourcesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the live sources.
	Items []*LiveSource `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLiveSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLiveSourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListLiveSourcesOutput) SetItems(v []*LiveSource) *ListLiveSourcesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLiveSourcesOutput) SetNextToken(v string) *ListLiveSourcesOutput {
	s.NextToken = &v
	return s
}

type ListPlaybackConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of playback configurations that you want MediaTailor to
	// return in response to the current request. If there are more than MaxResults
	// playback configurations, use the value of NextToken in the response to get
	// the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlaybackConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlaybackConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlaybackConfigurationsInput) SetMaxResults(v int64) *ListPlaybackConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaybackConfigurationsInput) SetNextToken(v string) *ListPlaybackConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListPlaybackConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Array of playback configurations. This might be all the available configurations
	// or a subset, depending on the settings that you provide and the total number
	// of configurations stored.
	Items []*PlaybackConfiguration `type:"list"`

	// Pagination token returned by the GET list request when results exceed the
	// maximum allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaybackConfigurationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListPlaybackConfigurationsOutput) SetItems(v []*PlaybackConfiguration) *ListPlaybackConfigurationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaybackConfigurationsOutput) SetNextToken(v string) *ListPlaybackConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListPrefetchSchedulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of prefetch schedules that you want MediaTailor to return
	// in response to the current request. If there are more than MaxResults prefetch
	// schedules, use the value of NextToken in the response to get the next page
	// of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) If the playback configuration has more than MaxResults prefetch
	// schedules, use NextToken to get the second and subsequent pages of results.
	//
	// For the first ListPrefetchSchedulesRequest request, omit this value.
	//
	// For the second and subsequent requests, get the value of NextToken from the
	// previous response and specify that value for NextToken in the request.
	//
	// If the previous response didn't include a NextToken element, there are no
	// more prefetch schedules to get.
	NextToken *string `type:"string"`

	// Retrieves the prefetch schedule(s) for a specific playback configuration.
	//
	// PlaybackConfigurationName is a required field
	PlaybackConfigurationName *string `location:"uri" locationName:"PlaybackConfigurationName" type:"string" required:"true"`

	// An optional filtering parameter whereby MediaTailor filters the prefetch
	// schedules to include only specific streams.
	StreamId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrefetchSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrefetchSchedulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrefetchSchedulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrefetchSchedulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PlaybackConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaybackConfigurationName"))
	}
	if s.PlaybackConfigurationName != nil && len(*s.PlaybackConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlaybackConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrefetchSchedulesInput) SetMaxResults(v int64) *ListPrefetchSchedulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrefetchSchedulesInput) SetNextToken(v string) *ListPrefetchSchedulesInput {
	s.NextToken = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *ListPrefetchSchedulesInput) SetPlaybackConfigurationName(v string) *ListPrefetchSchedulesInput {
	s.PlaybackConfigurationName = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *ListPrefetchSchedulesInput) SetStreamId(v string) *ListPrefetchSchedulesInput {
	s.StreamId = &v
	return s
}

type ListPrefetchSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the prefetch schedules. An empty Items list doesn't mean there aren't
	// more items to fetch, just that that page was empty.
	Items []*PrefetchSchedule `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrefetchSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrefetchSchedulesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListPrefetchSchedulesOutput) SetItems(v []*PrefetchSchedule) *ListPrefetchSchedulesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrefetchSchedulesOutput) SetNextToken(v string) *ListPrefetchSchedulesOutput {
	s.NextToken = &v
	return s
}

type ListSourceLocationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of source locations that you want MediaTailor to return
	// in response to the current request. If there are more than MaxResults source
	// locations, use the value of NextToken in the response to get the next page
	// of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSourceLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSourceLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSourceLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSourceLocationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSourceLocationsInput) SetMaxResults(v int64) *ListSourceLocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSourceLocationsInput) SetNextToken(v string) *ListSourceLocationsInput {
	s.NextToken = &v
	return s
}

type ListSourceLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of source locations.
	Items []*SourceLocation `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSourceLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSourceLocationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListSourceLocationsOutput) SetItems(v []*SourceLocation) *ListSourceLocationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSourceLocationsOutput) SetNextToken(v string) *ListSourceLocationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) associated with this resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with this resource. Tags are key-value pairs that you
	// can associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVodSourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of VOD sources that you want MediaTailor to return in
	// response to the current request. If there are more than MaxResults VOD sources,
	// use the value of NextToken in the response to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the source location associated with this VOD Source list.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVodSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVodSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVodSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVodSourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVodSourcesInput) SetMaxResults(v int64) *ListVodSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVodSourcesInput) SetNextToken(v string) *ListVodSourcesInput {
	s.NextToken = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *ListVodSourcesInput) SetSourceLocationName(v string) *ListVodSourcesInput {
	s.SourceLocationName = &v
	return s
}

type ListVodSourcesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the VOD sources.
	Items []*VodSource `type:"list"`

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVodSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVodSourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListVodSourcesOutput) SetItems(v []*VodSource) *ListVodSourcesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVodSourcesOutput) SetNextToken(v string) *ListVodSourcesOutput {
	s.NextToken = &v
	return s
}

// The configuration for pre-roll ad insertion.
type LivePreRollConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL for the ad decision server (ADS) for pre-roll ads. This includes
	// the specification of static parameters and placeholders for dynamic parameters.
	// AWS Elemental MediaTailor substitutes player-specific and session-specific
	// parameters as needed when calling the ADS. Alternately, for testing, you
	// can provide a static VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string `type:"string"`

	// The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor
	// won't play pre-roll ads to exceed this duration, regardless of the total
	// duration of ads that the ADS returns.
	MaxDurationSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LivePreRollConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LivePreRollConfiguration) GoString() string {
	return s.String()
}

// SetAdDecisionServerUrl sets the AdDecisionServerUrl field's value.
func (s *LivePreRollConfiguration) SetAdDecisionServerUrl(v string) *LivePreRollConfiguration {
	s.AdDecisionServerUrl = &v
	return s
}

// SetMaxDurationSeconds sets the MaxDurationSeconds field's value.
func (s *LivePreRollConfiguration) SetMaxDurationSeconds(v int64) *LivePreRollConfiguration {
	s.MaxDurationSeconds = &v
	return s
}

// Live source configuration parameters.
type LiveSource struct {
	_ struct{} `type:"structure"`

	// The ARN for the live source.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The timestamp that indicates when the live source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The HTTP package configurations for the live source.
	//
	// HttpPackageConfigurations is a required field
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list" required:"true"`

	// The timestamp that indicates when the live source was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name that's used to refer to a live source.
	//
	// LiveSourceName is a required field
	LiveSourceName *string `type:"string" required:"true"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `type:"string" required:"true"`

	// The tags assigned to the live source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveSource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LiveSource) SetArn(v string) *LiveSource {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *LiveSource) SetCreationTime(v time.Time) *LiveSource {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *LiveSource) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *LiveSource {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *LiveSource) SetLastModifiedTime(v time.Time) *LiveSource {
	s.LastModifiedTime = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *LiveSource) SetLiveSourceName(v string) *LiveSource {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *LiveSource) SetSourceLocationName(v string) *LiveSource {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LiveSource) SetTags(v map[string]*string) *LiveSource {
	s.Tags = v
	return s
}

// Returns Amazon CloudWatch log settings for a playback configuration.
type LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The percentage of session logs that MediaTailor sends to your Cloudwatch
	// Logs account. For example, if your playback configuration has 1000 sessions
	// and percentEnabled is set to 60, MediaTailor sends logs for 600 of the sessions
	// to CloudWatch Logs. MediaTailor decides at random which of the playback configuration
	// sessions to send logs for. If you want to view logs for a specific session,
	// you can use the debug log mode (https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html).
	//
	// Valid values: 0 - 100
	//
	// PercentEnabled is a required field
	PercentEnabled *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) GoString() string {
	return s.String()
}

// SetPercentEnabled sets the PercentEnabled field's value.
func (s *LogConfiguration) SetPercentEnabled(v int64) *LogConfiguration {
	s.PercentEnabled = &v
	return s
}

// The log configuration for the channel.
type LogConfigurationForChannel struct {
	_ struct{} `type:"structure"`

	// The log types.
	LogTypes []*string `type:"list" enum:"LogType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfigurationForChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfigurationForChannel) GoString() string {
	return s.String()
}

// SetLogTypes sets the LogTypes field's value.
func (s *LogConfigurationForChannel) SetLogTypes(v []*string) *LogConfigurationForChannel {
	s.LogTypes = v
	return s
}

// The configuration for manifest processing rules. Manifest processing rules
// enable customization of the personalized manifests created by MediaTailor.
type ManifestProcessingRules struct {
	_ struct{} `type:"structure"`

	// For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT,
	// and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor
	// personalized manifest.
	//
	// No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has
	// a value of 60, but no ads are filled for that ad break, MediaTailor will
	// not set the value to 0.
	AdMarkerPassthrough *AdMarkerPassthrough `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestProcessingRules) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestProcessingRules) GoString() string {
	return s.String()
}

// SetAdMarkerPassthrough sets the AdMarkerPassthrough field's value.
func (s *ManifestProcessingRules) SetAdMarkerPassthrough(v *AdMarkerPassthrough) *ManifestProcessingRules {
	s.AdMarkerPassthrough = v
	return s
}

// A playback configuration. For information about MediaTailor configurations,
// see Working with configurations in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
type PlaybackConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL for the ad decision server (ADS). This includes the specification
	// of static parameters and placeholders for dynamic parameters. AWS Elemental
	// MediaTailor substitutes player-specific and session-specific parameters as
	// needed when calling the ADS. Alternately, for testing you can provide a static
	// VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string `type:"string"`

	// The configuration for avail suppression, also known as ad suppression. For
	// more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	AvailSuppression *AvailSuppression `type:"structure"`

	// The configuration for bumpers. Bumpers are short audio or video clips that
	// play at the start or before the end of an ad break. To learn more about bumpers,
	// see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
	Bumper *Bumper `type:"structure"`

	// The configuration for using a content delivery network (CDN), like Amazon
	// CloudFront, for content and ad segment management.
	CdnConfiguration *CdnConfiguration `type:"structure"`

	// The player parameters and aliases used as dynamic variables during session
	// initialization. For more information, see Domain Variables (https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html).
	ConfigurationAliases map[string]map[string]*string `type:"map"`

	// The configuration for a DASH source.
	DashConfiguration *DashConfiguration `type:"structure"`

	// The configuration for HLS content.
	HlsConfiguration *HlsConfiguration `type:"structure"`

	// The configuration for pre-roll ad insertion.
	LivePreRollConfiguration *LivePreRollConfiguration `type:"structure"`

	// The Amazon CloudWatch log settings for a playback configuration.
	LogConfiguration *LogConfiguration `type:"structure"`

	// The configuration for manifest processing rules. Manifest processing rules
	// enable customization of the personalized manifests created by MediaTailor.
	ManifestProcessingRules *ManifestProcessingRules `type:"structure"`

	// The identifier for the playback configuration.
	Name *string `type:"string"`

	// Defines the maximum duration of underfilled ad time (in seconds) allowed
	// in an ad break. If the duration of underfilled ad time exceeds the personalization
	// threshold, then the personalization of the ad break is abandoned and the
	// underlying content is shown. This feature applies to ad replacement in live
	// and VOD streams, rather than ad insertion, because it relies on an underlying
	// content stream. For more information about ad break behavior, including ad
	// replacement and insertion, see Ad Behavior in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	PersonalizationThresholdSeconds *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) for the playback configuration.
	PlaybackConfigurationArn *string `type:"string"`

	// The URL that the player accesses to get a manifest from AWS Elemental MediaTailor.
	PlaybackEndpointPrefix *string `type:"string"`

	// The URL that the player uses to initialize a session that uses client-side
	// reporting.
	SessionInitializationEndpointPrefix *string `type:"string"`

	// The URL for a video asset to transcode and use to fill in time that's not
	// used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in
	// media content. Configuring the slate is optional for non-VPAID playback configurations.
	// For VPAID, the slate is required because MediaTailor provides it in the slots
	// designated for dynamic ad content. The slate must be a high-quality asset
	// that contains both audio and video.
	SlateAdUrl *string `type:"string"`

	// The tags to assign to the playback configuration. Tags are key-value pairs
	// that you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name that is used to associate this playback configuration with a custom
	// transcode profile. This overrides the dynamic transcoding defaults of MediaTailor.
	// Use this only if you have already set up custom profiles with the help of
	// AWS Support.
	TranscodeProfileName *string `type:"string"`

	// The URL prefix for the parent manifest for the stream, minus the asset ID.
	// The maximum length is 512 characters.
	VideoContentSourceUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackConfiguration) GoString() string {
	return s.String()
}

// SetAdDecisionServerUrl sets the AdDecisionServerUrl field's value.
func (s *PlaybackConfiguration) SetAdDecisionServerUrl(v string) *PlaybackConfiguration {
	s.AdDecisionServerUrl = &v
	return s
}

// SetAvailSuppression sets the AvailSuppression field's value.
func (s *PlaybackConfiguration) SetAvailSuppression(v *AvailSuppression) *PlaybackConfiguration {
	s.AvailSuppression = v
	return s
}

// SetBumper sets the Bumper field's value.
func (s *PlaybackConfiguration) SetBumper(v *Bumper) *PlaybackConfiguration {
	s.Bumper = v
	return s
}

// SetCdnConfiguration sets the CdnConfiguration field's value.
func (s *PlaybackConfiguration) SetCdnConfiguration(v *CdnConfiguration) *PlaybackConfiguration {
	s.CdnConfiguration = v
	return s
}

// SetConfigurationAliases sets the ConfigurationAliases field's value.
func (s *PlaybackConfiguration) SetConfigurationAliases(v map[string]map[string]*string) *PlaybackConfiguration {
	s.ConfigurationAliases = v
	return s
}

// SetDashConfiguration sets the DashConfiguration field's value.
func (s *PlaybackConfiguration) SetDashConfiguration(v *DashConfiguration) *PlaybackConfiguration {
	s.DashConfiguration = v
	return s
}

// SetHlsConfiguration sets the HlsConfiguration field's value.
func (s *PlaybackConfiguration) SetHlsConfiguration(v *HlsConfiguration) *PlaybackConfiguration {
	s.HlsConfiguration = v
	return s
}

// SetLivePreRollConfiguration sets the LivePreRollConfiguration field's value.
func (s *PlaybackConfiguration) SetLivePreRollConfiguration(v *LivePreRollConfiguration) *PlaybackConfiguration {
	s.LivePreRollConfiguration = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *PlaybackConfiguration) SetLogConfiguration(v *LogConfiguration) *PlaybackConfiguration {
	s.LogConfiguration = v
	return s
}

// SetManifestProcessingRules sets the ManifestProcessingRules field's value.
func (s *PlaybackConfiguration) SetManifestProcessingRules(v *ManifestProcessingRules) *PlaybackConfiguration {
	s.ManifestProcessingRules = v
	return s
}

// SetName sets the Name field's value.
func (s *PlaybackConfiguration) SetName(v string) *PlaybackConfiguration {
	s.Name = &v
	return s
}

// SetPersonalizationThresholdSeconds sets the PersonalizationThresholdSeconds field's value.
func (s *PlaybackConfiguration) SetPersonalizationThresholdSeconds(v int64) *PlaybackConfiguration {
	s.PersonalizationThresholdSeconds = &v
	return s
}

// SetPlaybackConfigurationArn sets the PlaybackConfigurationArn field's value.
func (s *PlaybackConfiguration) SetPlaybackConfigurationArn(v string) *PlaybackConfiguration {
	s.PlaybackConfigurationArn = &v
	return s
}

// SetPlaybackEndpointPrefix sets the PlaybackEndpointPrefix field's value.
func (s *PlaybackConfiguration) SetPlaybackEndpointPrefix(v string) *PlaybackConfiguration {
	s.PlaybackEndpointPrefix = &v
	return s
}

// SetSessionInitializationEndpointPrefix sets the SessionInitializationEndpointPrefix field's value.
func (s *PlaybackConfiguration) SetSessionInitializationEndpointPrefix(v string) *PlaybackConfiguration {
	s.SessionInitializationEndpointPrefix = &v
	return s
}

// SetSlateAdUrl sets the SlateAdUrl field's value.
func (s *PlaybackConfiguration) SetSlateAdUrl(v string) *PlaybackConfiguration {
	s.SlateAdUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PlaybackConfiguration) SetTags(v map[string]*string) *PlaybackConfiguration {
	s.Tags = v
	return s
}

// SetTranscodeProfileName sets the TranscodeProfileName field's value.
func (s *PlaybackConfiguration) SetTranscodeProfileName(v string) *PlaybackConfiguration {
	s.TranscodeProfileName = &v
	return s
}

// SetVideoContentSourceUrl sets the VideoContentSourceUrl field's value.
func (s *PlaybackConfiguration) SetVideoContentSourceUrl(v string) *PlaybackConfiguration {
	s.VideoContentSourceUrl = &v
	return s
}

// A complex type that contains settings that determine how and when that MediaTailor
// places prefetched ads into upcoming ad breaks.
type PrefetchConsumption struct {
	_ struct{} `type:"structure"`

	// If you only want MediaTailor to insert prefetched ads into avails (ad breaks)
	// that match specific dynamic variables, such as scte.event_id, set the avail
	// matching criteria.
	AvailMatchingCriteria []*AvailMatchingCriteria `type:"list"`

	// The time when MediaTailor no longer considers the prefetched ads for use
	// in an ad break. MediaTailor automatically deletes prefetch schedules no less
	// than seven days after the end time. If you'd like to manually delete the
	// prefetch schedule, you can call DeletePrefetchSchedule.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`

	// The time when prefetched ads are considered for use in an ad break. If you
	// don't specify StartTime, the prefetched ads are available after MediaTailor
	// retrives them from the ad decision server.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefetchConsumption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefetchConsumption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrefetchConsumption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrefetchConsumption"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.AvailMatchingCriteria != nil {
		for i, v := range s.AvailMatchingCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AvailMatchingCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailMatchingCriteria sets the AvailMatchingCriteria field's value.
func (s *PrefetchConsumption) SetAvailMatchingCriteria(v []*AvailMatchingCriteria) *PrefetchConsumption {
	s.AvailMatchingCriteria = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *PrefetchConsumption) SetEndTime(v time.Time) *PrefetchConsumption {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PrefetchConsumption) SetStartTime(v time.Time) *PrefetchConsumption {
	s.StartTime = &v
	return s
}

// A complex type that contains settings governing when MediaTailor prefetches
// ads, and which dynamic variables that MediaTailor includes in the request
// to the ad decision server.
type PrefetchRetrieval struct {
	_ struct{} `type:"structure"`

	// The dynamic variables to use for substitution during prefetch requests to
	// the ad decision server (ADS).
	//
	// You initially configure dynamic variables (https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html)
	// for the ADS URL when you set up your playback configuration. When you specify
	// DynamicVariables for prefetch retrieval, MediaTailor includes the dynamic
	// variables in the request to the ADS.
	DynamicVariables map[string]*string `type:"map"`

	// The time when prefetch retrieval ends for the ad break. Prefetching will
	// be attempted for manifest requests that occur at or before this time.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`

	// The time when prefetch retrievals can start for this break. Ad prefetching
	// will be attempted for manifest requests that occur at or after this time.
	// Defaults to the current time. If not specified, the prefetch retrieval starts
	// as soon as possible.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefetchRetrieval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefetchRetrieval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrefetchRetrieval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrefetchRetrieval"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDynamicVariables sets the DynamicVariables field's value.
func (s *PrefetchRetrieval) SetDynamicVariables(v map[string]*string) *PrefetchRetrieval {
	s.DynamicVariables = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *PrefetchRetrieval) SetEndTime(v time.Time) *PrefetchRetrieval {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PrefetchRetrieval) SetStartTime(v time.Time) *PrefetchRetrieval {
	s.StartTime = &v
	return s
}

// A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain
// ads before an ad break happens. For more information about ad prefetching,
// see Using ad prefetching (https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html)
// in the MediaTailor User Guide.
type PrefetchSchedule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prefetch schedule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Consumption settings determine how, and when, MediaTailor places the prefetched
	// ads into ad breaks. Ad consumption occurs within a span of time that you
	// define, called a consumption window. You can designate which ad breaks that
	// MediaTailor fills with prefetch ads by setting avail matching criteria.
	//
	// Consumption is a required field
	Consumption *PrefetchConsumption `type:"structure" required:"true"`

	// The name of the prefetch schedule. The name must be unique among all prefetch
	// schedules that are associated with the specified playback configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The name of the playback configuration to create the prefetch schedule for.
	//
	// PlaybackConfigurationName is a required field
	PlaybackConfigurationName *string `type:"string" required:"true"`

	// A complex type that contains settings for prefetch retrieval from the ad
	// decision server (ADS).
	//
	// Retrieval is a required field
	Retrieval *PrefetchRetrieval `type:"structure" required:"true"`

	// An optional stream identifier that you can specify in order to prefetch for
	// multiple streams that use the same playback configuration.
	StreamId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefetchSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefetchSchedule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PrefetchSchedule) SetArn(v string) *PrefetchSchedule {
	s.Arn = &v
	return s
}

// SetConsumption sets the Consumption field's value.
func (s *PrefetchSchedule) SetConsumption(v *PrefetchConsumption) *PrefetchSchedule {
	s.Consumption = v
	return s
}

// SetName sets the Name field's value.
func (s *PrefetchSchedule) SetName(v string) *PrefetchSchedule {
	s.Name = &v
	return s
}

// SetPlaybackConfigurationName sets the PlaybackConfigurationName field's value.
func (s *PrefetchSchedule) SetPlaybackConfigurationName(v string) *PrefetchSchedule {
	s.PlaybackConfigurationName = &v
	return s
}

// SetRetrieval sets the Retrieval field's value.
func (s *PrefetchSchedule) SetRetrieval(v *PrefetchRetrieval) *PrefetchSchedule {
	s.Retrieval = v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *PrefetchSchedule) SetStreamId(v string) *PrefetchSchedule {
	s.StreamId = &v
	return s
}

type PutChannelPolicyInput struct {
	_ struct{} `type:"structure"`

	// The channel name associated with this Channel Policy.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// Adds an IAM role that determines the permissions of your channel.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutChannelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutChannelPolicyInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *PutChannelPolicyInput) SetChannelName(v string) *PutChannelPolicyInput {
	s.ChannelName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutChannelPolicyInput) SetPolicy(v string) *PutChannelPolicyInput {
	s.Policy = &v
	return s
}

type PutChannelPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyOutput) GoString() string {
	return s.String()
}

type PutPlaybackConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The URL for the ad decision server (ADS). This includes the specification
	// of static parameters and placeholders for dynamic parameters. AWS Elemental
	// MediaTailor substitutes player-specific and session-specific parameters as
	// needed when calling the ADS. Alternately, for testing you can provide a static
	// VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string `type:"string"`

	// The configuration for avail suppression, also known as ad suppression. For
	// more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	AvailSuppression *AvailSuppression `type:"structure"`

	// The configuration for bumpers. Bumpers are short audio or video clips that
	// play at the start or before the end of an ad break. To learn more about bumpers,
	// see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
	Bumper *Bumper `type:"structure"`

	// The configuration for using a content delivery network (CDN), like Amazon
	// CloudFront, for content and ad segment management.
	CdnConfiguration *CdnConfiguration `type:"structure"`

	// The player parameters and aliases used as dynamic variables during session
	// initialization. For more information, see Domain Variables (https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html).
	ConfigurationAliases map[string]map[string]*string `type:"map"`

	// The configuration for DASH content.
	DashConfiguration *DashConfigurationForPut `type:"structure"`

	// The configuration for pre-roll ad insertion.
	LivePreRollConfiguration *LivePreRollConfiguration `type:"structure"`

	// The configuration for manifest processing rules. Manifest processing rules
	// enable customization of the personalized manifests created by MediaTailor.
	ManifestProcessingRules *ManifestProcessingRules `type:"structure"`

	// The identifier for the playback configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Defines the maximum duration of underfilled ad time (in seconds) allowed
	// in an ad break. If the duration of underfilled ad time exceeds the personalization
	// threshold, then the personalization of the ad break is abandoned and the
	// underlying content is shown. This feature applies to ad replacement in live
	// and VOD streams, rather than ad insertion, because it relies on an underlying
	// content stream. For more information about ad break behavior, including ad
	// replacement and insertion, see Ad Behavior in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	PersonalizationThresholdSeconds *int64 `min:"1" type:"integer"`

	// The URL for a high-quality video asset to transcode and use to fill in time
	// that's not used by ads. AWS Elemental MediaTailor shows the slate to fill
	// in gaps in media content. Configuring the slate is optional for non-VPAID
	// configurations. For VPAID, the slate is required because MediaTailor provides
	// it in the slots that are designated for dynamic ad content. The slate must
	// be a high-quality asset that contains both audio and video.
	SlateAdUrl *string `type:"string"`

	// The tags to assign to the playback configuration. Tags are key-value pairs
	// that you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name that is used to associate this playback configuration with a custom
	// transcode profile. This overrides the dynamic transcoding defaults of MediaTailor.
	// Use this only if you have already set up custom profiles with the help of
	// AWS Support.
	TranscodeProfileName *string `type:"string"`

	// The URL prefix for the parent manifest for the stream, minus the asset ID.
	// The maximum length is 512 characters.
	VideoContentSourceUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPlaybackConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPlaybackConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPlaybackConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPlaybackConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PersonalizationThresholdSeconds != nil && *s.PersonalizationThresholdSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PersonalizationThresholdSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdDecisionServerUrl sets the AdDecisionServerUrl field's value.
func (s *PutPlaybackConfigurationInput) SetAdDecisionServerUrl(v string) *PutPlaybackConfigurationInput {
	s.AdDecisionServerUrl = &v
	return s
}

// SetAvailSuppression sets the AvailSuppression field's value.
func (s *PutPlaybackConfigurationInput) SetAvailSuppression(v *AvailSuppression) *PutPlaybackConfigurationInput {
	s.AvailSuppression = v
	return s
}

// SetBumper sets the Bumper field's value.
func (s *PutPlaybackConfigurationInput) SetBumper(v *Bumper) *PutPlaybackConfigurationInput {
	s.Bumper = v
	return s
}

// SetCdnConfiguration sets the CdnConfiguration field's value.
func (s *PutPlaybackConfigurationInput) SetCdnConfiguration(v *CdnConfiguration) *PutPlaybackConfigurationInput {
	s.CdnConfiguration = v
	return s
}

// SetConfigurationAliases sets the ConfigurationAliases field's value.
func (s *PutPlaybackConfigurationInput) SetConfigurationAliases(v map[string]map[string]*string) *PutPlaybackConfigurationInput {
	s.ConfigurationAliases = v
	return s
}

// SetDashConfiguration sets the DashConfiguration field's value.
func (s *PutPlaybackConfigurationInput) SetDashConfiguration(v *DashConfigurationForPut) *PutPlaybackConfigurationInput {
	s.DashConfiguration = v
	return s
}

// SetLivePreRollConfiguration sets the LivePreRollConfiguration field's value.
func (s *PutPlaybackConfigurationInput) SetLivePreRollConfiguration(v *LivePreRollConfiguration) *PutPlaybackConfigurationInput {
	s.LivePreRollConfiguration = v
	return s
}

// SetManifestProcessingRules sets the ManifestProcessingRules field's value.
func (s *PutPlaybackConfigurationInput) SetManifestProcessingRules(v *ManifestProcessingRules) *PutPlaybackConfigurationInput {
	s.ManifestProcessingRules = v
	return s
}

// SetName sets the Name field's value.
func (s *PutPlaybackConfigurationInput) SetName(v string) *PutPlaybackConfigurationInput {
	s.Name = &v
	return s
}

// SetPersonalizationThresholdSeconds sets the PersonalizationThresholdSeconds field's value.
func (s *PutPlaybackConfigurationInput) SetPersonalizationThresholdSeconds(v int64) *PutPlaybackConfigurationInput {
	s.PersonalizationThresholdSeconds = &v
	return s
}

// SetSlateAdUrl sets the SlateAdUrl field's value.
func (s *PutPlaybackConfigurationInput) SetSlateAdUrl(v string) *PutPlaybackConfigurationInput {
	s.SlateAdUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutPlaybackConfigurationInput) SetTags(v map[string]*string) *PutPlaybackConfigurationInput {
	s.Tags = v
	return s
}

// SetTranscodeProfileName sets the TranscodeProfileName field's value.
func (s *PutPlaybackConfigurationInput) SetTranscodeProfileName(v string) *PutPlaybackConfigurationInput {
	s.TranscodeProfileName = &v
	return s
}

// SetVideoContentSourceUrl sets the VideoContentSourceUrl field's value.
func (s *PutPlaybackConfigurationInput) SetVideoContentSourceUrl(v string) *PutPlaybackConfigurationInput {
	s.VideoContentSourceUrl = &v
	return s
}

type PutPlaybackConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The URL for the ad decision server (ADS). This includes the specification
	// of static parameters and placeholders for dynamic parameters. AWS Elemental
	// MediaTailor substitutes player-specific and session-specific parameters as
	// needed when calling the ADS. Alternately, for testing you can provide a static
	// VAST URL. The maximum length is 25,000 characters.
	AdDecisionServerUrl *string `type:"string"`

	// The configuration for avail suppression, also known as ad suppression. For
	// more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	AvailSuppression *AvailSuppression `type:"structure"`

	// The configuration for bumpers. Bumpers are short audio or video clips that
	// play at the start or before the end of an ad break. To learn more about bumpers,
	// see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
	Bumper *Bumper `type:"structure"`

	// The configuration for using a content delivery network (CDN), like Amazon
	// CloudFront, for content and ad segment management.
	CdnConfiguration *CdnConfiguration `type:"structure"`

	// The player parameters and aliases used as dynamic variables during session
	// initialization. For more information, see Domain Variables (https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html).
	ConfigurationAliases map[string]map[string]*string `type:"map"`

	// The configuration for DASH content.
	DashConfiguration *DashConfiguration `type:"structure"`

	// The configuration for HLS content.
	HlsConfiguration *HlsConfiguration `type:"structure"`

	// The configuration for pre-roll ad insertion.
	LivePreRollConfiguration *LivePreRollConfiguration `type:"structure"`

	// The Amazon CloudWatch log settings for a playback configuration.
	LogConfiguration *LogConfiguration `type:"structure"`

	// The configuration for manifest processing rules. Manifest processing rules
	// enable customization of the personalized manifests created by MediaTailor.
	ManifestProcessingRules *ManifestProcessingRules `type:"structure"`

	// The identifier for the playback configuration.
	Name *string `type:"string"`

	// Defines the maximum duration of underfilled ad time (in seconds) allowed
	// in an ad break. If the duration of underfilled ad time exceeds the personalization
	// threshold, then the personalization of the ad break is abandoned and the
	// underlying content is shown. This feature applies to ad replacement in live
	// and VOD streams, rather than ad insertion, because it relies on an underlying
	// content stream. For more information about ad break behavior, including ad
	// replacement and insertion, see Ad Behavior in AWS Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
	PersonalizationThresholdSeconds *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) associated with the playback configuration.
	PlaybackConfigurationArn *string `type:"string"`

	// The playback endpoint prefix associated with the playback configuration.
	PlaybackEndpointPrefix *string `type:"string"`

	// The session initialization endpoint prefix associated with the playback configuration.
	SessionInitializationEndpointPrefix *string `type:"string"`

	// The URL for a high-quality video asset to transcode and use to fill in time
	// that's not used by ads. AWS Elemental MediaTailor shows the slate to fill
	// in gaps in media content. Configuring the slate is optional for non-VPAID
	// configurations. For VPAID, the slate is required because MediaTailor provides
	// it in the slots that are designated for dynamic ad content. The slate must
	// be a high-quality asset that contains both audio and video.
	SlateAdUrl *string `type:"string"`

	// The tags to assign to the playback configuration. Tags are key-value pairs
	// that you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name that is used to associate this playback configuration with a custom
	// transcode profile. This overrides the dynamic transcoding defaults of MediaTailor.
	// Use this only if you have already set up custom profiles with the help of
	// AWS Support.
	TranscodeProfileName *string `type:"string"`

	// The URL prefix for the parent manifest for the stream, minus the asset ID.
	// The maximum length is 512 characters.
	VideoContentSourceUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPlaybackConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPlaybackConfigurationOutput) GoString() string {
	return s.String()
}

// SetAdDecisionServerUrl sets the AdDecisionServerUrl field's value.
func (s *PutPlaybackConfigurationOutput) SetAdDecisionServerUrl(v string) *PutPlaybackConfigurationOutput {
	s.AdDecisionServerUrl = &v
	return s
}

// SetAvailSuppression sets the AvailSuppression field's value.
func (s *PutPlaybackConfigurationOutput) SetAvailSuppression(v *AvailSuppression) *PutPlaybackConfigurationOutput {
	s.AvailSuppression = v
	return s
}

// SetBumper sets the Bumper field's value.
func (s *PutPlaybackConfigurationOutput) SetBumper(v *Bumper) *PutPlaybackConfigurationOutput {
	s.Bumper = v
	return s
}

// SetCdnConfiguration sets the CdnConfiguration field's value.
func (s *PutPlaybackConfigurationOutput) SetCdnConfiguration(v *CdnConfiguration) *PutPlaybackConfigurationOutput {
	s.CdnConfiguration = v
	return s
}

// SetConfigurationAliases sets the ConfigurationAliases field's value.
func (s *PutPlaybackConfigurationOutput) SetConfigurationAliases(v map[string]map[string]*string) *PutPlaybackConfigurationOutput {
	s.ConfigurationAliases = v
	return s
}

// SetDashConfiguration sets the DashConfiguration field's value.
func (s *PutPlaybackConfigurationOutput) SetDashConfiguration(v *DashConfiguration) *PutPlaybackConfigurationOutput {
	s.DashConfiguration = v
	return s
}

// SetHlsConfiguration sets the HlsConfiguration field's value.
func (s *PutPlaybackConfigurationOutput) SetHlsConfiguration(v *HlsConfiguration) *PutPlaybackConfigurationOutput {
	s.HlsConfiguration = v
	return s
}

// SetLivePreRollConfiguration sets the LivePreRollConfiguration field's value.
func (s *PutPlaybackConfigurationOutput) SetLivePreRollConfiguration(v *LivePreRollConfiguration) *PutPlaybackConfigurationOutput {
	s.LivePreRollConfiguration = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *PutPlaybackConfigurationOutput) SetLogConfiguration(v *LogConfiguration) *PutPlaybackConfigurationOutput {
	s.LogConfiguration = v
	return s
}

// SetManifestProcessingRules sets the ManifestProcessingRules field's value.
func (s *PutPlaybackConfigurationOutput) SetManifestProcessingRules(v *ManifestProcessingRules) *PutPlaybackConfigurationOutput {
	s.ManifestProcessingRules = v
	return s
}

// SetName sets the Name field's value.
func (s *PutPlaybackConfigurationOutput) SetName(v string) *PutPlaybackConfigurationOutput {
	s.Name = &v
	return s
}

// SetPersonalizationThresholdSeconds sets the PersonalizationThresholdSeconds field's value.
func (s *PutPlaybackConfigurationOutput) SetPersonalizationThresholdSeconds(v int64) *PutPlaybackConfigurationOutput {
	s.PersonalizationThresholdSeconds = &v
	return s
}

// SetPlaybackConfigurationArn sets the PlaybackConfigurationArn field's value.
func (s *PutPlaybackConfigurationOutput) SetPlaybackConfigurationArn(v string) *PutPlaybackConfigurationOutput {
	s.PlaybackConfigurationArn = &v
	return s
}

// SetPlaybackEndpointPrefix sets the PlaybackEndpointPrefix field's value.
func (s *PutPlaybackConfigurationOutput) SetPlaybackEndpointPrefix(v string) *PutPlaybackConfigurationOutput {
	s.PlaybackEndpointPrefix = &v
	return s
}

// SetSessionInitializationEndpointPrefix sets the SessionInitializationEndpointPrefix field's value.
func (s *PutPlaybackConfigurationOutput) SetSessionInitializationEndpointPrefix(v string) *PutPlaybackConfigurationOutput {
	s.SessionInitializationEndpointPrefix = &v
	return s
}

// SetSlateAdUrl sets the SlateAdUrl field's value.
func (s *PutPlaybackConfigurationOutput) SetSlateAdUrl(v string) *PutPlaybackConfigurationOutput {
	s.SlateAdUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutPlaybackConfigurationOutput) SetTags(v map[string]*string) *PutPlaybackConfigurationOutput {
	s.Tags = v
	return s
}

// SetTranscodeProfileName sets the TranscodeProfileName field's value.
func (s *PutPlaybackConfigurationOutput) SetTranscodeProfileName(v string) *PutPlaybackConfigurationOutput {
	s.TranscodeProfileName = &v
	return s
}

// SetVideoContentSourceUrl sets the VideoContentSourceUrl field's value.
func (s *PutPlaybackConfigurationOutput) SetVideoContentSourceUrl(v string) *PutPlaybackConfigurationOutput {
	s.VideoContentSourceUrl = &v
	return s
}

// The output configuration for this channel.
type RequestOutputItem struct {
	_ struct{} `type:"structure"`

	// DASH manifest configuration parameters.
	DashPlaylistSettings *DashPlaylistSettings `type:"structure"`

	// HLS playlist configuration parameters.
	HlsPlaylistSettings *HlsPlaylistSettings `type:"structure"`

	// The name of the manifest for the channel. The name appears in the PlaybackUrl.
	//
	// ManifestName is a required field
	ManifestName *string `type:"string" required:"true"`

	// A string used to match which HttpPackageConfiguration is used for each VodSource.
	//
	// SourceGroup is a required field
	SourceGroup *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestOutputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestOutputItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestOutputItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestOutputItem"}
	if s.ManifestName == nil {
		invalidParams.Add(request.NewErrParamRequired("ManifestName"))
	}
	if s.SourceGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashPlaylistSettings sets the DashPlaylistSettings field's value.
func (s *RequestOutputItem) SetDashPlaylistSettings(v *DashPlaylistSettings) *RequestOutputItem {
	s.DashPlaylistSettings = v
	return s
}

// SetHlsPlaylistSettings sets the HlsPlaylistSettings field's value.
func (s *RequestOutputItem) SetHlsPlaylistSettings(v *HlsPlaylistSettings) *RequestOutputItem {
	s.HlsPlaylistSettings = v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *RequestOutputItem) SetManifestName(v string) *RequestOutputItem {
	s.ManifestName = &v
	return s
}

// SetSourceGroup sets the SourceGroup field's value.
func (s *RequestOutputItem) SetSourceGroup(v string) *RequestOutputItem {
	s.SourceGroup = &v
	return s
}

// The output item response.
type ResponseOutputItem struct {
	_ struct{} `type:"structure"`

	// DASH manifest configuration settings.
	DashPlaylistSettings *DashPlaylistSettings `type:"structure"`

	// HLS manifest configuration settings.
	HlsPlaylistSettings *HlsPlaylistSettings `type:"structure"`

	// The name of the manifest for the channel that will appear in the channel
	// output's playback URL.
	//
	// ManifestName is a required field
	ManifestName *string `type:"string" required:"true"`

	// The URL used for playback by content players.
	//
	// PlaybackUrl is a required field
	PlaybackUrl *string `type:"string" required:"true"`

	// A string used to associate a package configuration source group with a channel
	// output.
	//
	// SourceGroup is a required field
	SourceGroup *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseOutputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseOutputItem) GoString() string {
	return s.String()
}

// SetDashPlaylistSettings sets the DashPlaylistSettings field's value.
func (s *ResponseOutputItem) SetDashPlaylistSettings(v *DashPlaylistSettings) *ResponseOutputItem {
	s.DashPlaylistSettings = v
	return s
}

// SetHlsPlaylistSettings sets the HlsPlaylistSettings field's value.
func (s *ResponseOutputItem) SetHlsPlaylistSettings(v *HlsPlaylistSettings) *ResponseOutputItem {
	s.HlsPlaylistSettings = v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *ResponseOutputItem) SetManifestName(v string) *ResponseOutputItem {
	s.ManifestName = &v
	return s
}

// SetPlaybackUrl sets the PlaybackUrl field's value.
func (s *ResponseOutputItem) SetPlaybackUrl(v string) *ResponseOutputItem {
	s.PlaybackUrl = &v
	return s
}

// SetSourceGroup sets the SourceGroup field's value.
func (s *ResponseOutputItem) SetSourceGroup(v string) *ResponseOutputItem {
	s.SourceGroup = &v
	return s
}

// The schedule's ad break properties.
type ScheduleAdBreak struct {
	_ struct{} `type:"structure"`

	// The approximate duration of the ad break, in seconds.
	ApproximateDurationSeconds *int64 `type:"long"`

	// The approximate time that the ad will start playing.
	ApproximateStartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the source location containing the VOD source used for the ad
	// break.
	SourceLocationName *string `type:"string"`

	// The name of the VOD source used for the ad break.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleAdBreak) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleAdBreak) GoString() string {
	return s.String()
}

// SetApproximateDurationSeconds sets the ApproximateDurationSeconds field's value.
func (s *ScheduleAdBreak) SetApproximateDurationSeconds(v int64) *ScheduleAdBreak {
	s.ApproximateDurationSeconds = &v
	return s
}

// SetApproximateStartTime sets the ApproximateStartTime field's value.
func (s *ScheduleAdBreak) SetApproximateStartTime(v time.Time) *ScheduleAdBreak {
	s.ApproximateStartTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *ScheduleAdBreak) SetSourceLocationName(v string) *ScheduleAdBreak {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *ScheduleAdBreak) SetVodSourceName(v string) *ScheduleAdBreak {
	s.VodSourceName = &v
	return s
}

// Schedule configuration parameters. A channel must be stopped before changes
// can be made to the schedule.
type ScheduleConfiguration struct {
	_ struct{} `type:"structure"`

	// Program clip range configuration.
	ClipRange *ClipRange `type:"structure"`

	// Program transition configurations.
	//
	// Transition is a required field
	Transition *Transition `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleConfiguration"}
	if s.Transition == nil {
		invalidParams.Add(request.NewErrParamRequired("Transition"))
	}
	if s.ClipRange != nil {
		if err := s.ClipRange.Validate(); err != nil {
			invalidParams.AddNested("ClipRange", err.(request.ErrInvalidParams))
		}
	}
	if s.Transition != nil {
		if err := s.Transition.Validate(); err != nil {
			invalidParams.AddNested("Transition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClipRange sets the ClipRange field's value.
func (s *ScheduleConfiguration) SetClipRange(v *ClipRange) *ScheduleConfiguration {
	s.ClipRange = v
	return s
}

// SetTransition sets the Transition field's value.
func (s *ScheduleConfiguration) SetTransition(v *Transition) *ScheduleConfiguration {
	s.Transition = v
	return s
}

// The properties for a schedule.
type ScheduleEntry struct {
	_ struct{} `type:"structure"`

	// The approximate duration of this program, in seconds.
	ApproximateDurationSeconds *int64 `type:"long"`

	// The approximate time that the program will start playing.
	ApproximateStartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The ARN of the program.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name of the channel that uses this schedule.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The name of the live source used for the program.
	LiveSourceName *string `type:"string"`

	// The name of the program.
	//
	// ProgramName is a required field
	ProgramName *string `type:"string" required:"true"`

	// The schedule's ad break properties.
	ScheduleAdBreaks []*ScheduleAdBreak `type:"list"`

	// The type of schedule entry.
	ScheduleEntryType *string `type:"string" enum:"ScheduleEntryType"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `type:"string" required:"true"`

	// The name of the VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleEntry) GoString() string {
	return s.String()
}

// SetApproximateDurationSeconds sets the ApproximateDurationSeconds field's value.
func (s *ScheduleEntry) SetApproximateDurationSeconds(v int64) *ScheduleEntry {
	s.ApproximateDurationSeconds = &v
	return s
}

// SetApproximateStartTime sets the ApproximateStartTime field's value.
func (s *ScheduleEntry) SetApproximateStartTime(v time.Time) *ScheduleEntry {
	s.ApproximateStartTime = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ScheduleEntry) SetArn(v string) *ScheduleEntry {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *ScheduleEntry) SetChannelName(v string) *ScheduleEntry {
	s.ChannelName = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *ScheduleEntry) SetLiveSourceName(v string) *ScheduleEntry {
	s.LiveSourceName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *ScheduleEntry) SetProgramName(v string) *ScheduleEntry {
	s.ProgramName = &v
	return s
}

// SetScheduleAdBreaks sets the ScheduleAdBreaks field's value.
func (s *ScheduleEntry) SetScheduleAdBreaks(v []*ScheduleAdBreak) *ScheduleEntry {
	s.ScheduleAdBreaks = v
	return s
}

// SetScheduleEntryType sets the ScheduleEntryType field's value.
func (s *ScheduleEntry) SetScheduleEntryType(v string) *ScheduleEntry {
	s.ScheduleEntryType = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *ScheduleEntry) SetSourceLocationName(v string) *ScheduleEntry {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *ScheduleEntry) SetVodSourceName(v string) *ScheduleEntry {
	s.VodSourceName = &v
	return s
}

// AWS Secrets Manager access token configuration parameters. For information
// about Secrets Manager access token authentication, see Working with AWS Secrets
// Manager access token authentication (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html).
type SecretsManagerAccessTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the HTTP header used to supply the access token in requests to
	// the source location.
	HeaderName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains
	// the access token.
	SecretArn *string `type:"string"`

	// The AWS Secrets Manager SecretString (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html)
	// key associated with the access token. MediaTailor uses the key to look up
	// SecretString key and value pair containing the access token.
	SecretStringKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretsManagerAccessTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretsManagerAccessTokenConfiguration) GoString() string {
	return s.String()
}

// SetHeaderName sets the HeaderName field's value.
func (s *SecretsManagerAccessTokenConfiguration) SetHeaderName(v string) *SecretsManagerAccessTokenConfiguration {
	s.HeaderName = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *SecretsManagerAccessTokenConfiguration) SetSecretArn(v string) *SecretsManagerAccessTokenConfiguration {
	s.SecretArn = &v
	return s
}

// SetSecretStringKey sets the SecretStringKey field's value.
func (s *SecretsManagerAccessTokenConfiguration) SetSecretStringKey(v string) *SecretsManagerAccessTokenConfiguration {
	s.SecretStringKey = &v
	return s
}

// The segment delivery configuration settings.
type SegmentDeliveryConfiguration struct {
	_ struct{} `type:"structure"`

	// The base URL of the host or path of the segment delivery server that you're
	// using to serve segments. This is typically a content delivery network (CDN).
	// The URL can be absolute or relative. To use an absolute URL include the protocol,
	// such as https://example.com/some/path. To use a relative URL specify the
	// relative path, such as /some/path*.
	BaseUrl *string `type:"string"`

	// A unique identifier used to distinguish between multiple segment delivery
	// configurations in a source location.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentDeliveryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentDeliveryConfiguration) GoString() string {
	return s.String()
}

// SetBaseUrl sets the BaseUrl field's value.
func (s *SegmentDeliveryConfiguration) SetBaseUrl(v string) *SegmentDeliveryConfiguration {
	s.BaseUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *SegmentDeliveryConfiguration) SetName(v string) *SegmentDeliveryConfiguration {
	s.Name = &v
	return s
}

// The segmentation_descriptor message can contain advanced metadata fields,
// like content identifiers, to convey a wide range of information about the
// ad break. MediaTailor writes the ad metadata in the egress manifest as part
// of the EXT-X-DATERANGE or EventStream ad marker's SCTE-35 data.
//
// segmentation_descriptor messages must be sent with the time_signal message
// type.
//
// See the segmentation_descriptor() table of the 2022 SCTE-35 specification
// for more information.
type SegmentationDescriptor struct {
	_ struct{} `type:"structure"`

	// The segment number to assign to the segmentation_descriptor.segment_num message,
	// as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must
	// be between 0 and 256, inclusive. The default value is 0.
	SegmentNum *int64 `type:"integer"`

	// The Event Identifier to assign to the segmentation_descriptor.segmentation_event_id
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// The default value is 1.
	SegmentationEventId *int64 `type:"integer"`

	// The Type Identifier to assign to the segmentation_descriptor.segmentation_type_id
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// Values must be between 0 and 256, inclusive. The default value is 48.
	SegmentationTypeId *int64 `type:"integer"`

	// The Upid to assign to the segmentation_descriptor.segmentation_upid message,
	// as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The value
	// must be a hexadecimal string containing only the characters 0 though 9 and
	// A through F. The default value is "" (an empty string).
	SegmentationUpid *string `type:"string"`

	// The Upid Type to assign to the segmentation_descriptor.segmentation_upid_type
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// Values must be between 0 and 256, inclusive. The default value is 14.
	SegmentationUpidType *int64 `type:"integer"`

	// The number of segments expected, which is assigned to the segmentation_descriptor.segments_expectedS
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification
	// Values must be between 0 and 256, inclusive. The default value is 0.
	SegmentsExpected *int64 `type:"integer"`

	// The sub-segment number to assign to the segmentation_descriptor.sub_segment_num
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// Values must be between 0 and 256, inclusive. The defualt value is null.
	SubSegmentNum *int64 `type:"integer"`

	// The number of sub-segments expected, which is assigned to the segmentation_descriptor.sub_segments_expected
	// message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification.
	// Values must be between 0 and 256, inclusive. The default value is null.
	SubSegmentsExpected *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentationDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentationDescriptor) GoString() string {
	return s.String()
}

// SetSegmentNum sets the SegmentNum field's value.
func (s *SegmentationDescriptor) SetSegmentNum(v int64) *SegmentationDescriptor {
	s.SegmentNum = &v
	return s
}

// SetSegmentationEventId sets the SegmentationEventId field's value.
func (s *SegmentationDescriptor) SetSegmentationEventId(v int64) *SegmentationDescriptor {
	s.SegmentationEventId = &v
	return s
}

// SetSegmentationTypeId sets the SegmentationTypeId field's value.
func (s *SegmentationDescriptor) SetSegmentationTypeId(v int64) *SegmentationDescriptor {
	s.SegmentationTypeId = &v
	return s
}

// SetSegmentationUpid sets the SegmentationUpid field's value.
func (s *SegmentationDescriptor) SetSegmentationUpid(v string) *SegmentationDescriptor {
	s.SegmentationUpid = &v
	return s
}

// SetSegmentationUpidType sets the SegmentationUpidType field's value.
func (s *SegmentationDescriptor) SetSegmentationUpidType(v int64) *SegmentationDescriptor {
	s.SegmentationUpidType = &v
	return s
}

// SetSegmentsExpected sets the SegmentsExpected field's value.
func (s *SegmentationDescriptor) SetSegmentsExpected(v int64) *SegmentationDescriptor {
	s.SegmentsExpected = &v
	return s
}

// SetSubSegmentNum sets the SubSegmentNum field's value.
func (s *SegmentationDescriptor) SetSubSegmentNum(v int64) *SegmentationDescriptor {
	s.SubSegmentNum = &v
	return s
}

// SetSubSegmentsExpected sets the SubSegmentsExpected field's value.
func (s *SegmentationDescriptor) SetSubSegmentsExpected(v int64) *SegmentationDescriptor {
	s.SubSegmentsExpected = &v
	return s
}

// Slate VOD source configuration.
type SlateSource struct {
	_ struct{} `type:"structure"`

	// The name of the source location where the slate VOD source is stored.
	SourceLocationName *string `type:"string"`

	// The slate VOD source name. The VOD source must already exist in a source
	// location before it can be used for slate.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlateSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlateSource) GoString() string {
	return s.String()
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *SlateSource) SetSourceLocationName(v string) *SlateSource {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *SlateSource) SetVodSourceName(v string) *SlateSource {
	s.VodSourceName = &v
	return s
}

// A source location is a container for sources. For more information about
// source locations, see Working with source locations (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html)
// in the MediaTailor User Guide.
type SourceLocation struct {
	_ struct{} `type:"structure"`

	// The access configuration for the source location.
	AccessConfiguration *AccessConfiguration `type:"structure"`

	// The ARN of the SourceLocation.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The timestamp that indicates when the source location was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The default segment delivery configuration.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration `type:"structure"`

	// The HTTP configuration for the source location.
	//
	// HttpConfiguration is a required field
	HttpConfiguration *HttpConfiguration `type:"structure" required:"true"`

	// The timestamp that indicates when the source location was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The segment delivery configurations for the source location.
	SegmentDeliveryConfigurations []*SegmentDeliveryConfiguration `type:"list"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `type:"string" required:"true"`

	// The tags assigned to the source location. Tags are key-value pairs that you
	// can associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceLocation) GoString() string {
	return s.String()
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *SourceLocation) SetAccessConfiguration(v *AccessConfiguration) *SourceLocation {
	s.AccessConfiguration = v
	return s
}

// SetArn sets the Arn field's value.
func (s *SourceLocation) SetArn(v string) *SourceLocation {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *SourceLocation) SetCreationTime(v time.Time) *SourceLocation {
	s.CreationTime = &v
	return s
}

// SetDefaultSegmentDeliveryConfiguration sets the DefaultSegmentDeliveryConfiguration field's value.
func (s *SourceLocation) SetDefaultSegmentDeliveryConfiguration(v *DefaultSegmentDeliveryConfiguration) *SourceLocation {
	s.DefaultSegmentDeliveryConfiguration = v
	return s
}

// SetHttpConfiguration sets the HttpConfiguration field's value.
func (s *SourceLocation) SetHttpConfiguration(v *HttpConfiguration) *SourceLocation {
	s.HttpConfiguration = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *SourceLocation) SetLastModifiedTime(v time.Time) *SourceLocation {
	s.LastModifiedTime = &v
	return s
}

// SetSegmentDeliveryConfigurations sets the SegmentDeliveryConfigurations field's value.
func (s *SourceLocation) SetSegmentDeliveryConfigurations(v []*SegmentDeliveryConfiguration) *SourceLocation {
	s.SegmentDeliveryConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *SourceLocation) SetSourceLocationName(v string) *SourceLocation {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SourceLocation) SetTags(v map[string]*string) *SourceLocation {
	s.Tags = v
	return s
}

// Splice insert message configuration.
type SpliceInsertMessage struct {
	_ struct{} `type:"structure"`

	// This is written to splice_insert.avail_num, as defined in section 9.7.3.1
	// of the SCTE-35 specification. The default value is 0. Values must be between
	// 0 and 256, inclusive.
	AvailNum *int64 `type:"integer"`

	// This is written to splice_insert.avails_expected, as defined in section 9.7.3.1
	// of the SCTE-35 specification. The default value is 0. Values must be between
	// 0 and 256, inclusive.
	AvailsExpected *int64 `type:"integer"`

	// This is written to splice_insert.splice_event_id, as defined in section 9.7.3.1
	// of the SCTE-35 specification. The default value is 1.
	SpliceEventId *int64 `type:"integer"`

	// This is written to splice_insert.unique_program_id, as defined in section
	// 9.7.3.1 of the SCTE-35 specification. The default value is 0. Values must
	// be between 0 and 256, inclusive.
	UniqueProgramId *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpliceInsertMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpliceInsertMessage) GoString() string {
	return s.String()
}

// SetAvailNum sets the AvailNum field's value.
func (s *SpliceInsertMessage) SetAvailNum(v int64) *SpliceInsertMessage {
	s.AvailNum = &v
	return s
}

// SetAvailsExpected sets the AvailsExpected field's value.
func (s *SpliceInsertMessage) SetAvailsExpected(v int64) *SpliceInsertMessage {
	s.AvailsExpected = &v
	return s
}

// SetSpliceEventId sets the SpliceEventId field's value.
func (s *SpliceInsertMessage) SetSpliceEventId(v int64) *SpliceInsertMessage {
	s.SpliceEventId = &v
	return s
}

// SetUniqueProgramId sets the UniqueProgramId field's value.
func (s *SpliceInsertMessage) SetUniqueProgramId(v int64) *SpliceInsertMessage {
	s.UniqueProgramId = &v
	return s
}

type StartChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *StartChannelInput) SetChannelName(v string) *StartChannelInput {
	s.ChannelName = &v
	return s
}

type StartChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChannelOutput) GoString() string {
	return s.String()
}

type StopChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *StopChannelInput) SetChannelName(v string) *StopChannelInput {
	s.ChannelName = &v
	return s
}

type StopChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopChannelOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to assign to the resource. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The configuration for time-shifted viewing.
type TimeShiftConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum time delay for time-shifted viewing. The minimum allowed maximum
	// time delay is 0 seconds, and the maximum allowed maximum time delay is 21600
	// seconds (6 hours).
	//
	// MaxTimeDelaySeconds is a required field
	MaxTimeDelaySeconds *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeShiftConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeShiftConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeShiftConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeShiftConfiguration"}
	if s.MaxTimeDelaySeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxTimeDelaySeconds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxTimeDelaySeconds sets the MaxTimeDelaySeconds field's value.
func (s *TimeShiftConfiguration) SetMaxTimeDelaySeconds(v int64) *TimeShiftConfiguration {
	s.MaxTimeDelaySeconds = &v
	return s
}

// The SCTE-35 time_signal message can be sent with one or more segmentation_descriptor
// messages. A time_signal message can be sent only if a single segmentation_descriptor
// message is sent.
//
// The time_signal message contains only the splice_time field which is constructed
// using a given presentation timestamp. When sending a time_signal message,
// the splice_command_type field in the splice_info_section message is set to
// 6 (0x06).
//
// See the time_signal() table of the 2022 SCTE-35 specification for more information.
type TimeSignalMessage struct {
	_ struct{} `type:"structure"`

	// The configurations for the SCTE-35 segmentation_descriptor message(s) sent
	// with the time_signal message.
	SegmentationDescriptors []*SegmentationDescriptor `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSignalMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSignalMessage) GoString() string {
	return s.String()
}

// SetSegmentationDescriptors sets the SegmentationDescriptors field's value.
func (s *TimeSignalMessage) SetSegmentationDescriptors(v []*SegmentationDescriptor) *TimeSignalMessage {
	s.SegmentationDescriptors = v
	return s
}

// Program transition configuration.
type Transition struct {
	_ struct{} `type:"structure"`

	// The duration of the live program in seconds.
	DurationMillis *int64 `type:"long"`

	// The position where this program will be inserted relative to the RelativePosition.
	//
	// RelativePosition is a required field
	RelativePosition *string `type:"string" required:"true" enum:"RelativePosition"`

	// The name of the program that this program will be inserted next to, as defined
	// by RelativePosition.
	RelativeProgram *string `type:"string"`

	// The date and time that the program is scheduled to start, in epoch milliseconds.
	ScheduledStartTimeMillis *int64 `type:"long"`

	// Defines when the program plays in the schedule. You can set the value to
	// ABSOLUTE or RELATIVE.
	//
	// ABSOLUTE - The program plays at a specific wall clock time. This setting
	// can only be used for channels using the LINEAR PlaybackMode.
	//
	// Note the following considerations when using ABSOLUTE transitions:
	//
	// If the preceding program in the schedule has a duration that extends past
	// the wall clock time, MediaTailor truncates the preceding program on a common
	// segment boundary.
	//
	// If there are gaps in playback, MediaTailor plays the FillerSlate you configured
	// for your linear channel.
	//
	// RELATIVE - The program is inserted into the schedule either before or after
	// a program that you specify via RelativePosition.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Transition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Transition"}
	if s.RelativePosition == nil {
		invalidParams.Add(request.NewErrParamRequired("RelativePosition"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *Transition) SetDurationMillis(v int64) *Transition {
	s.DurationMillis = &v
	return s
}

// SetRelativePosition sets the RelativePosition field's value.
func (s *Transition) SetRelativePosition(v string) *Transition {
	s.RelativePosition = &v
	return s
}

// SetRelativeProgram sets the RelativeProgram field's value.
func (s *Transition) SetRelativeProgram(v string) *Transition {
	s.RelativeProgram = &v
	return s
}

// SetScheduledStartTimeMillis sets the ScheduledStartTimeMillis field's value.
func (s *Transition) SetScheduledStartTimeMillis(v int64) *Transition {
	s.ScheduledStartTimeMillis = &v
	return s
}

// SetType sets the Type field's value.
func (s *Transition) SetType(v string) *Transition {
	s.Type = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tag keys associated with the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The slate used to fill gaps between programs in the schedule. You must configure
	// filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't
	// support filler slate for channels using the LOOP PlaybackMode.
	FillerSlate *SlateSource `type:"structure"`

	// The channel's output properties.
	//
	// Outputs is a required field
	Outputs []*RequestOutputItem `type:"list" required:"true"`

	// The time-shifted viewing configuration you want to associate to the channel.
	TimeShiftConfiguration *TimeShiftConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimeShiftConfiguration != nil {
		if err := s.TimeShiftConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TimeShiftConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateChannelInput) SetChannelName(v string) *UpdateChannelInput {
	s.ChannelName = &v
	return s
}

// SetFillerSlate sets the FillerSlate field's value.
func (s *UpdateChannelInput) SetFillerSlate(v *SlateSource) *UpdateChannelInput {
	s.FillerSlate = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *UpdateChannelInput) SetOutputs(v []*RequestOutputItem) *UpdateChannelInput {
	s.Outputs = v
	return s
}

// SetTimeShiftConfiguration sets the TimeShiftConfiguration field's value.
func (s *UpdateChannelInput) SetTimeShiftConfiguration(v *TimeShiftConfiguration) *UpdateChannelInput {
	s.TimeShiftConfiguration = v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the channel.
	Arn *string `type:"string"`

	// The name of the channel.
	ChannelName *string `type:"string"`

	// Returns the state whether the channel is running or not.
	ChannelState *string `type:"string" enum:"ChannelState"`

	// The timestamp of when the channel was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The slate used to fill gaps between programs in the schedule. You must configure
	// filler slate if your channel uses the LINEAR PlaybackMode. MediaTailor doesn't
	// support filler slate for channels using the LOOP PlaybackMode.
	FillerSlate *SlateSource `type:"structure"`

	// The timestamp that indicates when the channel was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The channel's output properties.
	Outputs []*ResponseOutputItem `type:"list"`

	// The type of playback mode for this channel.
	//
	// LINEAR - Programs play back-to-back only once.
	//
	// LOOP - Programs play back-to-back in an endless loop. When the last program
	// in the schedule plays, playback loops back to the first program in the schedule.
	PlaybackMode *string `type:"string"`

	// The tags to assign to the channel. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The tier associated with this Channel.
	Tier *string `type:"string"`

	// The time-shifted viewing configuration for the channel.
	TimeShiftConfiguration *TimeShiftConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateChannelOutput) SetArn(v string) *UpdateChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateChannelOutput) SetChannelName(v string) *UpdateChannelOutput {
	s.ChannelName = &v
	return s
}

// SetChannelState sets the ChannelState field's value.
func (s *UpdateChannelOutput) SetChannelState(v string) *UpdateChannelOutput {
	s.ChannelState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateChannelOutput) SetCreationTime(v time.Time) *UpdateChannelOutput {
	s.CreationTime = &v
	return s
}

// SetFillerSlate sets the FillerSlate field's value.
func (s *UpdateChannelOutput) SetFillerSlate(v *SlateSource) *UpdateChannelOutput {
	s.FillerSlate = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateChannelOutput) SetLastModifiedTime(v time.Time) *UpdateChannelOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *UpdateChannelOutput) SetOutputs(v []*ResponseOutputItem) *UpdateChannelOutput {
	s.Outputs = v
	return s
}

// SetPlaybackMode sets the PlaybackMode field's value.
func (s *UpdateChannelOutput) SetPlaybackMode(v string) *UpdateChannelOutput {
	s.PlaybackMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateChannelOutput) SetTags(v map[string]*string) *UpdateChannelOutput {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *UpdateChannelOutput) SetTier(v string) *UpdateChannelOutput {
	s.Tier = &v
	return s
}

// SetTimeShiftConfiguration sets the TimeShiftConfiguration field's value.
func (s *UpdateChannelOutput) SetTimeShiftConfiguration(v *TimeShiftConfiguration) *UpdateChannelOutput {
	s.TimeShiftConfiguration = v
	return s
}

type UpdateLiveSourceInput struct {
	_ struct{} `type:"structure"`

	// A list of HTTP package configurations for the live source on this account.
	//
	// HttpPackageConfigurations is a required field
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list" required:"true"`

	// The name of the live source.
	//
	// LiveSourceName is a required field
	LiveSourceName *string `location:"uri" locationName:"LiveSourceName" type:"string" required:"true"`

	// The name of the source location associated with this Live Source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLiveSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLiveSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLiveSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLiveSourceInput"}
	if s.HttpPackageConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpPackageConfigurations"))
	}
	if s.LiveSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("LiveSourceName"))
	}
	if s.LiveSourceName != nil && len(*s.LiveSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LiveSourceName", 1))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.HttpPackageConfigurations != nil {
		for i, v := range s.HttpPackageConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HttpPackageConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *UpdateLiveSourceInput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *UpdateLiveSourceInput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *UpdateLiveSourceInput) SetLiveSourceName(v string) *UpdateLiveSourceInput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateLiveSourceInput) SetSourceLocationName(v string) *UpdateLiveSourceInput {
	s.SourceLocationName = &v
	return s
}

type UpdateLiveSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with this live source.
	Arn *string `type:"string"`

	// The timestamp that indicates when the live source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// A list of HTTP package configurations for the live source on this account.
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list"`

	// The timestamp that indicates when the live source was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the live source.
	LiveSourceName *string `type:"string"`

	// The name of the source location associated with the live source.
	SourceLocationName *string `type:"string"`

	// The tags to assign to the live source. Tags are key-value pairs that you
	// can associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLiveSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLiveSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateLiveSourceOutput) SetArn(v string) *UpdateLiveSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateLiveSourceOutput) SetCreationTime(v time.Time) *UpdateLiveSourceOutput {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *UpdateLiveSourceOutput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *UpdateLiveSourceOutput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateLiveSourceOutput) SetLastModifiedTime(v time.Time) *UpdateLiveSourceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *UpdateLiveSourceOutput) SetLiveSourceName(v string) *UpdateLiveSourceOutput {
	s.LiveSourceName = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateLiveSourceOutput) SetSourceLocationName(v string) *UpdateLiveSourceOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateLiveSourceOutput) SetTags(v map[string]*string) *UpdateLiveSourceOutput {
	s.Tags = v
	return s
}

type UpdateProgramInput struct {
	_ struct{} `type:"structure"`

	// The ad break configuration settings.
	AdBreaks []*AdBreak `type:"list"`

	// The name of the channel for this Program.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" type:"string" required:"true"`

	// The name of the Program.
	//
	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"ProgramName" type:"string" required:"true"`

	// The schedule configuration settings.
	//
	// ScheduleConfiguration is a required field
	ScheduleConfiguration *UpdateProgramScheduleConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProgramInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}
	if s.ScheduleConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleConfiguration"))
	}
	if s.AdBreaks != nil {
		for i, v := range s.AdBreaks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdBreaks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScheduleConfiguration != nil {
		if err := s.ScheduleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ScheduleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdBreaks sets the AdBreaks field's value.
func (s *UpdateProgramInput) SetAdBreaks(v []*AdBreak) *UpdateProgramInput {
	s.AdBreaks = v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateProgramInput) SetChannelName(v string) *UpdateProgramInput {
	s.ChannelName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *UpdateProgramInput) SetProgramName(v string) *UpdateProgramInput {
	s.ProgramName = &v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *UpdateProgramInput) SetScheduleConfiguration(v *UpdateProgramScheduleConfiguration) *UpdateProgramInput {
	s.ScheduleConfiguration = v
	return s
}

type UpdateProgramOutput struct {
	_ struct{} `type:"structure"`

	// The ad break configuration settings.
	AdBreaks []*AdBreak `type:"list"`

	// The ARN to assign to the program.
	Arn *string `type:"string"`

	// The name to assign to the channel for this program.
	ChannelName *string `type:"string"`

	// The clip range configuration settings.
	ClipRange *ClipRange `type:"structure"`

	// The time the program was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The duration of the live program in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The name of the LiveSource for this Program.
	LiveSourceName *string `type:"string"`

	// The name to assign to this program.
	ProgramName *string `type:"string"`

	// The scheduled start time for this Program.
	ScheduledStartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name to assign to the source location for this program.
	SourceLocationName *string `type:"string"`

	// The name that's used to refer to a VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramOutput) GoString() string {
	return s.String()
}

// SetAdBreaks sets the AdBreaks field's value.
func (s *UpdateProgramOutput) SetAdBreaks(v []*AdBreak) *UpdateProgramOutput {
	s.AdBreaks = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateProgramOutput) SetArn(v string) *UpdateProgramOutput {
	s.Arn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateProgramOutput) SetChannelName(v string) *UpdateProgramOutput {
	s.ChannelName = &v
	return s
}

// SetClipRange sets the ClipRange field's value.
func (s *UpdateProgramOutput) SetClipRange(v *ClipRange) *UpdateProgramOutput {
	s.ClipRange = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateProgramOutput) SetCreationTime(v time.Time) *UpdateProgramOutput {
	s.CreationTime = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *UpdateProgramOutput) SetDurationMillis(v int64) *UpdateProgramOutput {
	s.DurationMillis = &v
	return s
}

// SetLiveSourceName sets the LiveSourceName field's value.
func (s *UpdateProgramOutput) SetLiveSourceName(v string) *UpdateProgramOutput {
	s.LiveSourceName = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *UpdateProgramOutput) SetProgramName(v string) *UpdateProgramOutput {
	s.ProgramName = &v
	return s
}

// SetScheduledStartTime sets the ScheduledStartTime field's value.
func (s *UpdateProgramOutput) SetScheduledStartTime(v time.Time) *UpdateProgramOutput {
	s.ScheduledStartTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateProgramOutput) SetSourceLocationName(v string) *UpdateProgramOutput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *UpdateProgramOutput) SetVodSourceName(v string) *UpdateProgramOutput {
	s.VodSourceName = &v
	return s
}

// Schedule configuration parameters.
type UpdateProgramScheduleConfiguration struct {
	_ struct{} `type:"structure"`

	// Program clip range configuration.
	ClipRange *ClipRange `type:"structure"`

	// Program transition configuration.
	Transition *UpdateProgramTransition `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramScheduleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramScheduleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProgramScheduleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProgramScheduleConfiguration"}
	if s.ClipRange != nil {
		if err := s.ClipRange.Validate(); err != nil {
			invalidParams.AddNested("ClipRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClipRange sets the ClipRange field's value.
func (s *UpdateProgramScheduleConfiguration) SetClipRange(v *ClipRange) *UpdateProgramScheduleConfiguration {
	s.ClipRange = v
	return s
}

// SetTransition sets the Transition field's value.
func (s *UpdateProgramScheduleConfiguration) SetTransition(v *UpdateProgramTransition) *UpdateProgramScheduleConfiguration {
	s.Transition = v
	return s
}

// Program transition configuration.
type UpdateProgramTransition struct {
	_ struct{} `type:"structure"`

	// The duration of the live program in seconds.
	DurationMillis *int64 `type:"long"`

	// The date and time that the program is scheduled to start, in epoch milliseconds.
	ScheduledStartTimeMillis *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProgramTransition) GoString() string {
	return s.String()
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *UpdateProgramTransition) SetDurationMillis(v int64) *UpdateProgramTransition {
	s.DurationMillis = &v
	return s
}

// SetScheduledStartTimeMillis sets the ScheduledStartTimeMillis field's value.
func (s *UpdateProgramTransition) SetScheduledStartTimeMillis(v int64) *UpdateProgramTransition {
	s.ScheduledStartTimeMillis = &v
	return s
}

type UpdateSourceLocationInput struct {
	_ struct{} `type:"structure"`

	// Access configuration parameters. Configures the type of authentication used
	// to access content from your source location.
	AccessConfiguration *AccessConfiguration `type:"structure"`

	// The optional configuration for the host server that serves segments.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration `type:"structure"`

	// The HTTP configuration for the source location.
	//
	// HttpConfiguration is a required field
	HttpConfiguration *HttpConfiguration `type:"structure" required:"true"`

	// A list of the segment delivery configurations associated with this resource.
	SegmentDeliveryConfigurations []*SegmentDeliveryConfiguration `type:"list"`

	// The name of the source location.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSourceLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSourceLocationInput"}
	if s.HttpConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpConfiguration"))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.HttpConfiguration != nil {
		if err := s.HttpConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HttpConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *UpdateSourceLocationInput) SetAccessConfiguration(v *AccessConfiguration) *UpdateSourceLocationInput {
	s.AccessConfiguration = v
	return s
}

// SetDefaultSegmentDeliveryConfiguration sets the DefaultSegmentDeliveryConfiguration field's value.
func (s *UpdateSourceLocationInput) SetDefaultSegmentDeliveryConfiguration(v *DefaultSegmentDeliveryConfiguration) *UpdateSourceLocationInput {
	s.DefaultSegmentDeliveryConfiguration = v
	return s
}

// SetHttpConfiguration sets the HttpConfiguration field's value.
func (s *UpdateSourceLocationInput) SetHttpConfiguration(v *HttpConfiguration) *UpdateSourceLocationInput {
	s.HttpConfiguration = v
	return s
}

// SetSegmentDeliveryConfigurations sets the SegmentDeliveryConfigurations field's value.
func (s *UpdateSourceLocationInput) SetSegmentDeliveryConfigurations(v []*SegmentDeliveryConfiguration) *UpdateSourceLocationInput {
	s.SegmentDeliveryConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateSourceLocationInput) SetSourceLocationName(v string) *UpdateSourceLocationInput {
	s.SourceLocationName = &v
	return s
}

type UpdateSourceLocationOutput struct {
	_ struct{} `type:"structure"`

	// Access configuration parameters. Configures the type of authentication used
	// to access content from your source location.
	AccessConfiguration *AccessConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the source location.
	Arn *string `type:"string"`

	// The timestamp that indicates when the source location was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The optional configuration for the host server that serves segments.
	DefaultSegmentDeliveryConfiguration *DefaultSegmentDeliveryConfiguration `type:"structure"`

	// The HTTP configuration for the source location.
	HttpConfiguration *HttpConfiguration `type:"structure"`

	// The timestamp that indicates when the source location was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The segment delivery configurations for the source location. For information
	// about MediaTailor configurations, see Working with configurations in AWS
	// Elemental MediaTailor (https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html).
	SegmentDeliveryConfigurations []*SegmentDeliveryConfiguration `type:"list"`

	// The name of the source location.
	SourceLocationName *string `type:"string"`

	// The tags to assign to the source location. Tags are key-value pairs that
	// you can associate with Amazon resources to help with organization, access
	// control, and cost tracking. For more information, see Tagging AWS Elemental
	// MediaTailor Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceLocationOutput) GoString() string {
	return s.String()
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *UpdateSourceLocationOutput) SetAccessConfiguration(v *AccessConfiguration) *UpdateSourceLocationOutput {
	s.AccessConfiguration = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateSourceLocationOutput) SetArn(v string) *UpdateSourceLocationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateSourceLocationOutput) SetCreationTime(v time.Time) *UpdateSourceLocationOutput {
	s.CreationTime = &v
	return s
}

// SetDefaultSegmentDeliveryConfiguration sets the DefaultSegmentDeliveryConfiguration field's value.
func (s *UpdateSourceLocationOutput) SetDefaultSegmentDeliveryConfiguration(v *DefaultSegmentDeliveryConfiguration) *UpdateSourceLocationOutput {
	s.DefaultSegmentDeliveryConfiguration = v
	return s
}

// SetHttpConfiguration sets the HttpConfiguration field's value.
func (s *UpdateSourceLocationOutput) SetHttpConfiguration(v *HttpConfiguration) *UpdateSourceLocationOutput {
	s.HttpConfiguration = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateSourceLocationOutput) SetLastModifiedTime(v time.Time) *UpdateSourceLocationOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSegmentDeliveryConfigurations sets the SegmentDeliveryConfigurations field's value.
func (s *UpdateSourceLocationOutput) SetSegmentDeliveryConfigurations(v []*SegmentDeliveryConfiguration) *UpdateSourceLocationOutput {
	s.SegmentDeliveryConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateSourceLocationOutput) SetSourceLocationName(v string) *UpdateSourceLocationOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateSourceLocationOutput) SetTags(v map[string]*string) *UpdateSourceLocationOutput {
	s.Tags = v
	return s
}

type UpdateVodSourceInput struct {
	_ struct{} `type:"structure"`

	// A list of HTTP package configurations for the VOD source on this account.
	//
	// HttpPackageConfigurations is a required field
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list" required:"true"`

	// The name of the source location associated with this VOD Source.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `location:"uri" locationName:"SourceLocationName" type:"string" required:"true"`

	// The name of the VOD source.
	//
	// VodSourceName is a required field
	VodSourceName *string `location:"uri" locationName:"VodSourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVodSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVodSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVodSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVodSourceInput"}
	if s.HttpPackageConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpPackageConfigurations"))
	}
	if s.SourceLocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationName"))
	}
	if s.SourceLocationName != nil && len(*s.SourceLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocationName", 1))
	}
	if s.VodSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VodSourceName"))
	}
	if s.VodSourceName != nil && len(*s.VodSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VodSourceName", 1))
	}
	if s.HttpPackageConfigurations != nil {
		for i, v := range s.HttpPackageConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HttpPackageConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *UpdateVodSourceInput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *UpdateVodSourceInput {
	s.HttpPackageConfigurations = v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateVodSourceInput) SetSourceLocationName(v string) *UpdateVodSourceInput {
	s.SourceLocationName = &v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *UpdateVodSourceInput) SetVodSourceName(v string) *UpdateVodSourceInput {
	s.VodSourceName = &v
	return s
}

type UpdateVodSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the VOD source.
	Arn *string `type:"string"`

	// The timestamp that indicates when the VOD source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// A list of HTTP package configurations for the VOD source on this account.
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list"`

	// The timestamp that indicates when the VOD source was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the source location associated with the VOD source.
	SourceLocationName *string `type:"string"`

	// The tags to assign to the VOD source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the VOD source.
	VodSourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVodSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVodSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateVodSourceOutput) SetArn(v string) *UpdateVodSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateVodSourceOutput) SetCreationTime(v time.Time) *UpdateVodSourceOutput {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *UpdateVodSourceOutput) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *UpdateVodSourceOutput {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVodSourceOutput) SetLastModifiedTime(v time.Time) *UpdateVodSourceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *UpdateVodSourceOutput) SetSourceLocationName(v string) *UpdateVodSourceOutput {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateVodSourceOutput) SetTags(v map[string]*string) *UpdateVodSourceOutput {
	s.Tags = v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *UpdateVodSourceOutput) SetVodSourceName(v string) *UpdateVodSourceOutput {
	s.VodSourceName = &v
	return s
}

// VOD source configuration parameters.
type VodSource struct {
	_ struct{} `type:"structure"`

	// The ARN for the VOD source.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The timestamp that indicates when the VOD source was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The HTTP package configurations for the VOD source.
	//
	// HttpPackageConfigurations is a required field
	HttpPackageConfigurations []*HttpPackageConfiguration `type:"list" required:"true"`

	// The timestamp that indicates when the VOD source was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the source location that the VOD source is associated with.
	//
	// SourceLocationName is a required field
	SourceLocationName *string `type:"string" required:"true"`

	// The tags assigned to the VOD source. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control,
	// and cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the VOD source.
	//
	// VodSourceName is a required field
	VodSourceName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VodSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VodSource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VodSource) SetArn(v string) *VodSource {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *VodSource) SetCreationTime(v time.Time) *VodSource {
	s.CreationTime = &v
	return s
}

// SetHttpPackageConfigurations sets the HttpPackageConfigurations field's value.
func (s *VodSource) SetHttpPackageConfigurations(v []*HttpPackageConfiguration) *VodSource {
	s.HttpPackageConfigurations = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VodSource) SetLastModifiedTime(v time.Time) *VodSource {
	s.LastModifiedTime = &v
	return s
}

// SetSourceLocationName sets the SourceLocationName field's value.
func (s *VodSource) SetSourceLocationName(v string) *VodSource {
	s.SourceLocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *VodSource) SetTags(v map[string]*string) *VodSource {
	s.Tags = v
	return s
}

// SetVodSourceName sets the VodSourceName field's value.
func (s *VodSource) SetVodSourceName(v string) *VodSource {
	s.VodSourceName = &v
	return s
}

const (
	// AccessTypeS3Sigv4 is a AccessType enum value
	AccessTypeS3Sigv4 = "S3_SIGV4"

	// AccessTypeSecretsManagerAccessToken is a AccessType enum value
	AccessTypeSecretsManagerAccessToken = "SECRETS_MANAGER_ACCESS_TOKEN"

	// AccessTypeAutodetectSigv4 is a AccessType enum value
	AccessTypeAutodetectSigv4 = "AUTODETECT_SIGV4"
)

// AccessType_Values returns all elements of the AccessType enum
func AccessType_Values() []string {
	return []string{
		AccessTypeS3Sigv4,
		AccessTypeSecretsManagerAccessToken,
		AccessTypeAutodetectSigv4,
	}
}

const (
	// AdMarkupTypeDaterange is a AdMarkupType enum value
	AdMarkupTypeDaterange = "DATERANGE"

	// AdMarkupTypeScte35Enhanced is a AdMarkupType enum value
	AdMarkupTypeScte35Enhanced = "SCTE35_ENHANCED"
)

// AdMarkupType_Values returns all elements of the AdMarkupType enum
func AdMarkupType_Values() []string {
	return []string{
		AdMarkupTypeDaterange,
		AdMarkupTypeScte35Enhanced,
	}
}

const (
	// AlertCategorySchedulingError is a AlertCategory enum value
	AlertCategorySchedulingError = "SCHEDULING_ERROR"

	// AlertCategoryPlaybackWarning is a AlertCategory enum value
	AlertCategoryPlaybackWarning = "PLAYBACK_WARNING"

	// AlertCategoryInfo is a AlertCategory enum value
	AlertCategoryInfo = "INFO"
)

// AlertCategory_Values returns all elements of the AlertCategory enum
func AlertCategory_Values() []string {
	return []string{
		AlertCategorySchedulingError,
		AlertCategoryPlaybackWarning,
		AlertCategoryInfo,
	}
}

const (
	// ChannelStateRunning is a ChannelState enum value
	ChannelStateRunning = "RUNNING"

	// ChannelStateStopped is a ChannelState enum value
	ChannelStateStopped = "STOPPED"
)

// ChannelState_Values returns all elements of the ChannelState enum
func ChannelState_Values() []string {
	return []string{
		ChannelStateRunning,
		ChannelStateStopped,
	}
}

const (
	// FillPolicyFullAvailOnly is a FillPolicy enum value
	FillPolicyFullAvailOnly = "FULL_AVAIL_ONLY"

	// FillPolicyPartialAvail is a FillPolicy enum value
	FillPolicyPartialAvail = "PARTIAL_AVAIL"
)

// FillPolicy_Values returns all elements of the FillPolicy enum
func FillPolicy_Values() []string {
	return []string{
		FillPolicyFullAvailOnly,
		FillPolicyPartialAvail,
	}
}

const (
	// LogTypeAsRun is a LogType enum value
	LogTypeAsRun = "AS_RUN"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeAsRun,
	}
}

const (
	// MessageTypeSpliceInsert is a MessageType enum value
	MessageTypeSpliceInsert = "SPLICE_INSERT"

	// MessageTypeTimeSignal is a MessageType enum value
	MessageTypeTimeSignal = "TIME_SIGNAL"
)

// MessageType_Values returns all elements of the MessageType enum
func MessageType_Values() []string {
	return []string{
		MessageTypeSpliceInsert,
		MessageTypeTimeSignal,
	}
}

const (
	// ModeOff is a Mode enum value
	ModeOff = "OFF"

	// ModeBehindLiveEdge is a Mode enum value
	ModeBehindLiveEdge = "BEHIND_LIVE_EDGE"

	// ModeAfterLiveEdge is a Mode enum value
	ModeAfterLiveEdge = "AFTER_LIVE_EDGE"
)

// Mode_Values returns all elements of the Mode enum
func Mode_Values() []string {
	return []string{
		ModeOff,
		ModeBehindLiveEdge,
		ModeAfterLiveEdge,
	}
}

const (
	// OperatorEquals is a Operator enum value
	OperatorEquals = "EQUALS"
)

// Operator_Values returns all elements of the Operator enum
func Operator_Values() []string {
	return []string{
		OperatorEquals,
	}
}

const (
	// OriginManifestTypeSinglePeriod is a OriginManifestType enum value
	OriginManifestTypeSinglePeriod = "SINGLE_PERIOD"

	// OriginManifestTypeMultiPeriod is a OriginManifestType enum value
	OriginManifestTypeMultiPeriod = "MULTI_PERIOD"
)

// OriginManifestType_Values returns all elements of the OriginManifestType enum
func OriginManifestType_Values() []string {
	return []string{
		OriginManifestTypeSinglePeriod,
		OriginManifestTypeMultiPeriod,
	}
}

const (
	// PlaybackModeLoop is a PlaybackMode enum value
	PlaybackModeLoop = "LOOP"

	// PlaybackModeLinear is a PlaybackMode enum value
	PlaybackModeLinear = "LINEAR"
)

// PlaybackMode_Values returns all elements of the PlaybackMode enum
func PlaybackMode_Values() []string {
	return []string{
		PlaybackModeLoop,
		PlaybackModeLinear,
	}
}

const (
	// RelativePositionBeforeProgram is a RelativePosition enum value
	RelativePositionBeforeProgram = "BEFORE_PROGRAM"

	// RelativePositionAfterProgram is a RelativePosition enum value
	RelativePositionAfterProgram = "AFTER_PROGRAM"
)

// RelativePosition_Values returns all elements of the RelativePosition enum
func RelativePosition_Values() []string {
	return []string{
		RelativePositionBeforeProgram,
		RelativePositionAfterProgram,
	}
}

const (
	// ScheduleEntryTypeProgram is a ScheduleEntryType enum value
	ScheduleEntryTypeProgram = "PROGRAM"

	// ScheduleEntryTypeFillerSlate is a ScheduleEntryType enum value
	ScheduleEntryTypeFillerSlate = "FILLER_SLATE"
)

// ScheduleEntryType_Values returns all elements of the ScheduleEntryType enum
func ScheduleEntryType_Values() []string {
	return []string{
		ScheduleEntryTypeProgram,
		ScheduleEntryTypeFillerSlate,
	}
}

const (
	// TierBasic is a Tier enum value
	TierBasic = "BASIC"

	// TierStandard is a Tier enum value
	TierStandard = "STANDARD"
)

// Tier_Values returns all elements of the Tier enum
func Tier_Values() []string {
	return []string{
		TierBasic,
		TierStandard,
	}
}

const (
	// TypeDash is a Type enum value
	TypeDash = "DASH"

	// TypeHls is a Type enum value
	TypeHls = "HLS"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeDash,
		TypeHls,
	}
}
