/***************************************************************************
                           main.c  -  description
                             -------------------
    begin                : Mon Oct 28 00:00:00 EEST 2002
    copyright            : (C) 2002 Markus Kettunen
    email                : makegho@mbnet.fi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SDL.h"

#ifndef WIN32
	#include <unistd.h>
	#include <dirent.h>
#else
	#include <io.h>
	#include <windows.h>
	#define Uint8 unsigned char
#endif

#define fps 50
#define pi 3.14159265358979

#define midposx 310
#define midposy 337

  SDL_Surface *back;
  SDL_Surface *TMP;
  SDL_Surface *numv;
  SDL_Surface *font;
  SDL_Surface *font2;
  SDL_Surface *screen;
  SDL_Surface *blobtrox;
  SDL_Surface *blursurface;
  SDL_Surface *blursurface2;
  SDL_Surface *blobsmall;
  SDL_Surface *target;
  SDL_Surface *sprites;
  SDL_Surface *sprites2;
  SDL_Surface *gameover;
  SDL_Surface *menuback;
  SDL_Surface *newgame;
  SDL_Surface *quitgame;
  SDL_Surface *betna;

  SDL_Event event;


// long status[3][10];
				

struct dirent *currentfile;




  Uint8* keys;
  Uint32 oldtime;
  Uint32 newtime;
  Uint32 frames;
  Uint32 stime;


  long decorused;

  int gametype=0;

  int mypos=0;
  int mxpos=0;

int exittexts()
{
#ifndef WIN32
  fprintf (stderr, "Comments to: Blobtrox@sunpoint.net\n");
  fprintf(stderr, "\nBetna\n");
#endif
  
  SDL_FreeSurface (back);
  SDL_FreeSurface (font);
  SDL_FreeSurface (blobtrox);
  SDL_FreeSurface (blursurface);
  SDL_FreeSurface (blursurface2);
  SDL_FreeSurface (blobsmall);
  SDL_FreeSurface (target);
  exit (1);
}

void emergencyexit()
{
	fprintf (stderr, "Quitting program... \n");
	exittexts();
	exit (1);
}

void Slock(SDL_Surface *screen)
{
	if ( SDL_MUSTLOCK(screen) )
		{
		if ( SDL_LockSurface(screen) < 0 )
			{
			return;
			}
		}
}

void Sulock(SDL_Surface *screen)
{
	if ( SDL_MUSTLOCK(screen) )
		{
		SDL_UnlockSurface(screen);
		}
}

void DrawPixel (SDL_Surface *screen, int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
  Uint32 color = SDL_MapRGB(screen->format, R, G, B);
  Uint32 *bufp;
  bufp = (Uint32 *)screen->pixels + y*screen->pitch/4+x;
  *bufp = color;
}

void DrawPartOfIMG(SDL_Surface *img, SDL_Surface *screen, int x, int y, int w, int h, int x2, int y2)
{
SDL_Rect dest;
SDL_Rect dest2;
dest.x = x;
dest.y = y;
dest2.x = x2;
dest2.y = y2;
dest2.w = w;
dest2.h = h;
SDL_BlitSurface(img, &dest2, screen, &dest);
}

int DrawIMG(SDL_Surface *screen, SDL_Surface *img, int x, int y)
{
	SDL_Rect dest;
	dest.x = x;
	dest.y = y;
	SDL_BlitSurface(img, NULL, screen, &dest);
	return 0;
}


void line (SDL_Surface *screen, int x0, int y0, int x1, int y1, Uint8 R, Uint8 G, Uint8 B)
    {
        int dy;
        int dx;
        int stepx, stepy;
	int fraction;

 	dy = y1 - y0;
	dx = x1 - x0;

        if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }
        dy <<= 1;                                                  // dy is now 2*dy
        dx <<= 1;                                                  // dx is now 2*dx

	if (x0 >= 0 && x0 <= 639 && y0 >= 0 && y0 <= 479) DrawPixel(screen, x0, y0, R, G, B);
        if (dx > dy) {
            fraction = dy - (dx >> 1);                         // same as 2*dy - dx
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;                                // same as fraction -= 2*dx
                }
                x0 += stepx;
                fraction += dy;                                    // same as fraction -= 2*dy
		if (x0 >= 0 && x0 <= 639 && y0 >= 0 && y0 <= 479) DrawPixel(screen, x0, y0, R, G, B);
            }
        } else {
            fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                y0 += stepy;
                fraction += dx;
		if (x0 >= 0 && x0 <= 639 && y0 >= 0 && y0 <= 479) DrawPixel(screen, x0, y0, R, G, B);
            }
        }
    }

int InitImages()
{
	back = SDL_LoadBMP("images/back.bmp");

	font2 = SDL_LoadBMP("images/font.bmp");
	font = SDL_CreateRGBSurface(SDL_SWSURFACE, 1288, 100, 32, 0xFF000000, 0x00FF0000, 0x0000FF00, 0x000000FF);
	SDL_SetColorKey(font, SDL_SRCCOLORKEY, SDL_MapRGB(font->format, 0x00, 0x00, 0x00));
	DrawIMG (font, font2, 0, 0);

	sprites = SDL_LoadBMP("images/sprites.bmp");
	SDL_SetColorKey(sprites, SDL_SRCCOLORKEY, SDL_MapRGB(sprites->format, 0xFF, 0xFF, 0xFF));
	sprites2 = SDL_LoadBMP("images/sprites2.bmp");

    gameover = SDL_LoadBMP("images/gameover.bmp");
	target = SDL_LoadBMP("images/target.bmp");
	blobtrox = SDL_LoadBMP("images/blobtrox.bmp");
	blobsmall= SDL_LoadBMP("images/blobsmall.bmp");
	newgame= SDL_LoadBMP("images/newgame.bmp");
	quitgame=SDL_LoadBMP("images/quitgame.bmp");
	betna =  SDL_LoadBMP("images/betna.bmp");
	SDL_SetColorKey(newgame, SDL_SRCCOLORKEY, SDL_MapRGB(newgame->format, 0xFF, 0xFF, 0xFF));
	SDL_SetColorKey(quitgame, SDL_SRCCOLORKEY, SDL_MapRGB(quitgame->format, 0xFF, 0xFF, 0xFF));
	SDL_SetColorKey(betna, SDL_SRCCOLORKEY, SDL_MapRGB(betna->format, 0xFF, 0x00, 0x00));

	blursurface = SDL_CreateRGBSurface(SDL_SWSURFACE, 640, 480, 32, 0x00000000, 0x00000000, 0x00000000, 0x00000000);
	blursurface2 = SDL_CreateRGBSurface(SDL_SWSURFACE, 640, 480, 32, 0x00000000, 0x00000000, 0x00000000, 0x00000000);
	menuback = SDL_CreateRGBSurface(SDL_SWSURFACE, 1280, 960, 32, 0x00000000, 0x00000000, 0x000000000, 0x00000000);
	return 0;
}

int chkkeys()
{
int enter=0;
	while ( SDL_PollEvent(&event) )
		{
			if ( event.type == SDL_QUIT ) emergencyexit();
			if ( event.type == SDL_KEYDOWN )
			{
				if ( event.key.keysym.sym == SDLK_KP_ENTER || event.key.keysym.sym == SDLK_SPACE
						|| event.key.keysym.sym == SDLK_RETURN) enter=1;
				if ( event.key.keysym.sym == SDLK_ESCAPE) enter=2;
			}
		}
	return enter;
}

int fadein(SDL_Surface *screen, SDL_Surface *blursurface)
{
  int x,y,skpd;
  int bpp = screen->format->BytesPerPixel;
  Uint16 blurpitch = (Uint16)blursurface->pitch;
  Uint32 stime, etime;
  Uint32 i;
  i=1;
  stime=SDL_GetTicks();
	while (i>0 && i<34)
		{
				for (y=0;y<480;y++)
				{
					for (x=0;x<640;x++)
						{
								Uint8 *p = (Uint8 *)blursurface->pixels + y * blurpitch + (x*bpp) ;
								Uint32 *bufp = (Uint32 *)screen->pixels + y*blurpitch/4+x;
								*bufp = (int)( (p[0]*i>>5) ) + (int)( (p[1]*i>>5)<<8 ) + (int)( (p[2]*i>>5)<<16);
						}
				}
			SDL_Flip(screen);
			skpd=chkkeys();
			etime=SDL_GetTicks();
			i = 32-(int)((stime+1000-etime)*32/1000);
		}
  return skpd;
}

int fadeout(SDL_Surface *screen, SDL_Surface *blursurface)
{
  int x,y,skpd;
  int bpp = screen->format->BytesPerPixel;
  Uint16 blurpitch = (Uint16)blursurface->pitch;
  Uint32 stime, etime;
  Uint32 i;
  i=32;
  stime=SDL_GetTicks();
	while (i>0 && i<34)
		{
				for (y=0;y<480;y++)
				{
					for (x=0;x<640;x++)
						{
								Uint8 *p = (Uint8 *)blursurface->pixels + y * blurpitch + (x*bpp);
								Uint32 *bufp = (Uint32 *)screen->pixels + y*blurpitch/4+x;
								*bufp = (int)( (p[0]*i>>5) ) + (int)( (p[1]*i>>5)<<8 ) + (int)( (p[2]*i>>5)<<16);
						}
				}
			SDL_Flip(screen);
			skpd=chkkeys();
			etime=SDL_GetTicks();
			i = (int)((stime+1000-etime)*32/1000);

		}
  return skpd;
}

int crossfade (SDL_Surface *screen, SDL_Surface *tmp1, SDL_Surface *tmp2)
{
  int x,y,j,skpd;
  Uint16 blurpitch = (Uint16)blursurface->pitch;
  Uint32 stime, etime, i;
  int bpp1 = tmp1->format->BytesPerPixel;
  int bpp2 = tmp2->format->BytesPerPixel;

  stime=SDL_GetTicks();
	i=32;
	while(i>0 && i < 40) //for (i=32;i>=1;i--)
		{
			SDL_Flip (screen);
			skpd=chkkeys();
			for (y=0;y<480;y++)
				{
					for (x=0;x<640;x++)
						{
							Uint8 *p1 = (Uint8 *)tmp1->pixels + y * blurpitch+x*bpp1;
							Uint8 *p2 = (Uint8 *)tmp2->pixels + y * blurpitch+x*bpp2;
							Uint32 *bufp = (Uint32 *)screen->pixels + y*blurpitch/4+x;
							j=32-i;
							*bufp = (int)( (p1[0]*i>>5) ) + ((p1[1]*i>>5)<<8) + ( (p1[2]*i>>5)<<16) +
									(( (p2[0]*j>>5) ) + ( (p2[1]*j>>5)<<8 ) + ( (p2[2]*j>>5)<<16));
						}
				}
			etime=SDL_GetTicks();
			i=(int)( 				(stime+1000-etime) *32/1000);
		}
  DrawIMG(screen, tmp2, 0, 0);
  SDL_Flip(screen);
  return skpd;
}

Uint32 rgb(Uint8 r, Uint8 g, Uint8 b)
{
	return (b)+(g<<8)+(r<<16);
}








void blobprintf(SDL_Surface *screen, char msg[60], int x, int y, Uint8 r, Uint8 g, Uint8 b, int effect)
{
int str, cpx, fx, fy, px, py;
Uint32 fpitch = (Uint16)font->pitch;
	for (str=0;msg[str];str++)
		{
			cpx = str*18;
			fx = (msg[str]-33)*28;
			fy = 0;
			while (fx>=1286)
				{
					fx-=1286;
					fy+=32;
				}
			if (msg[str]!=' ')
				{
					for (px=0; px<=27;px++)
						for (py=0;py<32;py++)
							{
								Uint8 *p = (Uint8 *)font->pixels + (fy+py) * fpitch + ((px+fx)<<2);
								if (effect==0 || effect >= 31337)
									{
										Uint32 *bufp = (Uint32 *)screen->pixels + (y+py) * screen->pitch/4+(px+x+cpx);
										if (effect==31337)
											{
												Uint32 col;
												col=(int)(fabs(255/pi*atan2(strlen(msg)*9-px, 16-py)));
												r=col; g=col;
												b=col;
											}
										if ( rgb(p[3],p[2],p[1]) != 0) *bufp = rgb(r, g, b);

									}
								if (effect>0 && effect < 31337)
									{
										Uint32 *bufp = (Uint32 *)screen->pixels + (y+py) * screen->pitch/4+(px+x+cpx);
										Uint8 *p2 = (Uint8 *)blursurface->pixels + (y+py) *
											blursurface->pitch + ((px+x+cpx)<<2);
										Uint16 r2 = (p2[2]+effect);
										Uint16 g2 = (p2[1]+effect);
										Uint16 b2 = (p2[0]+effect);
										if (r2 > 255) r2=255;
										if (g2 > 255) g2=255;
										if (b2 > 255) b2=255;
										if (p[2]!=0) *bufp = rgb((Uint8)r2,(Uint8)g2,(Uint8)b2);
									}
							}
				}
		}
}




void blur(SDL_Surface *screen, SDL_Surface *blursurface, int x1, int y1, int x2, int y2)
{
int x, y, xx, yy;
Uint32 r, g, b;
int range=1;
int colors;

	DrawPartOfIMG(screen, blursurface, x1-range, y1-range, x2-x1+(range<<1), y2-y1+(range<<1), x1-range, y1-range);

	for (y=y1; y<=y2; y++)
		for (x=x1; x<=x2; x++)
			{
				r=0;
				g=0;
				b=0;
				colors=0;
				for (yy=-range;yy<=range;yy++)
					for (xx=-range;xx<=range;xx++)
						{
									Uint8 *p = (Uint8 *)blursurface->pixels + (y+yy) * blursurface->pitch + ((x+xx)<<2);
									colors++;
									r+=p[0];
									g+=p[1];
									b+=p[2];
						}
				r/=colors;
				g/=colors;
				b/=colors;
				Uint32 *bufp = (Uint32 *)screen->pixels + (y) * screen->pitch/4+(x);
				*bufp=(b<<16)+(g<<8)+(r);
			}
}

void box(SDL_Surface *screen, int x, int y, int x2, int y2, Uint8 R, Uint8 G, Uint8 B)
{
	line (screen, x,   y,  x2,   y,   R, G, B);
	line (screen, x,   y,   x,  y2,   R, G, B);
	line (screen, x,  y2,  x2,  y2,   R, G, B);
	line (screen, x2,  y,  x2,  y2,   R, G, B);
}

void DrawCursor(int x, int y, int draw)
{
int x0, y0;
if (draw==1)
		for (y0=y-15; y0<=y+15; y0++)
			for (x0=x-15;x0<=x+15;x0++)
				if (x0 >= 0 && x0 <= 639 && y0 >= 0 && y0 <= 479)
					{
						Uint8 *p = (Uint8 *)blursurface2->pixels + (int)y0 * blursurface2->pitch + (x0<<2);
						Uint8 *p1 = (Uint8 *)target->pixels + (y0-y+15) * target->pitch + ((x0-x+15)*3);
						Uint32 b=(int)( p[2] + p1[2] );
						Uint32 g=(int)( p[1] + p1[1] );
						Uint32 r=(int)( p[0] + p1[0] );
						if (r>255) r=255;
						if (g>255) g=255;
						if (b>255) b=255;
						Uint32 *bufp = (Uint32 *)screen->pixels + (int)y0 * screen->pitch/4 + (int)x0;
						if (!(p[2]==b && p[1]==g && p[0]==r)) *bufp= r+(g<<8)+(b<<16);
					}
if (draw==0)
		for (y0=y-15; y0<=y+15; y0++)
			for (x0=x-15;x0<=x+15;x0++)
				if (x0 >= 0 && x0 <= 639 && y0 >= 0 && y0 <= 479)
					{
						Uint8 *p = (Uint8 *)blursurface2->pixels + (int)y0 * blursurface2->pitch + (x0<<2);
						Uint32 b=(int)( p[2] );
						Uint32 g=(int)( p[1] );
						Uint32 r=(int)( p[0] );
						Uint32 *bufp = (Uint32 *)screen->pixels + (int)y0 * screen->pitch/4 + (int)x0;
						*bufp= r+(g<<8)+(b<<16);
					}
}

void DrawSprite(int num, int x, int y)
{
int vx, vy, xx, yy;
  if (num>0)
		{
			vx=num*26;
			vy=0;
			for (yy=0;yy<11;yy++)
				{
					for (xx=0;xx<23;xx++)
						{
							Uint8 *p = (Uint8 *)sprites->pixels + (int)(vy+yy) * sprites->pitch + ((vx+xx)*sprites->format->BytesPerPixel);
							Uint32 *bufp = (Uint32 *)screen->pixels + (int)(yy+y) * screen->pitch/4 + (int)(xx+x);
							if (! (p[0]==255 && p[1]==255 && p[2]==255) )
								if (x+xx >= 0 && x+xx <= 639 && y+yy >=0 && y+yy <=479) *bufp= p[0]+(p[1]<<8)+(p[2]<<16);
						}
				}
		}
  else
		{
			vx=abs(num)*26;
			vy=0;
			for (yy=0;yy<11;yy++)
				{
					for (xx=0;xx<23;xx++)
						{
							Uint8 *p = (Uint8 *)sprites->pixels + (int)(vy+yy) * sprites->pitch + ((vx+22-xx)*sprites->format->BytesPerPixel);
							Uint32 *bufp = (Uint32 *)screen->pixels + (int)(yy+y) * screen->pitch/4 + (int)(xx+x);
							if (! (p[0]==255 && p[1]==255 && p[2]==255) )
								if (x+xx >= 0 && x+xx <= 639 && y+yy >=0 && y+yy <=479) *bufp= p[0]+(p[1]<<8)+(p[2]<<16);
						}
				}
		}
}

void DrawSprite2(int num, int x, int y)
{
int vx, vy, xx, yy, ax, ay;
  if (num==0)
		{
			vx=0; vy=0;	ax=-14;	ay=-14;
			for (yy=0;yy<28;yy++)
				{
					for (xx=0;xx<30;xx++)
						{
							Uint8 *p = (Uint8 *)sprites2->pixels + (int)(vy+yy) * sprites2->pitch + ((vx+xx)*sprites2->format->BytesPerPixel);
							Uint8 *p2 = (Uint8 *)screen->pixels + (int)(y+yy+ax) * screen->pitch + ((x+xx+ay)<<2);
							Uint32 *bufp = (Uint32 *)screen->pixels + (int)(yy+y+ax) * screen->pitch/4 + (int)(xx+x+ay);
							if (! (p[0]==0 || p[1]==0 || p[2]==0) )
								if (x+xx+ax >= 0 && x+xx+ax <= 639 && y+yy+ay >=0 && y+yy+ay <=479)
									{
										Uint16 r, g, b;
										if (p2[2]-p[2]<0) r=0;
												else r=p2[2]-p[2];
										if (p2[1]-p[1]<0) g=0;
												else g=p2[1]-p[1];
										if (p2[0]-p[0]<0) b=0;
												else b=p2[0]-p[0];
										*bufp= b+(g<<8)+(r<<16);
									}
						}
				}
		}
  if (num==1)
		{
			vx=30; vy=0; ax=-7;	ay=-5;
			for (yy=0;yy<=10;yy++)
				{
					for (xx=0;xx<15;xx++)
						{
							Uint8 *p = (Uint8 *)sprites2->pixels + (int)(vy+yy) * sprites2->pitch + ((vx+xx)*sprites2->format->BytesPerPixel);
							Uint32 *bufp = (Uint32 *)screen->pixels + (int)(yy+y+ax) * screen->pitch/4 + (int)(xx+x+ay);
							if (! (p[0]==0 || p[1]==0 || p[2]==0) )
								if (x+xx+ax >= 0 && x+xx+ax <= 639 && y+yy+ay >=0 && y+yy+ay <=479)
									{
										Uint8 r, g, b;
										r=p[2];
										g=p[1];
										b=p[0];
										*bufp= b+(g<<8)+(r<<16);
									}
						}
				}
		}

}

void game_over(int score)
{
int x, y;
	for (y=0;y<480;y++)
		for (x=0;x<640;x++)
			{
				Uint32 *bufp = (Uint32 *)screen->pixels + y * ((screen->pitch)>>2) + x;
				*bufp = 0;
			}
	DrawIMG (screen, gameover, 38, 178);

    char text[100];
	sprintf (text, "Your score was: %d", score);
	blobprintf (screen, text, 30, 30, 190, 190, 190, 0);
	SDL_Flip(screen);
	while (chkkeys()==0) SDL_Delay(10);
}

typedef struct
{
double x;
double y;
double xvel;
double yvel;
int type;
int energy;
} s_enemy;

typedef struct
{
double x;
double y;
double xvel;
double yvel;
int type;
int lifetime;
} s_magma;

typedef struct
{
int energy;
int score;
int power;
} s_player;

typedef struct
{
int b1;
int b2;
int b3;
} s_clicked;

void resetstructs (s_enemy enemy[50], s_magma magma[1050], s_player player, s_clicked clicked)
{
int i;
  for (i=0;i<500;i++)
		{
			enemy[i].x=0;		enemy[i].y=0;		enemy[i].xvel=0;		enemy[i].xvel=0;		enemy[i].type=0;		enemy[i].energy=0;
		}
  for (i=0;i<1500;i++)
		{
			magma[i].x=0;		magma[i].y=0;		magma[i].xvel=0;		magma[i].yvel=0;		magma[i].type=0;		magma[i].lifetime=0;
		}
  player.score=0;
  player.energy=100;
  player.power=0;
  clicked.b1=0;
  clicked.b2=0;
  clicked.b3=0;
}

void LaunchMagma(int type, int *magmaused, s_magma magma[1500])
{
char found=false;
int i;
	for (i=0; (i<1500 && !found); i++)
		{
			if (magma[i].x==0)
				{
					magma[i].x=midposx;
					magma[i].y=midposy;
					if (type==0)
						{
							magma[i].xvel=(mxpos-midposx)/100.0;		//sin(kulma)*2;
							magma[i].yvel=(mypos-midposy)/100.0;		//cos(kulma)*2;
						}
					if (type==1)
						{
							magma[i].xvel= -1+rand()/((RAND_MAX/2.0+1.0));
							magma[i].yvel= -(rand()/((RAND_MAX/4.0+1.0)));
							magma[i].lifetime= 100+(int)(rand()/((RAND_MAX/100.0+1.0)));
						}
					if (type==2)
						{
							double kulma=atan2(mxpos-midposx, mypos-midposy);
							magma[i].xvel=sin(kulma)*3;
							magma[i].yvel=cos(kulma)*3;
						}
					if (type==3)
						{
							magma[i].xvel= -1+rand()/((RAND_MAX/2.0+1.0));
							magma[i].yvel= -(rand()/((RAND_MAX/4.0+1.0)));
						}
					magma[i].type=type;
					found=true;
					if (i>*magmaused) *magmaused=i;
				}
		}
}

void createmuurahainen(s_enemy enemy[500], int &enemyused)
{
char found=false;
int i;
	for (i=0; (i<500 && found==false); i++)
		{
			if (enemy[i].energy==0)
				{
					enemy[i].y=midposy+40;
					enemy[i].yvel=0;
					if (rand()/((RAND_MAX/2)+1)==0)
						{
							enemy[i].x=1;
							enemy[i].xvel=1.0;
						}
					else
						{
							enemy[i].x=639-22;
							enemy[i].xvel=-1.0;
						}
					enemy[i].energy=1;
					found=true;
					if (i>enemyused) enemyused=i;
				}
		}	
}

bool level(int *number, int roundselapsed, s_enemy enemy[50], s_player player, int *enemyused, int time)
{
if (*number==1)
	{
		if (roundselapsed>=time)
			{
				createmuurahainen (enemy, *enemyused);
				return 1;
			}
	}
	return 0;
}

void MainLoop(SDL_Surface *screen)
{
  int i, j;
  int magmaslow=0, enemyslow=0;
  s_magma magma[1500];
  s_enemy enemy[500];
  s_player player;
  s_clicked clicked;
  player.energy = 0;
  player.power = 0;
  player.score = 0;
  clicked.b1 = 0;
  clicked.b2 = 0;
  clicked.b3 = 0;
  int magmaused=0, enemyused=0;
  bool shifted=false, found=false;
  Uint32 stime, etime;

  resetstructs(enemy, magma, player, clicked);
  SDL_ShowCursor(0);
  char ready=0;
  player.energy=100;
  player.power=100;
  int time=1;
  int time2=100;
  int levnum=1;
  int roundselapsed=0;
  int prwait=0;

  while (ready<2)
	{
		stime=SDL_GetTicks();
		ready=chkkeys();

		prwait++;
		if (prwait>=100)
			{
				prwait=0;
				if (player.energy<100)
					{
						player.energy++;
						player.score--;
					}
				else
					player.score++;
				if (time2>5)time2--;
			}

		roundselapsed++;
		if (level(&levnum, roundselapsed, enemy, player, &enemyused, time)==1)
			{
				time+=time2;
			}

		SDL_GetMouseState(&mxpos, &mypos);

		double xeta=(mxpos-midposx);
		double yeta=(mypos-185);

		double langle = atan2(xeta, yeta);
		xeta=fabs(xeta);
		yeta=fabs(yeta);

		double lrange = sqrt(xeta*xeta + yeta*yeta);
		if (lrange > 155)
			{
				mxpos=(int)(midposx+sin(langle)*155);
				mypos=(int)(185+cos(langle)*155);
				SDL_WarpMouse(mxpos, mypos);
			}

		if (magmaslow>0) magmaslow--;
		if (enemyslow>0) enemyslow--;
		if (player.power<100) player.power++;

		keys = SDL_GetKeyState(NULL);
		if (!(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(1)) && !keys[SDLK_z]) clicked.b1=false;
		if (!(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(2)) && !keys[SDLK_c]) clicked.b2=false;
		if (!(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(3)) && !keys[SDLK_x]) clicked.b3=false;

		if ((SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(3) || keys[SDLK_x]) && !clicked.b3 && player.power>=10)
			{
				clicked.b3=true;
				LaunchMagma(0, &magmaused, magma);
				for (i=0; i<10;i++)
					LaunchMagma(1, &magmaused, magma);
				player.power-=10;
			}

		if ((SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(2) || keys[SDLK_c])&& !clicked.b2 && player.power>=10)
			{
				clicked.b2=true;
				for (i=0; i<10; i++)
							if (player.power>=10)
								{
									LaunchMagma(3, &magmaused, magma);
									for (j=0;j<5;j++) LaunchMagma(1, &magmaused, magma);
									player.power-=10;
								}
			}

		if ((SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(1) || keys[SDLK_z])&& !clicked.b1 && player.power>=30)
			{
				clicked.b1=true;
				LaunchMagma(2, &magmaused, magma);
				for (i=0; i<10;i++)
					LaunchMagma(1, &magmaused, magma);
				player.power-=30;
			}

		for (i=0; i<enemyused; i++)
			{
				if (enemy[i].energy>0)
					{
						DrawPartOfIMG(blursurface2, screen, (int)enemy[i].x, (int)enemy[i].y, 24, 12, (int)enemy[i].x, (int)enemy[i].y);
						enemy[i].x+=enemy[i].xvel;
						enemy[i].y+=enemy[i].yvel;
						for (j=0; j<magmaused; j++)
							{
								if (magma[j].type!=1 && magma[j].x!=0 &&
										magma[j].x+15>=enemy[i].x  &&   magma[j].x <=enemy[i].x+23 &&
											magma[j].y+10 >= enemy[i].y && magma[j].y <= enemy[i].y+10)
									{
										DrawPartOfIMG(blursurface2, screen, (int)magma[j].x-7,(int)magma[j].y-7, 18, 15,
												(int)magma[j].x-7, (int)magma[j].y-7);
										enemy[i].energy=0;
										magma[j].x=0;
										player.score+=10;
									}
							}
						if (enemy[i].x>300-62 && enemy[i].x<340)
							{
								player.energy-=20;
								enemy[i].energy=0;
							}
						else
							{
									if (enemy[i].energy!=0)
										{
											if (enemy[i].xvel >0) DrawSprite((1+(int)(enemy[i].x/3)%3), (int)enemy[i].x, (int)enemy[i].y );
											else DrawSprite((-1-(int)(enemy[i].x/3)%3),(int)enemy[i].x, (int)enemy[i].y);
										}
							}
					}
			}


		for (i=0; i<magmaused; i++)
			{
				if (magma[i].x >0 && magma[i].x<=639 && magma[i].y >=0 && magma[i].y<=479)
					{
						if (magma[i].type==1 && magma[i].lifetime>0) DrawPartOfIMG(blursurface2, screen, (int)magma[i].x-16, (int)magma[i].y-15,
							32, 30, (int)magma[i].x-16, (int)magma[i].y-15);
					
						if (magma[i].type==0 || magma[i].type==2 || magma[i].type==3) DrawPartOfIMG(blursurface2, screen, (int)magma[i].x-7,
							(int)magma[i].y-7, 18, 15, (int)magma[i].x-7, (int)magma[i].y-7);
					}
			}
		for (i=0; i<magmaused; i++)
			{
				if (magma[i].x!=0)
					{
						magma[i].lifetime-=1;
						magma[i].x+=magma[i].xvel;
						magma[i].y+=magma[i].yvel;
						if (magma[i].type==0 || magma[i].type==2 || magma[i].type==3) magma[i].yvel+=0.04;
						if (magma[i].type==1) magma[i].yvel+=0.01;
						found=true;
						if (magma[i].x<0 || magma[i].x>639 || magma[i].y<0 || magma[i].y>479 || (magma[i].type==1 && magma[i].lifetime<=0) )magma[i].x=0;
						else
							{
								if (magma[i].type==0 || magma[i].type==2 || magma[i].type==3)
									{
										DrawSprite2(1, (int)magma[i].x, (int)magma[i].y);
									}
								if (magma[i].type==1)
									{
										DrawSprite2(0, (int)magma[i].x, (int)magma[i].y);
									}
							}
					}
			}

		if (player.energy <=0) ready=2;

		int x, y;
		for (y=4; y<=26; y++)
			for (x=0;x<=100;x++)
				{
					if (x<=player.energy) DrawPixel (screen, x+100, y, 0, 100+x, 100-x);
					else DrawPixel (screen, x+100, y, 255-x, 0, 100-x);
				}
		for (y=4; y<=26; y++)
			for (x=0;x<=100;x++)
				{
					if (x<=player.power) DrawPixel (screen, x+230, y, 100+x, 100+x, 0);
					else DrawPixel (screen, x+230, y, 0, 0, 100+x);
				}
		DrawCursor(mxpos, mypos, 1);
		char score[20];
		DrawPartOfIMG(blursurface2, screen, 0, 0, 99, 32, 0, 0);
		sprintf (score, "%d", player.score);
		blobprintf (screen, score, 0, 0, 255, 255, 255, 0);
		SDL_Flip(screen);
		DrawCursor(mxpos, mypos, 0);
		etime=SDL_GetTicks();
		while (etime-stime<1000/fps)
			{
				SDL_Delay((etime-stime)/5);
				etime=SDL_GetTicks();
			}
	}
  SDL_ShowCursor(1);
  game_over(player.score);
}

void makemenuback(SDL_Surface *menuback)
{
  int x, y;
  Uint32 r, g, b;
  double ax1=639, ay1=479;
  for (y=0;y<960;y++)
	for (x=0;x<1280;x++)
		{
			r = (int)(fabs( (127.5*sin(pi*x/200)+127.5*sin(pi*y/200)) * (2+sin (pi/512*x) * sin(pi/512*y))/4 ));
			g = (int)(fabs( (127.5*sin(pi*(1280-x)/220)+127.5*sin(pi*y/220)) * (2+sin (pi/325*x) * sin(pi/325*y))/4 ));
			b = (int)(fabs( (127.5*sin(pi*x/120)+127.5*sin(pi*(960-y)/120)) * (2+sin (pi/278*x) * sin(pi/278*y))/4 ));

			Uint32 *bufp = (Uint32 *)menuback->pixels + y * (menuback->pitch>>2)+x;
			*bufp = (r<<16)+(g<<8)+(b);
		}
  SDL_Flip(screen);
}


void menu (SDL_Surface *screen, SDL_Surface *menuback)
{
  int x, y;
  double i;
  int ax1, ay1, ax2, ay2, ax3, ay3;
  Uint32 stime, itime;
  Uint32 r, g, b;
  char ready=0;
  itime=SDL_GetTicks();
  while (ready<2)
	{
		stime=SDL_GetTicks();
		i=(stime-itime)/50.0;
		ready=chkkeys();
		ax1 = 639-(int)(320+ (100*sin(pi/200*i)*sin(pi/60*i) + 100*sin(-pi/200*i)*cos(pi/60*i)) );
		ay1 = 479-(int)(200+ (100*cos(pi/200*i)*sin(pi/60*i) + 100*cos(-pi/200*i)*cos(pi/60*i)) );
		ax2 = 639-(int)(320+ (100*sin(pi+pi/200*i)*sin(pi/95*i) + 100*sin(pi-pi/200*i)*cos(pi/95*i)) );
		ay2 = 479-(int)(200+ (100*cos(pi+pi/200*i)*sin(pi/95*i) + 100*cos(pi-pi/200*i)*cos(pi/95*i)) );
		ax3 = 639-(int)(320+ (100*cos(pi/200*i)*sin(pi/110*i) + 100*cos(-pi/200*i)*cos(pi/110*i)) );
		ay3 = 479-(int)(200+ (100*sin(pi/200*i)*sin(pi/110*i) + 100*sin(-pi/200*i)*cos(pi/110*i)) );
		for (y=0;y<=479;y++)
			for (x=0;x<=639;x++)
				{
					Uint8 *p  = (Uint8 *)menuback->pixels + (y+ay1) * menuback->pitch + ((x+ax1)<<2);
					Uint8 *p1 = (Uint8 *)menuback->pixels + (y+ay2) * menuback->pitch + ((x+ax2)<<2);
					Uint8 *p2 = (Uint8 *)menuback->pixels + (y+ay3) * menuback->pitch + ((x+ax3)<<2);

					Uint32 *bufp = (Uint32 *)screen->pixels + y * (screen->pitch>>2)+x;
					r=(int)( (p[2]+p1[2]+p2[2]) >>1);
					g=(int)( (p[1]+p1[1]+p2[1]) >>1);
					b=(int)( (p[0]+p1[0]+p2[0]) >>1);

					if (r>255)r=255;
					if (g>255)g=255;
					if (b>255)b=255;

					*bufp = b+(g<<8)+(r<<16);
				}
		DrawIMG(screen, betna, 160, 60);
		DrawIMG(screen, newgame, 125, 280-74);
		DrawIMG(screen, quitgame, 151, 304);
		if (SDL_GetMouseState(&mxpos, &mypos)&SDL_BUTTON(1))
			{
				if (mxpos>=125 && mxpos<=125+389 && mypos>=280-74 && mypos <=280)
					{
						DrawIMG (blursurface, screen, 0, 0);
						DrawIMG (blursurface2, back, 0, 0);
						DrawIMG (blursurface2, blobsmall, 639-152, 0);
						crossfade(screen, blursurface, blursurface2);
						MainLoop(screen);
						DrawIMG (blursurface2, screen,0,0);
						fadeout(screen, blursurface2);
					}
				else if (mxpos>=151 && mxpos<=151+337 && mypos>=304 && mypos <=304+74) ready=2;
			}
		SDL_Flip (screen);
	}
  SDL_Flip (screen);
  DrawIMG(blursurface, screen,0,0);
  fadeout(screen, blursurface);
}

void DrawBlobtroxLogo(SDL_Surface *screen, SDL_Surface *blobtrox)
{
	int x, y,i;
	Uint16 scrpitch = (Uint16)screen->pitch;
	for (y=0;y<480;y++)
		for (x=0;x<640;x++)
			{
					Uint32 *bufp = (Uint32 *)screen->pixels + y* ((int)scrpitch/4) +x;
					*bufp = 0;
			}
	DrawIMG(screen, blobtrox, 49, 100);
	blobprintf (screen, "Make", 280, 270, 255,255,255,31337);
}

int main(int argc, char **argv)
{
  atexit(SDL_Quit);
  if ( SDL_Init(SDL_INIT_VIDEO) < 0) {
      fprintf(stderr, "Unable to init SDL: %s\n", SDL_GetError());
      exit(1);
  }
  srand(SDL_GetTicks());

  screen = SDL_SetVideoMode(640, 480, 32, SDL_SWSURFACE);//SWSURFACE); //SDL_FULLSCREEN);
  if (screen==NULL) {
	fprintf(stderr, "Unable to set 640x480 video: %s\n", SDL_GetError());
	exit(1);
	}

  SDL_WM_SetCaption ("Betna", 0);

Uint32 stime;
Uint32 etime;
char ready=0;

  InitImages();
  DrawBlobtroxLogo(blursurface, blobtrox);
  fadein(screen, blursurface);
  stime=SDL_GetTicks();
  makemenuback(menuback);
  etime=SDL_GetTicks();
  while (etime-stime<1000 && ready==0)
		{
			ready=chkkeys();
			etime=SDL_GetTicks();
		}
  fadeout(screen, blursurface);
  

  menu(screen, menuback);
  exittexts();
	/* Program should never get here :) */
  return(0);
}
