// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, translate::*, ChecksumType};

crate::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct Checksum(Boxed<ffi::GChecksum>);

    match fn {
        copy => |ptr| ffi::g_checksum_copy(ptr),
        free => |ptr| ffi::g_checksum_free(ptr),
        type_ => || ffi::g_checksum_get_type(),
    }
}

impl Checksum {
    #[doc(alias = "g_checksum_new")]
    pub fn new(checksum_type: ChecksumType) -> Option<Checksum> {
        unsafe { from_glib_full(ffi::g_checksum_new(checksum_type.into_glib())) }
    }

    #[doc(alias = "g_checksum_reset")]
    pub fn reset(&mut self) {
        unsafe {
            ffi::g_checksum_reset(self.to_glib_none_mut().0);
        }
    }

    #[doc(alias = "g_checksum_update")]
    pub fn update(&mut self, data: &[u8]) {
        let length = data.len() as _;
        unsafe {
            ffi::g_checksum_update(self.to_glib_none_mut().0, data.to_glib_none().0, length);
        }
    }

    #[doc(alias = "g_checksum_type_get_length")]
    pub fn type_get_length(checksum_type: ChecksumType) -> isize {
        unsafe { ffi::g_checksum_type_get_length(checksum_type.into_glib()) }
    }
}

unsafe impl Send for Checksum {}
unsafe impl Sync for Checksum {}
