[![](https://git.sr.ht/~alip/jja/blob/main/misc/jja-logo.png)](https://git.sr.ht/~alip/jja)

Satranç dosya formatları için İsviçre çakısı
============================================
[![Jin, Jîyan, Azadî](https://img.shields.io/badge/Jin,%20J%C3%AEyan,%20Azad%C3%AE!-8A2BE2)](https://en.wikipedia.org/wiki/Woman,_Life,_Freedom)
[![crates.io](https://img.shields.io/crates/v/jja.svg)](https://crates.io/crates/jja)
[![repology](https://repology.org/badge/latest-versions/jja.svg)](https://repology.org/project/jja/versions)
[![msrv](https://img.shields.io/badge/rustc-1.70%2B-green?style=plastic)](https://blog.rust-lang.org/2022/09/22/Rust-1.70.0.html)
[![documentation](https://docs.rs/jja/badge.svg)](https://docs.rs/jja)
[![build status](https://builds.sr.ht/~alip/jja.svg)](https://builds.sr.ht/~alip/jja?)
[![downloads](https://img.shields.io/crates/d/jja.svg)](https://crates.io/crates/jja)
[![Crowdin](https://badges.crowdin.net/jja/localized.svg)](https://crowdin.com/project/jja)
[![stability-beta](https://img.shields.io/badge/stability-beta-33bbff.svg)](https://github.com/mkenney/software-guides/blob/master/STABILITY-BADGES.md#beta)
[![license](https://img.shields.io/crates/l/jja.svg)](https://git.sr.ht/~alip/jja/tree/main/item/COPYING)
[![dependency status](https://deps.rs/repo/sourcehut/~alip/jja/status.svg)](https://deps.rs/repo/sourcehut/~alip/jja)
[![maintenance-status](https://img.shields.io/badge/maintenance-actively--developed-brightgreen.svg)](https://git.sr.ht/~alip/jja)

___jja___, çeşitli satranç dosya formatlarıyla etkileşimde bulunmak için bir
komut satırı yardımcı programıdır. Halen gelişimin erken aşamalarındadır.
Yazarın başlangıç niyeti, ChessBase'in kapalı kaynak kodlu
[CTG](https://www.chessprogramming.org/CTG) formatında kaydedilen açılış
kitaplarını, özgür ve açık [PolyGlot](http://hgm.nubati.net/book_format.html)
formatına dönüştürmektir. Zamanla diğer satranç dosya formatları için destek
eklemeyi planlıyorlar (
[cbh](https://www.chessprogramming.org%2FChessBase_%28Database%29%23Formats),
[epd](https://www.chessprogramming.org/Extended_Position_Description),
[pgn](https://www.chessprogramming.org/Portable_Game_Notation),
[si4](https://www.chessprogramming.org/SCID#Database_Format),
[si5](https://www.chessprogramming.org/SCID#Database_Format)
ve benzeri).

## Formatlar

0.7.0 sürümü itibariyle, ___jja___ şu formatları okuma/sorgulama için destekler:

- [PolyGlot](http://hgm.nubati.net/book_format.html), yani `bin`
- [Arena](https://www.chessprogramming.org/ABK), yani `abk`
- [ChessBase](https://www.chessprogramming.org/CTG), yani `ctg`
- [ChessMaster](https://www.chessprogramming.org/Chessmaster), yani `obk`
(1. ve 2. sürüm, metin notları olan ve olmayan)
- [BrainLearn](https://github.com/amchess/BrainLearn), yani `exp`

Buna karşılık yazma/dönüştürme için şu formatları destekler:

- [PolyGlot](http://hgm.nubati.net/book_format.html), yani `bin`
- [Arena](https://www.chessprogramming.org/ABK), yani `abk`
- [BrainLearn](https://github.com/amchess/BrainLearn), yani `exp`

Açılış kitabı dönüştürme sırasında, ___jja___ çeşitli giriş açılış kitabı
formatlarında sağlanan bilgileri kullanarak,
[PolyGlot](http://hgm.nubati.net/book_format.html) açılış dosyasındaki hamleye
eşlik eden bir **hamle ağırlığı** oluşturur. ___jja___ ayrıca, `ctg` dönüşümü
sırasında [NAG](https://en.wikipedia.org/wiki/Numeric_Annotation_Glyphs)'lar
veya `abk` dönüşümü sırasında öncelik gibi öğrenme alanında bazı özel sayılar
yazar. Bu özel kullanımı, bu alanı kullanan diğer yazılımların kafa
karışıklığına neden olabileceği için `--no-learn` ile devre dışı
bırakabilirsiniz.

Not, [Arena](https://www.chessprogramming.org/ABK), yani `abk`, açılış kitap
dosya yazma desteği yalnızca [ChessBase](https://www.chessprogramming.org/CTG),
yani `ctg` kitaplarından desteklenir.
[ABK](https://www.chessprogramming.org/ABK) başlık meta verilerini
yapılandırmak için `--author`, `--comment`, `--probability-priority`,
`--probability-games`, `--probability-win-percent` komut satırı bayraklarını
kullanın. Oyun istatistikleri (her iki taraf için minimum oyun/kazanma sayısı,
kazanma yüzdeleri) ___jja___ tarafından otomatik olarak yönetilir.

[Arena](https://www.chessprogramming.org/ABK) açılış kitapları için yerinde
düzenleme de `-i, --in-place=SUFFIX` komut satırı seçeneği kullanılarak
mümkündür. [PolyGlot](http://hgm.nubati.net/book_format.html), yani `bin`, ve
[ChessMaster](https://www.chessprogramming.org/Chessmaster) yani `obk` açılış
kitaplarından [Arena](https://www.chessprogramming.org/ABK), yani `abk` açılış
kitap dosyalarına dönüştürme, gelecekteki bir sürüm için planlanmaktadır.

## PGN Kitap Oluşturma

0.4.0 sürümünden itibaren, ___jja___
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)
dosyalarından [PolyGlot](http://hgm.nubati.net/book_format.html) kitapları
oluşturabilir. Bu özellik, `polyglot make-book`'a benzer şekilde aşağıdaki
farklarla sunulmaktadır:

1. ___jja___, sıkıştırılmış
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)
dosyalarını .pgn.{bz2, gz, lz4, zst} doğrudan okuyabilir.
2. ___jja___, geçici bir [RocksDB](https://rocksdb.org/) veritabanında
istatistikleri saklayarak, sisteminizin kullanılabilir belleğinden daha büyük
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)
dosyalarını işleyebilir.
3. ___jja___, devasa
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)
dosyalarıyla potansiyel taşmaları önlemek için hamle ağırlıklarını varsayılan
olarak ölçeklendirir, devre dışı bırakmak için `--no-scale` kullanın.
4. ___jja___, *Filtre İfadeleri* kullanarak hamleleri filtreleyebilir ve
kullanıcının istenmeyen oyunları elemesine ve özel açılış kitapları
oluşturmasına olanak tanır.

(Gerisi çevirilecek -alip 20230409)
