#!/bin/bash
# Copyright (c) 2021, 2023 Ali Polatel <alip@exherbo.org>
# SPDX-License-Identifier: GPL-3.0-or-later

root=$(git rev-parse --show-toplevel)
jja="${root}/target/release/jja"
pgn_book="${root}/samples/caissa-ai.pgn"
tmp_book="/tmp/tmp.bin"

exec hyperfine \
    --export-json jja-make-hyperfine.json \
    --warmup 1 \
    --prepare "sync; echo 3 | sudo tee /proc/sys/vm/drop_caches; rm -f ${tmp_book}" \
    -L threads $(nproc),$(expr $(nproc) '*' 2)  \
    -L compalg bzip2,lz4,lz4hc,snappy,zlib,zstd \
    -L compfac 4,7,14,22 \
    -L batchsz 5000,10000 \
    "${jja} make ${pgn_book} -o ${tmp_book} -T{threads} --compression={compalg} --compression-level={compfac} --batch-size={batchsz}"
