## Layer Tree View Widget Overview

### The Problem

Some complex drawings may include lots of layers. Also, one layer may be used for single part/view, and separate layers 
may be used for dimensions, alternative position of part or for some additional meta information (notes, sketches and so on).      

If some parts belong to some units, it is convenient to name layers for such parts in uniform way, or, what is even
better, organize hierarchy of layers.

Unfortunately, DXF format does not support hierarchy of layer as well as LibreCAD (so far).  

Even with plain list of layers it is possible to use logical grouping or layers - by relying on some common 
logical prefix in their names. However, while artificial naming of layers simplifies layers related operations a bit, 
it is still limited.  

### The Solution

In order to provide more convenient way of working with layers, support of hierarchical layers was added and implemented 
in Layer Tree widget. The widget is similar to standard Layer List widget, yet brings a bit more functions. 

Layers hierarchy is built purely based on naming convention, which assumes that some uniform substring is used as separator 
of layer's levels). 

In addition to support of hierarchical view of layers, the widget adds some additional features that are listed below.

### Features

Here is a brief list of features, implemented in widget

### General
* Two modes of layers displaying - hierarchical (tree) and flat (list)
* Regexp-based filter, that allows to filter layers OR highlight layers that matches regexp string
* Drag&Drop restructure
* Group operations on layers hierarchy

Several predefined layer types are supported: 
* Normal (ordinary layer)
* Dimensional (stores dimensions for corresponding normal layer)
* Informational (for notes and sketches)
* Alternative position (same part but located in different position)
* Virtual - holder for layers of other types, may be considered as something similar to folder

#### Toolbar Actions
* Show all Layers
* Hide all Layers
* Show/Hide Secondary layers
* Show Active layer Only
* Expand All Items (Tree mode)
* Collapse All Items (Tree Mode)
* Collapse Secondary Layers (Tree Mode)
* Lock All Layers
* Unlock All Layers
* Add layer
* Add Dimensional layer
* Remove Active Layer
* Edit Active Layer

#### Filtering Box
* If Highlight Mode check is selected, items that matches provided regexp will be highlighted in the list.  
* Otherwise - only layer items that matches regexp will be shown in the list. 

#### Layers Tree View
* Displaying logical structure of layers based on naming convention
* Icons that display type of layer
* Columns for layers flags (frozen, locked, print enabled, construction)
* Support of **GROUP operations** on flags - i.e. click on top layer flag also is applied on descendant layers
* Drag&Drop for restructuring hierarchy
* Double-click on virtual layer item - expands children
* Double-click on actual layer item - invokes Layer Edit dialog
* Item-aware context menu
* Customizable appearance (colors, items displaying)
* Showing full layer name as tooltip
* Optional indentation of layer names according to the level in hierarchy

#### Operations With Layers
* Layer creation (with support of **default pen** for specific layer type)
* Layer editing
* Hierarchy-aware layers rename (mass rename of descendent children based on parent layer)
* Single layer removal
* Hierarchy-aware layers removal (layer and its children, or children only)
* Add child layers with predefined type
* Change of layer type
* Freeze all layers **except** selected
* **Copy** of layer (hierarchy aware)  - copies the structure of layers with attributes copy)
* **Duplicate** Layer (hierarchy aware) - copies the structure of layers with attributes copy **AND** copies entities from 
source levels to their copies 
* Removing empty layers without entities

#### Operations with entities
* Select layer entities (hierarchy aware)
* Move current entities selection to layer
* Copy current entities selection to layer

#### Customization options
* Naming convention, that defines string used as separator of layer levels and set of prefixes that are used to identify 
particular layer type
* Prefix and suffix for autogenerated names that may occur in order to prevent layer name's duplication
* Colors (highlighted matched item, grid, background for virtual layer, background for selected item, background for active layer)
* Minor UI adjustments options (tooltips, drag&drop support, names indentation, layer type options)
* **DEFAULT PEN** for each layer type - that pen will be set in layer creation dialog 

#### Implementation notes

This is pure UI implementation that does not affect internal structures of layers or underlying storage format. Original
plain layers list is not affected and two widgets may be used in parallel. 

The current implementation tried to affect existing codebase as minimal as it is possible and minimize refactoring of the 
existing codebase in order to avoid introducing regression issues.  

No additional libraries or dependencies were added, it's just plain C++/QT code with comments. 

While such approach allows to have quite isolated and self-contained implementation, it is not clear how does it fit in 
general architecture of the existing code. 

Possible candidates for further refactorings (if it will be reasonable) - classes for actions,  code for working with 
entities, original layers list (RS_LayersList).  

#### Localization 
All strings used are localizable, yet it is necessary to create actual language-specific values for them. 








