# MoarVM Release Guide

## Versions

MoarVM currently has a **monthly release cycle**, with releases made in time for
the month's **NQP** and **Rakudo** release.

Version numbers are simply `YYYY.MM`. For example, the **January 2014 release** is
`2014.01`.

If any **bugfix releases** need to
be made, they should be numbered as `2014.01`**.1**, `2014.01`**.2**, etc.

## Making a release

1. Make sure that you are on the MoarVM commit you want to make a release
   from, and that your status is clean.

2. Ensure that **NQP** and **Rakudo** will build and that `make test` in each is
   clean. Also run `make spectest` in Rakudo; discuss any failures you see
   with the Rakudo developers.

3. If possible, run **NQP** and **Rakudo** `make test` and **Rakudo** `make spectest` when
   `#define MVM_DEBUG_NFG 1` and `#define MVM_DEBUG_NFG_STRICT 1` in `src/strings/ops.h`
   after recompiling to make sure there have been no normalization bugs
   introduced.

4. Do a checkout to a new branch name, which equals to the release version
   (e.g. `git checkout -b 2014.01`, substituting the correct version).

5. Update the `docs/ChangeLog` file with any significant changes since the previous release.
   To do so, write down commits from the previous release merge commit to latest ones (using
   Github interface or git's CLI). Changes are split into categories, usually to konw
   a category where to place some change you can see what files were changes (e.g. changes
   to JIT to to the JIT category or GC fixes go into GC category).
   Do not forget to check merge commits, as they can bring in commits older than the previous
   release merge commit and those won't be visible in the history.

6. Update the `VERSION` file with the release name.

7. Commit the changes.  Typically the message is just "Update changelog and
   version".

8. Run `make release VERSION=2014.01`, substituting the correct version.

9. Take the `MoarVM-2014.01.tar.gz` file generated by **step 8**, copy it to a separate directory,
   extract it, and then in that directory do:

        perl Configure.pl --prefix=install
        make install
        install/bin/moar --version

10. Provided **step 8** and **9** work, you have a new release! Your git instance must
    sign commits. Now we tag the release. The `-a` option adds a tag while
    the `-s` makes sure the tag is signed. Even if your commits are signed by default,
    you will need the -s option as well.
    Note: For the tag's message, in the past we have used format:
    '20XX.YY release'. To see the past release messages use `git tag -n9`

        git tag -as 2014.01

11. Run `git verify-tag 2014.01` to make sure the signature is valid and the tag
    was actually signed.

12. Run `git push origin refs/heads/2014.01:refs/heads/2014.010` assuming
    the upstream remote is `origin` to push the branch and `git push origin --tags`
    to push the tag. Open a Pull Request for the branch.

13. From here on this assumes you have the `https://github.com/MoarVM/moarvm.org/` repository
    in the same folder as the main MoarVM repo.

14. Make sure you have the `Text::Markdown` **Perl 5** module and run:

        ./tools/moarvm.org_releases.pl > ../moarvm.org/releases.html

   It should output to STDERR all the versions it found in ChangeLog make sure
   the most recent release appears first and all releases going back to 2014.01
   appear.

15. Manually edit the `moarvm.org/index.html` file to have the DL link and mention the most
    recent release.
    Changes need to be made on lines:
  - 36: Large text
  - 38: Description text
  - 41: Download link

16. Create a gpg signature

        gpg --detach-sign --armor MoarVM-2014.01.tar.gz

   Verify the signature:

        gpg --verify MoarVM-2014.01.tar.gz.asc

17. Copy the tar.gz and the signature:

        cp MoarVM-2014.01.tar.gz MoarVM-2014.01.tar.gz.asc ../moarvm.org/releases

18. Commit release to moarvm.org repo and check moarvm.org after 5-10 minutes and
    make sure download works.

        cd ../moarvm.org
        git add . # Add release files and changes to index.html and releases.html
        git commit -m "Commit release 2014.01"

19. Make sure both pages look alright, open `index.html` and `releases.html` with
    your browser and check markup highlighting.

20. If both look good, push with `git push origin master`

21. Merge the release Pull Request.

22. There is a [github workflow](.github/workflows/build_release.yml) (commit 2a60bd07bd3b90d6d5c5d30311bdb5cb2f0f2a59, added on Mar 16, 2024) that creates the github
    release after a `git tag` was pushed.  You just have to wait a few minutes for it to happen after the
    pushes.  Once it appears you have to add the release assets (the tarball and
    the sig file) by hand.  If need be the old way should still work, which is available in `tools/releasable/github-release.p6`:

        raku github-release.p6 --repo=MoarVM/MoarVM --tag=2014.01 --token=... --asset=MoarVM-2014.01.tar.gz --asset=MoarVM-2014.01.tar.gz.asc

    but the asset upload is broken so still have to get those up by hand.

23. Update [MoarVM article on Wikipedia](https://en.wikipedia.org/wiki/MoarVM) with the latest release information.

24. Time to prepare a Rakudo release.
