// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package main

import (
	"example.com/bar"
	"example.com/baz"
	"example.com/foo"
	"fmt"
)

// Injectors from wire.go:

func newMainService(config *foo.Config, barConfig *bar.Config, bazConfig *baz.Config) *MainService {
	service := foo.New(config)
	barService := bar.New(barConfig, service)
	bazService := baz.New(bazConfig, barService)
	mainService := &MainService{
		Foo: service,
		Bar: barService,
		Baz: bazService,
	}
	return mainService
}

// wire.go:

type MainConfig struct {
	Foo *foo.Config
	Bar *bar.Config
	Baz *baz.Config
}

type MainService struct {
	Foo *foo.Service
	Bar *bar.Service
	Baz *baz.Service
}

func (m *MainService) String() string {
	return fmt.Sprintf("%d %d %d", m.Foo.Cfg.V, m.Bar.Cfg.V, m.Baz.Cfg.V)
}

func main() {
	cfg := &MainConfig{
		Foo: &foo.Config{1},
		Bar: &bar.Config{2},
		Baz: &baz.Config{3},
	}
	svc := newMainService(cfg.Foo, cfg.Bar, cfg.Baz)
	fmt.Println(svc.String())
}
