/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class CBErrorWin
extends JDialog {
    String msg;
    String error;
    String title;
    boolean haveErrorMsg;
    CBButton OK;
    CBButton Details;
    CBPanel display;
    Exception exception;

    public CBErrorWin(Dialog owner, String Msg, Exception e) {
        super(owner);
        this.title = CBIntText.get("Error Encountered");
        this.commonConstructor(Msg, e);
    }

    public CBErrorWin(Frame owner, String Msg, Exception e) {
        super(owner);
        this.title = CBIntText.get("Error Encountered");
        this.commonConstructor(Msg, e);
    }

    public CBErrorWin(Frame owner, String Msg, String msgTitle) {
        super(owner);
        this.title = msgTitle;
        this.commonConstructor(Msg, null);
    }

    public void commonConstructor(String Msg, Exception e) {
        this.setModal(true);
        this.exception = e;
        this.setTitle(CBIntText.get(this.title));
        this.msg = Msg == null ? CBIntText.get("No Message Given") : Msg;
        this.haveErrorMsg = e != null;
        this.error = this.haveErrorMsg ? e.toString() : CBIntText.get("No specific information");
        JScrollPane scrollPane = new JScrollPane(this.makeTextArea(this.msg));
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.display = new CBPanel();
        this.display.makeHeavy();
        this.display.addLine(scrollPane);
        this.display.makeLight();
        JPanel buttons = new JPanel();
        this.OK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click to close error window."));
        buttons.add(this.OK);
        if (this.haveErrorMsg) {
            this.Details = new CBButton(CBIntText.get("Details"), CBIntText.get("Click to display the full error message."));
            buttons.add(this.Details);
        }
        this.display.add(buttons);
        this.OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CBErrorWin.this.setVisible(false);
                CBErrorWin.this.dispose();
            }
        });
        if (this.haveErrorMsg) {
            this.Details.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollPane scrollPane2 = new JScrollPane(CBErrorWin.this.makeTextArea(CBErrorWin.this.msg));
                    final JScrollPane newPane = new JScrollPane(CBErrorWin.this.makeTextArea(CBErrorWin.this.error));
                    TitledBorder border = new TitledBorder(CBIntText.get("error details"));
                    newPane.setBorder(border);
                    CBErrorWin.this.getContentPane().remove(CBErrorWin.this.display);
                    CBErrorWin.this.display = new CBPanel();
                    CBErrorWin.this.display.makeHeavy();
                    CBErrorWin.this.display.addLine(scrollPane2);
                    CBErrorWin.this.display.addLine(newPane);
                    CBErrorWin.this.display.makeLight();
                    JPanel buttons2 = new JPanel();
                    if (CBErrorWin.this.exception != null) {
                        JButton StackTrace = new JButton(CBIntText.get("Print Stack"));
                        StackTrace.setToolTipText(CBIntText.get("Prints a stack trace to the console (if active)"));
                        StackTrace.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                StringWriter sw = new StringWriter();
                                CBErrorWin.this.exception.printStackTrace(new PrintWriter(sw));
                                String trace = sw.toString();
                                newPane.setViewportView(CBErrorWin.this.makeTextArea(trace));
                                CBErrorWin.this.exception.printStackTrace();
                            }
                        });
                        buttons2.add(StackTrace);
                    }
                    buttons2.add(CBErrorWin.this.OK);
                    CBErrorWin.this.display.add(buttons2);
                    CBErrorWin.this.setContentPane(CBErrorWin.this.display);
                    CBErrorWin.this.setSize(new Dimension(CBErrorWin.this.getWidth(), CBErrorWin.this.getHeight() + 100));
                    CBErrorWin.this.setVisible(true);
                }
            });
        }
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.setContentPane(this.display);
        this.setSize(new Dimension(400, 150));
        CBUtility.center(this, this.getOwner());
        this.setVisible(true);
    }

    protected JTextArea makeTextArea(String text) {
        JTextArea a = new JTextArea(text);
        a.setBackground(this.getBackground());
        a.setEnabled(true);
        a.setDisabledTextColor(Color.black);
        a.setLineWrap(true);
        a.setWrapStyleWord(true);
        a.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        a.getActionMap().put("enter", new MyAction(10));
        return a;
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CBErrorWin.this.setVisible(false);
            CBErrorWin.this.dispose();
        }
    }
}

