/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.util.Diagnostic;
import java.io.Closeable;
import java.util.function.Consumer;

public class ThreadCtx {
    private static final ThreadLocal<ThreadData> data = ThreadLocal.withInitial(() -> new ThreadData());
    private static final ThreadLocal<Consumer<Diagnostic>> diagnosticConsumer = new ThreadLocal();

    public static ThreadData get() {
        return data.get();
    }

    static void addDiagnostic(Diagnostic diagnostic) {
        Consumer<Diagnostic> consumer = diagnosticConsumer.get();
        if (consumer != null) {
            consumer.accept(diagnostic);
        }
    }

    public static void cleanup() {
        data.remove();
    }

    public static Closeable applyDiagnosticConsumer(Consumer<Diagnostic> consumer) {
        diagnosticConsumer.set(consumer);
        return diagnosticConsumer::remove;
    }

    public static class ThreadData {
        private SharedContext sharedContext;

        private ThreadData() {
        }

        public SharedContext sharedContext() {
            if (this.sharedContext == null) {
                throw new NullPointerException("SharedContext must be registered in renderer.");
            }
            return this.sharedContext;
        }

        public void setSharedContext(SharedContext sharedContext) {
            this.sharedContext = sharedContext;
        }
    }
}

