/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap.misc;

import com.jetbrains.rd.platform.codeWithMe.blockmap.misc.FileCache;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/misc/MockServer;", "", "root", "", "<init>", "(Ljava/lang/String;)V", "server", "Lcom/sun/net/httpserver/HttpServer;", "getHostAddress", "start", "", "stop", "MyHandler", "intellij.platform.split"})
public final class MockServer {
    @NotNull
    private final String root;
    @NotNull
    private final HttpServer server;

    public MockServer(@NotNull String root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(0), 0);
        Intrinsics.checkNotNullExpressionValue((Object)httpServer, (String)"create(...)");
        this.server = httpServer;
    }

    @NotNull
    public final String getHostAddress() {
        return "http://127.0.0.1:" + this.server.getAddress().getPort();
    }

    public final void start() {
        this.server.createContext("/", new MyHandler(this.root));
        this.server.setExecutor(null);
        this.server.start();
    }

    public final void stop() {
        this.server.stop(0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/misc/MockServer$MyHandler;", "Lcom/sun/net/httpserver/HttpHandler;", "root", "", "<init>", "(Ljava/lang/String;)V", "fileCache", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/misc/FileCache;", "getBytesRange", "Lkotlin/ranges/IntRange;", "headers", "Lcom/sun/net/httpserver/Headers;", "handle", "", "t", "Lcom/sun/net/httpserver/HttpExchange;", "respond", "code", "", "description", "respondFileNotFound", "intellij.platform.split"})
    public static final class MyHandler
    implements HttpHandler {
        @NotNull
        private final String root;
        @NotNull
        private final FileCache fileCache;

        public MyHandler(@NotNull String root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
            this.fileCache = new FileCache(null, 0, 3, null);
        }

        private final IntRange getBytesRange(Headers headers) {
            String string = headers.getFirst("Range");
            if (string == null) {
                return null;
            }
            String range = string;
            if (!StringsKt.startsWith$default((String)range, (String)"bytes=", (boolean)false, (int)2, null)) {
                return null;
            }
            String fromTo = StringsKt.replace$default((String)range, (String)"bytes=", (String)"", (boolean)false, (int)4, null);
            char[] cArray = new char[]{'-'};
            List tokens = StringsKt.split$default((CharSequence)fromTo, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            return new IntRange(Integer.parseInt((String)tokens.get(0)), Integer.parseInt((String)tokens.get(1)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(@NotNull HttpExchange t) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String[] stringArray = new String[]{t.getRequestURI().getPath()};
            Path path = Paths.get(this.root, stringArray);
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                this.respondFileNotFound(t);
                return;
            }
            Headers headers = t.getRequestHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"getRequestHeaders(...)");
            IntRange range = this.getBytesRange(headers);
            if (range == null) {
                byArray = this.fileCache.readWholeFile(((Object)path).toString());
            } else {
                int length = range.getLast() + 1 - range.getFirst();
                byArray = this.fileCache.readBytes(((Object)path).toString(), range.getFirst(), length);
            }
            byte[] bytes = byArray;
            t.sendResponseHeaders(200, bytes.length);
            Closeable closeable = t.getResponseBody();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                it.write(bytes);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void respond(HttpExchange t, int code, String description) {
            t.sendResponseHeaders(code, description.length());
            Closeable closeable = t.getResponseBody();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                byte[] byArray = description.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final void respondFileNotFound(HttpExchange t) {
            this.respond(t, 404, "Resource not found");
        }
    }
}

