/***************************************************************************
 *                                                                         *
 *   brarr.h     (begin: Mar 12 2003)                                      *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef BRARR_H
#define BRARR_H

#include <iostream>
//#include <hash_map.h>
#include "vec.h"
#include "br.h"

/*
template<class T>
struct hash_branch {
	size_t operator() (const Br<T> & branch) {
		return branch.smaNdNo_ + branch.greNdNo_;
	}
};

template<class T>
struct equal_branch {
	size_t operator() (const Br<T> & branch1, const Br<T> &branch2) {
		return (branch1.smaNdNo_ == branch2.smaNdNo_) && (branch1.greNdNo_ == branch2.greNdNo_);
	}
};
*/

//this class is a collect of all branches of the unrooted tree
template <class T = double>
class BrArr {
public :

	//constructor function
	BrArr () {
		curNBr_ = 0;
		maxNBr_ = 0;
	}

	//constructor function
	BrArr (const int maxNBr) {
		curNBr_ = 0;
		setLimit (maxNBr);
	}

	//--------------------------------------------------------------------
	//set limit of this list
	void setLimit (const int maxNBr) {
		maxNBr_ = maxNBr;
		items_.set (maxNBr_, maxNBr_);
		brNoLs_.setLimit (maxNBr_);
	}

	/*
	int findBr (int ndNo0, int ndNo1) {
		for (int brNo_ = 0; brNo_ < maxNBr_; brNo_ ++)
			if (items_[brNo_].getId () != -1) {
				int headNdNo_ = items_[brNo_].getHeadNd ();
				int tailNdNo_ = items_[brNo_].getTailNd ();
				if (Utl::isEqualPair (headNdNo_, tailNdNo_, ndNo0, ndNo1) == 1)
					return brNo_;
			}
		return -1;
	}
	*/
	//--------------------------------------------------------------------
	//overload the operator []
	Br<T> &operator[] (const int index) {
		if (index < 0) {
			items_.printVecInfo(index, "error in BrArr[]");
			Utl::announceError (BAD_MEMORY_ACCESS);
		}
		return items_[index];
	}

	//--------------------------------------------------------------------
	//overload the operator +=
	void operator += (Br<T> &br) {
		int brNo_ = br.getId ();
		if (brNo_ < 0) {
			items_.printVecInfo(brNo_, "error in BrArr+=");
			Utl::announceError (BAD_MEMORY_ACCESS);
		}
		items_[brNo_] = br;
		curNBr_ ++;
		brNoLs_ += brNo_;
	}

	//--------------------------------------------------------------------
	//overload the operator -=
	void operator -= (int brNo) {
		items_[brNo].clean ();
		brNoLs_.delItem (brNo);
		curNBr_ --;
	}

	//--------------------------------------------------------------------
	//change the data of br
	void change (Br<T> &br) {
		int brNo_ = br.getId ();
		items_[brNo_] = br;
	}

	//--------------------------------------------------------------------
	//clean all content of branch array
	void clean () {
		for (int count_ = 0; count_ < maxNBr_; count_ ++)
			items_[count_].clean ();

		curNBr_ = 0;
		brNoLs_.clean ();
	}

	//--------------------------------------------------------------------
	//get the the curretn number of the bres list
	int getCurNBr () {
		return curNBr_;
	}

	//--------------------------------------------------------------------
	//get the maximum number branches of this class
	int getMaxNBr () {
		return maxNBr_;
	}

	//--------------------------------------------------------------------
	//return the first free branch
	int getNewBr () {
		for (int brNo_ = 0; brNo_ < curNBr_ + 1; brNo_ ++)
			if (items_[brNo_].getId () == -1)
				return brNo_;

		return -1;
	}

	//--------------------------------------------------------------------
	//return items
	typedef Br<T> TBr;
	Vec<TBr> &getItem () {
		return items_;
	}

	//--------------------------------------------------------------------
	//return the brNoLs_
	Vec<int> &getBrNo () {
		return brNoLs_;
	}

	//--------------------------------------------------------------------
	//this = brArr
	void operator = (BrArr<T> &brArr) {
		this->items_ = brArr.getItem ();
		this->curNBr_ = brArr.getCurNBr ();
		this->maxNBr_ = brArr.getMaxNBr ();
		this->brNoLs_ = brArr.getBrNo ();
	}

	//--------------------------------------------------------------------
	//release all memory of this class
	void release () {
		int realLimit_ = items_.getLimit ();
		items_.setSize (realLimit_);
		for (int count_ = 0; count_ < realLimit_; count_ ++)
			items_[count_].release ();
		items_.release ();

		brNoLs_.release ();

	}

	Vec<int> *getBrLs () {
		return &brNoLs_;
	}
	//--------------------------------------------------------------------
	//destructor function
	virtual ~BrArr () {
		release ();
		//  std::cout << "this is destructor function of BrArr class " << endl;
	}

	/********************************************************************************
	********************************************************************************
	********************************************************************************
	********************************************************************************/

private :
	//the number of current bres
	int curNBr_;

	//the maximum number branches of this branch array
	int maxNBr_;

	//the array of all bres, full information store here
	Vec<TBr> items_;

	// hash map 
	///hash_map<Br<T>, int, hash_branch<T>, equal_branch<T> > branch_index;
	
	//the list off all current branches no
	Vec<int> brNoLs_;

}
; //end of brArr class

#endif
