/***************************************************************************
 *                                                                         *
 *   exnd.h         (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EXND_H
#define EXND_H

/**
        this class contains all necessary information and methods for an external node being specified more
*/

class ExNd {
public :
/**     
        constructor function
*/
	ExNd ();
/**
        clean all content of this external node
*/
	void clean ();

/**
        set the indentical number for this external node
*/
	void setId (const int Id);

/**
        set the internal node of this external node
        @param inNdNo indentical number of internal node
*/
	void setInNd (const int inNdNo);

/**
        set the branch number contacting this node and the internal node
*/
	void setBr (const int brNo);

/**
        set all information for this external node
        @param Id indentical number of external node
        @param idNdNo indentical number of internal node
        @param brNo indentical number of branch
*/
	void set (const int Id, const int inNdNo, const int brNo);

/**

        get the indentical number of this external node
*/
	int getId ();

/**
        get the internal node number of this node
*/
	int getInNd ();

/**
        get the branch number contacting this node and the internal node
*/
	int getBr ();

/**
        copy the external node into the external node
        @param &exNd the external node
*/
	void copy (ExNd &exNd);

	//overload operator =. Thus, copy an internal node into this internal node
	void operator = (ExNd &exNd);

/**
        change the internal node of this external node
        @param newInNdNo the indentical number of new internal node number
*/
	void changeInNd (const int newInNdNo);

/**
        change the branch of this external node
        @param newBrNo  the indentical number of new branch number
*/
	void changeBr (const int newBrNo);

/**
        release all memmory for this class
*/
	void release ();

/**
        destructor function for all releasing before deleting object
*/
	~ExNd ();

	/********************************************************************************************
	********************************************************************************************
	********************************************************************************************
	********************************************************************************************
	********************************************************************************************/

private :
/**
        the identical number of this node
*/
	int id_;

/**
        the internal node no of this external node
*/
	int inNdNo_;

/**
        brNo_ is the br no  between this node and the internalNdNo_
*/
	int brNo_;

}
;  //end of exnd class
#endif
