/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   Source code here taken from TREE-PUZZLE package               
 * (c) 2003-2004 by Heiko A. Schmidt, Korbinian Strimmer, Arndt von Haeseler
 * (c) 1999-2003 by Heiko A. Schmidt, Korbinian Strimmer,
 *                  M. Vingron, and Arndt von Haeseler
 * (c) 1995-1999 by Korbinian Strimmer and Arndt von Haeseler
 
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "constant.h"
#include "vt.h"
#include "dvec20.h"
#include "dmat20.h"


//this part are taken from PUZZLE-TREE
void VTM::getData(DMat20 &q, DVec20 &f) {
	if (isMasterProc())
		std::cout <<"Using VT model" << endl;
	/*
	* Dayhoff model for amino acid evolution 
	* Mueller, T. and Vingron, M. 
	* "Modeling Amino Acid Replacement" 
	* Journal of Comp. Biology, 7(6):761-776,2000
	*/

	/* amino acid frequencies */
	f[ 0]=0.0770764620135024 ; f[ 1]=0.0500819370772208 ;
	f[ 2]=0.0462377395993731 ; f[ 3]=0.0537929860758246 ;
	f[ 4]=0.0144533387583345 ; f[ 5]=0.0408923608974345 ;
	f[ 6]=0.0633579339160905 ; f[ 7]=0.0655672355884439 ;
	f[ 8]=0.0218802687005936 ; f[ 9]=0.0591969699027449 ;
	f[10]=0.0976461276528445 ; f[11]=0.0592079410822730 ;
	f[12]=0.0220695876653368 ; f[13]=0.0413508521834260 ;
	f[14]=0.0476871596856874 ; f[15]=0.0707295165111524 ;
	f[16]=0.0567759161524817 ; f[17]=0.0127019797647213 ;
	f[18]=0.0323746050281867 ; f[19]=0.0669190817443274 ;

	/* relative rates */

	q[ 0][ 1] = 1.2412691067876198;  q[ 0][ 2] = 1.2184237953498958;
	q[ 0][ 3] = 1.3759368509441177;  q[ 0][ 4] = 2.4731223087544874;
	q[ 0][ 5] = 2.2155167805137470;  q[ 0][ 6] = 2.3379911207495061;
	q[ 0][ 7] = 3.3386555146457697;  q[ 0][ 8] = 0.9615841926910841;
	q[ 0][ 9] = 0.8908203061925510;  q[ 0][10] = 1.0778497408764076;
	q[ 0][11] = 1.4932055816372476;  q[ 0][12] = 1.9006455961717605;
	q[ 0][13] = 0.6883439026872615;  q[ 0][14] = 2.7355620089953550;
	q[ 0][15] = 6.4208961859142883;  q[ 0][16] = 5.2892514169776437;
	q[ 0][17] = 0.5488578478106930;  q[ 0][18] = 0.5411769916657778;
	q[ 0][19] = 4.6501894691803214;

	q[ 1][ 2] = 1.5720770753326880;  q[ 1][ 3] = 0.7550654439001206;
	q[ 1][ 4] = 1.4414262567428417;  q[ 1][ 5] = 5.5120819705248678;
	q[ 1][ 6] = 1.3542404860613146;  q[ 1][ 7] = 1.3121700301622004;
	q[ 1][ 8] = 4.9238668283945266;  q[ 1][ 9] = 0.4323005487925516;
	q[ 1][10] = 0.8386701149158265;  q[ 1][11] = 10.0173308173660018;
	q[ 1][12] = 1.2488638689609959;  q[ 1][13] = 0.4224945197276290;
	q[ 1][14] = 1.3091837782420783;  q[ 1][15] = 1.9202994262316166;
	q[ 1][16] = 1.3363401740560601;  q[ 1][17] = 1.5170142153962840;
	q[ 1][18] = 0.8912614404565405;  q[ 1][19] = 0.7807017855806767;

	q[ 2][ 3] = 7.8584219153689405;  q[ 2][ 4] = 0.9784679122774127;
	q[ 2][ 5] = 3.0143201670924822;  q[ 2][ 6] = 2.0093434778398112;
	q[ 2][ 7] = 2.4117632898861809;  q[ 2][ 8] = 6.1974384977884114;
	q[ 2][ 9] = 0.9179291175331520;  q[ 2][10] = 0.4098311270816011;
	q[ 2][11] = 4.4034547578962568;  q[ 2][12] = 0.9378803706165143;
	q[ 2][13] = 0.5044944273324311;  q[ 2][14] = 0.7103720531974738;
	q[ 2][15] = 6.1234512396801764;  q[ 2][16] = 3.8852506105922231;
	q[ 2][17] = 0.1808525752605976;  q[ 2][18] = 1.0894926581511342;
	q[ 2][19] = 0.4586061981719967;

	q[ 3][ 4] = 0.2272488448121475;  q[ 3][ 5] = 1.6562495638176040;
	q[ 3][ 6] = 9.6883451875685065;  q[ 3][ 7] = 1.9142079025990228;
	q[ 3][ 8] = 2.1459640610133781;  q[ 3][ 9] = 0.2161660372725585;
	q[ 3][10] = 0.3574207468998517;  q[ 3][11] = 1.4521790561663968;
	q[ 3][12] = 0.4075239926000898;  q[ 3][13] = 0.1675129724559251;
	q[ 3][14] = 1.0714605979577547;  q[ 3][15] = 2.2161944596741829;
	q[ 3][16] = 1.5066839872944762;  q[ 3][17] = 0.2496584188151770;
	q[ 3][18] = 0.7447620891784513;  q[ 3][19] = 0.4594535241660911;

	q[ 4][ 5] = 0.4587469126746136;  q[ 4][ 6] = 0.4519167943192672;
	q[ 4][ 7] = 1.1034605684472507;  q[ 4][ 8] = 1.5196756759380692;
	q[ 4][ 9] = 0.9126668032539315;  q[ 4][10] = 1.4081315998413697;
	q[ 4][11] = 0.3371091785647479;  q[ 4][12] = 1.2213054800811556;
	q[ 4][13] = 1.6953951980808002;  q[ 4][14] = 0.4326227078645523;
	q[ 4][15] = 3.6366815408744255;  q[ 4][16] = 1.7557065205837685;
	q[ 4][17] = 1.6275179891253113;  q[ 4][18] = 2.1579775140421025;
	q[ 4][19] = 2.2627456996290891;

	q[ 5][ 6] = 6.8124601839937675;  q[ 5][ 7] = 0.8776110594765502;
	q[ 5][ 8] = 7.9943228564946525;  q[ 5][ 9] = 0.4882733432879921;
	q[ 5][10] = 1.3318097154194044;  q[ 5][11] = 6.0519085243118811;
	q[ 5][12] = 1.9106190827629084;  q[ 5][13] = 0.3573432522499545;
	q[ 5][14] = 2.3019177728300728;  q[ 5][15] = 2.3193703643237220;
	q[ 5][16] = 2.1576510103471440;  q[ 5][17] = 0.8959082681546182;
	q[ 5][18] = 0.9183596801412757;  q[ 5][19] = 0.6366932501396869;

	q[ 6][ 7] = 1.3860121390169038;  q[ 6][ 8] = 1.6360079688522375;
	q[ 6][ 9] = 0.4035497929633328;  q[ 6][10] = 0.5610717242294755;
	q[ 6][11] = 4.3290086529582830;  q[ 6][12] = 0.7471936218068498;
	q[ 6][13] = 0.2317194387691585;  q[ 6][14] = 1.5132807416252063;
	q[ 6][15] = 1.8273535587773553;  q[ 6][16] = 1.5839981708584689;
	q[ 6][17] = 0.4198391148111098;  q[ 6][18] = 0.5818111331782764;
	q[ 6][19] = 0.8940572875547330;

	q[ 7][ 8] = 0.8561248973045037;  q[ 7][ 9] = 0.2888075033037488;
	q[ 7][10] = 0.3578662395745526;  q[ 7][11] = 0.8945563662345198;
	q[ 7][12] = 0.5954812791740037;  q[ 7][13] = 0.3693722640980460;
	q[ 7][14] = 0.7744933618134962;  q[ 7][15] = 3.0637776193717610;
	q[ 7][16] = 0.7147489676267383;  q[ 7][17] = 0.9349753595598769;
	q[ 7][18] = 0.3374467649724478;  q[ 7][19] = 0.6193321034173915;

	q[ 8][ 9] = 0.5787937115407940;  q[ 8][10] = 1.0765007949562073;
	q[ 8][11] = 1.8085136096039203;  q[ 8][12] = 1.3808291710019667;
	q[ 8][13] = 1.3629765501081097;  q[ 8][14] = 1.8370555852070649;
	q[ 8][15] = 1.9699895187387506;  q[ 8][16] = 1.6136654573285647;
	q[ 8][17] = 0.6301954684360302;  q[ 8][18] = 7.7587442309146040;
	q[ 8][19] = 0.5333220944030346;

	q[ 9][10] = 6.0019110258426362;  q[ 9][11] = 0.6244297525127139;
	q[ 9][12] = 6.7597899772045418;  q[ 9][13] = 2.2864286949316077;
	q[ 9][14] = 0.4811402387911145;  q[ 9][15] = 0.6047491507504744;
	q[ 9][16] = 2.6344778384442731;  q[ 9][17] = 0.5604648274060783;
	q[ 9][18] = 0.8626796044156272;  q[ 9][19] = 14.8729334615190609;

	q[10][11] = 0.5642322882556321;  q[10][12] = 8.0327792947421148;
	q[10][13] = 4.3611548063555778;  q[10][14] = 1.0084320519837335;
	q[10][15] = 0.8953754669269811;  q[10][16] = 1.0192004372506540;
	q[10][17] = 1.5183114434679339;  q[10][18] = 1.2452243224541324;
	q[10][19] = 3.5458093276667237;

	q[11][12] = 1.7129670976916258;  q[11][13] = 0.3910559903834828;
	q[11][14] = 1.3918935593582853;  q[11][15] = 1.9776630140912268;
	q[11][16] = 2.5513781312660280;  q[11][17] = 0.5851920879490173;
	q[11][18] = 0.7835447533710449;  q[11][19] = 0.7801080335991272;

	q[12][13] = 2.3201373546296349;  q[12][14] = 0.4953193808676289;
	q[12][15] = 1.0657482318076852;  q[12][16] = 3.3628488360462363;
	q[12][17] = 1.4680478689711018;  q[12][18] = 1.0899165770956820;
	q[12][19] = 4.0584577156753401;

	q[13][14] = 0.3746821107962129;  q[13][15] = 1.1079144700606407;
	q[13][16] = 0.6882725908872254;  q[13][17] = 3.3448437239772266;
	q[13][18] = 10.3848523331334590;  q[13][19] = 1.7039730522675411;

	q[14][15] = 3.5465914843628927;  q[14][16] = 1.9485376673137556;
	q[14][17] = 0.4326058001438786;  q[14][18] = 0.4819109019647465;
	q[14][19] = 0.5985498912985666;

	q[15][16] = 8.8479984061248178;  q[15][17] = 0.6791126595939816;
	q[15][18] = 0.9547229305958682;  q[15][19] = 0.9305232113028208;

	q[16][17] = 0.4514203099376473;  q[16][18] = 0.8564314184691215;
	q[16][19] = 3.4242218450865543;

	q[17][18] = 4.5377235790405388;  q[17][19] = 0.5658969249032649;

	q[18][19] = 1.0000000000000000;


} /* vt data */

