import { ActionIconProps, BoxProps, Factory, InputVariant, StylesApiProps } from '@mantine/core';
import { CalendarLevel, DateValue } from '../../types';
import { CalendarBaseProps, CalendarSettings, CalendarStylesNames } from '../Calendar';
import { DateInputSharedProps, PickerInputBaseStylesNames } from '../PickerInputBase';
import { TimeInputProps } from '../TimeInput';
export type DateTimePickerStylesNames = 'timeWrapper' | 'timeInput' | 'submitButton' | PickerInputBaseStylesNames | CalendarStylesNames;
export interface DateTimePickerProps extends BoxProps, Omit<DateInputSharedProps, 'classNames' | 'styles' | 'closeOnChange' | 'size' | 'valueFormatter'>, Omit<CalendarBaseProps, 'defaultDate'>, Omit<CalendarSettings, 'onYearMouseEnter' | 'onMonthMouseEnter' | 'hasNextLevel'>, StylesApiProps<DateTimePickerFactory> {
    /** Dayjs format to display input value, "DD/MM/YYYY HH:mm" by default  */
    valueFormat?: string;
    /** Controlled component value */
    value?: DateValue;
    /** Default value for uncontrolled component */
    defaultValue?: DateValue;
    /** Called when value changes */
    onChange?: (value: DateValue) => void;
    /** TimeInput component props */
    timeInputProps?: Omit<TimeInputProps, 'defaultValue' | 'value'> & {
        ref?: React.ComponentPropsWithRef<'input'>['ref'];
    };
    /** Props passed down to the submit button */
    submitButtonProps?: ActionIconProps & React.ComponentPropsWithoutRef<'button'>;
    /** Determines whether seconds input should be rendered */
    withSeconds?: boolean;
    /** Max level that user can go up to (decade, year, month), defaults to decade */
    maxLevel?: CalendarLevel;
}
export type DateTimePickerFactory = Factory<{
    props: DateTimePickerProps;
    ref: HTMLButtonElement;
    stylesNames: DateTimePickerStylesNames;
    variant: InputVariant;
}>;
export declare const DateTimePicker: import("@mantine/core").MantineComponent<{
    props: DateTimePickerProps;
    ref: HTMLButtonElement;
    stylesNames: DateTimePickerStylesNames;
    variant: InputVariant;
}>;
