package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUpgradeStatus invokes the cs.GetUpgradeStatus API synchronously
func (client *Client) GetUpgradeStatus(request *GetUpgradeStatusRequest) (response *GetUpgradeStatusResponse, err error) {
	response = CreateGetUpgradeStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetUpgradeStatusWithChan invokes the cs.GetUpgradeStatus API asynchronously
func (client *Client) GetUpgradeStatusWithChan(request *GetUpgradeStatusRequest) (<-chan *GetUpgradeStatusResponse, <-chan error) {
	responseChan := make(chan *GetUpgradeStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUpgradeStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUpgradeStatusWithCallback invokes the cs.GetUpgradeStatus API asynchronously
func (client *Client) GetUpgradeStatusWithCallback(request *GetUpgradeStatusRequest, callback func(response *GetUpgradeStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUpgradeStatusResponse
		var err error
		defer close(result)
		response, err = client.GetUpgradeStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUpgradeStatusRequest is the request struct for api GetUpgradeStatus
type GetUpgradeStatusRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// GetUpgradeStatusResponse is the response struct for api GetUpgradeStatus
type GetUpgradeStatusResponse struct {
	*responses.BaseResponse
	ErrorMessage     string       `json:"error_message" xml:"error_message"`
	PrecheckReportId string       `json:"precheck_report_id" xml:"precheck_report_id"`
	UpgradeStep      string       `json:"upgrade_step" xml:"upgrade_step"`
	Status           string       `json:"status" xml:"status"`
	UpgradeTask      Upgrade_task `json:"upgrade_task" xml:"upgrade_task"`
}

// CreateGetUpgradeStatusRequest creates a request to invoke GetUpgradeStatus API
func CreateGetUpgradeStatusRequest() (request *GetUpgradeStatusRequest) {
	request = &GetUpgradeStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "GetUpgradeStatus", "/api/v2/clusters/[ClusterId]/upgrade/status", "", "")
	request.Method = requests.GET
	return
}

// CreateGetUpgradeStatusResponse creates a response to parse from GetUpgradeStatus response
func CreateGetUpgradeStatusResponse() (response *GetUpgradeStatusResponse) {
	response = &GetUpgradeStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
