package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceServices invokes the eas.ListResourceServices API synchronously
func (client *Client) ListResourceServices(request *ListResourceServicesRequest) (response *ListResourceServicesResponse, err error) {
	response = CreateListResourceServicesResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceServicesWithChan invokes the eas.ListResourceServices API asynchronously
func (client *Client) ListResourceServicesWithChan(request *ListResourceServicesRequest) (<-chan *ListResourceServicesResponse, <-chan error) {
	responseChan := make(chan *ListResourceServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceServicesWithCallback invokes the eas.ListResourceServices API asynchronously
func (client *Client) ListResourceServicesWithCallback(request *ListResourceServicesRequest, callback func(response *ListResourceServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceServicesResponse
		var err error
		defer close(result)
		response, err = client.ListResourceServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceServicesRequest is the request struct for api ListResourceServices
type ListResourceServicesRequest struct {
	*requests.RoaRequest
	ResourceId string           `position:"Path" name:"ResourceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	ClusterId  string           `position:"Path" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListResourceServicesResponse is the response struct for api ListResourceServices
type ListResourceServicesResponse struct {
	*responses.BaseResponse
}

// CreateListResourceServicesRequest creates a request to invoke ListResourceServices API
func CreateListResourceServicesRequest() (request *ListResourceServicesRequest) {
	request = &ListResourceServicesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "ListResourceServices", "/api/v2/resources/[ClusterId]/[ResourceId]/services", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListResourceServicesResponse creates a response to parse from ListResourceServices response
func CreateListResourceServicesResponse() (response *ListResourceServicesResponse) {
	response = &ListResourceServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
