package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CountNodesByNodeGroupId invokes the linkwan.CountNodesByNodeGroupId API synchronously
func (client *Client) CountNodesByNodeGroupId(request *CountNodesByNodeGroupIdRequest) (response *CountNodesByNodeGroupIdResponse, err error) {
	response = CreateCountNodesByNodeGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// CountNodesByNodeGroupIdWithChan invokes the linkwan.CountNodesByNodeGroupId API asynchronously
func (client *Client) CountNodesByNodeGroupIdWithChan(request *CountNodesByNodeGroupIdRequest) (<-chan *CountNodesByNodeGroupIdResponse, <-chan error) {
	responseChan := make(chan *CountNodesByNodeGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CountNodesByNodeGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CountNodesByNodeGroupIdWithCallback invokes the linkwan.CountNodesByNodeGroupId API asynchronously
func (client *Client) CountNodesByNodeGroupIdWithCallback(request *CountNodesByNodeGroupIdRequest, callback func(response *CountNodesByNodeGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CountNodesByNodeGroupIdResponse
		var err error
		defer close(result)
		response, err = client.CountNodesByNodeGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CountNodesByNodeGroupIdRequest is the request struct for api CountNodesByNodeGroupId
type CountNodesByNodeGroupIdRequest struct {
	*requests.RpcRequest
	FuzzyDevEui string `position:"Query" name:"FuzzyDevEui"`
	NodeGroupId string `position:"Query" name:"NodeGroupId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// CountNodesByNodeGroupIdResponse is the response struct for api CountNodesByNodeGroupId
type CountNodesByNodeGroupIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCountNodesByNodeGroupIdRequest creates a request to invoke CountNodesByNodeGroupId API
func CreateCountNodesByNodeGroupIdRequest() (request *CountNodesByNodeGroupIdRequest) {
	request = &CountNodesByNodeGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "CountNodesByNodeGroupId", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCountNodesByNodeGroupIdResponse creates a response to parse from CountNodesByNodeGroupId response
func CreateCountNodesByNodeGroupIdResponse() (response *CountNodesByNodeGroupIdResponse) {
	response = &CountNodesByNodeGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
