package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventMonitorList invokes the retailcloud.DescribeEventMonitorList API synchronously
func (client *Client) DescribeEventMonitorList(request *DescribeEventMonitorListRequest) (response *DescribeEventMonitorListResponse, err error) {
	response = CreateDescribeEventMonitorListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventMonitorListWithChan invokes the retailcloud.DescribeEventMonitorList API asynchronously
func (client *Client) DescribeEventMonitorListWithChan(request *DescribeEventMonitorListRequest) (<-chan *DescribeEventMonitorListResponse, <-chan error) {
	responseChan := make(chan *DescribeEventMonitorListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventMonitorList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventMonitorListWithCallback invokes the retailcloud.DescribeEventMonitorList API asynchronously
func (client *Client) DescribeEventMonitorListWithCallback(request *DescribeEventMonitorListRequest, callback func(response *DescribeEventMonitorListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventMonitorListResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventMonitorList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventMonitorListRequest is the request struct for api DescribeEventMonitorList
type DescribeEventMonitorListRequest struct {
	*requests.RpcRequest
	EventLevel string           `position:"Query" name:"EventLevel"`
	AppId      requests.Integer `position:"Query" name:"AppId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PodName    string           `position:"Query" name:"PodName"`
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	EventType  string           `position:"Query" name:"EventType"`
	EnvId      requests.Integer `position:"Query" name:"EnvId"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	PageNum    requests.Integer `position:"Query" name:"PageNum"`
}

// DescribeEventMonitorListResponse is the response struct for api DescribeEventMonitorList
type DescribeEventMonitorListResponse struct {
	*responses.BaseResponse
	Code       int         `json:"Code" xml:"Code"`
	ErrorMsg   string      `json:"ErrorMsg" xml:"ErrorMsg"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int         `json:"PageSize" xml:"PageSize"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int64       `json:"TotalCount" xml:"TotalCount"`
	Data       []EventInfo `json:"Data" xml:"Data"`
}

// CreateDescribeEventMonitorListRequest creates a request to invoke DescribeEventMonitorList API
func CreateDescribeEventMonitorListRequest() (request *DescribeEventMonitorListRequest) {
	request = &DescribeEventMonitorListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DescribeEventMonitorList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEventMonitorListResponse creates a response to parse from DescribeEventMonitorList response
func CreateDescribeEventMonitorListResponse() (response *DescribeEventMonitorListResponse) {
	response = &DescribeEventMonitorListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
