package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagStaticRouteList invokes the smartag.DescribeSagStaticRouteList API synchronously
func (client *Client) DescribeSagStaticRouteList(request *DescribeSagStaticRouteListRequest) (response *DescribeSagStaticRouteListResponse, err error) {
	response = CreateDescribeSagStaticRouteListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagStaticRouteListWithChan invokes the smartag.DescribeSagStaticRouteList API asynchronously
func (client *Client) DescribeSagStaticRouteListWithChan(request *DescribeSagStaticRouteListRequest) (<-chan *DescribeSagStaticRouteListResponse, <-chan error) {
	responseChan := make(chan *DescribeSagStaticRouteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagStaticRouteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagStaticRouteListWithCallback invokes the smartag.DescribeSagStaticRouteList API asynchronously
func (client *Client) DescribeSagStaticRouteListWithCallback(request *DescribeSagStaticRouteListRequest, callback func(response *DescribeSagStaticRouteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagStaticRouteListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagStaticRouteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagStaticRouteListRequest is the request struct for api DescribeSagStaticRouteList
type DescribeSagStaticRouteListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DescribeSagStaticRouteListResponse is the response struct for api DescribeSagStaticRouteList
type DescribeSagStaticRouteListResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	StaticRoutes []StaticRoute `json:"StaticRoutes" xml:"StaticRoutes"`
	TaskStates   []TaskState   `json:"TaskStates" xml:"TaskStates"`
}

// CreateDescribeSagStaticRouteListRequest creates a request to invoke DescribeSagStaticRouteList API
func CreateDescribeSagStaticRouteListRequest() (request *DescribeSagStaticRouteListRequest) {
	request = &DescribeSagStaticRouteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagStaticRouteList", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagStaticRouteListResponse creates a response to parse from DescribeSagStaticRouteList response
func CreateDescribeSagStaticRouteListResponse() (response *DescribeSagStaticRouteListResponse) {
	response = &DescribeSagStaticRouteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
