IF(${CMAKE_BUILD_TYPE} MATCHES "Release" AND MINGW)
  INCLUDE(FindSelfPackers)
  IF(SELF_PACKER_FOR_EXECUTABLE)
    message(STATUS "Found ${SELF_PACKER_FOR_EXECUTABLE}, using it for compression")
  ELSE()
    message(WARNING "Did not find 'upx', binaries will not be packed")
  ENDIF()

  MACRO(PACK_EXECUTABLE _target _targetpath)
    IF(SELF_PACKER_FOR_EXECUTABLE)
        ADD_CUSTOM_COMMAND(TARGET ${_target} POST_BUILD COMMAND ${SELF_PACKER_FOR_EXECUTABLE} ${SELF_PACKER_FOR_EXECUTABLE_FLAGS} ${_targetpath} VERBATIM)
    ENDIF()
  ENDMACRO()

  MACRO(PACK_LIBRARY _target _targetpath)
    IF(SELF_PACKER_FOR_SHARED_LIB)
        ADD_CUSTOM_COMMAND(TARGET ${_target} POST_BUILD COMMAND ${SELF_PACKER_FOR_SHARED_LIB} ${SELF_PACKER_FOR_SHARED_LIB_FLAGS} ${_targetpath} VERBATIM)
    ENDIF()
  ENDMACRO()
ELSE(${CMAKE_BUILD_TYPE} MATCHES "Release")
#Do not pack when build type is not Release
  MACRO(PACK_EXECUTABLE _target _targetpath)
  ENDMACRO()
  MACRO(PACK_LIBRARY _target _targetpath)
  ENDMACRO()
ENDIF()
