package workspaces

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/machinelearning/mgmt/2019-10-01/workspaces"

// ErrorResponse the error response send when an operation fails.
type ErrorResponse struct {
	// Code - error code
	Code *string `json:"code,omitempty"`
	// Message - error message
	Message *string `json:"message,omitempty"`
}

// KeysResponse workspace authorization keys for a workspace.
type KeysResponse struct {
	autorest.Response `json:"-"`
	// PrimaryToken - Primary authorization key for this workspace.
	PrimaryToken *string `json:"primaryToken,omitempty"`
	// SecondaryToken - Secondary authorization key for this workspace.
	SecondaryToken *string `json:"secondaryToken,omitempty"`
}

// ListResult the result of a request to list machine learning workspace keys.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of Workspace values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of Workspace values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []Workspace {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// Operation azure Machine Learning Studio REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display name of operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display name of operation
type OperationDisplay struct {
	// Provider - The resource provider name: Microsoft.MachineLearning
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult an array of operations supported by the resource provider.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of AML Studio operations supported by the AML Studio resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// Properties the properties of a machine learning workspace.
type Properties struct {
	// UserStorageAccountID - The fully qualified arm id of the storage account associated with this workspace.
	UserStorageAccountID *string `json:"userStorageAccountId,omitempty"`
	// OwnerEmail - The email id of the owner for this workspace.
	OwnerEmail *string `json:"ownerEmail,omitempty"`
	// WorkspaceType - READ-ONLY; The type of this workspace. Possible values include: 'Production', 'Free', 'Anonymous', 'PaidStandard', 'PaidPremium'
	WorkspaceType WorkspaceType `json:"workspaceType,omitempty"`
	// WorkspaceState - READ-ONLY; The current state of workspace resource. Possible values include: 'Deleted', 'Enabled', 'Disabled', 'Migrated', 'Updated', 'Registered', 'Unregistered'
	WorkspaceState State `json:"workspaceState,omitempty"`
	// WorkspaceID - READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// CreationTime - READ-ONLY; The creation time for this workspace resource.
	CreationTime *string `json:"creationTime,omitempty"`
	// StudioEndpoint - READ-ONLY; The regional endpoint for the machine learning studio service which hosts this workspace.
	StudioEndpoint *string `json:"studioEndpoint,omitempty"`
	// KeyVaultIdentifierID - The key vault identifier used for encrypted workspaces.
	KeyVaultIdentifierID *string `json:"keyVaultIdentifierId,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.UserStorageAccountID != nil {
		objectMap["userStorageAccountId"] = p.UserStorageAccountID
	}
	if p.OwnerEmail != nil {
		objectMap["ownerEmail"] = p.OwnerEmail
	}
	if p.KeyVaultIdentifierID != nil {
		objectMap["keyVaultIdentifierId"] = p.KeyVaultIdentifierID
	}
	return json.Marshal(objectMap)
}

// PropertiesUpdateParameters the parameters for updating the properties of a machine learning workspace.
type PropertiesUpdateParameters struct {
	// WorkspaceState - The current state of workspace resource. Possible values include: 'Deleted', 'Enabled', 'Disabled', 'Migrated', 'Updated', 'Registered', 'Unregistered'
	WorkspaceState State `json:"workspaceState,omitempty"`
	// KeyVaultIdentifierID - The key vault identifier used for encrypted workspaces.
	KeyVaultIdentifierID *string `json:"keyVaultIdentifierId,omitempty"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// Sku sku of the resource
type Sku struct {
	// Name - Name of the sku
	Name *string `json:"name,omitempty"`
	// Tier - Tier of the sku like Basic or Enterprise
	Tier *string `json:"tier,omitempty"`
}

// UpdateParameters the parameters for updating a machine learning workspace.
type UpdateParameters struct {
	// Tags - The resource tags for the machine learning workspace.
	Tags map[string]*string `json:"tags"`
	// PropertiesUpdateParameters - The properties that the machine learning workspace will be updated with.
	*PropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateParameters.
func (up UpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Tags != nil {
		objectMap["tags"] = up.Tags
	}
	if up.PropertiesUpdateParameters != nil {
		objectMap["properties"] = up.PropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateParameters struct.
func (up *UpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				up.Tags = tags
			}
		case "properties":
			if v != nil {
				var propertiesUpdateParameters PropertiesUpdateParameters
				err = json.Unmarshal(*v, &propertiesUpdateParameters)
				if err != nil {
					return err
				}
				up.PropertiesUpdateParameters = &propertiesUpdateParameters
			}
		}
	}

	return nil
}

// Workspace an object that represents a machine learning workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// Properties - The properties of the machine learning workspace.
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.Properties != nil {
		objectMap["properties"] = w.Properties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Sku != nil {
		objectMap["sku"] = w.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				w.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				w.Sku = &sku
			}
		}
	}

	return nil
}
