package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ManagedInstancePrivateLinkResourcesClient is the the Azure SQL Database management API provides a RESTful set of web
// services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type ManagedInstancePrivateLinkResourcesClient struct {
	BaseClient
}

// NewManagedInstancePrivateLinkResourcesClient creates an instance of the ManagedInstancePrivateLinkResourcesClient
// client.
func NewManagedInstancePrivateLinkResourcesClient(subscriptionID string) ManagedInstancePrivateLinkResourcesClient {
	return NewManagedInstancePrivateLinkResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewManagedInstancePrivateLinkResourcesClientWithBaseURI creates an instance of the
// ManagedInstancePrivateLinkResourcesClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewManagedInstancePrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) ManagedInstancePrivateLinkResourcesClient {
	return ManagedInstancePrivateLinkResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets a private link resource for SQL server.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// managedInstanceName - the name of the managed instance.
// groupName - the name of the private link resource.
func (client ManagedInstancePrivateLinkResourcesClient) Get(ctx context.Context, resourceGroupName string, managedInstanceName string, groupName string) (result ManagedInstancePrivateLink, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateLinkResourcesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, managedInstanceName, groupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ManagedInstancePrivateLinkResourcesClient) GetPreparer(ctx context.Context, resourceGroupName string, managedInstanceName string, groupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":           autorest.Encode("path", groupName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/privateLinkResources/{groupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedInstancePrivateLinkResourcesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ManagedInstancePrivateLinkResourcesClient) GetResponder(resp *http.Response) (result ManagedInstancePrivateLink, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByManagedInstance gets the private link resources for SQL server.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// managedInstanceName - the name of the managed instance.
func (client ManagedInstancePrivateLinkResourcesClient) ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result ManagedInstancePrivateLinkListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateLinkResourcesClient.ListByManagedInstance")
		defer func() {
			sc := -1
			if result.mipllr.Response.Response != nil {
				sc = result.mipllr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByManagedInstanceNextResults
	req, err := client.ListByManagedInstancePreparer(ctx, resourceGroupName, managedInstanceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "ListByManagedInstance", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByManagedInstanceSender(req)
	if err != nil {
		result.mipllr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "ListByManagedInstance", resp, "Failure sending request")
		return
	}

	result.mipllr, err = client.ListByManagedInstanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "ListByManagedInstance", resp, "Failure responding to request")
		return
	}
	if result.mipllr.hasNextLink() && result.mipllr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByManagedInstancePreparer prepares the ListByManagedInstance request.
func (client ManagedInstancePrivateLinkResourcesClient) ListByManagedInstancePreparer(ctx context.Context, resourceGroupName string, managedInstanceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/privateLinkResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByManagedInstanceSender sends the ListByManagedInstance request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedInstancePrivateLinkResourcesClient) ListByManagedInstanceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByManagedInstanceResponder handles the response to the ListByManagedInstance request. The method always
// closes the http.Response Body.
func (client ManagedInstancePrivateLinkResourcesClient) ListByManagedInstanceResponder(resp *http.Response) (result ManagedInstancePrivateLinkListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByManagedInstanceNextResults retrieves the next set of results, if any.
func (client ManagedInstancePrivateLinkResourcesClient) listByManagedInstanceNextResults(ctx context.Context, lastResults ManagedInstancePrivateLinkListResult) (result ManagedInstancePrivateLinkListResult, err error) {
	req, err := lastResults.managedInstancePrivateLinkListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "listByManagedInstanceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByManagedInstanceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "listByManagedInstanceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByManagedInstanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateLinkResourcesClient", "listByManagedInstanceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByManagedInstanceComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagedInstancePrivateLinkResourcesClient) ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result ManagedInstancePrivateLinkListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateLinkResourcesClient.ListByManagedInstance")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByManagedInstance(ctx, resourceGroupName, managedInstanceName)
	return
}
