/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolTableTruncateSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.utils.CommonUtils;

public class PostgreToolTableTruncate
extends PostgreToolWithStatus<PostgreTableBase, PostgreToolTableTruncateSettings> {
    private static final Log log = Log.getLog(PostgreToolTableTruncate.class);

    @NotNull
    public PostgreToolTableTruncateSettings createToolSettings() {
        return new PostgreToolTableTruncateSettings();
    }

    public void generateObjectQueries(DBCSession session, PostgreToolTableTruncateSettings settings, List<DBEPersistAction> queries, PostgreTableBase table) throws DBCException {
        if (settings.isRunning()) {
            this.commitChanges(session);
        }
        PostgreServerExtension serverType = ((PostgreDataSource)table.getDataSource()).getServerType();
        Object sql = "TRUNCATE TABLE";
        if (settings.isOnly() && CommonUtils.isBitSet((int)serverType.getTruncateToolModes(), (int)1)) {
            sql = (String)sql + " ONLY";
        }
        sql = (String)sql + " " + table.getFullyQualifiedName(DBPEvaluationContext.DDL);
        if (CommonUtils.isBitSet((int)serverType.getTruncateToolModes(), (int)2)) {
            sql = settings.isRestarting() ? (String)sql + " RESTART IDENTITY" : (String)sql + " CONTINUE IDENTITY";
        }
        if (CommonUtils.isBitSet((int)serverType.getTruncateToolModes(), (int)4)) {
            sql = settings.isCascading() ? (String)sql + " CASCADE" : (String)sql + " RESTRICT";
        }
        queries.add((DBEPersistAction)new SQLDatabasePersistAction((String)sql));
    }

    private void commitChanges(DBCSession session) {
        try {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && !txnManager.isAutoCommit()) {
                txnManager.commit(session);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error committing transactions", e);
        }
    }

    public boolean needsRefreshOnFinish() {
        return true;
    }
}

