// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"
)

// GetBindPeerHandlerFunc turns a function with the right signature into a get bind peer handler
type GetBindPeerHandlerFunc func(GetBindPeerParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn GetBindPeerHandlerFunc) Handle(params GetBindPeerParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// GetBindPeerHandler interface for that can handle valid get bind peer params
type GetBindPeerHandler interface {
	Handle(GetBindPeerParams, interface{}) middleware.Responder
}

// NewGetBindPeer creates a new http.Handler for the get bind peer operation
func NewGetBindPeer(ctx *middleware.Context, handler GetBindPeerHandler) *GetBindPeer {
	return &GetBindPeer{Context: ctx, Handler: handler}
}

/*
	GetBindPeer swagger:route GET /services/haproxy/configuration/peers/{parent_name}/binds/{name} Bind getBindPeer

# Return one bind

Returns one bind configuration by it's name in the specified frontend.
*/
type GetBindPeer struct {
	Context *middleware.Context
	Handler GetBindPeerHandler
}

func (o *GetBindPeer) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetBindPeerParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
