// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateLogTargetBackendCreatedCode is the HTTP code returned for type CreateLogTargetBackendCreated
const CreateLogTargetBackendCreatedCode int = 201

/*
CreateLogTargetBackendCreated Log Target created

swagger:response createLogTargetBackendCreated
*/
type CreateLogTargetBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetBackendCreated creates CreateLogTargetBackendCreated with default headers values
func NewCreateLogTargetBackendCreated() *CreateLogTargetBackendCreated {

	return &CreateLogTargetBackendCreated{}
}

// WithPayload adds the payload to the create log target backend created response
func (o *CreateLogTargetBackendCreated) WithPayload(payload *models.LogTarget) *CreateLogTargetBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target backend created response
func (o *CreateLogTargetBackendCreated) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetBackendAcceptedCode is the HTTP code returned for type CreateLogTargetBackendAccepted
const CreateLogTargetBackendAcceptedCode int = 202

/*
CreateLogTargetBackendAccepted Configuration change accepted and reload requested

swagger:response createLogTargetBackendAccepted
*/
type CreateLogTargetBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetBackendAccepted creates CreateLogTargetBackendAccepted with default headers values
func NewCreateLogTargetBackendAccepted() *CreateLogTargetBackendAccepted {

	return &CreateLogTargetBackendAccepted{}
}

// WithReloadID adds the reloadId to the create log target backend accepted response
func (o *CreateLogTargetBackendAccepted) WithReloadID(reloadID string) *CreateLogTargetBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create log target backend accepted response
func (o *CreateLogTargetBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create log target backend accepted response
func (o *CreateLogTargetBackendAccepted) WithPayload(payload *models.LogTarget) *CreateLogTargetBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target backend accepted response
func (o *CreateLogTargetBackendAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetBackendBadRequestCode is the HTTP code returned for type CreateLogTargetBackendBadRequest
const CreateLogTargetBackendBadRequestCode int = 400

/*
CreateLogTargetBackendBadRequest Bad request

swagger:response createLogTargetBackendBadRequest
*/
type CreateLogTargetBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetBackendBadRequest creates CreateLogTargetBackendBadRequest with default headers values
func NewCreateLogTargetBackendBadRequest() *CreateLogTargetBackendBadRequest {

	return &CreateLogTargetBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target backend bad request response
func (o *CreateLogTargetBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateLogTargetBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target backend bad request response
func (o *CreateLogTargetBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target backend bad request response
func (o *CreateLogTargetBackendBadRequest) WithPayload(payload *models.Error) *CreateLogTargetBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target backend bad request response
func (o *CreateLogTargetBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetBackendConflictCode is the HTTP code returned for type CreateLogTargetBackendConflict
const CreateLogTargetBackendConflictCode int = 409

/*
CreateLogTargetBackendConflict The specified resource already exists

swagger:response createLogTargetBackendConflict
*/
type CreateLogTargetBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetBackendConflict creates CreateLogTargetBackendConflict with default headers values
func NewCreateLogTargetBackendConflict() *CreateLogTargetBackendConflict {

	return &CreateLogTargetBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target backend conflict response
func (o *CreateLogTargetBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateLogTargetBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target backend conflict response
func (o *CreateLogTargetBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target backend conflict response
func (o *CreateLogTargetBackendConflict) WithPayload(payload *models.Error) *CreateLogTargetBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target backend conflict response
func (o *CreateLogTargetBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateLogTargetBackendDefault General Error

swagger:response createLogTargetBackendDefault
*/
type CreateLogTargetBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetBackendDefault creates CreateLogTargetBackendDefault with default headers values
func NewCreateLogTargetBackendDefault(code int) *CreateLogTargetBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateLogTargetBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create log target backend default response
func (o *CreateLogTargetBackendDefault) WithStatusCode(code int) *CreateLogTargetBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create log target backend default response
func (o *CreateLogTargetBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create log target backend default response
func (o *CreateLogTargetBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateLogTargetBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target backend default response
func (o *CreateLogTargetBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target backend default response
func (o *CreateLogTargetBackendDefault) WithPayload(payload *models.Error) *CreateLogTargetBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target backend default response
func (o *CreateLogTargetBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
