// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetServerBackendOKCode is the HTTP code returned for type GetServerBackendOK
const GetServerBackendOKCode int = 200

/*
GetServerBackendOK Successful operation

swagger:response getServerBackendOK
*/
type GetServerBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewGetServerBackendOK creates GetServerBackendOK with default headers values
func NewGetServerBackendOK() *GetServerBackendOK {

	return &GetServerBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get server backend o k response
func (o *GetServerBackendOK) WithConfigurationVersion(configurationVersion string) *GetServerBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server backend o k response
func (o *GetServerBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server backend o k response
func (o *GetServerBackendOK) WithPayload(payload *models.Server) *GetServerBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server backend o k response
func (o *GetServerBackendOK) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetServerBackendNotFoundCode is the HTTP code returned for type GetServerBackendNotFound
const GetServerBackendNotFoundCode int = 404

/*
GetServerBackendNotFound The specified resource was not found

swagger:response getServerBackendNotFound
*/
type GetServerBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerBackendNotFound creates GetServerBackendNotFound with default headers values
func NewGetServerBackendNotFound() *GetServerBackendNotFound {

	return &GetServerBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get server backend not found response
func (o *GetServerBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetServerBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server backend not found response
func (o *GetServerBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server backend not found response
func (o *GetServerBackendNotFound) WithPayload(payload *models.Error) *GetServerBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server backend not found response
func (o *GetServerBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetServerBackendDefault General Error

swagger:response getServerBackendDefault
*/
type GetServerBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerBackendDefault creates GetServerBackendDefault with default headers values
func NewGetServerBackendDefault(code int) *GetServerBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetServerBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get server backend default response
func (o *GetServerBackendDefault) WithStatusCode(code int) *GetServerBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get server backend default response
func (o *GetServerBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get server backend default response
func (o *GetServerBackendDefault) WithConfigurationVersion(configurationVersion string) *GetServerBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server backend default response
func (o *GetServerBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server backend default response
func (o *GetServerBackendDefault) WithPayload(payload *models.Error) *GetServerBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server backend default response
func (o *GetServerBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
