// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllTCPCheckDefaultsOKCode is the HTTP code returned for type GetAllTCPCheckDefaultsOK
const GetAllTCPCheckDefaultsOKCode int = 200

/*
GetAllTCPCheckDefaultsOK Successful operation

swagger:response getAllTcpCheckDefaultsOK
*/
type GetAllTCPCheckDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.TCPChecks `json:"body,omitempty"`
}

// NewGetAllTCPCheckDefaultsOK creates GetAllTCPCheckDefaultsOK with default headers values
func NewGetAllTCPCheckDefaultsOK() *GetAllTCPCheckDefaultsOK {

	return &GetAllTCPCheckDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Tcp check defaults o k response
func (o *GetAllTCPCheckDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetAllTCPCheckDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Tcp check defaults o k response
func (o *GetAllTCPCheckDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Tcp check defaults o k response
func (o *GetAllTCPCheckDefaultsOK) WithPayload(payload models.TCPChecks) *GetAllTCPCheckDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Tcp check defaults o k response
func (o *GetAllTCPCheckDefaultsOK) SetPayload(payload models.TCPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPCheckDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllTCPCheckDefaultsDefault General Error

swagger:response getAllTcpCheckDefaultsDefault
*/
type GetAllTCPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllTCPCheckDefaultsDefault creates GetAllTCPCheckDefaultsDefault with default headers values
func NewGetAllTCPCheckDefaultsDefault(code int) *GetAllTCPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllTCPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all TCP check defaults default response
func (o *GetAllTCPCheckDefaultsDefault) WithStatusCode(code int) *GetAllTCPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all TCP check defaults default response
func (o *GetAllTCPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all TCP check defaults default response
func (o *GetAllTCPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetAllTCPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all TCP check defaults default response
func (o *GetAllTCPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all TCP check defaults default response
func (o *GetAllTCPCheckDefaultsDefault) WithPayload(payload *models.Error) *GetAllTCPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all TCP check defaults default response
func (o *GetAllTCPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
