// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllBindPeerOKCode is the HTTP code returned for type GetAllBindPeerOK
const GetAllBindPeerOKCode int = 200

/*
GetAllBindPeerOK Successful operation

swagger:response getAllBindPeerOK
*/
type GetAllBindPeerOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Binds `json:"body,omitempty"`
}

// NewGetAllBindPeerOK creates GetAllBindPeerOK with default headers values
func NewGetAllBindPeerOK() *GetAllBindPeerOK {

	return &GetAllBindPeerOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all bind peer o k response
func (o *GetAllBindPeerOK) WithConfigurationVersion(configurationVersion string) *GetAllBindPeerOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all bind peer o k response
func (o *GetAllBindPeerOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all bind peer o k response
func (o *GetAllBindPeerOK) WithPayload(payload models.Binds) *GetAllBindPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all bind peer o k response
func (o *GetAllBindPeerOK) SetPayload(payload models.Binds) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllBindPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Binds{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllBindPeerDefault General Error

swagger:response getAllBindPeerDefault
*/
type GetAllBindPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllBindPeerDefault creates GetAllBindPeerDefault with default headers values
func NewGetAllBindPeerDefault(code int) *GetAllBindPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllBindPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all bind peer default response
func (o *GetAllBindPeerDefault) WithStatusCode(code int) *GetAllBindPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all bind peer default response
func (o *GetAllBindPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all bind peer default response
func (o *GetAllBindPeerDefault) WithConfigurationVersion(configurationVersion string) *GetAllBindPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all bind peer default response
func (o *GetAllBindPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all bind peer default response
func (o *GetAllBindPeerDefault) WithPayload(payload *models.Error) *GetAllBindPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all bind peer default response
func (o *GetAllBindPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllBindPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
