/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class TailIterator<T extends Item<?>>
implements SequenceIterator<T>,
LastPositionFinder,
LookaheadIterator<T> {
    private SequenceIterator<T> base;
    private int start;

    private TailIterator(SequenceIterator<T> base, int start) {
        this.base = base;
        this.start = start;
    }

    public static <T extends Item<?>> SequenceIterator<T> make(SequenceIterator<T> base, int start) throws XPathException {
        if (start <= 1) {
            return base;
        }
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(start, Integer.MAX_VALUE);
        }
        if ((base.getProperties() & 1) != 0) {
            GroundedValue<T> value = base.materialize();
            if (start > value.getLength()) {
                return EmptyIterator.emptyIterator();
            }
            return new ValueTailIterator<T>(value, start - 1);
        }
        for (int i = 0; i < start - 1; ++i) {
            T b = base.next();
            if (b != null) continue;
            return EmptyIterator.emptyIterator();
        }
        return new TailIterator<T>(base, start);
    }

    @Override
    public T next() throws XPathException {
        return this.base.next();
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public int getLength() throws XPathException {
        int bl = ((LastPositionFinder)((Object)this.base)).getLength() - this.start + 1;
        return bl > 0 ? bl : 0;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public int getProperties() {
        return this.base.getProperties() & 6;
    }
}

