/* $Id: init.c,v 1.5 2005/09/06 15:10:26 cegger Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 2004 Chriatoph Egger

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "quartzwmh.h"

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32_t *dlret)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);
	ggi_quartz_priv *qzpriv = QUARTZ_PRIV(vis);


	priv->move     = GGIwmh_quartz_move;
	priv->resize   = GGIwmh_quartz_resize;
	priv->getpos   = GGIwmh_quartz_getpos;
	priv->getsize  = GGIwmh_quartz_getsize;
	priv->settitle = GGIwmh_quartz_settitle;
	priv->maximize = GGIwmh_quartz_maximize;
	priv->zorder   = GGIwmh_quartz_zorder;
	priv->iconify  = GGIwmh_quartz_iconify;
	priv->moveicon = GGIwmh_quartz_moveicon;
	priv->seticontitle = GGIwmh_quartz_seticontitle;
	priv->allowresize  = GGIwmh_quartz_allowresize;

#if 0
	enableResize(vis);
#endif

	*dlret = GGI_DL_EXTENSION | GGI_DL_OPDISPLAY;
	return 0;
}

EXPORTFUNC
int WMHdl_quartz_wmh(int func, void **funcptr);

int WMHdl_quartz_wmh(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = (void *)GGIopen;
		return 0;
	case GGIFUNC_exit:
	case GGIFUNC_close:
		*funcptr = NULL;
		return 0;
	default:
		*funcptr = NULL;
	}

	return GGI_ENOTFOUND;
}

#include <ggi/internal/ggidlinit.h>
