/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.EagerForeignCollection;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.dao.LazyForeignCollection;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.VoidType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.mapped.MappedQueryForId;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldType {
    public static final String FOREIGN_ID_FIELD_SUFFIX = "_id";
    private static boolean DEFAULT_VALUE_BOOLEAN;
    private static byte DEFAULT_VALUE_BYTE;
    private static char DEFAULT_VALUE_CHAR;
    private static short DEFAULT_VALUE_SHORT;
    private static int DEFAULT_VALUE_INT;
    private static long DEFAULT_VALUE_LONG;
    private static float DEFAULT_VALUE_FLOAT;
    private static double DEFAULT_VALUE_DOUBLE;
    private final ConnectionSource connectionSource;
    private final String tableName;
    private final Field field;
    private final String columnName;
    private final DatabaseFieldConfig fieldConfig;
    private final boolean isId;
    private final boolean isGeneratedId;
    private final String generatedIdSequence;
    private final Method fieldGetMethod;
    private final Method fieldSetMethod;
    private final Class<?> parentClass;
    private DataPersister dataPersister;
    private Object defaultValue;
    private Object dataTypeConfigObj;
    private FieldConverter fieldConverter;
    private FieldType foreignIdField;
    private TableInfo<?, ?> foreignTableInfo;
    private FieldType foreignFieldType;
    private BaseDaoImpl<?, ?> foreignDao;
    private MappedQueryForId<Object, Object> mappedQueryForId;
    private static final ThreadLocal<LevelCounters> threadLevelCounters;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldType(ConnectionSource connectionSource, String tableName, Field field, DatabaseFieldConfig fieldConfig, Class<?> parentClass) throws SQLException {
        DataPersister dataPersister;
        Class<?> clazz;
        DatabaseType databaseType;
        block46: {
            block45: {
                this.connectionSource = connectionSource;
                this.tableName = tableName;
                databaseType = connectionSource.getDatabaseType();
                this.field = field;
                this.parentClass = parentClass;
                fieldConfig.postProcess();
                clazz = field.getType();
                if (fieldConfig.getDataPersister() != null) break block45;
                Class<? extends DataPersister> persisterClass = fieldConfig.getPersisterClass();
                if (persisterClass == null || persisterClass == VoidType.class) {
                    dataPersister = DataPersisterManager.lookupForField(field);
                    break block46;
                } else {
                    Object result;
                    Method method;
                    try {
                        method = persisterClass.getDeclaredMethod("getSingleton", new Class[0]);
                    }
                    catch (Exception e) {
                        throw SqlExceptionUtil.create("Could not find getSingleton static method on class " + persisterClass, e);
                    }
                    try {
                        result = method.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw SqlExceptionUtil.create("Could not run getSingleton method on class " + persisterClass, e.getTargetException());
                    }
                    catch (Exception e) {
                        throw SqlExceptionUtil.create("Could not run getSingleton method on class " + persisterClass, e);
                    }
                    if (result == null) {
                        throw new SQLException("Static getSingleton method should not return null on class " + persisterClass);
                    }
                    try {
                        dataPersister = (DataPersister)result;
                    }
                    catch (Exception e) {
                        throw SqlExceptionUtil.create("Could not cast result of static getSingleton method to DataPersister from class " + persisterClass, e);
                    }
                }
            }
            dataPersister = fieldConfig.getDataPersister();
            if (!dataPersister.isValidForField(field)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Field class ").append(clazz.getName());
                sb.append(" for field ").append(this);
                sb.append(" is not valid for type ").append(dataPersister);
                Class<?> primaryClass = dataPersister.getPrimaryClass();
                if (primaryClass != null) {
                    sb.append(", maybe should be " + primaryClass);
                }
                throw new IllegalArgumentException(sb.toString());
            }
        }
        String foreignColumnName = fieldConfig.getForeignColumnName();
        String defaultFieldName = field.getName();
        if (fieldConfig.isForeign() || fieldConfig.isForeignAutoRefresh() || foreignColumnName != null) {
            if (dataPersister != null && dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + clazz + " but marked as foreign");
            }
            defaultFieldName = foreignColumnName == null ? defaultFieldName + FOREIGN_ID_FIELD_SUFFIX : defaultFieldName + "_" + foreignColumnName;
            if (ForeignCollection.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field '" + field.getName() + "' in class " + clazz + "' should use the @" + ForeignCollectionField.class.getSimpleName() + " annotation not foreign=true");
            }
        } else if (fieldConfig.isForeignCollection()) {
            if (clazz != Collection.class && !ForeignCollection.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be of class " + ForeignCollection.class.getSimpleName() + " or Collection.");
            }
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection.");
            }
            Type[] genericArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (genericArguments.length == 0) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
        } else if (dataPersister == null && !fieldConfig.isForeignCollection()) {
            if (byte[].class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite does not know how to store " + clazz + " for field '" + field.getName() + "'. byte[] fields must specify dataType=DataType.BYTE_ARRAY or SERIALIZABLE");
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite does not know how to store " + clazz + " for field '" + field.getName() + "'.  Use another class, custom persister, or to serialize it use " + "dataType=DataType.SERIALIZABLE");
            }
            throw new IllegalArgumentException("ORMLite does not know how to store " + clazz + " for field " + field.getName() + ". Use another class or a custom persister.");
        }
        this.columnName = fieldConfig.getColumnName() == null ? defaultFieldName : fieldConfig.getColumnName();
        this.fieldConfig = fieldConfig;
        if (fieldConfig.isId()) {
            if (fieldConfig.isGeneratedId() || fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        } else if (fieldConfig.isGeneratedId()) {
            if (fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = true;
            this.generatedIdSequence = databaseType.isIdSequenceNeeded() ? databaseType.generateIdSequenceName(tableName, this) : null;
        } else if (fieldConfig.getGeneratedIdSequence() != null) {
            this.isId = true;
            this.isGeneratedId = true;
            String seqName = fieldConfig.getGeneratedIdSequence();
            if (databaseType.isEntityNamesMustBeUpCase()) {
                seqName = seqName.toUpperCase();
            }
            this.generatedIdSequence = seqName;
        } else {
            this.isId = false;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        }
        if (this.isId && (fieldConfig.isForeign() || fieldConfig.isForeignAutoRefresh())) {
            throw new IllegalArgumentException("Id field " + field.getName() + " cannot also be a foreign object");
        }
        if (fieldConfig.isUseGetSet()) {
            this.fieldGetMethod = DatabaseFieldConfig.findGetMethod(field, true);
            this.fieldSetMethod = DatabaseFieldConfig.findSetMethod(field, true);
        } else {
            if (!field.isAccessible()) {
                try {
                    this.field.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("Could not open access to field " + field.getName() + ".  You may have to set useGetSet=true to fix.");
                }
            }
            this.fieldGetMethod = null;
            this.fieldSetMethod = null;
        }
        if (fieldConfig.isAllowGeneratedIdInsert() && !fieldConfig.isGeneratedId()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must be a generated-id if allowGeneratedIdInsert = true");
        }
        if (fieldConfig.isForeignAutoRefresh() && !fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignAutoRefresh = true");
        }
        if (fieldConfig.isForeignAutoCreate() && !fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignAutoCreate = true");
        }
        if (fieldConfig.getForeignColumnName() != null && !fieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignColumnName is set");
        }
        if (fieldConfig.isVersion() && (dataPersister == null || !dataPersister.isValidForVersion())) {
            throw new IllegalArgumentException("Field " + field.getName() + " is not a valid type to be a version field");
        }
        if (fieldConfig.getMaxForeignAutoRefreshLevel() > 0 && !fieldConfig.isForeignAutoRefresh()) {
            throw new IllegalArgumentException("Field " + field.getName() + " has maxForeignAutoRefreshLevel set but not foreignAutoRefresh is false");
        }
        this.assignDataType(databaseType, dataPersister);
    }

    public void configDaoInformation(ConnectionSource connectionSource, Class<?> parentClass) throws SQLException {
        FieldType foreignFieldType;
        MappedQueryForId mappedQueryForId;
        FieldType foreignIdField;
        TableInfo foreignTableInfo;
        BaseDaoImpl foreignDao;
        Class<?> fieldClass = this.field.getType();
        DatabaseType databaseType = connectionSource.getDatabaseType();
        String foreignColumnName = this.fieldConfig.getForeignColumnName();
        if (this.fieldConfig.isForeignAutoRefresh() || foreignColumnName != null) {
            MappedQueryForId castMappedQueryForId;
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig == null) {
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, fieldClass);
                foreignTableInfo = foreignDao.getTableInfo();
            } else {
                tableConfig.extractFieldTypes(connectionSource);
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, tableConfig);
                foreignTableInfo = foreignDao.getTableInfo();
            }
            if (foreignColumnName == null) {
                foreignIdField = foreignTableInfo.getIdField();
                if (foreignIdField == null) {
                    throw new IllegalArgumentException("Foreign field " + fieldClass + " does not have id field");
                }
            } else {
                foreignIdField = foreignTableInfo.getFieldTypeByColumnName(foreignColumnName);
                if (foreignIdField == null) {
                    throw new IllegalArgumentException("Foreign field " + fieldClass + " does not have field named '" + foreignColumnName + "'");
                }
            }
            mappedQueryForId = castMappedQueryForId = MappedQueryForId.build(databaseType, foreignTableInfo, foreignIdField);
            foreignFieldType = null;
        } else if (this.fieldConfig.isForeign()) {
            if (this.dataPersister != null && this.dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + fieldClass + " but marked as foreign");
            }
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig != null) {
                tableConfig.extractFieldTypes(connectionSource);
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, tableConfig);
            } else {
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, fieldClass);
            }
            foreignTableInfo = foreignDao.getTableInfo();
            foreignIdField = foreignTableInfo.getIdField();
            if (foreignIdField == null) {
                throw new IllegalArgumentException("Foreign field " + fieldClass + " does not have id field");
            }
            if (this.isForeignAutoCreate() && !foreignIdField.isGeneratedId()) {
                throw new IllegalArgumentException("Field " + this.field.getName() + ", if foreignAutoCreate = true then class " + fieldClass.getSimpleName() + " must have id field with generatedId = true");
            }
            foreignFieldType = null;
            mappedQueryForId = null;
        } else if (this.fieldConfig.isForeignCollection()) {
            BaseDaoImpl castDao;
            if (fieldClass != Collection.class && !ForeignCollection.class.isAssignableFrom(fieldClass)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be of class " + ForeignCollection.class.getSimpleName() + " or Collection.");
            }
            Type type = this.field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection.");
            }
            Type[] genericArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (genericArguments.length == 0) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
            Class collectionClazz = (Class)genericArguments[0];
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            BaseDaoImpl foundDao = tableConfig == null ? (castDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, collectionClazz)) : (castDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, tableConfig));
            foreignDao = foundDao;
            foreignFieldType = this.findForeignFieldType(collectionClazz, parentClass, foundDao);
            foreignIdField = null;
            foreignTableInfo = null;
            mappedQueryForId = null;
        } else {
            foreignTableInfo = null;
            foreignIdField = null;
            foreignFieldType = null;
            foreignDao = null;
            mappedQueryForId = null;
        }
        this.mappedQueryForId = mappedQueryForId;
        this.foreignTableInfo = foreignTableInfo;
        this.foreignFieldType = foreignFieldType;
        this.foreignDao = foreignDao;
        this.foreignIdField = foreignIdField;
        if (this.foreignIdField != null) {
            this.assignDataType(databaseType, this.foreignIdField.getDataPersister());
        }
    }

    public Field getField() {
        return this.field;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DataPersister getDataPersister() {
        return this.dataPersister;
    }

    public Object getDataTypeConfigObj() {
        return this.dataTypeConfigObj;
    }

    public SqlType getSqlType() {
        return this.fieldConverter.getSqlType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.fieldConfig.getWidth();
    }

    public boolean isCanBeNull() {
        return this.fieldConfig.isCanBeNull();
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isGeneratedId() {
        return this.isGeneratedId;
    }

    public boolean isGeneratedIdSequence() {
        return this.generatedIdSequence != null;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public boolean isForeign() {
        return this.fieldConfig.isForeign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignField(Object data, Object val, boolean parentObject, ObjectCache objectCache) throws SQLException {
        if (this.foreignIdField != null && val != null) {
            Object foreignId = this.extractJavaFieldValue(data);
            if (foreignId != null && foreignId.equals(val)) {
                return;
            }
            if (!parentObject) {
                Object foreignObject;
                LevelCounters levelCounters = threadLevelCounters.get();
                if (levelCounters.autoRefreshLevel == 0) {
                    levelCounters.autoRefreshLevelMax = this.fieldConfig.getMaxForeignAutoRefreshLevel();
                }
                if (levelCounters.autoRefreshLevel >= levelCounters.autoRefreshLevelMax) {
                    foreignObject = this.foreignTableInfo.createObject();
                    this.foreignIdField.assignField(foreignObject, val, false, objectCache);
                } else {
                    if (this.mappedQueryForId == null) {
                        MappedQueryForId<?, ?> castMappedQueryForId = MappedQueryForId.build(this.connectionSource.getDatabaseType(), this.foreignDao.getTableInfo(), this.foreignIdField);
                        this.mappedQueryForId = castMappedQueryForId;
                    }
                    ++levelCounters.autoRefreshLevel;
                    try {
                        DatabaseConnection databaseConnection = this.connectionSource.getReadOnlyConnection();
                        try {
                            foreignObject = this.mappedQueryForId.execute(databaseConnection, val, objectCache);
                        }
                        finally {
                            this.connectionSource.releaseConnection(databaseConnection);
                        }
                    }
                    finally {
                        --levelCounters.autoRefreshLevel;
                    }
                }
                val = foreignObject;
            }
        }
        if (this.fieldSetMethod == null) {
            try {
                this.field.set(data, val);
            }
            catch (IllegalArgumentException e) {
                throw SqlExceptionUtil.create("Could not assign object '" + val + "' to field " + this, e);
            }
            catch (IllegalAccessException e) {
                throw SqlExceptionUtil.create("Could not assign object '" + val + "' to field " + this, e);
            }
        }
        try {
            this.fieldSetMethod.invoke(data, val);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not call " + this.fieldSetMethod + " on object with '" + val + "' for " + this, e);
        }
    }

    public Object assignIdValue(Object data, Number val, ObjectCache objectCache) throws SQLException {
        Object idVal = this.dataPersister.convertIdNumber(val);
        if (idVal == null) {
            throw new SQLException("Invalid class " + this.dataPersister + " for sequence-id " + this);
        }
        this.assignField(data, idVal, false, objectCache);
        return idVal;
    }

    public <FV> FV extractRawJavaFieldValue(Object object) throws SQLException {
        Object val;
        if (this.fieldGetMethod == null) {
            try {
                val = this.field.get(object);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not get field value for " + this, e);
            }
        }
        try {
            val = this.fieldGetMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not call " + this.fieldGetMethod + " for " + this, e);
        }
        Object converted = val;
        return (FV)converted;
    }

    public Object extractJavaFieldValue(Object object) throws SQLException {
        Object val = this.extractRawJavaFieldValue(object);
        if (this.foreignIdField != null && val != null) {
            val = this.foreignIdField.extractRawJavaFieldValue(val);
        }
        return val;
    }

    public Object extractJavaFieldToSqlArgValue(Object object) throws SQLException {
        return this.convertJavaFieldToSqlArgValue(this.extractJavaFieldValue(object));
    }

    public Object convertJavaFieldToSqlArgValue(Object fieldVal) throws SQLException {
        if (fieldVal == null) {
            return null;
        }
        return this.fieldConverter.javaToSqlArg(this, fieldVal);
    }

    public Object convertStringToJavaField(String value, int columnPos) throws SQLException {
        if (value == null) {
            return null;
        }
        return this.fieldConverter.resultStringToJava(this, value, columnPos);
    }

    public Object moveToNextValue(Object val) {
        if (this.dataPersister == null) {
            return null;
        }
        return this.dataPersister.moveToNextValue(val);
    }

    public FieldType getForeignIdField() {
        return this.foreignIdField;
    }

    public boolean isEscapedValue() {
        return this.dataPersister.isEscapedValue();
    }

    public Enum<?> getUnknownEnumVal() {
        return this.fieldConfig.getUnknownEnumValue();
    }

    public String getFormat() {
        return this.fieldConfig.getFormat();
    }

    public boolean isUnique() {
        return this.fieldConfig.isUnique();
    }

    public boolean isUniqueCombo() {
        return this.fieldConfig.isUniqueCombo();
    }

    public String getIndexName() {
        return this.fieldConfig.getIndexName(this.tableName);
    }

    public String getUniqueIndexName() {
        return this.fieldConfig.getUniqueIndexName(this.tableName);
    }

    public boolean isEscapedDefaultValue() {
        return this.dataPersister.isEscapedDefaultValue();
    }

    public boolean isComparable() throws SQLException {
        if (this.fieldConfig.isForeignCollection()) {
            return false;
        }
        if (this.dataPersister == null) {
            throw new SQLException("Internal error.  Data-persister is not configured for field.  Please post _full_ exception with associated data objects to mailing list: " + this);
        }
        return this.dataPersister.isComparable();
    }

    public boolean isArgumentHolderRequired() {
        return this.dataPersister.isArgumentHolderRequired();
    }

    public boolean isForeignCollection() {
        return this.fieldConfig.isForeignCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <FT, FID> BaseForeignCollection<FT, FID> buildForeignCollection(Object parent, FID id) throws SQLException {
        if (this.foreignFieldType == null) {
            return null;
        }
        BaseDaoImpl<?, ?> castDao = this.foreignDao;
        if (!this.fieldConfig.isForeignCollectionEager()) {
            return new LazyForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
        }
        LevelCounters levelCounters = threadLevelCounters.get();
        if (levelCounters.foreignCollectionLevel == 0) {
            levelCounters.foreignCollectionLevelMax = this.fieldConfig.getForeignCollectionMaxEagerLevel();
        }
        if (levelCounters.foreignCollectionLevel >= levelCounters.foreignCollectionLevelMax) {
            return new LazyForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
        }
        ++levelCounters.foreignCollectionLevel;
        try {
            EagerForeignCollection eagerForeignCollection = new EagerForeignCollection(castDao, parent, id, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
            return eagerForeignCollection;
        }
        finally {
            --levelCounters.foreignCollectionLevel;
        }
    }

    public <T> T resultToJava(DatabaseResults results, Map<String, Integer> columnPositions) throws SQLException {
        Integer dbColumnPos = columnPositions.get(this.columnName);
        if (dbColumnPos == null) {
            dbColumnPos = results.findColumn(this.columnName);
            columnPositions.put(this.columnName, dbColumnPos);
        }
        Object converted = this.fieldConverter.resultToJava(this, results, dbColumnPos);
        if (this.fieldConfig.isForeign()) {
            if (results.wasNull(dbColumnPos)) {
                return null;
            }
        } else if (this.dataPersister.isPrimitive()) {
            if (this.fieldConfig.isThrowIfNull() && results.wasNull(dbColumnPos)) {
                throw new SQLException("Results value for primitive field '" + this.field.getName() + "' was an invalid null value");
            }
        } else if (!this.fieldConverter.isStreamType() && results.wasNull(dbColumnPos)) {
            return null;
        }
        return (T)converted;
    }

    public boolean isSelfGeneratedId() {
        return this.dataPersister.isSelfGeneratedId();
    }

    public boolean isAllowGeneratedIdInsert() {
        return this.fieldConfig.isAllowGeneratedIdInsert();
    }

    public String getColumnDefinition() {
        return this.fieldConfig.getColumnDefinition();
    }

    public boolean isForeignAutoCreate() {
        return this.fieldConfig.isForeignAutoCreate();
    }

    public boolean isVersion() {
        return this.fieldConfig.isVersion();
    }

    public Object generateId() {
        return this.dataPersister.generateId();
    }

    public boolean isReadOnly() {
        return this.fieldConfig.isReadOnly();
    }

    public <FV> FV getFieldValueIfNotDefault(Object object) throws SQLException {
        Object fieldValue = this.extractJavaFieldValue(object);
        if (this.isFieldValueDefault(fieldValue)) {
            return null;
        }
        return (FV)fieldValue;
    }

    public boolean isObjectsFieldValueDefault(Object object) throws SQLException {
        Object fieldValue = this.extractJavaFieldValue(object);
        return this.isFieldValueDefault(fieldValue);
    }

    public Object getJavaDefaultValueDefault() {
        if (this.field.getType() == Boolean.TYPE) {
            return DEFAULT_VALUE_BOOLEAN;
        }
        if (this.field.getType() == Byte.TYPE || this.field.getType() == Byte.class) {
            return DEFAULT_VALUE_BYTE;
        }
        if (this.field.getType() == Character.TYPE || this.field.getType() == Character.class) {
            return Character.valueOf(DEFAULT_VALUE_CHAR);
        }
        if (this.field.getType() == Short.TYPE || this.field.getType() == Short.class) {
            return DEFAULT_VALUE_SHORT;
        }
        if (this.field.getType() == Integer.TYPE || this.field.getType() == Integer.class) {
            return DEFAULT_VALUE_INT;
        }
        if (this.field.getType() == Long.TYPE || this.field.getType() == Long.class) {
            return DEFAULT_VALUE_LONG;
        }
        if (this.field.getType() == Float.TYPE || this.field.getType() == Float.class) {
            return Float.valueOf(DEFAULT_VALUE_FLOAT);
        }
        if (this.field.getType() == Double.TYPE || this.field.getType() == Double.class) {
            return DEFAULT_VALUE_DOUBLE;
        }
        return null;
    }

    public <T> int createWithForeignDao(T foreignData) throws SQLException {
        BaseDaoImpl<?, ?> castDao = this.foreignDao;
        return castDao.create(foreignData);
    }

    public static FieldType createFieldType(ConnectionSource connectionSource, String tableName, Field field, Class<?> parentClass) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        DatabaseFieldConfig fieldConfig = DatabaseFieldConfig.fromField(databaseType, tableName, field);
        if (fieldConfig == null) {
            return null;
        }
        return new FieldType(connectionSource, tableName, field, fieldConfig, parentClass);
    }

    public boolean equals(Object arg) {
        if (arg == null || arg.getClass() != this.getClass()) {
            return false;
        }
        FieldType other = (FieldType)arg;
        return this.field.equals(other.field) && (this.parentClass == null ? other.parentClass == null : this.parentClass.equals(other.parentClass));
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":name=" + this.field.getName() + ",class=" + this.field.getDeclaringClass().getSimpleName();
    }

    private boolean isFieldValueDefault(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        return fieldValue.equals(this.getJavaDefaultValueDefault());
    }

    private FieldType findForeignFieldType(Class<?> clazz, Class<?> foreignClass, BaseDaoImpl<?, ?> foreignDao) throws SQLException {
        String foreignColumnName = this.fieldConfig.getForeignCollectionForeignFieldName();
        for (FieldType fieldType : foreignDao.getTableInfo().getFieldTypes()) {
            if (fieldType.getType() != foreignClass || foreignColumnName != null && !fieldType.getField().getName().equals(foreignColumnName)) continue;
            if (!fieldType.fieldConfig.isForeign() && !fieldType.fieldConfig.isForeignAutoRefresh()) {
                throw new SQLException("Foreign collection object " + clazz + " for field '" + this.field.getName() + "' contains a field of class " + foreignClass + " but it's not foreign");
            }
            return fieldType;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Foreign collection class ").append(clazz.getName());
        sb.append(" for field '").append(this.field.getName()).append("' column-name does not contain a foreign field");
        if (foreignColumnName != null) {
            sb.append(" named '").append(foreignColumnName).append('\'');
        }
        sb.append(" of class ").append(foreignClass.getName());
        throw new SQLException(sb.toString());
    }

    private void assignDataType(DatabaseType databaseType, DataPersister dataPersister) throws SQLException {
        this.dataPersister = dataPersister;
        if (dataPersister == null) {
            if (!this.fieldConfig.isForeign() && !this.fieldConfig.isForeignCollection()) {
                throw new SQLException("Data persister for field " + this + " is null but the field is not a foreign or foreignCollection");
            }
            return;
        }
        this.fieldConverter = databaseType.getFieldConverter(dataPersister);
        if (this.isGeneratedId && !dataPersister.isValidGeneratedType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated-id field '").append(this.field.getName());
            sb.append("' in ").append(this.field.getDeclaringClass().getSimpleName());
            sb.append(" can't be type ").append((Object)this.dataPersister.getSqlType());
            sb.append(".  Must be one of: ");
            for (DataType dataType : DataType.values()) {
                DataPersister persister = dataType.getDataPersister();
                if (persister == null || !persister.isValidGeneratedType()) continue;
                sb.append((Object)dataType).append(' ');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        if (this.fieldConfig.isThrowIfNull() && !dataPersister.isPrimitive()) {
            throw new SQLException("Field " + this.field.getName() + " must be a primitive if set with throwIfNull");
        }
        if (this.isId && !dataPersister.isAppropriateId()) {
            throw new SQLException("Field '" + this.field.getName() + "' is of data type " + dataPersister + " which cannot be the ID field");
        }
        this.dataTypeConfigObj = dataPersister.makeConfigObject(this);
        String defaultStr = this.fieldConfig.getDefaultValue();
        if (defaultStr == null) {
            this.defaultValue = null;
        } else {
            if (this.isGeneratedId) {
                throw new SQLException("Field '" + this.field.getName() + "' cannot be a generatedId and have a default value '" + defaultStr + "'");
            }
            this.defaultValue = this.fieldConverter.parseDefaultString(this, defaultStr);
        }
    }

    static {
        threadLevelCounters = new ThreadLocal<LevelCounters>(){

            @Override
            protected LevelCounters initialValue() {
                return new LevelCounters();
            }
        };
    }

    private static class LevelCounters {
        int autoRefreshLevel;
        int autoRefreshLevelMax;
        int foreignCollectionLevel;
        int foreignCollectionLevelMax;

        private LevelCounters() {
        }
    }
}

