import { TFilter } from "./types";
import { TValue } from "../../Form/Select/Cascade";
import { TCascadeOption } from "../../Form/Select/Cascade/CascadeOption";
export declare const termMachine: (term: TFilter.Internal.Term.State) => {
    build: () => {
        attribute: TFilter.ConfigItem | null;
        operator: TFilter.Operator | null;
        value: TFilter.Internal.Term.TermValue;
        selectedCascadeValues: TFilter.CascadeValue[] | null;
        completed: boolean;
        id: number;
        active: boolean;
    };
    setIncomplete: () => any;
    setComplete: () => any;
    setActive: () => any;
    setInactive: () => any;
    setAttribute: (attribute: TFilter.ConfigItem) => any;
    setSelectedCascadeValue: (values: TCascadeOption<TValue[]>[]) => any;
    setAttributeValues: (value: string[]) => any;
    setOperator: (operator: TFilter.Operator) => any;
    setValue: (value: TFilter.Internal.Term.TermValue) => any;
};
export declare const termsMachine: (terms: TFilter.Internal.Term.State[]) => {
    build: () => TFilter.Internal.Term.State[];
    getSpecificTerm: (id: TFilter.Internal.Term.State["id"]) => TFilter.Internal.Term.State | undefined;
    removeAllIncompleted: () => any;
    updateSpecificTerm: (id: TFilter.Internal.Term.State["id"], update: (term: TFilter.Internal.Term.State) => TFilter.Internal.Term.State) => any;
    setAllInactive: () => any;
    pushNewTerm: () => any;
    removeSpecificTerm: (id: TFilter.Internal.Term.State["id"]) => any;
    getSpecificTermIndex: (id: TFilter.Internal.Term.State["id"]) => number;
    updateSpecificTermByIndex: (index: number, update: (term: TFilter.Internal.Term.State) => TFilter.Internal.Term.State) => any;
};
export declare const prepareValueDeletion: (oldValue: TFilter.Internal.Term.TermValue, valueToDelete?: string) => (string | number)[] | null;
export declare const getCascadeValuesForConfigitem: (configItem: TFilter.ConfigItem, lastVal: TValue) => TFilter.CascadeValue | undefined;
export declare const prepareValueChange: (currentValue: TFilter.Internal.Term.TermValue, newValue: TFilter.Internal.Term.TermValue) => string | number | (string | number)[] | null;
export declare const serializeFilterToRequestDTO: (state: TFilter.Internal.State, transformConfig?: TFilter.DTO.ValueTransformConfigByAttributeName) => TFilter.DTO.State;
export declare const createEmptyTerm: () => TFilter.Internal.Term.State;
export declare const capitalize: (string: string) => string;
export declare function parseNumber(value: string, type: TFilter.EControlType): number;
export declare const appendValueToCurrentValueArray: (controlType: TFilter.EControlType, newValue: string | string[]) => TFilter.Internal.Term.TermValue;
export declare function parseString(input: string): string[];
export declare const emptyFilterDTO: TFilter.DTO.State;
export declare const emptyFilterInternal: TFilter.Internal.State;
export declare const validateFilterDTO: (filterDTO: TFilter.DTO.State, config: TFilter.Config) => {
    operator: TFilter.DTO.Match;
    fields: Array<TFilter.DTO.Field>;
};
//# sourceMappingURL=libs.d.ts.map