'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
require('../../CloseButton/CloseIcon.cjs');
var CloseButton = require('../../CloseButton/CloseButton.cjs');

const ComboboxClearButton = react.forwardRef(
  ({ size, onMouseDown, onClick, onClear, ...others }, ref) => /* @__PURE__ */ jsxRuntime.jsx(
    CloseButton.CloseButton,
    {
      ref,
      size: size || "sm",
      variant: "transparent",
      tabIndex: -1,
      "aria-hidden": true,
      ...others,
      onMouseDown: (event) => {
        event.preventDefault();
        onMouseDown?.(event);
      },
      onClick: (event) => {
        onClear();
        onClick?.(event);
      }
    }
  )
);
ComboboxClearButton.displayName = "@mantine/core/ComboboxClearButton";

exports.ComboboxClearButton = ComboboxClearButton;
//# sourceMappingURL=ComboboxClearButton.cjs.map
