'use client';
'use strict';

var react = require('react');
var hooks = require('@mantine/hooks');

function useLockScroll({ opened, transitionDuration }) {
  const [shouldLockScroll, setShouldLockScroll] = react.useState(opened);
  const timeout = react.useRef();
  const reduceMotion = hooks.useReducedMotion();
  const _transitionDuration = reduceMotion ? 0 : transitionDuration;
  react.useEffect(() => {
    if (opened) {
      setShouldLockScroll(true);
      window.clearTimeout(timeout.current);
    } else if (_transitionDuration === 0) {
      setShouldLockScroll(false);
    } else {
      timeout.current = window.setTimeout(() => setShouldLockScroll(false), _transitionDuration);
    }
    return () => window.clearTimeout(timeout.current);
  }, [opened, _transitionDuration]);
  return shouldLockScroll;
}

exports.useLockScroll = useLockScroll;
//# sourceMappingURL=use-lock-scroll.cjs.map
