import{useEffect,useState}from"react";import{useSorting}from"./state/sortSlice";import{usePaging}from"./state/pageSlice";import{useSelect}from"./state/selectSlice";import{useColumns}from"../hooks/useColumns";import{useFillers}from"../hooks/useFillers";import{useRowFactoryBuilder}from"../hooks/useRowFactoryBuilder";export function useTableClientSide(inputData,config,onSelect,onSortingChange,onPagingChange,defaultPaging){var _config_meta;const[data,setData]=useState(inputData);const{sorting,sortBy,sortFunction}=useSorting(config);const{paging,gotoPageIndex,setPageSize,sliceParams}=usePaging(data,defaultPaging);const selectionState=useSelect();const columns=useColumns(config,{sorting,sortBy,allSelected:selectionState.allSelected,selectAll:selectionState.selectAll});const rowFactory=useRowFactoryBuilder(config,selectionState);useEffect(()=>{onPagingChange&&onPagingChange({index:paging.index,size:paging.size})},[paging]);useEffect(()=>{onSortingChange&&onSortingChange({column:sorting.column,direction:sorting.direction})},[sorting]);useEffect(()=>{if(!onSelect)return;const selectedData=selectionState.selected.map(id=>data.find(d=>config.rowIdentifierAccessor(d)===id)).filter(x=>x);onSelect(selectedData)},[selectionState.selected]);useEffect(()=>{if(JSON.stringify(data)===JSON.stringify(inputData))return;setData(inputData)},[inputData]);const rows=[...data].sort(sortFunction).slice(...sliceParams).map(rowFactory);const fillers=useFillers(config,rows,paging.size);return{head:{columns},body:{rows,fillers,meta:{noDataTextContent:(_config_meta=config.meta)===null||_config_meta===void 0?void 0:_config_meta.noDataTextContent}},paging:{index:paging.index,size:paging.size,totalDisplayableResults:paging.totalDisplayableResults,actions:{gotoPageIndex,setPageSize}},selection:selectionState}}
//# sourceMappingURL=useTableClientSide.js.map