import { EHTTP_STATUS } from "../../base/EHttpStatus";
import { TErrorType, TFieldErrors, TResponseError } from "../types";
interface ICustomError extends Error {
    toObject: () => TResponseError;
}
export declare class CustomError<R = unknown> implements ICustomError {
    message: string;
    type: TErrorType;
    statuscode: EHTTP_STATUS;
    name: string;
    error: string;
    fieldErrors?: TFieldErrors;
    responseBody: R;
    constructor(statusCode: EHTTP_STATUS, type: string, responseBody: R, error: string, message?: string, fieldErrors?: TFieldErrors);
    log(): void;
    toObject(): {
        message: string;
        type: string;
        name: string;
        statuscode: EHTTP_STATUS;
        error: string;
        fieldErrors: TFieldErrors | undefined;
        responseBody: R;
    };
}
export {};
//# sourceMappingURL=CustomError.d.ts.map