'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('react');
var getDefaultZIndex = require('../../core/utils/get-default-z-index/get-default-z-index.cjs');
require('@mantine/hooks');
require('clsx');
require('../../core/MantineProvider/Mantine.context.cjs');
require('../../core/MantineProvider/default-theme.cjs');
require('../../core/MantineProvider/MantineProvider.cjs');
require('../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../core/MantineProvider/use-props/use-props.cjs');
require('../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
require('../../core/Box/Box.cjs');
var factory = require('../../core/factory/factory.cjs');
require('../../core/DirectionProvider/DirectionProvider.cjs');
var DrawerBody = require('./DrawerBody.cjs');
var DrawerCloseButton = require('./DrawerCloseButton.cjs');
var DrawerContent = require('./DrawerContent.cjs');
var DrawerHeader = require('./DrawerHeader.cjs');
var DrawerOverlay = require('./DrawerOverlay.cjs');
var DrawerRoot = require('./DrawerRoot.cjs');
var DrawerTitle = require('./DrawerTitle.cjs');
var Drawer_module = require('./Drawer.module.css.cjs');

const defaultProps = {
  closeOnClickOutside: true,
  withinPortal: true,
  lockScroll: true,
  trapFocus: true,
  returnFocus: true,
  closeOnEscape: true,
  keepMounted: false,
  zIndex: getDefaultZIndex.getDefaultZIndex("modal"),
  withOverlay: true,
  withCloseButton: true
};
const Drawer = factory.factory((_props, ref) => {
  const {
    title,
    withOverlay,
    overlayProps,
    withCloseButton,
    closeButtonProps,
    children,
    ...others
  } = useProps.useProps("Drawer", defaultProps, _props);
  const hasHeader = !!title || withCloseButton;
  return /* @__PURE__ */ jsxRuntime.jsxs(DrawerRoot.DrawerRoot, { ref, ...others, children: [
    withOverlay && /* @__PURE__ */ jsxRuntime.jsx(DrawerOverlay.DrawerOverlay, { ...overlayProps }),
    /* @__PURE__ */ jsxRuntime.jsxs(DrawerContent.DrawerContent, { children: [
      hasHeader && /* @__PURE__ */ jsxRuntime.jsxs(DrawerHeader.DrawerHeader, { children: [
        title && /* @__PURE__ */ jsxRuntime.jsx(DrawerTitle.DrawerTitle, { children: title }),
        withCloseButton && /* @__PURE__ */ jsxRuntime.jsx(DrawerCloseButton.DrawerCloseButton, { ...closeButtonProps })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(DrawerBody.DrawerBody, { children })
    ] })
  ] });
});
Drawer.classes = Drawer_module;
Drawer.displayName = "@mantine/core/Drawer";
Drawer.Root = DrawerRoot.DrawerRoot;
Drawer.Overlay = DrawerOverlay.DrawerOverlay;
Drawer.Content = DrawerContent.DrawerContent;
Drawer.Body = DrawerBody.DrawerBody;
Drawer.Header = DrawerHeader.DrawerHeader;
Drawer.Title = DrawerTitle.DrawerTitle;
Drawer.CloseButton = DrawerCloseButton.DrawerCloseButton;

exports.Drawer = Drawer;
//# sourceMappingURL=Drawer.cjs.map
