'use client';
'use strict';

var react = require('react');
var hooks = require('@mantine/hooks');
var useLockScroll = require('./use-lock-scroll.cjs');

function useModal({
  id,
  transitionProps,
  opened,
  trapFocus,
  closeOnEscape,
  onClose,
  returnFocus
}) {
  const _id = hooks.useId(id);
  const [titleMounted, setTitleMounted] = react.useState(false);
  const [bodyMounted, setBodyMounted] = react.useState(false);
  const transitionDuration = typeof transitionProps?.duration === "number" ? transitionProps?.duration : 200;
  const shouldLockScroll = useLockScroll.useLockScroll({ opened, transitionDuration });
  hooks.useWindowEvent(
    "keydown",
    (event) => {
      if (event.key === "Escape" && closeOnEscape && opened) {
        const shouldTrigger = event.target?.getAttribute("data-mantine-stop-propagation") !== "true";
        shouldTrigger && onClose();
      }
    },
    { capture: true }
  );
  hooks.useFocusReturn({ opened, shouldReturnFocus: trapFocus && returnFocus });
  return {
    _id,
    titleMounted,
    bodyMounted,
    shouldLockScroll,
    setTitleMounted,
    setBodyMounted
  };
}

exports.useModal = useModal;
//# sourceMappingURL=use-modal.cjs.map
