'use strict';

var reactRemoveScroll = require('react-remove-scroll');
var keys = require('./core/utils/keys/keys.cjs');
var deepMerge = require('./core/utils/deep-merge/deep-merge.cjs');
var camelToKebabCase = require('./core/utils/camel-to-kebab-case/camel-to-kebab-case.cjs');
var px = require('./core/utils/units-converters/px.cjs');
var rem = require('./core/utils/units-converters/rem.cjs');
var filterProps = require('./core/utils/filter-props/filter-props.cjs');
var isNumberLike = require('./core/utils/is-number-like/is-number-like.cjs');
var isElement = require('./core/utils/is-element/is-element.cjs');
var createSafeContext = require('./core/utils/create-safe-context/create-safe-context.cjs');
var createOptionalContext = require('./core/utils/create-optional-context/create-optional-context.cjs');
var getSafeId = require('./core/utils/get-safe-id/get-safe-id.cjs');
var createScopedKeydownHandler = require('./core/utils/create-scoped-keydown-handler/create-scoped-keydown-handler.cjs');
var findElementAncestor = require('./core/utils/find-element-ancestor/find-element-ancestor.cjs');
var getDefaultZIndex = require('./core/utils/get-default-z-index/get-default-z-index.cjs');
var closeOnEscape = require('./core/utils/close-on-escape/close-on-escape.cjs');
var noop = require('./core/utils/noop/noop.cjs');
var getSize = require('./core/utils/get-size/get-size.cjs');
var createEventHandler = require('./core/utils/create-event-handler/create-event-handler.cjs');
var getBreakpointValue = require('./core/utils/get-breakpoint-value/get-breakpoint-value.cjs');
var getSortedBreakpoints = require('./core/utils/get-sorted-breakpoints/get-sorted-breakpoints.cjs');
var getBaseValue = require('./core/utils/get-base-value/get-base-value.cjs');
var getContextItemIndex = require('./core/utils/get-context-item-index/get-context-item-index.cjs');
var useHovered = require('./core/utils/use-hovered/use-hovered.cjs');
var createUseExternalEvents = require('./core/utils/create-use-external-events/create-use-external-events.cjs');
var getEnv = require('./core/utils/get-env/get-env.cjs');
var memoize = require('./core/utils/memoize/memoize.cjs');
var createVarsResolver = require('./core/styles-api/create-vars-resolver/create-vars-resolver.cjs');
var resolveClassNames = require('./core/styles-api/use-styles/get-class-name/resolve-class-names/resolve-class-names.cjs');
var resolveStyles = require('./core/styles-api/use-styles/get-style/resolve-styles/resolve-styles.cjs');
var useResolvedStylesApi = require('./core/styles-api/use-resolved-styles-api/use-resolved-styles-api.cjs');
var getGlobalClassNames = require('./core/styles-api/use-styles/get-class-name/get-global-class-names/get-global-class-names.cjs');
var useStyles = require('./core/styles-api/use-styles/use-styles.cjs');
var localStorageManager = require('./core/MantineProvider/color-scheme-managers/local-storage-manager.cjs');
var isMantineColorScheme = require('./core/MantineProvider/color-scheme-managers/is-mantine-color-scheme.cjs');
var getPrimaryShade = require('./core/MantineProvider/color-functions/get-primary-shade/get-primary-shade.cjs');
var parseThemeColor = require('./core/MantineProvider/color-functions/parse-theme-color/parse-theme-color.cjs');
var getThemeColor = require('./core/MantineProvider/color-functions/get-theme-color/get-theme-color.cjs');
var defaultVariantColorsResolver = require('./core/MantineProvider/color-functions/default-variant-colors-resolver/default-variant-colors-resolver.cjs');
var getGradient = require('./core/MantineProvider/color-functions/get-gradient/get-gradient.cjs');
var toRgba = require('./core/MantineProvider/color-functions/to-rgba/to-rgba.cjs');
var rgba = require('./core/MantineProvider/color-functions/rgba/rgba.cjs');
var darken = require('./core/MantineProvider/color-functions/darken/darken.cjs');
var lighten = require('./core/MantineProvider/color-functions/lighten/lighten.cjs');
var luminance = require('./core/MantineProvider/color-functions/luminance/luminance.cjs');
var getContrastColor = require('./core/MantineProvider/color-functions/get-contrast-color/get-contrast-color.cjs');
var getAutoContrastValue = require('./core/MantineProvider/color-functions/get-auto-contrast-value/get-auto-contrast-value.cjs');
var colorsTuple = require('./core/MantineProvider/color-functions/colors-tuple/colors-tuple.cjs');
var useMantineColorScheme = require('./core/MantineProvider/use-mantine-color-scheme/use-mantine-color-scheme.cjs');
var useProviderColorScheme = require('./core/MantineProvider/use-mantine-color-scheme/use-provider-color-scheme.cjs');
var useComputedColorScheme = require('./core/MantineProvider/use-mantine-color-scheme/use-computed-color-scheme.cjs');
var ColorSchemeScript = require('./core/MantineProvider/ColorSchemeScript/ColorSchemeScript.cjs');
var defaultTheme = require('./core/MantineProvider/default-theme.cjs');
var mergeMantineTheme = require('./core/MantineProvider/merge-mantine-theme/merge-mantine-theme.cjs');
var MantineProvider = require('./core/MantineProvider/MantineProvider.cjs');
var Mantine_context = require('./core/MantineProvider/Mantine.context.cjs');
var MantineThemeProvider = require('./core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('./core/MantineProvider/use-props/use-props.cjs');
var convertCssVariables = require('./core/MantineProvider/convert-css-variables/convert-css-variables.cjs');
var createTheme = require('./core/MantineProvider/create-theme/create-theme.cjs');
var mergeThemeOverrides = require('./core/MantineProvider/merge-theme-overrides/merge-theme-overrides.cjs');
var defaultCssVariablesResolver = require('./core/MantineProvider/MantineCssVariables/default-css-variables-resolver.cjs');
require('./core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
var getCssColorVariables = require('./core/MantineProvider/MantineCssVariables/get-css-color-variables.cjs');
var virtualColor = require('./core/MantineProvider/MantineCssVariables/virtual-color/virtual-color.cjs');
var useMatches = require('./core/MantineProvider/use-matches/use-matches.cjs');
var InlineStyles = require('./core/InlineStyles/InlineStyles.cjs');
var stylesToString = require('./core/InlineStyles/styles-to-string/styles-to-string.cjs');
var extractStyleProps = require('./core/Box/style-props/extract-style-props/extract-style-props.cjs');
var stylePropsData = require('./core/Box/style-props/style-props-data.cjs');
var parseStyleProps = require('./core/Box/style-props/parse-style-props/parse-style-props.cjs');
var useRandomClassname = require('./core/Box/use-random-classname/use-random-classname.cjs');
var getStyleObject = require('./core/Box/get-style-object/get-style-object.cjs');
var Box = require('./core/Box/Box.cjs');
var factory = require('./core/factory/factory.cjs');
var polymorphicFactory = require('./core/factory/polymorphic-factory.cjs');
var createPolymorphicComponent = require('./core/factory/create-polymorphic-component.cjs');
var DirectionProvider = require('./core/DirectionProvider/DirectionProvider.cjs');
var Collapse = require('./components/Collapse/Collapse.cjs');
var ScrollArea = require('./components/ScrollArea/ScrollArea.cjs');
var UnstyledButton = require('./components/UnstyledButton/UnstyledButton.cjs');
var VisuallyHidden = require('./components/VisuallyHidden/VisuallyHidden.cjs');
var Paper = require('./components/Paper/Paper.cjs');
var Popover = require('./components/Popover/Popover.cjs');
var PopoverDropdown = require('./components/Popover/PopoverDropdown/PopoverDropdown.cjs');
var PopoverTarget = require('./components/Popover/PopoverTarget/PopoverTarget.cjs');
var ActionIcon = require('./components/ActionIcon/ActionIcon.cjs');
var ActionIconGroup = require('./components/ActionIcon/ActionIconGroup/ActionIconGroup.cjs');
var CloseIcon = require('./components/CloseButton/CloseIcon.cjs');
var CloseButton = require('./components/CloseButton/CloseButton.cjs');
var Group = require('./components/Group/Group.cjs');
var Loader = require('./components/Loader/Loader.cjs');
var Overlay = require('./components/Overlay/Overlay.cjs');
var ModalBase = require('./components/ModalBase/ModalBase.cjs');
var ModalBaseBody = require('./components/ModalBase/ModalBaseBody.cjs');
var ModalBaseCloseButton = require('./components/ModalBase/ModalBaseCloseButton.cjs');
var ModalBaseContent = require('./components/ModalBase/ModalBaseContent.cjs');
var ModalBaseHeader = require('./components/ModalBase/ModalBaseHeader.cjs');
var ModalBaseOverlay = require('./components/ModalBase/ModalBaseOverlay.cjs');
var ModalBaseTitle = require('./components/ModalBase/ModalBaseTitle.cjs');
var NativeScrollArea = require('./components/ModalBase/NativeScrollArea.cjs');
var Input = require('./components/Input/Input.cjs');
var InputWrapper = require('./components/Input/InputWrapper/InputWrapper.cjs');
var InputDescription = require('./components/Input/InputDescription/InputDescription.cjs');
var InputError = require('./components/Input/InputError/InputError.cjs');
var InputLabel = require('./components/Input/InputLabel/InputLabel.cjs');
var InputPlaceholder = require('./components/Input/InputPlaceholder/InputPlaceholder.cjs');
var useInputProps = require('./components/Input/use-input-props.cjs');
var InputWrapper_context = require('./components/Input/InputWrapper.context.cjs');
var InputBase = require('./components/InputBase/InputBase.cjs');
var flexProps = require('./components/Flex/flex-props.cjs');
var Flex = require('./components/Flex/Flex.cjs');
var FloatingIndicator = require('./components/FloatingIndicator/FloatingIndicator.cjs');
var Accordion = require('./components/Accordion/Accordion.cjs');
var AccordionChevron = require('./components/Accordion/AccordionChevron.cjs');
var AccordionItem = require('./components/Accordion/AccordionItem/AccordionItem.cjs');
var AccordionPanel = require('./components/Accordion/AccordionPanel/AccordionPanel.cjs');
var AccordionControl = require('./components/Accordion/AccordionControl/AccordionControl.cjs');
var Affix = require('./components/Affix/Affix.cjs');
var Alert = require('./components/Alert/Alert.cjs');
var Anchor = require('./components/Anchor/Anchor.cjs');
var AppShell = require('./components/AppShell/AppShell.cjs');
var AppShellAside = require('./components/AppShell/AppShellAside/AppShellAside.cjs');
var AppShellFooter = require('./components/AppShell/AppShellFooter/AppShellFooter.cjs');
var AppShellHeader = require('./components/AppShell/AppShellHeader/AppShellHeader.cjs');
var AppShellNavbar = require('./components/AppShell/AppShellNavbar/AppShellNavbar.cjs');
var AppShellSection = require('./components/AppShell/AppShellSection/AppShellSection.cjs');
var AppShellMain = require('./components/AppShell/AppShellMain/AppShellMain.cjs');
var AspectRatio = require('./components/AspectRatio/AspectRatio.cjs');
var Autocomplete = require('./components/Autocomplete/Autocomplete.cjs');
var Avatar = require('./components/Avatar/Avatar.cjs');
var AvatarGroup = require('./components/Avatar/AvatarGroup/AvatarGroup.cjs');
var BackgroundImage = require('./components/BackgroundImage/BackgroundImage.cjs');
var Badge = require('./components/Badge/Badge.cjs');
var Blockquote = require('./components/Blockquote/Blockquote.cjs');
var Breadcrumbs = require('./components/Breadcrumbs/Breadcrumbs.cjs');
var Burger = require('./components/Burger/Burger.cjs');
var Button = require('./components/Button/Button.cjs');
var ButtonGroup = require('./components/Button/ButtonGroup/ButtonGroup.cjs');
var Card = require('./components/Card/Card.cjs');
var CardSection = require('./components/Card/CardSection/CardSection.cjs');
var Center = require('./components/Center/Center.cjs');
var Checkbox = require('./components/Checkbox/Checkbox.cjs');
var CheckboxGroup = require('./components/Checkbox/CheckboxGroup/CheckboxGroup.cjs');
var CheckIcon = require('./components/Checkbox/CheckIcon.cjs');
var CheckboxIndicator = require('./components/Checkbox/CheckboxIndicator/CheckboxIndicator.cjs');
var CheckboxCard = require('./components/Checkbox/CheckboxCard/CheckboxCard.cjs');
var CheckboxCard_context = require('./components/Checkbox/CheckboxCard/CheckboxCard.context.cjs');
var CheckboxGroup_context = require('./components/Checkbox/CheckboxGroup.context.cjs');
var Chip = require('./components/Chip/Chip.cjs');
var ChipGroup = require('./components/Chip/ChipGroup/ChipGroup.cjs');
var Code = require('./components/Code/Code.cjs');
var ColorPicker = require('./components/ColorPicker/ColorPicker.cjs');
var AlphaSlider = require('./components/ColorPicker/AlphaSlider/AlphaSlider.cjs');
var HueSlider = require('./components/ColorPicker/HueSlider/HueSlider.cjs');
var converters = require('./components/ColorPicker/converters/converters.cjs');
var parsers = require('./components/ColorPicker/converters/parsers.cjs');
var ColorInput = require('./components/ColorInput/ColorInput.cjs');
var ColorSwatch = require('./components/ColorSwatch/ColorSwatch.cjs');
var getParsedComboboxData = require('./components/Combobox/get-parsed-combobox-data/get-parsed-combobox-data.cjs');
var getOptionsLockup = require('./components/Combobox/get-options-lockup/get-options-lockup.cjs');
var ComboboxChevron = require('./components/Combobox/ComboboxChevron/ComboboxChevron.cjs');
var Combobox = require('./components/Combobox/Combobox.cjs');
var ComboboxDropdown = require('./components/Combobox/ComboboxDropdown/ComboboxDropdown.cjs');
var ComboboxOptions = require('./components/Combobox/ComboboxOptions/ComboboxOptions.cjs');
var ComboboxOption = require('./components/Combobox/ComboboxOption/ComboboxOption.cjs');
var ComboboxTarget = require('./components/Combobox/ComboboxTarget/ComboboxTarget.cjs');
var ComboboxSearch = require('./components/Combobox/ComboboxSearch/ComboboxSearch.cjs');
var ComboboxEmpty = require('./components/Combobox/ComboboxEmpty/ComboboxEmpty.cjs');
var ComboboxFooter = require('./components/Combobox/ComboboxFooter/ComboboxFooter.cjs');
var ComboboxHeader = require('./components/Combobox/ComboboxHeader/ComboboxHeader.cjs');
var ComboboxEventsTarget = require('./components/Combobox/ComboboxEventsTarget/ComboboxEventsTarget.cjs');
var ComboboxDropdownTarget = require('./components/Combobox/ComboboxDropdownTarget/ComboboxDropdownTarget.cjs');
var ComboboxGroup = require('./components/Combobox/ComboboxGroup/ComboboxGroup.cjs');
var ComboboxClearButton = require('./components/Combobox/ComboboxClearButton/ComboboxClearButton.cjs');
var ComboboxHiddenInput = require('./components/Combobox/ComboboxHiddenInput/ComboboxHiddenInput.cjs');
var OptionsDropdown = require('./components/Combobox/OptionsDropdown/OptionsDropdown.cjs');
var useCombobox = require('./components/Combobox/use-combobox/use-combobox.cjs');
var useVirtualizedCombobox = require('./components/Combobox/use-combobox/use-virtualized-combobox.cjs');
var useComboboxTargetProps = require('./components/Combobox/use-combobox-target-props/use-combobox-target-props.cjs');
var isOptionsGroup = require('./components/Combobox/OptionsDropdown/is-options-group.cjs');
var defaultOptionsFilter = require('./components/Combobox/OptionsDropdown/default-options-filter.cjs');
var Container = require('./components/Container/Container.cjs');
var CopyButton = require('./components/CopyButton/CopyButton.cjs');
var Dialog = require('./components/Dialog/Dialog.cjs');
var Divider = require('./components/Divider/Divider.cjs');
var Drawer = require('./components/Drawer/Drawer.cjs');
var DrawerRoot = require('./components/Drawer/DrawerRoot.cjs');
var DrawerBody = require('./components/Drawer/DrawerBody.cjs');
var DrawerCloseButton = require('./components/Drawer/DrawerCloseButton.cjs');
var DrawerContent = require('./components/Drawer/DrawerContent.cjs');
var DrawerHeader = require('./components/Drawer/DrawerHeader.cjs');
var DrawerOverlay = require('./components/Drawer/DrawerOverlay.cjs');
var DrawerTitle = require('./components/Drawer/DrawerTitle.cjs');
var Fieldset = require('./components/Fieldset/Fieldset.cjs');
var FileButton = require('./components/FileButton/FileButton.cjs');
var FileInput = require('./components/FileInput/FileInput.cjs');
var useDelayedHover = require('./components/Floating/use-delayed-hover.cjs');
var useFloatingAutoUpdate = require('./components/Floating/use-floating-auto-update.cjs');
var getFloatingPosition = require('./components/Floating/get-floating-position/get-floating-position.cjs');
var FloatingArrow = require('./components/Floating/FloatingArrow/FloatingArrow.cjs');
var FocusTrap = require('./components/FocusTrap/FocusTrap.cjs');
var Grid = require('./components/Grid/Grid.cjs');
var GridCol = require('./components/Grid/GridCol/GridCol.cjs');
var Highlight = require('./components/Highlight/Highlight.cjs');
var HoverCard = require('./components/HoverCard/HoverCard.cjs');
var HoverCardDropdown = require('./components/HoverCard/HoverCardDropdown/HoverCardDropdown.cjs');
var HoverCardTarget = require('./components/HoverCard/HoverCardTarget/HoverCardTarget.cjs');
var Image = require('./components/Image/Image.cjs');
var Indicator = require('./components/Indicator/Indicator.cjs');
var JsonInput = require('./components/JsonInput/JsonInput.cjs');
var Kbd = require('./components/Kbd/Kbd.cjs');
var List = require('./components/List/List.cjs');
var ListItem = require('./components/List/ListItem/ListItem.cjs');
var LoadingOverlay = require('./components/LoadingOverlay/LoadingOverlay.cjs');
var Mark = require('./components/Mark/Mark.cjs');
var Menu = require('./components/Menu/Menu.cjs');
var MenuDivider = require('./components/Menu/MenuDivider/MenuDivider.cjs');
var MenuItem = require('./components/Menu/MenuItem/MenuItem.cjs');
var MenuLabel = require('./components/Menu/MenuLabel/MenuLabel.cjs');
var MenuDropdown = require('./components/Menu/MenuDropdown/MenuDropdown.cjs');
var MenuTarget = require('./components/Menu/MenuTarget/MenuTarget.cjs');
var Modal = require('./components/Modal/Modal.cjs');
var ModalRoot = require('./components/Modal/ModalRoot.cjs');
var ModalBody = require('./components/Modal/ModalBody.cjs');
var ModalCloseButton = require('./components/Modal/ModalCloseButton.cjs');
var ModalContent = require('./components/Modal/ModalContent.cjs');
var ModalHeader = require('./components/Modal/ModalHeader.cjs');
var ModalOverlay = require('./components/Modal/ModalOverlay.cjs');
var ModalTitle = require('./components/Modal/ModalTitle.cjs');
var MultiSelect = require('./components/MultiSelect/MultiSelect.cjs');
var NativeSelect = require('./components/NativeSelect/NativeSelect.cjs');
var NavLink = require('./components/NavLink/NavLink.cjs');
var Notification = require('./components/Notification/Notification.cjs');
var NumberFormatter = require('./components/NumberFormatter/NumberFormatter.cjs');
var NumberInput = require('./components/NumberInput/NumberInput.cjs');
var Pagination = require('./components/Pagination/Pagination.cjs');
var PaginationControl = require('./components/Pagination/PaginationControl/PaginationControl.cjs');
var PaginationDots = require('./components/Pagination/PaginationDots/PaginationDots.cjs');
var PaginationEdges = require('./components/Pagination/PaginationEdges/PaginationEdges.cjs');
var PaginationItems = require('./components/Pagination/PaginationItems/PaginationItems.cjs');
var PaginationRoot = require('./components/Pagination/PaginationRoot/PaginationRoot.cjs');
var PasswordInput = require('./components/PasswordInput/PasswordInput.cjs');
var Pill = require('./components/Pill/Pill.cjs');
var PillGroup = require('./components/Pill/PillGroup/PillGroup.cjs');
var PillsInput = require('./components/PillsInput/PillsInput.cjs');
var PillsInputField = require('./components/PillsInput/PillsInputField/PillsInputField.cjs');
var PinInput = require('./components/PinInput/PinInput.cjs');
var Portal = require('./components/Portal/Portal.cjs');
var OptionalPortal = require('./components/Portal/OptionalPortal.cjs');
var Progress = require('./components/Progress/Progress.cjs');
var ProgressLabel = require('./components/Progress/ProgressLabel/ProgressLabel.cjs');
var ProgressRoot = require('./components/Progress/ProgressRoot/ProgressRoot.cjs');
var ProgressSection = require('./components/Progress/ProgressSection/ProgressSection.cjs');
var Radio = require('./components/Radio/Radio.cjs');
var RadioGroup = require('./components/Radio/RadioGroup/RadioGroup.cjs');
var RadioIcon = require('./components/Radio/RadioIcon.cjs');
var RadioCard = require('./components/Radio/RadioCard/RadioCard.cjs');
var RadioCard_context = require('./components/Radio/RadioCard/RadioCard.context.cjs');
var RadioIndicator = require('./components/Radio/RadioIndicator/RadioIndicator.cjs');
var Rating = require('./components/Rating/Rating.cjs');
var RingProgress = require('./components/RingProgress/RingProgress.cjs');
var SegmentedControl = require('./components/SegmentedControl/SegmentedControl.cjs');
var Select = require('./components/Select/Select.cjs');
var SemiCircleProgress = require('./components/SemiCircleProgress/SemiCircleProgress.cjs');
var SimpleGrid = require('./components/SimpleGrid/SimpleGrid.cjs');
var Skeleton = require('./components/Skeleton/Skeleton.cjs');
var Slider = require('./components/Slider/Slider/Slider.cjs');
var RangeSlider = require('./components/Slider/RangeSlider/RangeSlider.cjs');
var Space = require('./components/Space/Space.cjs');
var Spoiler = require('./components/Spoiler/Spoiler.cjs');
var Stack = require('./components/Stack/Stack.cjs');
var Stepper = require('./components/Stepper/Stepper.cjs');
var StepperStep = require('./components/Stepper/StepperStep/StepperStep.cjs');
var StepperCompleted = require('./components/Stepper/StepperCompleted/StepperCompleted.cjs');
var Switch = require('./components/Switch/Switch.cjs');
var SwitchGroup = require('./components/Switch/SwitchGroup/SwitchGroup.cjs');
var Table = require('./components/Table/Table.cjs');
var Table_components = require('./components/Table/Table.components.cjs');
var TableScrollContainer = require('./components/Table/TableScrollContainer.cjs');
var Tabs = require('./components/Tabs/Tabs.cjs');
var TabsList = require('./components/Tabs/TabsList/TabsList.cjs');
var TabsTab = require('./components/Tabs/TabsTab/TabsTab.cjs');
var TabsPanel = require('./components/Tabs/TabsPanel/TabsPanel.cjs');
var TagsInput = require('./components/TagsInput/TagsInput.cjs');
var Text = require('./components/Text/Text.cjs');
var Textarea = require('./components/Textarea/Textarea.cjs');
var TextInput = require('./components/TextInput/TextInput.cjs');
var ThemeIcon = require('./components/ThemeIcon/ThemeIcon.cjs');
var Timeline = require('./components/Timeline/Timeline.cjs');
var TimelineItem = require('./components/Timeline/TimelineItem/TimelineItem.cjs');
var Title = require('./components/Title/Title.cjs');
var Tooltip = require('./components/Tooltip/Tooltip.cjs');
var TooltipGroup = require('./components/Tooltip/TooltipGroup/TooltipGroup.cjs');
var TooltipFloating = require('./components/Tooltip/TooltipFloating/TooltipFloating.cjs');
var transitions = require('./components/Transition/transitions.cjs');
var Transition = require('./components/Transition/Transition.cjs');
var getTransitionProps = require('./components/Transition/get-transition-props/get-transition-props.cjs');
var Tree = require('./components/Tree/Tree.cjs');
var useTree = require('./components/Tree/use-tree.cjs');
var TypographyStylesProvider = require('./components/TypographyStylesProvider/TypographyStylesProvider.cjs');



Object.defineProperty(exports, 'RemoveScroll', {
	enumerable: true,
	get: function () { return reactRemoveScroll.RemoveScroll; }
});
exports.keys = keys.keys;
exports.deepMerge = deepMerge.deepMerge;
exports.camelToKebabCase = camelToKebabCase.camelToKebabCase;
exports.px = px.px;
exports.em = rem.em;
exports.rem = rem.rem;
exports.filterProps = filterProps.filterProps;
exports.isNumberLike = isNumberLike.isNumberLike;
exports.isElement = isElement.isElement;
exports.createSafeContext = createSafeContext.createSafeContext;
exports.createOptionalContext = createOptionalContext.createOptionalContext;
exports.getSafeId = getSafeId.getSafeId;
exports.createScopedKeydownHandler = createScopedKeydownHandler.createScopedKeydownHandler;
exports.findElementAncestor = findElementAncestor.findElementAncestor;
exports.getDefaultZIndex = getDefaultZIndex.getDefaultZIndex;
exports.closeOnEscape = closeOnEscape.closeOnEscape;
exports.noop = noop.noop;
exports.getFontSize = getSize.getFontSize;
exports.getLineHeight = getSize.getLineHeight;
exports.getRadius = getSize.getRadius;
exports.getShadow = getSize.getShadow;
exports.getSize = getSize.getSize;
exports.getSpacing = getSize.getSpacing;
exports.createEventHandler = createEventHandler.createEventHandler;
exports.getBreakpointValue = getBreakpointValue.getBreakpointValue;
exports.getSortedBreakpoints = getSortedBreakpoints.getSortedBreakpoints;
exports.getBaseValue = getBaseValue.getBaseValue;
exports.getContextItemIndex = getContextItemIndex.getContextItemIndex;
exports.useHovered = useHovered.useHovered;
exports.createUseExternalEvents = createUseExternalEvents.createUseExternalEvents;
exports.getEnv = getEnv.getEnv;
exports.memoize = memoize.memoize;
exports.createVarsResolver = createVarsResolver.createVarsResolver;
exports.resolveClassNames = resolveClassNames.resolveClassNames;
exports.resolveStyles = resolveStyles.resolveStyles;
exports.useResolvedStylesApi = useResolvedStylesApi.useResolvedStylesApi;
exports.FOCUS_CLASS_NAMES = getGlobalClassNames.FOCUS_CLASS_NAMES;
exports.useStyles = useStyles.useStyles;
exports.localStorageColorSchemeManager = localStorageManager.localStorageColorSchemeManager;
exports.isMantineColorScheme = isMantineColorScheme.isMantineColorScheme;
exports.getPrimaryShade = getPrimaryShade.getPrimaryShade;
exports.parseThemeColor = parseThemeColor.parseThemeColor;
exports.getThemeColor = getThemeColor.getThemeColor;
exports.defaultVariantColorsResolver = defaultVariantColorsResolver.defaultVariantColorsResolver;
exports.getGradient = getGradient.getGradient;
exports.toRgba = toRgba.toRgba;
exports.alpha = rgba.alpha;
exports.rgba = rgba.rgba;
exports.darken = darken.darken;
exports.lighten = lighten.lighten;
exports.isLightColor = luminance.isLightColor;
exports.luminance = luminance.luminance;
exports.getContrastColor = getContrastColor.getContrastColor;
exports.getPrimaryContrastColor = getContrastColor.getPrimaryContrastColor;
exports.getAutoContrastValue = getAutoContrastValue.getAutoContrastValue;
exports.colorsTuple = colorsTuple.colorsTuple;
exports.useMantineColorScheme = useMantineColorScheme.useMantineColorScheme;
exports.useProviderColorScheme = useProviderColorScheme.useProviderColorScheme;
exports.useComputedColorScheme = useComputedColorScheme.useComputedColorScheme;
exports.ColorSchemeScript = ColorSchemeScript.ColorSchemeScript;
exports.DEFAULT_THEME = defaultTheme.DEFAULT_THEME;
exports.mergeMantineTheme = mergeMantineTheme.mergeMantineTheme;
exports.validateMantineTheme = mergeMantineTheme.validateMantineTheme;
exports.HeadlessMantineProvider = MantineProvider.HeadlessMantineProvider;
exports.MantineProvider = MantineProvider.MantineProvider;
exports.MantineContext = Mantine_context.MantineContext;
exports.useMantineClassNamesPrefix = Mantine_context.useMantineClassNamesPrefix;
exports.useMantineContext = Mantine_context.useMantineContext;
exports.useMantineCssVariablesResolver = Mantine_context.useMantineCssVariablesResolver;
exports.useMantineIsHeadless = Mantine_context.useMantineIsHeadless;
exports.useMantineStyleNonce = Mantine_context.useMantineStyleNonce;
exports.useMantineStylesTransform = Mantine_context.useMantineStylesTransform;
exports.useMantineSxTransform = Mantine_context.useMantineSxTransform;
exports.useMantineWithStaticClasses = Mantine_context.useMantineWithStaticClasses;
exports.MantineThemeContext = MantineThemeProvider.MantineThemeContext;
exports.MantineThemeProvider = MantineThemeProvider.MantineThemeProvider;
exports.useMantineTheme = MantineThemeProvider.useMantineTheme;
exports.useSafeMantineTheme = MantineThemeProvider.useSafeMantineTheme;
exports.useProps = useProps.useProps;
exports.convertCssVariables = convertCssVariables.convertCssVariables;
exports.createTheme = createTheme.createTheme;
exports.mergeThemeOverrides = mergeThemeOverrides.mergeThemeOverrides;
exports.defaultCssVariablesResolver = defaultCssVariablesResolver.defaultCssVariablesResolver;
exports.getCSSColorVariables = getCssColorVariables.getCSSColorVariables;
exports.isVirtualColor = virtualColor.isVirtualColor;
exports.virtualColor = virtualColor.virtualColor;
exports.useMatches = useMatches.useMatches;
exports.InlineStyles = InlineStyles.InlineStyles;
exports.stylesToString = stylesToString.stylesToString;
exports.extractStyleProps = extractStyleProps.extractStyleProps;
exports.STYlE_PROPS_DATA = stylePropsData.STYlE_PROPS_DATA;
exports.parseStyleProps = parseStyleProps.parseStyleProps;
exports.useRandomClassName = useRandomClassname.useRandomClassName;
exports.getStyleObject = getStyleObject.getStyleObject;
exports.Box = Box.Box;
exports.factory = factory.factory;
exports.getWithProps = factory.getWithProps;
exports.polymorphicFactory = polymorphicFactory.polymorphicFactory;
exports.createPolymorphicComponent = createPolymorphicComponent.createPolymorphicComponent;
exports.DirectionContext = DirectionProvider.DirectionContext;
exports.DirectionProvider = DirectionProvider.DirectionProvider;
exports.useDirection = DirectionProvider.useDirection;
exports.Collapse = Collapse.Collapse;
exports.ScrollArea = ScrollArea.ScrollArea;
exports.ScrollAreaAutosize = ScrollArea.ScrollAreaAutosize;
exports.UnstyledButton = UnstyledButton.UnstyledButton;
exports.VisuallyHidden = VisuallyHidden.VisuallyHidden;
exports.Paper = Paper.Paper;
exports.Popover = Popover.Popover;
exports.PopoverDropdown = PopoverDropdown.PopoverDropdown;
exports.PopoverTarget = PopoverTarget.PopoverTarget;
exports.ActionIcon = ActionIcon.ActionIcon;
exports.ActionIconGroup = ActionIconGroup.ActionIconGroup;
exports.CloseIcon = CloseIcon.CloseIcon;
exports.CloseButton = CloseButton.CloseButton;
exports.Group = Group.Group;
exports.Loader = Loader.Loader;
exports.defaultLoaders = Loader.defaultLoaders;
exports.Overlay = Overlay.Overlay;
exports.ModalBase = ModalBase.ModalBase;
exports.ModalBaseBody = ModalBaseBody.ModalBaseBody;
exports.ModalBaseCloseButton = ModalBaseCloseButton.ModalBaseCloseButton;
exports.ModalBaseContent = ModalBaseContent.ModalBaseContent;
exports.ModalBaseHeader = ModalBaseHeader.ModalBaseHeader;
exports.ModalBaseOverlay = ModalBaseOverlay.ModalBaseOverlay;
exports.ModalBaseTitle = ModalBaseTitle.ModalBaseTitle;
exports.NativeScrollArea = NativeScrollArea.NativeScrollArea;
exports.Input = Input.Input;
exports.InputWrapper = InputWrapper.InputWrapper;
exports.InputDescription = InputDescription.InputDescription;
exports.InputError = InputError.InputError;
exports.InputLabel = InputLabel.InputLabel;
exports.InputPlaceholder = InputPlaceholder.InputPlaceholder;
exports.useInputProps = useInputProps.useInputProps;
exports.useInputWrapperContext = InputWrapper_context.useInputWrapperContext;
exports.InputBase = InputBase.InputBase;
exports.FLEX_STYLE_PROPS_DATA = flexProps.FLEX_STYLE_PROPS_DATA;
exports.Flex = Flex.Flex;
exports.FloatingIndicator = FloatingIndicator.FloatingIndicator;
exports.Accordion = Accordion.Accordion;
exports.AccordionChevron = AccordionChevron.AccordionChevron;
exports.AccordionItem = AccordionItem.AccordionItem;
exports.AccordionPanel = AccordionPanel.AccordionPanel;
exports.AccordionControl = AccordionControl.AccordionControl;
exports.Affix = Affix.Affix;
exports.Alert = Alert.Alert;
exports.Anchor = Anchor.Anchor;
exports.AppShell = AppShell.AppShell;
exports.AppShellAside = AppShellAside.AppShellAside;
exports.AppShellFooter = AppShellFooter.AppShellFooter;
exports.AppShellHeader = AppShellHeader.AppShellHeader;
exports.AppShellNavbar = AppShellNavbar.AppShellNavbar;
exports.AppShellSection = AppShellSection.AppShellSection;
exports.AppShellMain = AppShellMain.AppShellMain;
exports.AspectRatio = AspectRatio.AspectRatio;
exports.Autocomplete = Autocomplete.Autocomplete;
exports.Avatar = Avatar.Avatar;
exports.AvatarGroup = AvatarGroup.AvatarGroup;
exports.BackgroundImage = BackgroundImage.BackgroundImage;
exports.Badge = Badge.Badge;
exports.Blockquote = Blockquote.Blockquote;
exports.Breadcrumbs = Breadcrumbs.Breadcrumbs;
exports.Burger = Burger.Burger;
exports.Button = Button.Button;
exports.ButtonGroup = ButtonGroup.ButtonGroup;
exports.Card = Card.Card;
exports.CardSection = CardSection.CardSection;
exports.Center = Center.Center;
exports.Checkbox = Checkbox.Checkbox;
exports.CheckboxGroup = CheckboxGroup.CheckboxGroup;
exports.CheckIcon = CheckIcon.CheckIcon;
exports.CheckboxIndicator = CheckboxIndicator.CheckboxIndicator;
exports.CheckboxCard = CheckboxCard.CheckboxCard;
exports.useCheckboxCardContext = CheckboxCard_context.useCheckboxCardContext;
exports.useCheckboxGroupContext = CheckboxGroup_context.useCheckboxGroupContext;
exports.Chip = Chip.Chip;
exports.ChipGroup = ChipGroup.ChipGroup;
exports.Code = Code.Code;
exports.ColorPicker = ColorPicker.ColorPicker;
exports.AlphaSlider = AlphaSlider.AlphaSlider;
exports.HueSlider = HueSlider.HueSlider;
exports.convertHsvaTo = converters.convertHsvaTo;
exports.isColorValid = parsers.isColorValid;
exports.parseColor = parsers.parseColor;
exports.ColorInput = ColorInput.ColorInput;
exports.ColorSwatch = ColorSwatch.ColorSwatch;
exports.getParsedComboboxData = getParsedComboboxData.getParsedComboboxData;
exports.getLabelsLockup = getOptionsLockup.getLabelsLockup;
exports.getOptionsLockup = getOptionsLockup.getOptionsLockup;
exports.ComboboxChevron = ComboboxChevron.ComboboxChevron;
exports.Combobox = Combobox.Combobox;
exports.ComboboxDropdown = ComboboxDropdown.ComboboxDropdown;
exports.ComboboxOptions = ComboboxOptions.ComboboxOptions;
exports.ComboboxOption = ComboboxOption.ComboboxOption;
exports.ComboboxTarget = ComboboxTarget.ComboboxTarget;
exports.ComboboxSearch = ComboboxSearch.ComboboxSearch;
exports.ComboboxEmpty = ComboboxEmpty.ComboboxEmpty;
exports.ComboboxFooter = ComboboxFooter.ComboboxFooter;
exports.ComboboxHeader = ComboboxHeader.ComboboxHeader;
exports.ComboboxEventsTarget = ComboboxEventsTarget.ComboboxEventsTarget;
exports.ComboboxDropdownTarget = ComboboxDropdownTarget.ComboboxDropdownTarget;
exports.ComboboxGroup = ComboboxGroup.ComboboxGroup;
exports.ComboboxClearButton = ComboboxClearButton.ComboboxClearButton;
exports.ComboboxHiddenInput = ComboboxHiddenInput.ComboboxHiddenInput;
exports.OptionsDropdown = OptionsDropdown.OptionsDropdown;
exports.useCombobox = useCombobox.useCombobox;
exports.useVirtualizedCombobox = useVirtualizedCombobox.useVirtualizedCombobox;
exports.useComboboxTargetProps = useComboboxTargetProps.useComboboxTargetProps;
exports.isOptionsGroup = isOptionsGroup.isOptionsGroup;
exports.defaultOptionsFilter = defaultOptionsFilter.defaultOptionsFilter;
exports.Container = Container.Container;
exports.CopyButton = CopyButton.CopyButton;
exports.Dialog = Dialog.Dialog;
exports.Divider = Divider.Divider;
exports.Drawer = Drawer.Drawer;
exports.DrawerRoot = DrawerRoot.DrawerRoot;
exports.DrawerBody = DrawerBody.DrawerBody;
exports.DrawerCloseButton = DrawerCloseButton.DrawerCloseButton;
exports.DrawerContent = DrawerContent.DrawerContent;
exports.DrawerHeader = DrawerHeader.DrawerHeader;
exports.DrawerOverlay = DrawerOverlay.DrawerOverlay;
exports.DrawerTitle = DrawerTitle.DrawerTitle;
exports.Fieldset = Fieldset.Fieldset;
exports.FileButton = FileButton.FileButton;
exports.FileInput = FileInput.FileInput;
exports.useDelayedHover = useDelayedHover.useDelayedHover;
exports.useFloatingAutoUpdate = useFloatingAutoUpdate.useFloatingAutoUpdate;
exports.getFloatingPosition = getFloatingPosition.getFloatingPosition;
exports.FloatingArrow = FloatingArrow.FloatingArrow;
exports.FocusTrap = FocusTrap.FocusTrap;
exports.FocusTrapInitialFocus = FocusTrap.FocusTrapInitialFocus;
exports.Grid = Grid.Grid;
exports.GridCol = GridCol.GridCol;
exports.Highlight = Highlight.Highlight;
exports.HoverCard = HoverCard.HoverCard;
exports.HoverCardDropdown = HoverCardDropdown.HoverCardDropdown;
exports.HoverCardTarget = HoverCardTarget.HoverCardTarget;
exports.Image = Image.Image;
exports.Indicator = Indicator.Indicator;
exports.JsonInput = JsonInput.JsonInput;
exports.Kbd = Kbd.Kbd;
exports.List = List.List;
exports.ListItem = ListItem.ListItem;
exports.LoadingOverlay = LoadingOverlay.LoadingOverlay;
exports.Mark = Mark.Mark;
exports.Menu = Menu.Menu;
exports.MenuDivider = MenuDivider.MenuDivider;
exports.MenuItem = MenuItem.MenuItem;
exports.MenuLabel = MenuLabel.MenuLabel;
exports.MenuDropdown = MenuDropdown.MenuDropdown;
exports.MenuTarget = MenuTarget.MenuTarget;
exports.Modal = Modal.Modal;
exports.ModalRoot = ModalRoot.ModalRoot;
exports.ModalBody = ModalBody.ModalBody;
exports.ModalCloseButton = ModalCloseButton.ModalCloseButton;
exports.ModalContent = ModalContent.ModalContent;
exports.ModalHeader = ModalHeader.ModalHeader;
exports.ModalOverlay = ModalOverlay.ModalOverlay;
exports.ModalTitle = ModalTitle.ModalTitle;
exports.MultiSelect = MultiSelect.MultiSelect;
exports.NativeSelect = NativeSelect.NativeSelect;
exports.NavLink = NavLink.NavLink;
exports.Notification = Notification.Notification;
exports.NumberFormatter = NumberFormatter.NumberFormatter;
exports.NumberInput = NumberInput.NumberInput;
exports.Pagination = Pagination.Pagination;
exports.PaginationControl = PaginationControl.PaginationControl;
exports.PaginationDots = PaginationDots.PaginationDots;
exports.PaginationFirst = PaginationEdges.PaginationFirst;
exports.PaginationLast = PaginationEdges.PaginationLast;
exports.PaginationNext = PaginationEdges.PaginationNext;
exports.PaginationPrevious = PaginationEdges.PaginationPrevious;
exports.PaginationItems = PaginationItems.PaginationItems;
exports.PaginationRoot = PaginationRoot.PaginationRoot;
exports.PasswordInput = PasswordInput.PasswordInput;
exports.Pill = Pill.Pill;
exports.PillGroup = PillGroup.PillGroup;
exports.PillsInput = PillsInput.PillsInput;
exports.PillsInputField = PillsInputField.PillsInputField;
exports.PinInput = PinInput.PinInput;
exports.Portal = Portal.Portal;
exports.OptionalPortal = OptionalPortal.OptionalPortal;
exports.Progress = Progress.Progress;
exports.ProgressLabel = ProgressLabel.ProgressLabel;
exports.ProgressRoot = ProgressRoot.ProgressRoot;
exports.ProgressSection = ProgressSection.ProgressSection;
exports.Radio = Radio.Radio;
exports.RadioGroup = RadioGroup.RadioGroup;
exports.RadioIcon = RadioIcon.RadioIcon;
exports.RadioCard = RadioCard.RadioCard;
exports.useRadioCardContext = RadioCard_context.useRadioCardContext;
exports.RadioIndicator = RadioIndicator.RadioIndicator;
exports.Rating = Rating.Rating;
exports.RingProgress = RingProgress.RingProgress;
exports.SegmentedControl = SegmentedControl.SegmentedControl;
exports.Select = Select.Select;
exports.SemiCircleProgress = SemiCircleProgress.SemiCircleProgress;
exports.SimpleGrid = SimpleGrid.SimpleGrid;
exports.Skeleton = Skeleton.Skeleton;
exports.Slider = Slider.Slider;
exports.RangeSlider = RangeSlider.RangeSlider;
exports.Space = Space.Space;
exports.Spoiler = Spoiler.Spoiler;
exports.Stack = Stack.Stack;
exports.Stepper = Stepper.Stepper;
exports.StepperStep = StepperStep.StepperStep;
exports.StepperCompleted = StepperCompleted.StepperCompleted;
exports.Switch = Switch.Switch;
exports.SwitchGroup = SwitchGroup.SwitchGroup;
exports.Table = Table.Table;
exports.TableCaption = Table_components.TableCaption;
exports.TableTbody = Table_components.TableTbody;
exports.TableTd = Table_components.TableTd;
exports.TableTfoot = Table_components.TableTfoot;
exports.TableTh = Table_components.TableTh;
exports.TableThead = Table_components.TableThead;
exports.TableTr = Table_components.TableTr;
exports.TableScrollContainer = TableScrollContainer.TableScrollContainer;
exports.Tabs = Tabs.Tabs;
exports.TabsList = TabsList.TabsList;
exports.TabsTab = TabsTab.TabsTab;
exports.TabsPanel = TabsPanel.TabsPanel;
exports.TagsInput = TagsInput.TagsInput;
exports.Text = Text.Text;
exports.Textarea = Textarea.Textarea;
exports.TextInput = TextInput.TextInput;
exports.ThemeIcon = ThemeIcon.ThemeIcon;
exports.Timeline = Timeline.Timeline;
exports.TimelineItem = TimelineItem.TimelineItem;
exports.Title = Title.Title;
exports.Tooltip = Tooltip.Tooltip;
exports.TooltipGroup = TooltipGroup.TooltipGroup;
exports.TooltipFloating = TooltipFloating.TooltipFloating;
exports.MANTINE_TRANSITIONS = transitions.transitions;
exports.Transition = Transition.Transition;
exports.getTransitionProps = getTransitionProps.getTransitionProps;
exports.Tree = Tree.Tree;
exports.useTree = useTree.useTree;
exports.TypographyStylesProvider = TypographyStylesProvider.TypographyStylesProvider;
//# sourceMappingURL=index.cjs.map
