'use client';
'use strict';

var React = require('react');

function useInterval(fn, interval, { autoInvoke = false } = {}) {
  const [active, setActive] = React.useState(false);
  const intervalRef = React.useRef();
  const fnRef = React.useRef();
  const start = () => {
    setActive((old) => {
      if (!old && !intervalRef.current) {
        intervalRef.current = window.setInterval(fnRef.current, interval);
      }
      return true;
    });
  };
  const stop = () => {
    setActive(false);
    window.clearInterval(intervalRef.current);
    intervalRef.current = void 0;
  };
  const toggle = () => {
    if (active) {
      stop();
    } else {
      start();
    }
  };
  React.useEffect(() => {
    fnRef.current = fn;
    active && start();
    return stop;
  }, [fn, active, interval]);
  React.useEffect(() => {
    if (autoInvoke) {
      start();
    }
  }, []);
  return { start, stop, toggle, active };
}

exports.useInterval = useInterval;
//# sourceMappingURL=use-interval.cjs.map
